/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDPathDiagramNode;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDSelfLink;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.interfaces.PathDiagramLinkLayoutInterface;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class PFDPathDiagramSelfLink
extends PFDSelfLink
implements PathDiagramLinkLayoutInterface {
    private static final long serialVersionUID = 4099998626454441806L;
    private int linkDirection = 3;
    private int linkPriority = 1;
    private double gridScaleFactor = 1.0;
    private double graphScale = 1.0;

    public void setGridScaleFactor(double fac) {
        this.gridScaleFactor = fac;
    }

    public void setGraphScale(double s) {
        this.graphScale = s;
    }

    public PFDPathDiagramSelfLink(PFDPort self, int relativeLocation) {
        super(self, relativeLocation);
    }

    @Override
    public int getLinkDirection() {
        return this.linkDirection;
    }

    @Override
    public void setLinkDirection(int linkDirection) {
        this.linkDirection = linkDirection;
    }

    @Override
    public int getLinkPriority() {
        return this.linkPriority;
    }

    @Override
    public void setLinkPriority(int priority) {
        this.linkPriority = priority;
    }

    @Override
    protected int getArcRadius() {
        PFDAbstractNode node = this.fromPort.getParentNode();
        if (node == null) {
            return 0;
        }
        double scale = this.graphScale;
        if (scale != 1.0) {
            scale = Math.sqrt(scale);
        }
        return Math.max(Math.min(node.getWidth(), node.getHeight()), (int)(52.0 * this.gridScaleFactor * scale)) / 4;
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        Shape s;
        if (this.fromPort == null || this.toPort == null) {
            return;
        }
        if (this.getFromElbowLineWidth() == 1.0f && this.getToElbowLineWidth() == 1.0f) {
            super.render(g2d, v);
            return;
        }
        Shape clipSave = g2d.getClip();
        Rectangle clipBounds = g2d.getClipBounds();
        if (clipBounds == null) {
            clipBounds = v.getViewRect();
        }
        Area area = new Area(new Rectangle2D.Double(clipBounds.getX(), clipBounds.getY(), clipBounds.getWidth(), clipBounds.getHeight()));
        PFDAbstractNode node = this.fromPort.getParentNode();
        if (node instanceof PFDPathDiagramNode && (s = ((PFDPathDiagramNode)node).getDrawableShape()) != null) {
            area.subtract(new Area(s));
        }
        if ((node = this.toPort.getParentNode()) instanceof PFDPathDiagramNode && (s = ((PFDPathDiagramNode)node).getDrawableShape()) != null) {
            area.subtract(new Area(s));
        }
        g2d.setClip(area);
        super.render(g2d, v);
        g2d.setClip(clipSave);
    }
}

