/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDBrush;
import com.sas.graphics.components.pfd.PFDEllipse;
import com.sas.graphics.components.pfd.PFDFlowChartShapes;
import com.sas.graphics.components.pfd.PFDPen;
import com.sas.graphics.components.pfd.PFDPolygon;
import com.sas.graphics.components.pfd.PFDRectangle;
import com.sas.graphics.components.pfd.PFDRoundRectangle;
import com.sas.graphics.components.pfd.PFDSimpleShapeNode;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDUtil;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.interfaces.PathDiagramNodeLayoutInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PFDPathDiagramNode
extends PFDSimpleShapeNode
implements PathDiagramNodeLayoutInterface {
    private static final long serialVersionUID = 397626597003472785L;
    public static int NODE_PRIORITY_1 = 1;
    public static int NODE_PRIORITY_2 = 2;
    public static int NODE_PRIORITY_3 = 3;
    private int nodePriority;
    private double relativeNodeSize = 1.0;
    protected PFDText outsideLabel = null;
    private boolean directErrorNode = false;
    private double gapScaleFactor = 1.0;
    protected Shape drawableShape = null;
    protected int index;
    private Dimension originalSize;

    public PFDPathDiagramNode(Point loc, Dimension size, String label) {
        super(loc, size, 2, label);
        this.originalSize = new Dimension(size.width, size.height);
    }

    public PFDPathDiagramNode(Point loc, Dimension size, int shape, String label, int index) {
        super(loc, size, shape, label);
        this.index = index;
        this.originalSize = new Dimension(size.width, size.height);
    }

    public int getIndex() {
        return this.index;
    }

    public Dimension getOriginalSize() {
        return this.originalSize;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.port.setNodeShape(this.shape);
        this.label.setFontSize(10);
        this.label.setFontStyle(1);
        this.label.setSelectable(false);
        this.label.setForeground(new Color(60, 60, 60));
        int horizontalPadding = 6;
        this.label.setVerticalAlignment(0);
        this.label.setHorizontalAlignment(0);
        Point topLeftPoint = this.drawable.getSpotLocation(1, null);
        this.label.setBBox(topLeftPoint.x + horizontalPadding, topLeftPoint.y, this.drawable.getWidth() - 2 * horizontalPadding - 2 * (topLeftPoint.x - this.drawable.getSpotLocation((int)8, null).x), this.drawable.getHeight() - 2 * (topLeftPoint.y - this.drawable.getSpotLocation((int)2, null).y));
        this.label.setMultiline(true);
        this.label.setWrapWidth(this.label.getBBox().width);
        this.label.forceUpdate();
    }

    @Override
    protected void checkShape(int shape) {
        switch (shape) {
            case 0: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource("PFDSimpleShapeNode.", "shape.ex.txt"));
            }
        }
    }

    @Override
    protected void createDrawable() {
        PFDBrush brush = null;
        PFDPen pen = null;
        if (this.drawable != null) {
            brush = this.drawable.getBrush();
            pen = this.drawable.getPen();
            this.location = this.drawable.getLocation();
            this.size = this.drawable.getSize();
        }
        switch (this.shape) {
            default: {
                this.drawable = new PFDRectangle();
                break;
            }
            case 3: {
                this.drawable = new PFDRoundRectangle();
                break;
            }
            case 5: {
                this.drawable = new PFDEllipse();
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.drawable = new PFDPolygon();
            }
        }
        this.drawable.setBBox(this.location, this.size);
        if (brush != null) {
            this.drawable.setBrush(brush);
        }
        if (pen != null) {
            this.drawable.setPen(pen);
        }
    }

    @Override
    public void layoutChildren() {
        switch (this.shape) {
            default: {
                break;
            }
            case 4: {
                PFDPolygon poly = (PFDPolygon)this.drawable;
                poly.setVertices(PFDFlowChartShapes.createTopTriangle(new Rectangle(this.location, this.size)));
            }
        }
        Point p = new Point();
        Rectangle r = this.drawable.getRBBox();
        int iw = 0;
        int ih = 0;
        if (this.icon != null) {
            iw = this.image.getIconWidth();
            ih = this.image.getIconHeight();
            int dx = 0;
            int dy = 0;
            if (r.width > iw + 2 * this.iconPadding && r.height > ih + 2 * this.iconPadding) {
                switch (this.iconPosition) {
                    default: {
                        dx = (r.width - iw) / 2;
                        dy = (r.height - ih) / 2;
                        break;
                    }
                    case 1: {
                        dx = this.iconPadding;
                        dy = this.iconPadding;
                        break;
                    }
                    case 2: {
                        dx = (r.width - iw) / 2;
                        dy = this.iconPadding;
                        break;
                    }
                    case 3: {
                        dx = r.width - this.iconPadding - iw;
                        dy = this.iconPadding;
                        break;
                    }
                    case 8: {
                        dx = this.iconPadding;
                        dy = (r.height - ih) / 2;
                        break;
                    }
                    case 4: {
                        dx = r.width - this.iconPadding - iw;
                        dy = (r.height - ih) / 2;
                        break;
                    }
                    case 7: {
                        dx = this.iconPadding;
                        dy = r.height - this.iconPadding - ih;
                        break;
                    }
                    case 6: {
                        dx = (r.width - iw) / 2;
                        dy = r.height - this.iconPadding - ih;
                        break;
                    }
                    case 5: {
                        dx = r.width - this.iconPadding - iw;
                        dy = r.height - this.iconPadding - ih;
                        break;
                    }
                }
            } else {
                iw = 0;
                ih = 0;
            }
            this.icon.setBBox(r.x + dx, r.y + dy, iw, ih);
        }
        switch (this.labelPosition) {
            default: {
                if (this.label.isHTML()) {
                    this.label.setTruncateLines(true);
                    int wrap = Math.max(0, r.width - this.labelXPadding * 2);
                    int clip = Math.max(0, r.height - this.labelYPadding * 2);
                    this.drawable.getSpotLocation(1, p);
                    this.label.setHorizontalAlignment(1);
                    this.label.setVerticalAlignment(1);
                    this.label.setBBox(p.x + this.labelXPadding, p.y + this.labelYPadding, 0, 0);
                    this.label.setWrapWidth(wrap);
                    this.label.setClipHeight(clip);
                    if (this.icon == null) break;
                    Rectangle iconBBox = this.icon.getBBox();
                    Rectangle clipBBox = new Rectangle(iconBBox.x - this.iconPadding - r.x, iconBBox.y - this.iconPadding - r.y, iconBBox.width + 2 * this.iconPadding, iconBBox.height + 2 * this.iconPadding);
                    if (!iconBBox.isEmpty()) {
                        this.label.setClipRectangle(clipBBox);
                        break;
                    }
                    this.label.setClipRectangle(null);
                    break;
                }
                this.drawable.getSpotLocation(0, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
                this.label.setClipHeight(r.height);
                break;
            }
            case 1: {
                this.drawable.getSpotLocation(2, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(2);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(2 * r.width);
                break;
            }
            case 2: {
                this.drawable.getSpotLocation(6, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(1);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(2 * r.width);
                break;
            }
            case 3: {
                this.drawable.getSpotLocation(8, p);
                this.label.setHorizontalAlignment(2);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
                break;
            }
            case 4: {
                this.drawable.getSpotLocation(4, p);
                this.label.setHorizontalAlignment(1);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
            }
        }
        this.drawable.getSpotLocation(0, p);
        this.port.setBBox(p.x, p.y, 0, 0);
        switch (this.shape) {
            case 4: 
            case 5: {
                this.port.setFreeSpotBox(false);
                break;
            }
            default: {
                this.port.setFreeSpotBox(true);
            }
        }
        this.port.setFreeSpotOffsetX(r.width / 2);
        this.port.setFreeSpotOffsetY(r.height / 2);
        this.port.setSnapBox(true);
        this.port.setSnapXDistance(r.width / 2);
        this.port.setSnapYDistance(r.height / 2);
        this.calculateBBox();
    }

    @Override
    public int getNodePriority() {
        return this.nodePriority;
    }

    @Override
    public void setNodePriority(int nodePriority) {
        this.nodePriority = nodePriority;
    }

    @Override
    public void setRelativeNodeSize(double relativeSize) {
        this.relativeNodeSize = relativeSize;
    }

    @Override
    public double getRelativeNodeSize() {
        return this.relativeNodeSize;
    }

    public String toString() {
        PFDText t = this.getLabel();
        if (t != null) {
            return t.getText();
        }
        return super.toString();
    }

    public void setOutsideLabel(String text) {
        this.initializeOutsideLabel(text);
    }

    public PFDText getOutsideLabel() {
        return this.outsideLabel;
    }

    private void initializeOutsideLabel(String text) {
        this.outsideLabel = new PFDText(text);
        this.addPrimitive(this.outsideLabel);
        this.outsideLabel.setFontSize(10);
        this.outsideLabel.setFontStyle(1);
        Font f = new Font("Tahoma", 1, 10);
        TextLayout tl = new TextLayout(text, f, PFDUtil.getFontRenderContext());
        this.outsideLabel.setSelectable(false);
        this.outsideLabel.setForeground(new Color(60, 60, 60));
        int horizontalPadding = 6;
        this.outsideLabel.setVerticalAlignment(1);
        this.outsideLabel.setHorizontalAlignment(1);
        Rectangle bbox = this.drawable.getRBBox();
        int overflow = (int)((double)bbox.width * 0.05);
        Point topRightPoint = this.drawable.getSpotLocation(3, null);
        int adjust = (int)(tl.getBounds().getWidth() - (double)overflow);
        int gap = (int)(4.0 * this.gapScaleFactor);
        this.outsideLabel.setBBox(topRightPoint.x + (this.shape == 2 ? horizontalPadding : 0) - adjust, (int)((double)topRightPoint.y - tl.getBounds().getHeight() - (double)gap), this.drawable.getWidth() - 2 * horizontalPadding - 2 * this.drawable.getSpotLocation((int)8, null).x, this.drawable.getHeight() - 2 * (topRightPoint.y - this.drawable.getSpotLocation((int)2, null).y));
        this.outsideLabel.forceUpdate();
        this.outsideLabel.addPropertyChangeListener("font", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Font f = PFDPathDiagramNode.this.outsideLabel.getFont();
                if (f == null) {
                    f = new Font("Tahoma", 1, 10);
                }
                TextLayout tl = new TextLayout(PFDPathDiagramNode.this.outsideLabel.getText(), f, PFDUtil.getFontRenderContext());
                int horizontalPadding = 6;
                Rectangle bbox = PFDPathDiagramNode.this.drawable.getRBBox();
                int overflow = (int)((double)bbox.width * 0.05);
                int adjust = (int)(tl.getBounds().getWidth() - (double)overflow);
                Point topRightPoint = PFDPathDiagramNode.this.drawable.getSpotLocation(3, null);
                int gap = (int)(4.0 * PFDPathDiagramNode.this.gapScaleFactor);
                PFDPathDiagramNode.this.outsideLabel.setBBox(topRightPoint.x + (PFDPathDiagramNode.this.shape == 2 ? horizontalPadding : 0) - adjust, (int)((double)topRightPoint.y - tl.getBounds().getHeight() - (double)gap), PFDPathDiagramNode.this.drawable.getWidth() - 2 * horizontalPadding - 2 * PFDPathDiagramNode.this.drawable.getSpotLocation((int)8, null).x, PFDPathDiagramNode.this.drawable.getHeight() - 2 * (topRightPoint.y - PFDPathDiagramNode.this.drawable.getSpotLocation((int)2, null).y));
                PFDPathDiagramNode.this.outsideLabel.setWrapWidth(PFDPathDiagramNode.this.outsideLabel.getBBox().width);
                PFDPathDiagramNode.this.outsideLabel.forceUpdate();
            }
        });
    }

    @Override
    protected Rectangle getRBBox() {
        Rectangle rbBox = new Rectangle(super.getRBBox());
        return rbBox;
    }

    @Override
    public void setDirectErrorNode(boolean value) {
        this.directErrorNode = value;
    }

    @Override
    public boolean isDirectErrorNode() {
        return this.directErrorNode;
    }

    public double getGapScaleFactor() {
        return this.gapScaleFactor;
    }

    public void setGapScaleFactor(double gapScaleFactor) {
        this.gapScaleFactor = gapScaleFactor;
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        super.render(g2d, v);
        Rectangle bbox = this.drawable.getRBBox();
        if (this.drawable instanceof PFDEllipse) {
            this.drawableShape = new Ellipse2D.Double(bbox.x, bbox.y, bbox.width - 1, bbox.height - 1);
        } else if (this.drawable instanceof PFDRectangle) {
            this.drawableShape = new Rectangle2D.Double(bbox.x, bbox.y, bbox.width - 1, bbox.height - 1);
        }
    }

    public Shape getDrawableShape() {
        return this.drawableShape;
    }
}

