/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDEllipse;
import com.sas.graphics.components.pfd.PFDPathDiagramNode;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDRectangle;
import com.sas.graphics.components.pfd.PFDSimpleNode;
import com.sas.graphics.interfaces.LinkLayoutInterface;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.interfaces.NodeLinkDiagramLayoutInterface;
import com.sas.graphics.interfaces.PathDiagramLinkLayoutInterface;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class PFDPathDiagramModel
implements NodeLinkDiagramLayoutInterface {
    private Vector<NodeLayoutInterface> nodes = null;
    private Vector<PathDiagramLinkLayoutInterface> links = null;
    private String flowDirection = "Right";

    public PFDPathDiagramModel(Vector<NodeLayoutInterface> nodes, Vector<PathDiagramLinkLayoutInterface> links) {
        this.nodes = nodes;
        this.links = links;
    }

    @Override
    public Vector getAllLinks() {
        return this.links;
    }

    @Override
    public Vector getAllNodes() {
        return this.nodes;
    }

    @Override
    public Vector getAllLayoutNodes() {
        return this.nodes;
    }

    @Override
    public NodeLayoutInterface createDummyNode(int width, int height) {
        PFDSimpleNode sn = new PFDSimpleNode(new Point(0, 0), new Dimension(width, height), null);
        sn.getPort().setFreeSpotOffsetX(0);
        sn.getPort().setFreeSpotOffsetY(0);
        sn.setVisible(false);
        return sn;
    }

    @Override
    public String getFlowDirection() {
        return this.flowDirection;
    }

    @Override
    public void setFlowDirection(String x) {
        this.flowDirection = x;
    }

    @Override
    public void removeLink(LinkLayoutInterface link) {
    }

    @Override
    public void setForceNodePosition(boolean force) {
    }

    @Override
    public boolean getForceNodePosition() {
        return false;
    }

    public static void resetNodeSize(Vector allNodes) {
        if (allNodes == null) {
            return;
        }
        for (int i = 0; i < allNodes.size(); ++i) {
            if (!(allNodes.get(i) instanceof PFDPathDiagramNode)) continue;
            PFDPathDiagramNode node = (PFDPathDiagramNode)allNodes.get(i);
            for (int j = 0; j < node.children.size(); ++j) {
                PFDPrimitive p = (PFDPrimitive)node.children.elementAt(j);
                if (!(p instanceof PFDRectangle) && !(p instanceof PFDEllipse)) continue;
                Rectangle r = p.getBBox();
                int x = r.x;
                int w = r.width;
                r.x = x - (int)((double)(node.getOriginalSize().width - w) * 0.5);
                r.width = node.getOriginalSize().width;
                r.height = node.getOriginalSize().height;
                p.setBBox(r);
            }
            node.layoutChildren();
        }
    }

    public static void scaleNodeSize(Vector allNodes, double scale) {
        if (allNodes == null) {
            return;
        }
        for (int i = 0; i < allNodes.size(); ++i) {
            if (!(allNodes.get(i) instanceof PFDPathDiagramNode)) continue;
            PFDPathDiagramNode node = (PFDPathDiagramNode)allNodes.get(i);
            for (int j = 0; j < node.children.size(); ++j) {
                PFDPrimitive p = (PFDPrimitive)node.children.elementAt(j);
                if (!(p instanceof PFDRectangle) && !(p instanceof PFDEllipse)) continue;
                Rectangle r = p.getBBox();
                int x = r.x;
                int w = r.width;
                r.x = x + (int)(((double)w - (double)w * scale) * 0.5);
                r.width = (int)((double)r.width * scale);
                r.height = (int)((double)r.height * scale);
                p.setBBox(r);
            }
            node.layoutChildren();
        }
    }
}

