/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDOverview;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.LineBorder;

public class PFDOverviewPanel
extends JComponent {
    private PFDOverview overview;
    private static final Dimension defaultSize = new Dimension(200, 150);

    public PFDOverviewPanel(PFDView view) {
        this.overview = new PFDOverview(view);
        this.setLayout(new OverviewPanelLayout());
        LineBorder lineBorder = new LineBorder(new Color(110, 110, 110));
        this.overview.setBorder(lineBorder);
        this.add((Component)this.overview, "overview");
        this.setVisible(false);
    }

    public void dispose() {
        if (this.overview != null) {
            this.overview.dispose();
            this.overview = null;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.overview.updateOverview(true);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.overview.contains(x - this.overview.getX(), y - this.overview.getY());
    }

    private class OverviewPanelLayout
    implements LayoutManager {
        public static final String OVERVIEW = "overview";
        private Component overviewComponent;
        private static final int padding = 1;

        private OverviewPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (OVERVIEW.equals(name)) {
                this.overviewComponent = comp;
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            if (this.overviewComponent != null) {
                this.overviewComponent.setSize(defaultSize);
                this.overviewComponent.setLocation(parent.getWidth() - this.overviewComponent.getWidth() - 1, parent.getHeight() - this.overviewComponent.getHeight() - 1);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return defaultSize;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp == this.overviewComponent) {
                this.overviewComponent = null;
            }
        }
    }
}

