/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAnnotateComponent;
import com.sas.graphics.components.pfd.PFDHandle;
import com.sas.graphics.components.pfd.PFDLayer;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDModelEvent;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDRectangle;
import com.sas.graphics.components.pfd.PFDScrollView;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDViewEvent;
import com.sas.graphics.components.pfd.PFDViewListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollBar;

public class PFDOverview
extends PFDView
implements PFDViewListener,
PropertyChangeListener,
MouseListener,
MouseMotionListener {
    public static final int UPDATE_CONSTANTLY = 0;
    public static final int UPDATE_WHEN_NEEDED = 1;
    private int updateMode = 0;
    private PFDRectangle roi;
    private PFDHandle roiResizeHandle;
    private Color roiColor = new Color(153, 153, 255, 51);
    private Color roiOutlineColor = new Color(150, 150, 150);
    private static final int HANDLE = 0;
    private static final int INSIDE = 1;
    private static final int OUTSIDE = 2;
    private int cursorSpot = 2;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_MOVE = 1;
    private static final int ACTION_RESIZE = 2;
    private int action = 0;
    private int handleIndex = -1;
    private double aspect;
    private PFDView view;
    private boolean ignoreModelChanges = false;
    private boolean ignoreViewportChanges = false;
    private OverviewMouseAdapter ma;
    private OverviewMouseMotionAdapter mma;
    private int currentDocWidth = 0;
    private int currentDocHeight = 0;

    public PFDOverview(PFDView detailedView) {
        this.cleanBufferDirty = true;
        OverviewMouseAdapter ma = new OverviewMouseAdapter(this);
        OverviewMouseMotionAdapter mma = new OverviewMouseMotionAdapter(this);
        this.addMouseListener(ma);
        this.addMouseMotionListener(mma);
        this.attachView(detailedView);
        this.setHoldDisplay(true);
        this.disableChangeUpdate();
        this.setToolTipEnabled(false);
        this.setMouseEnabled(false);
        this.setKeyboardEnabled(false);
        this.currentDocWidth = this.view.getDocumentWidth();
        this.currentDocHeight = this.view.getDocumentHeight();
        if (this.view.isPageDividerVisible()) {
            this.setPageFormat(this.view.getPageFormat());
        }
        Rectangle viewRect = this.view.getViewRect();
        this.roi = new PFDRectangle();
        this.roi.setBBox(viewRect);
        this.roi.getBrush().setColor(this.roiColor);
        this.roi.getPen().setColor(this.roiOutlineColor);
        this.roiResizeHandle = new PFDHandle(this.roi);
        this.roiResizeHandle.setBBoxIncludeHandle(false);
        this.roiResizeHandle.getBrush().setColor(new Color(255, 204, 102, 128));
        this.roiResizeHandle.getPen().setColor(Color.gray);
        this.aspect = (double)this.view.getWidth() / (double)this.view.getHeight();
        this.currentXfm = null;
        this.enableChangeUpdate();
        this.setHoldDisplay(false);
    }

    @Override
    protected PFDAnnotateComponent createAnnotateComponent() {
        return null;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        this.cleanBufferDirty = true;
        this.resetRenderMode();
        super.setBounds(x, y, w, h);
    }

    @Override
    public void setModel(PFDModel m) {
        PFDModel oldVal = this.model;
        if (this.model == m) {
            return;
        }
        if (this.model != null) {
            this.model.removePFDModelListener(this);
        }
        this.model = m;
        if (this.model != null) {
            this.model.addPFDModelListener(this);
        }
        this.repaint();
        this.firePropertyChange("model", oldVal, this.model);
    }

    @Override
    protected synchronized void renderDrawablePrimitives(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform defaultXfm = g2d.getTransform();
        int vw = this.getWidth();
        int vh = this.getHeight();
        Dimension ms = this.view.getModel().getSize();
        int w = this.currentDocWidth;
        int h = this.currentDocHeight;
        double sx = (double)vw / (double)w;
        double sy = (double)vh / (double)h;
        double s = Math.min(sx, sy);
        this.currentXfm = new AffineTransform();
        this.currentXfm.scale(s, s);
        AffineTransform newXfm = new AffineTransform(defaultXfm);
        newXfm.concatenate(this.currentXfm);
        g2d.setTransform(newXfm);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        Dimension hs = new Dimension(10, 10);
        this.ViewToModel(hs);
        if (this.renderMode != 2 && this.view.isPageDividerVisible()) {
            this.renderPageDivider(g2d, new Rectangle(0, 0, ms.width, ms.height));
        }
        if (this.renderMode != 2) {
            for (int i = 0; i < this.model.getNumLayers(); ++i) {
                PFDLayer layer = this.model.getLayer(i);
                for (int j = 0; j < layer.getNumPrimitives(); ++j) {
                    PFDPrimitive p = layer.getPrimitive(j);
                    p.renderOverview(g2d, this);
                }
            }
        }
        if (this.renderMode != 1) {
            this.roi.renderOverview(g2d, this);
            Rectangle r = this.roi.getRBBox();
            this.roiResizeHandle.setHandleSize(hs.width);
            if (r.width > 4 * hs.width && r.height > 4 * hs.height) {
                this.roiResizeHandle.setHandleSpot(0);
            } else {
                this.roiResizeHandle.setHandleSpot(2);
            }
            this.roiResizeHandle.createHandles();
        }
        g2d.setTransform(defaultXfm);
    }

    @Override
    public void modelChanged(PFDModelEvent e) {
        if (this.updateMode == 1 && this.ignoreModelChanges) {
            return;
        }
        this.resetRenderMode();
        this.repaint();
        this.cleanBufferDirty = true;
    }

    @Override
    public void viewChanged(PFDViewEvent e) {
        if (this.cleanBuffer == null || this.backBuffer == null) {
            return;
        }
        PFDView v = (PFDView)e.getSource();
        if (v.getCurrentXfm() == null) {
            return;
        }
        switch (e.getType()) {
            case 0: {
                if (this.ignoreViewportChanges) {
                    return;
                }
                this.updateOverview(false);
                break;
            }
            case 1: {
                if (this.updateMode != 1) break;
                this.ignoreModelChanges = true;
                break;
            }
            case 2: {
                if (this.updateMode != 1) break;
                this.ignoreModelChanges = false;
                this.cleanBufferDirty = true;
                this.repaint();
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                this.updateOverview(false);
                break;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        PFDView v = (PFDView)e.getSource();
        if (v.getCurrentXfm() == null) {
            return;
        }
        String property = e.getPropertyName();
        if (property.equals("pageFormat")) {
            if (v.isPageDividerVisible()) {
                this.setPageFormat(v.getPageFormat());
                this.cleanBufferDirty = true;
                this.repaint();
            }
        } else if (property.equals("pageDividerVisible")) {
            this.cleanBufferDirty = true;
            this.repaint();
        } else if (property.equals("model")) {
            this.setModel(v.getModel());
            Rectangle viewRect = v.getViewRect();
            this.roi.setBBox(viewRect);
            this.resetRenderMode();
            if (this.cleanBuffer != null && this.backBuffer != null) {
                this.copyToCleanBuffer();
                this.blitCleanBuffer();
                this.renderDraggedPrimitives();
            }
            this.repaint();
            this.cleanBufferDirty = true;
        }
    }

    public void attachView(PFDView v) {
        if (this.view != null) {
            this.detachView();
        }
        this.view = v;
        this.model = this.view.getModel();
        this.view.addPFDViewListener(this);
        this.view.addPropertyChangeListener(this);
        this.model.addPFDModelListener(this);
        if (this.view.getParent() instanceof PFDScrollView) {
            PFDScrollView scroll = (PFDScrollView)this.view.getParent();
            scroll.vScrollBar.addMouseListener(this.ma);
            scroll.hScrollBar.addMouseListener(this.ma);
            scroll.vScrollBar.addMouseMotionListener(this.mma);
            scroll.hScrollBar.addMouseMotionListener(this.mma);
        }
    }

    public void detachView() {
        if (this.view != null) {
            this.view.removePFDViewListener(this);
            this.view.removePropertyChangeListener(this);
            if (this.view.getParent() instanceof PFDScrollView) {
                PFDScrollView scroll = (PFDScrollView)this.view.getParent();
                scroll.vScrollBar.removeMouseListener(this.ma);
                scroll.hScrollBar.removeMouseListener(this.ma);
                scroll.vScrollBar.removeMouseMotionListener(this.mma);
                scroll.hScrollBar.removeMouseMotionListener(this.mma);
            }
        }
        if (this.model != null) {
            this.model.removePFDModelListener(this);
        }
        this.view = null;
        this.model = null;
    }

    protected void calculateNewBBox(Rectangle r, int resizeHandle, int newX, int newY) {
        Point newPoint = new Point(newX, newY);
        this.ViewToModel(newPoint);
        int xmax = this.currentDocWidth;
        int ymax = this.currentDocHeight;
        Dimension minViewSize = this.view.getMinViewSize();
        Dimension maxViewSize = this.view.getMaxViewSize();
        if (newPoint.x < 0) {
            newPoint.x = 0;
        }
        if (newPoint.x > xmax) {
            newPoint.x = xmax;
        }
        if (newPoint.y < 0) {
            newPoint.y = 0;
        }
        if (newPoint.y > ymax) {
            newPoint.y = ymax;
        }
        switch (resizeHandle) {
            case 0: {
                int newXSize = r.x + r.width - newPoint.x;
                int newYSize = r.y + r.height - newPoint.y;
                if ((int)((double)newXSize / this.aspect) <= newYSize) {
                    newYSize = (int)((double)newXSize / this.aspect);
                } else {
                    newXSize = (int)((double)newYSize * this.aspect);
                }
                newXSize = Math.max(Math.min(newXSize, maxViewSize.width), minViewSize.width);
                newYSize = Math.max(Math.min(newYSize, maxViewSize.height), minViewSize.height);
                r.x = r.x + r.width - newXSize;
                r.y = r.y + r.height - newYSize;
                r.width = newXSize;
                r.height = newYSize;
                break;
            }
            case 1: {
                int newYSize = r.y + r.height - newPoint.y;
                int newXSize = (int)((double)newYSize * this.aspect);
                int maxXSize = (int)(2.0 * Math.min((double)r.x + (double)r.width / 2.0, (double)(xmax - r.x) - (double)r.width / 2.0));
                if (newXSize > maxXSize) {
                    newXSize = maxXSize;
                    newYSize = (int)((double)maxXSize / this.aspect);
                }
                newXSize = Math.max(Math.min(newXSize, maxViewSize.width), minViewSize.width);
                newYSize = Math.max(Math.min(newYSize, maxViewSize.height), minViewSize.height);
                r.y = r.y + r.height - newYSize;
                r.x = r.x + r.width / 2 - newXSize / 2;
                r.width = newXSize;
                r.height = newYSize;
                break;
            }
            case 2: {
                int newXSize = newPoint.x - r.x;
                int newYSize = r.y + r.height - newPoint.y;
                if ((int)((double)newXSize / this.aspect) <= newYSize) {
                    newYSize = (int)((double)newXSize / this.aspect);
                } else {
                    newXSize = (int)((double)newYSize * this.aspect);
                }
                newXSize = Math.max(Math.min(newXSize, maxViewSize.width), minViewSize.width);
                newYSize = Math.max(Math.min(newYSize, maxViewSize.height), minViewSize.height);
                r.y = r.y + r.height - newYSize;
                r.width = newXSize;
                r.height = newYSize;
                break;
            }
            case 3: {
                int newXSize = newPoint.x - r.x;
                int newYSize = (int)((double)newXSize / this.aspect);
                int maxYSize = (int)(2.0 * Math.min((double)r.y + (double)r.height / 2.0, (double)(ymax - r.y) - (double)r.height / 2.0));
                if (newYSize > maxYSize) {
                    newYSize = maxYSize;
                    newXSize = (int)((double)maxYSize * this.aspect);
                }
                newXSize = Math.max(Math.min(newXSize, maxViewSize.width), minViewSize.width);
                newYSize = Math.max(Math.min(newYSize, maxViewSize.height), minViewSize.height);
                r.y = r.y + r.height / 2 - newYSize / 2;
                r.width = newXSize;
                r.height = newYSize;
                break;
            }
            case 4: {
                int newXSize = newPoint.x - r.x;
                int newYSize = newPoint.y - r.y;
                if ((int)((double)newXSize / this.aspect) <= newYSize) {
                    newYSize = (int)((double)newXSize / this.aspect);
                } else {
                    newXSize = (int)((double)newYSize * this.aspect);
                }
                newXSize = Math.max(Math.min(newXSize, maxViewSize.width), minViewSize.width);
                newYSize = Math.max(Math.min(newYSize, maxViewSize.height), minViewSize.height);
                r.width = newXSize;
                r.height = newYSize;
                break;
            }
            case 5: {
                int newYSize = newPoint.y - r.y;
                int newXSize = (int)((double)newYSize * this.aspect);
                int maxXSize = (int)(2.0 * Math.min((double)r.x + (double)r.width / 2.0, (double)(xmax - r.x) - (double)r.width / 2.0));
                if (newXSize > maxXSize) {
                    newXSize = maxXSize;
                    newYSize = (int)((double)maxXSize / this.aspect);
                }
                newXSize = Math.max(Math.min(newXSize, maxViewSize.width), minViewSize.width);
                newYSize = Math.max(Math.min(newYSize, maxViewSize.height), minViewSize.height);
                r.x = r.x + r.width / 2 - newXSize / 2;
                r.width = newXSize;
                r.height = newYSize;
                break;
            }
            case 6: {
                int newXSize = r.x + r.width - newPoint.x;
                int newYSize = newPoint.y - r.y;
                if ((int)((double)newXSize / this.aspect) <= newYSize) {
                    newYSize = (int)((double)newXSize / this.aspect);
                } else {
                    newXSize = (int)((double)newYSize * this.aspect);
                }
                r.x = r.x + r.width - newXSize;
                r.width = newXSize;
                r.height = newYSize;
                break;
            }
            case 7: {
                int newXSize = r.x + r.width - newPoint.x;
                int newYSize = (int)((double)newXSize / this.aspect);
                int maxYSize = (int)(2.0 * Math.min((double)r.y + (double)r.height / 2.0, (double)(ymax - r.y) - (double)r.height / 2.0));
                if (newYSize > maxYSize) {
                    newYSize = maxYSize;
                    newXSize = (int)((double)maxYSize * this.aspect);
                }
                newXSize = Math.max(Math.min(newXSize, maxViewSize.width), minViewSize.width);
                newYSize = Math.max(Math.min(newYSize, maxViewSize.height), minViewSize.height);
                r.x = r.x + r.width - newXSize;
                r.y = r.y + r.height / 2 - newYSize / 2;
                r.width = newXSize;
                r.height = newYSize;
                break;
            }
        }
    }

    public void updateOverview(boolean forceRedraw) {
        int newDocWidth = this.view.getDocumentWidth();
        int newDocHeight = this.view.getDocumentHeight();
        this.aspect = (double)this.view.getWidth() / (double)this.view.getHeight();
        Rectangle viewRect = this.view.getViewRect();
        this.roi.setBBox(viewRect);
        if (forceRedraw || newDocWidth != this.currentDocWidth || newDocHeight != this.currentDocHeight) {
            this.currentDocWidth = newDocWidth;
            this.currentDocHeight = newDocHeight;
            this.resetRenderMode();
            this.cleanBufferDirty = true;
            this.repaint();
        } else {
            this.blitCleanBuffer();
            this.renderDraggedPrimitives();
            this.repaint();
        }
    }

    class OverviewMouseMotionAdapter
    extends MouseMotionAdapter {
        PFDOverview oview;

        public OverviewMouseMotionAdapter(PFDOverview overview) {
            this.oview = overview;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            Object source = e.getSource();
            if (source == this.oview) {
                if (this.oview.cursorSpot == 2) {
                    return;
                }
                if (this.oview.cursorSpot == 1) {
                    this.oview.action = 1;
                    PFDOverview.this.ignoreViewportChanges = true;
                    Point pt = new Point(x + this.oview.initialOffsetX, y + this.oview.initialOffsetY);
                    this.oview.ViewToModel(pt);
                    Rectangle r = this.oview.roi.getBBox();
                    r.x = pt.x;
                    r.y = pt.y;
                    int w = PFDOverview.this.currentDocWidth;
                    int h = PFDOverview.this.currentDocHeight;
                    if (r.x < 0) {
                        r.x = 0;
                    }
                    if (r.x + r.width > w) {
                        r.x = w - r.width;
                    }
                    if (r.y < 0) {
                        r.y = 0;
                    }
                    if (r.y + r.height > h) {
                        r.y = h - r.height;
                    }
                    this.oview.roi.setBBox(r);
                    this.oview.blitCleanBuffer();
                    this.oview.renderDraggedPrimitives();
                    this.oview.repaint();
                    if (PFDOverview.this.updateMode == 0) {
                        this.oview.view.setViewPosition(new Point(r.x, r.y));
                    }
                } else {
                    this.oview.action = 2;
                    PFDOverview.this.ignoreViewportChanges = true;
                    Rectangle r = this.oview.roi.getBBox();
                    this.oview.calculateNewBBox(r, this.oview.handleIndex, x, y);
                    this.oview.roi.setBBox(r);
                    this.oview.blitCleanBuffer();
                    this.oview.renderDraggedPrimitives();
                    this.oview.repaint();
                    if (PFDOverview.this.updateMode == 0) {
                        this.oview.view.setViewRect(r);
                    }
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            Object source = e.getSource();
            if (source == this.oview) {
                if (this.oview.getCurrentXfm() == null) {
                    return;
                }
                Point p = new Point(x, y);
                this.oview.ViewToModel(p);
                if (this.oview.roiResizeHandle != null) {
                    this.oview.handleIndex = this.oview.roiResizeHandle.getSelectedResizeHandle(p);
                } else {
                    this.oview.handleIndex = -1;
                }
                if (this.oview.handleIndex >= 0) {
                    this.oview.roiResizeHandle;
                    this.oview.setCursor(Cursor.getPredefinedCursor(PFDHandle.getCursor(this.oview.handleIndex)));
                    this.oview.cursorSpot = 0;
                } else if (this.oview.roi.contains(p.x, p.y)) {
                    this.oview.setCursor(6);
                    this.oview.cursorSpot = 1;
                } else {
                    this.oview.setCursor(Cursor.getDefaultCursor());
                    this.oview.cursorSpot = 2;
                }
            }
        }
    }

    class OverviewMouseAdapter
    extends MouseAdapter {
        PFDOverview oview;

        public OverviewMouseAdapter(PFDOverview overview) {
            this.oview = overview;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            Object source = e.getSource();
            if (source == this.oview) {
                this.oview.clickedX = x;
                this.oview.clickedY = y;
                Point loc = this.oview.roi.getLocation();
                PFDOverview.this.ModelToView(loc);
                this.oview.initialOffsetX = loc.x - x;
                this.oview.initialOffsetY = loc.y - y;
                this.oview.action = 0;
            } else if (source instanceof JScrollBar && PFDOverview.this.updateMode == 1) {
                PFDOverview.this.ignoreViewportChanges = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Object source = e.getSource();
            if (source == this.oview) {
                if (this.oview.action == 0) {
                    return;
                }
                PFDOverview.this.ignoreViewportChanges = false;
                if (PFDOverview.this.updateMode == 1) {
                    if (this.oview.action == 2) {
                        Rectangle r = this.oview.roi.getRBBox();
                        this.oview.view.setViewRect(r);
                    } else if (PFDOverview.this.action == 1) {
                        Rectangle r = this.oview.roi.getRBBox();
                        this.oview.view.setViewPosition(new Point(r.x, r.y));
                    }
                }
                this.oview.updateOverview(false);
            } else if (source instanceof JScrollBar && PFDOverview.this.updateMode == 1) {
                PFDOverview.this.ignoreViewportChanges = false;
                Rectangle viewRect = this.oview.view.getViewRect();
                this.oview.roi.setBBox(viewRect);
                this.oview.repaint();
            }
        }
    }
}

