/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDNoteIcon;
import com.sas.graphics.components.pfd.PFDNoteWindow;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.components.pfd.interfaces.PFDCollapsableInterface;
import com.sas.graphics.components.pfd.ui.PFDChickletIcon;
import com.sas.graphics.components.pfd.ui.actions.PFDAbstractAction;
import com.sas.graphics.components.pfd.ui.actions.PFDActionGroup;
import com.sas.graphics.components.pfd.ui.actions.PFDCloseNoteAction;
import com.sas.graphics.components.pfd.ui.actions.PFDOpenNoteAction;
import com.sas.graphics.components.pfd.ui.actions.PFDSetNoteStyleAction;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextPane;

public class PFDNote
extends PFDGroup
implements PFDCollapsableInterface,
PropertyInterface {
    private static final long serialVersionUID = 1L;
    private static final Color defaultFillColor = SystemColor.info;
    private static final String RB_KEY = "PFDNote.";
    private PFDNoteWindow noteWindow;
    private PFDNoteIcon noteIcon;
    private String noteStyleContext = "NoteStyleYellow";
    private transient PFDSetNoteStyleAction styleActionYellow;
    private transient PFDSetNoteStyleAction styleActionBlue;
    private transient PFDSetNoteStyleAction styleActionPink;
    private static final int menuIconSize = 12;
    private boolean isCollapsed = true;
    private transient JMenu colorMenu;
    protected transient PropertyList pending = null;
    private String DEFAULT_noteStyleContext = new String(this.noteStyleContext);
    private Boolean DEFAULT_isCollapsed = new Boolean(this.isCollapsed);
    private int DEFAULT_width = 180;
    private int DEFAULT_height = 141;

    public PFDNote() {
        this.initialize();
    }

    private void initialize() {
        this.setEditable(true);
        this.setBreakable(false);
        this.setCustomSelection(true);
        this.initializeActions();
        this.noteWindow = new PFDNoteWindow(this);
        this.noteWindow.setNoteStyleContext(this.noteStyleContext);
        this.DEFAULT_width = this.noteWindow.getWidth();
        this.DEFAULT_height = this.noteWindow.getHeight();
        this.noteIcon = new PFDNoteIcon(this);
        this.noteIcon.setNoteStyleContext(this.noteStyleContext);
        this.addPrimitive(this.noteIcon);
        this.noteIcon.setExpanded(this.noteWindow);
        this.pending = new PropertyList();
    }

    private void initializeActions() {
        this.styleActionYellow = new PFDSetNoteStyleAction(this, "NoteStyleYellow");
        this.styleActionYellow.putValue("ShortDescription", RB.getStringResource(RB_KEY, "styleActionYellow.tip"));
        this.styleActionYellow.setSelected(true);
        this.styleActionBlue = new PFDSetNoteStyleAction(this, "NoteStyleBlue");
        this.styleActionBlue.putValue("ShortDescription", RB.getStringResource(RB_KEY, "styleActionBlue.tip"));
        this.styleActionPink = new PFDSetNoteStyleAction(this, "NoteStylePink");
        this.styleActionPink.putValue("ShortDescription", RB.getStringResource(RB_KEY, "styleActionPink.tip"));
        PFDActionGroup group = new PFDActionGroup();
        group.addAction(this.styleActionYellow);
        group.addAction(this.styleActionBlue);
        group.addAction(this.styleActionPink);
    }

    protected void layoutChildren() {
        this.noteIcon.setLocation(this.bbox.x, this.bbox.y);
        this.noteWindow.setLocation(this.bbox.x, this.bbox.y);
        this.calculateBBox();
    }

    public void setText(String text) {
        this.noteWindow.setText(text);
        this.noteIcon.setText(text);
    }

    public String getText() {
        return this.noteWindow.getText();
    }

    public JTextPane getTextPane() {
        return this.noteWindow.getTextPane();
    }

    public void setNoteStyleContext(String styleContext) {
        if (styleContext == null || styleContext.equals(this.noteStyleContext)) {
            return;
        }
        this.noteStyleContext = styleContext;
        this.noteWindow.setNoteStyleContext(this.noteStyleContext);
        this.noteIcon.setNoteStyleContext(this.noteStyleContext);
        this.firePropertyChange("noteStyle");
    }

    public String getNoteStyleContext() {
        return this.noteStyleContext;
    }

    public PFDAbstractAction getStyleAction(String styleContext) {
        if (styleContext.equals("NoteStyleYellow")) {
            return this.styleActionYellow;
        }
        if (styleContext.equals("NoteStyleBlue")) {
            return this.styleActionBlue;
        }
        if (styleContext.equals("NoteStylePink")) {
            return this.styleActionPink;
        }
        return null;
    }

    private void setStyleColor(String styleName, Color color) {
        this.getStyleAction(styleName).putValue("SmallIcon", new PFDChickletIcon(color, color.darker(), 12, 12));
    }

    @Override
    protected void updateStyle() {
        if (this.model == null) {
            return;
        }
        Style style = this.model.getStyle();
        if (style == null) {
            return;
        }
        StyleElement se = style.getStyleElement("NoteStyleYellow");
        if (se != null) {
            this.setStyleColor("NoteStyleYellow", se.getColorAttribute("fillColor", defaultFillColor));
        }
        if ((se = style.getStyleElement("NoteStyleBlue")) != null) {
            this.setStyleColor("NoteStyleBlue", se.getColorAttribute("fillColor", defaultFillColor));
        }
        if ((se = style.getStyleElement("NoteStylePink")) != null) {
            this.setStyleColor("NoteStylePink", se.getColorAttribute("fillColor", defaultFillColor));
        }
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("children")) {
            this.layoutChildren();
        } else if (property.equals("style")) {
            this.updateStyle();
        } else if (property.equals("all")) {
            this.updateStyle();
            this.layoutChildren();
        }
        super.update(property, v);
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        g2d.setColor(defaultFillColor);
        g2d.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        g2d.setColor(Color.black);
        g2d.drawRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDNote clone = new PFDNote();
        table.put(this, clone);
        this.copyObject(clone);
        return clone;
    }

    public void copyObject(PFDNote toObject) {
        super.copyObject(toObject);
        toObject.setText(this.getText());
        toObject.setNoteStyleContext(this.getNoteStyleContext());
        toObject.setLocation(this.getLocation());
    }

    @Override
    public void setCollapsed(boolean collapsed) {
        if (collapsed == this.isCollapsed) {
            return;
        }
        this.isCollapsed = collapsed;
        if (this.isCollapsed) {
            this.noteWindow.collapse();
            this.noteIcon.setText(this.noteWindow.getText());
        } else {
            this.noteIcon.expand();
            this.noteWindow.getTextPane().requestFocusInWindow();
        }
        this.firePropertyChange("isCollapsed");
    }

    @Override
    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    @Override
    public void updateCollapsed() {
    }

    @Override
    public List getMenuItems() {
        Vector<JComponent> items = new Vector<JComponent>();
        if (this.isCollapsed) {
            Action open = this.getAction("ACTION_OPEN_NOTE");
            items.add(new JMenuItem(open));
            items.add(new JPopupMenu.Separator());
        }
        items.addAll(super.getMenuItems());
        items.add(new JPopupMenu.Separator());
        if (this.colorMenu == null) {
            this.colorMenu = this.createColorMenu();
        }
        this.updateColorMenu();
        items.add(this.colorMenu);
        if (!this.isCollapsed) {
            items.add(new JPopupMenu.Separator());
            Action close = this.getAction("ACTION_CLOSE_NOTE");
            items.add(new JMenuItem(close));
        }
        return items;
    }

    private JMenu createColorMenu() {
        JMenu colorMenu = new JMenu(RB.getStringResource(RB_KEY, "colorMenu.name.txt"));
        PFDAbstractAction yellowAction = this.getStyleAction("NoteStyleYellow");
        PFDAbstractAction blueAction = this.getStyleAction("NoteStyleBlue");
        PFDAbstractAction pinkAction = this.getStyleAction("NoteStylePink");
        JRadioButtonMenuItem yellowButton = new JRadioButtonMenuItem(yellowAction);
        yellowAction.addButton(yellowButton);
        JRadioButtonMenuItem blueButton = new JRadioButtonMenuItem(blueAction);
        blueAction.addButton(blueButton);
        JRadioButtonMenuItem pinkButton = new JRadioButtonMenuItem(pinkAction);
        pinkAction.addButton(pinkButton);
        colorMenu.add(yellowButton);
        colorMenu.add(blueButton);
        colorMenu.add(pinkButton);
        return colorMenu;
    }

    private void updateColorMenu() {
        PFDAbstractAction styleAction = this.getStyleAction(this.noteStyleContext);
        if (styleAction != null) {
            styleAction.putValue("pfdAbstractAction.selected", Boolean.TRUE);
        }
    }

    @Override
    protected Action createAction(String actionKey) {
        if (actionKey == null) {
            return null;
        }
        if (actionKey.equals("ACTION_OPEN_NOTE")) {
            return new PFDOpenNoteAction(this);
        }
        if (actionKey.equals("ACTION_CLOSE_NOTE")) {
            return new PFDCloseNoteAction(this);
        }
        return super.createAction(actionKey);
    }

    public Dimension getWindowSize() {
        return this.noteWindow.getPreferredSize();
    }

    public void setWindowSize(Dimension size) {
        this.noteWindow.setPreferredSize(size);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeActions();
        this.pending = new PropertyList();
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        boolean rc = true;
        Vector changes = this.pending.getChangesBySource(source);
        if (changes.size() > 0) {
            rc = true;
            for (int i = 0; i < changes.size(); ++i) {
                PropertyEvent event = (PropertyEvent)changes.elementAt(i);
                int key = event.id;
                Object value = event.value;
                this.applyChange(key, value);
            }
        }
        this.pending.removeChangesBySource(source);
        return rc;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        switch (id) {
            case 600: {
                return this.noteStyleContext;
            }
            case 601: {
                return this.isCollapsed;
            }
            case 602: {
                return this.noteWindow.getWidth();
            }
            case 603: {
                return this.noteWindow.getHeight();
            }
            case 410: {
                return this.getPFDItemId();
            }
            case 408: {
                return this.getX();
            }
            case 409: {
                return this.getY();
            }
            case 604: {
                return this.getText();
            }
        }
        return null;
    }

    public boolean hasUserSetValue(int id) {
        boolean userSet = false;
        switch (id) {
            case 600: {
                if (this.noteStyleContext.equalsIgnoreCase(this.DEFAULT_noteStyleContext)) break;
                userSet = true;
                break;
            }
            case 601: {
                if (this.isCollapsed == this.DEFAULT_isCollapsed) break;
                userSet = true;
                break;
            }
            case 602: {
                if (this.noteWindow.getWidth() == this.DEFAULT_width) break;
                userSet = true;
                break;
            }
            case 603: {
                if (this.noteWindow.getHeight() == this.DEFAULT_height) break;
                userSet = true;
                break;
            }
            case 604: {
                if (this.getText().equals("")) break;
                userSet = true;
                break;
            }
            case 410: {
                userSet = true;
                break;
            }
            case 408: {
                userSet = true;
                break;
            }
            case 409: {
                userSet = true;
            }
        }
        return userSet;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public boolean isPropertySupported(int id) {
        switch (id) {
            case 408: 
            case 409: 
            case 410: 
            case 600: 
            case 601: 
            case 602: 
            case 603: 
            case 604: {
                return true;
            }
        }
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.isPropertySupported(id)) {
            return this.pending.store(id, value);
        }
        return false;
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 600: {
                if (!(value instanceof String)) break;
                this.setNoteStyleContext((String)value);
                break;
            }
            case 601: {
                if (!(value instanceof Boolean)) break;
                this.setCollapsed((Boolean)value);
                break;
            }
            case 602: {
                if (!(value instanceof Number)) break;
                this.noteWindow.setPreferredSize(new Dimension(((Number)value).intValue(), this.noteWindow.getPreferredSize().height));
                break;
            }
            case 603: {
                if (!(value instanceof Number)) break;
                this.noteWindow.setPreferredSize(new Dimension(this.noteWindow.getPreferredSize().width, ((Number)value).intValue()));
                break;
            }
            case 604: {
                if (!(value instanceof String)) break;
                this.setText((String)value);
                break;
            }
            case 410: {
                if (!(value instanceof String)) break;
                this.setPFDItemId((String)value);
                break;
            }
            case 408: {
                if (!(value instanceof Integer)) break;
                this.setLocation((Integer)value, this.getY());
                break;
            }
            case 409: {
                if (!(value instanceof Integer)) break;
                this.setLocation(this.getX(), (Integer)value);
            }
        }
    }
}

