/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDCollapsableNodeGroup;
import com.sas.graphics.components.pfd.PFDComponentPrimitive;
import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDDirectionalNodeInterface;
import com.sas.graphics.components.pfd.PFDEllipse;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDHoldChangeUpdateInterface;
import com.sas.graphics.components.pfd.PFDImage;
import com.sas.graphics.components.pfd.PFDImageNode;
import com.sas.graphics.components.pfd.PFDLayer;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDLinkLabel;
import com.sas.graphics.components.pfd.PFDListInterface;
import com.sas.graphics.components.pfd.PFDModelEvent;
import com.sas.graphics.components.pfd.PFDModelListener;
import com.sas.graphics.components.pfd.PFDNote;
import com.sas.graphics.components.pfd.PFDPolygon;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDRectangle;
import com.sas.graphics.components.pfd.PFDRoundRectangle;
import com.sas.graphics.components.pfd.PFDShapeIconNode;
import com.sas.graphics.components.pfd.PFDShapeNode;
import com.sas.graphics.components.pfd.PFDSimpleNode;
import com.sas.graphics.components.pfd.PFDSubdiagram;
import com.sas.graphics.components.pfd.PFDTableNode;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.components.pfd.interfaces.PFDLinkValidator;
import com.sas.graphics.components.pfd.xml.PFDParser;
import com.sas.graphics.components.pfd.xml.PFDParserFactory;
import com.sas.graphics.components.pfd.xml.parsers.GroupParser;
import com.sas.graphics.components.pfd.xml.parsers.PFDParserUtils;
import com.sas.graphics.data.TemporarySourceInterface;
import com.sas.graphics.interfaces.LinkLayoutInterface;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.interfaces.NodeLinkDiagramLayoutInterface;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.styles.Style;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableModel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PFDModel
implements PFDListInterface,
PFDHoldChangeUpdateInterface,
NodeLinkDiagramLayoutInterface,
Serializable,
SourceInterface,
TemporarySourceInterface {
    private static final long serialVersionUID = -6699609777702541233L;
    protected DataFilterReadInterface filter = null;
    protected DataFilterInfoInterface infoFilter = null;
    public static final String RB_KEY = "PFDModel.";
    public static final int COMPONENT = 0;
    public static final int ELLIPSE = 1;
    public static final int GROUP = 2;
    public static final int IMAGE = 3;
    public static final int IMAGE_NODE = 4;
    public static final int LINK = 5;
    public static final int LINK_LABEL = 6;
    public static final int POLYGON = 7;
    public static final int PORT = 8;
    public static final int RECTANGLE = 9;
    public static final int ROUND_RECTANGLE = 10;
    public static final int SHAPE_ICON_NODE = 11;
    public static final int SHAPE_NODE = 12;
    public static final int SIMPLE_NODE = 13;
    public static final int TABLE_NODE = 14;
    public static final int TEXT = 15;
    public static final int CUSTOM_NODE = 17;
    public static final int CUSTOM_PRIMITIVE = 18;
    public static final int SUBDIAGRAM = 19;
    private static Dimension minSize = new Dimension(640, 480);
    protected Vector layers = new Vector();
    protected PFDLayer flowLayer;
    protected PFDLayer defaultLayer = this.flowLayer = new PFDLayer();
    protected boolean modifiable = true;
    protected boolean enableUpdate = true;
    protected Dimension size = new Dimension(minSize);
    protected boolean forceNodePosition = false;
    protected transient EventListenerList listenerList = new EventListenerList();
    protected int eastBorderSpace = 0;
    protected int southBorderSpace = 0;
    private transient Style style = null;
    private PFDLinkValidator linkValidator = null;
    boolean sizeDirty = false;
    private String flowDirection = "Right";
    private boolean needNewDataModel = false;
    private Vector links = null;
    private String customParserLocation = null;

    public PFDModel() {
        this.addLayer(this.flowLayer);
        this.setStyle(this.loadStyle("/com/sas/graphics/components/pfd/styles/xml/PFDDEFAULT.xml"));
    }

    public PFDLayer getDefaultLayer() {
        return this.defaultLayer;
    }

    public void setDefaultLayer(PFDLayer l) {
        this.defaultLayer = l;
        this.fireModelChange(3, null, null);
    }

    public void setMinSize(Dimension size) {
        minSize = size;
    }

    public int getNumLayers() {
        return this.layers.size();
    }

    public PFDLayer getLayer(int index) {
        return (PFDLayer)this.layers.elementAt(index);
    }

    public void addLayer(PFDLayer l) {
        l.setModel(this);
        this.layers.addElement(l);
        this.fireModelChange(0, null, null);
    }

    public void addLayer(int index, PFDLayer l) {
        l.setModel(this);
        this.layers.insertElementAt(l, index);
        this.fireModelChange(0, null, null);
    }

    public void removeLayer(int index) {
        this.layers.removeElementAt(index);
        this.fireModelChange(1, null, null);
    }

    public void removeAllLayers() {
        this.layers.removeAllElements();
        this.fireModelChange(2, null, null);
    }

    @Override
    public int getNumPrimitives() {
        return this.getDefaultLayer().getNumPrimitives();
    }

    @Override
    public boolean hasNoPrimitives() {
        return this.getDefaultLayer().hasNoPrimitives();
    }

    @Override
    public boolean containsPrimitive(PFDPrimitive p) {
        return this.getDefaultLayer().containsPrimitive(p);
    }

    @Override
    public PFDPrimitive getPrimitive(int index) {
        return this.getDefaultLayer().getPrimitive(index);
    }

    @Override
    public PFDPrimitive setPrimitive(int index, PFDPrimitive p) {
        PFDPrimitive rv = this.getDefaultLayer().setPrimitive(index, p);
        this.fireModelChange(7, null, p);
        this.updateSize(p);
        return rv;
    }

    @Override
    public boolean addPrimitive(PFDPrimitive p) {
        if (p == null) {
            return false;
        }
        boolean rv = this.getDefaultLayer().addPrimitive(p);
        this.setPrimitiveFlowDirection(p);
        this.fireModelChange(4, null, p);
        this.updateSize(p);
        return rv;
    }

    @Override
    public void addPrimitive(int index, PFDPrimitive p) {
        if (p == null) {
            return;
        }
        this.getDefaultLayer().addPrimitive(index, p);
        this.setPrimitiveFlowDirection(p);
        this.fireModelChange(4, null, p);
        this.updateSize(p);
    }

    @Override
    public boolean removePrimitive(PFDPrimitive p) {
        if (p == null) {
            return false;
        }
        this.fireModelChange(11, null, p);
        p.removeModelAssociation();
        boolean ok = this.getDefaultLayer().removePrimitive(p);
        this.fireModelChange(5, null, p);
        this.sizeDirty = true;
        this.fireModelChange(10, null, null);
        return ok;
    }

    @Override
    public PFDPrimitive removePrimitive(int index) {
        PFDPrimitive p = this.getDefaultLayer().getPrimitive(index);
        this.fireModelChange(11, null, p);
        p.removeModelAssociation();
        this.getDefaultLayer().removePrimitive(p);
        this.fireModelChange(5, null, p);
        this.sizeDirty = true;
        this.fireModelChange(10, null, null);
        return p;
    }

    @Override
    public void removeAllPrimitives() {
        this.getDefaultLayer().removeAllPrimitives();
        this.fireModelChange(6, null, null);
        this.sizeDirty = true;
        this.fireModelChange(10, null, null);
    }

    @Override
    public int indexOfPrimitive(PFDPrimitive p) {
        return this.getDefaultLayer().indexOfPrimitive(p);
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public void setModifiable(boolean b) {
        this.modifiable = b;
        this.fireModelChange(9, null, null);
    }

    @Override
    public void disableChangeUpdate() {
        this.enableUpdate = false;
    }

    @Override
    public void enableChangeUpdate() {
        this.enableUpdate = true;
    }

    public boolean isChangeUpdateEnabled() {
        return this.enableUpdate;
    }

    public void crop() {
        this.calculateSize(true);
        this.fireModelChange(10, null, null);
    }

    public void normalizedAndCrop() {
        int i;
        int numberOfPrimitives = this.defaultLayer.getNumPrimitives() - 1;
        if (numberOfPrimitives == -1) {
            return;
        }
        this.size.setSize(minSize);
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        PFDPrimitive p = null;
        Rectangle r = null;
        for (i = numberOfPrimitives; i >= 0; --i) {
            p = this.defaultLayer.getPrimitive(i);
            if (!p.isVisible() || (r = p.getRBBox()).isEmpty()) continue;
            minX = Math.min(minX, r.x);
            maxX = Math.max(maxX, r.x + r.width + this.eastBorderSpace);
            minY = Math.min(minY, r.y);
            maxY = Math.max(maxY, r.y + r.height + this.southBorderSpace);
        }
        for (i = numberOfPrimitives; i >= 0; --i) {
            p = this.defaultLayer.getPrimitive(i);
            if (!p.isVisible()) continue;
            p.move(-minX, -minY);
        }
        this.size.width = maxX - minX;
        this.size.height = maxY - minY;
        this.sizeDirty = true;
        this.fireModelChange(10, null, null);
    }

    protected void calculateSize(boolean crop) {
        int numberOfPrimitives;
        Dimension oldSize = new Dimension(this.size);
        this.size.setSize(minSize);
        PFDPrimitive p = null;
        Rectangle r = null;
        for (int i = numberOfPrimitives = this.defaultLayer.getNumPrimitives() - 1; i >= 0; --i) {
            p = this.defaultLayer.getPrimitive(i);
            if (!p.isVisible()) continue;
            r = p.getRBBox();
            if (r.x + r.width + this.eastBorderSpace > this.size.width) {
                this.size.width = r.x + r.width + this.eastBorderSpace;
            }
            if (r.y + r.height + this.southBorderSpace <= this.size.height) continue;
            this.size.height = r.y + r.height + this.southBorderSpace;
        }
        if (!crop) {
            this.size.width = Math.max(this.size.width, oldSize.width);
            this.size.height = Math.max(this.size.height, oldSize.height);
        }
    }

    public Dimension getSize() {
        if (this.sizeDirty) {
            this.calculateSize(false);
            this.sizeDirty = false;
        }
        return this.size;
    }

    protected void updateSize(PFDPrimitive p) {
        Rectangle r = p.getRBBox();
        boolean changed = false;
        if (r.x + r.width + this.eastBorderSpace > this.size.width) {
            this.size.width = r.x + r.width + this.eastBorderSpace;
            changed = true;
        }
        if (r.y + r.height + this.southBorderSpace > this.size.height) {
            this.size.height = r.y + r.height + this.southBorderSpace;
            changed = true;
        }
        if (changed) {
            this.fireModelChange(10, null, null);
        }
    }

    protected void updateSize(Point p) {
        if (p == null) {
            return;
        }
        boolean changed = false;
        if (p.x > this.size.width) {
            this.size.width = p.x;
            changed = true;
        }
        if (p.y > this.size.height) {
            this.size.height = p.y;
            changed = true;
        }
        if (changed) {
            this.fireModelChange(10, null, null);
        }
    }

    public void updateSize(Dimension sz) {
        if (sz == null) {
            return;
        }
        boolean changed = false;
        if (sz.width > 0) {
            this.size.width = Math.max(PFDModel.minSize.width, sz.width);
            changed = true;
        }
        if (sz.height > 0) {
            this.size.height = Math.max(PFDModel.minSize.height, sz.height);
            changed = true;
        }
        if (changed) {
            this.fireModelChange(10, null, null);
        }
    }

    public Dimension getExcludedSize(List primitives) {
        int numberOfPrimitives;
        Dimension sz = new Dimension(minSize);
        PFDPrimitive p = null;
        Rectangle r = null;
        for (int i = numberOfPrimitives = this.defaultLayer.getNumPrimitives() - 1; i >= 0; --i) {
            p = this.defaultLayer.getPrimitive(i);
            if (!p.isVisible() || primitives.contains(p)) continue;
            r = p.getRBBox();
            if (r.x + r.width + this.eastBorderSpace > sz.width) {
                sz.width = r.x + r.width + this.eastBorderSpace;
            }
            if (r.y + r.height + this.southBorderSpace <= sz.height) continue;
            sz.height = r.y + r.height + this.southBorderSpace;
        }
        return sz;
    }

    public void addPFDModelListener(PFDModelListener l) {
        this.listenerList.add(PFDModelListener.class, l);
    }

    public void removePFDModelListener(PFDModelListener l) {
        this.listenerList.remove(PFDModelListener.class, l);
    }

    protected void firePFDModelChanged(PFDModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PFDModelListener.class) continue;
            ((PFDModelListener)listeners[i + 1]).modelChanged(e);
        }
        this.needNewDataModel = true;
    }

    protected void fireModelChange(int type, String property, PFDPrimitive p) {
        this.fireModelChange(type, property, p, null);
    }

    protected void fireModelChange(int type, String property, PFDPrimitive p, Object o) {
        if (!this.enableUpdate) {
            return;
        }
        PFDModelEvent e = new PFDModelEvent(this, type, property, p, o);
        this.firePFDModelChanged(e);
    }

    protected PFDPort getNearestPort(int x, int y) {
        double d = Double.MAX_VALUE;
        PFDPort nearest = null;
        for (int i = this.getNumPrimitives() - 1; i >= 0; --i) {
            double temp;
            double dist;
            PFDGroup g;
            PFDPort port;
            PFDPrimitive p = this.getPrimitive(i);
            if (p instanceof PFDPort) {
                PFDPort port2 = (PFDPort)p;
                double temp2 = (x - port2.getX()) * (x - port2.getX()) + (y - port2.getY()) * (y - port2.getY());
                double dist2 = Math.sqrt(temp2);
                if (!(dist2 < d)) continue;
                d = dist2;
                nearest = port2;
                continue;
            }
            if (!(p instanceof PFDGroup) || (port = (g = (PFDGroup)p).getNearestPort(x, y)) == null || !((dist = Math.sqrt(temp = (double)((x - port.getX()) * (x - port.getX()) + (y - port.getY()) * (y - port.getY())))) < d)) continue;
            d = dist;
            nearest = port;
        }
        return nearest;
    }

    public PFDGroup group(Vector primitives) {
        PFDGroup g = new PFDGroup();
        this.addPrimitive(g);
        for (int i = 0; i < primitives.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)primitives.elementAt(i);
            this.getDefaultLayer().removePrimitive(p);
            g.addPrimitive(p);
        }
        return g;
    }

    public PFDGroup group(Enumeration primitives) {
        PFDGroup g = new PFDGroup();
        this.addPrimitive(g);
        while (primitives.hasMoreElements()) {
            PFDPrimitive p = (PFDPrimitive)primitives.nextElement();
            this.getDefaultLayer().removePrimitive(p);
            g.addPrimitive(p);
        }
        return g;
    }

    public PFDCollapsableNodeGroup createGroup(List primitives) {
        return PFDCollapsableNodeGroup.createGroup(primitives, this);
    }

    public void ungroup(PFDGroup g) {
        Vector<PFDPrimitive> children = new Vector<PFDPrimitive>();
        for (int i = 0; i < g.getNumPrimitives(); ++i) {
            children.add(g.getPrimitive(i));
        }
        g.removeAllPrimitives();
        PFDPrimitive p = null;
        for (int i = 0; i < children.size(); ++i) {
            p = (PFDPrimitive)children.get(i);
            this.addPrimitive(p);
            if (p.isCollapsable() && p.getCollapsed() != null) {
                this.addPrimitive(p.getCollapsed());
            }
            if (!p.isExpandable() || p.getExpanded() == null) continue;
            this.addPrimitive(p.getExpanded());
        }
        this.removePrimitive(g);
    }

    public void bringToFront(Enumeration primitives) {
        this.getDefaultLayer().bringToFront(primitives);
        this.fireModelChange(8, null, null);
    }

    public void bringToFront(PFDPrimitive p) {
        this.getDefaultLayer().bringToFront(p);
        this.fireModelChange(8, null, p);
    }

    public void sendToBack(Enumeration primitives) {
        this.getDefaultLayer().sendToBack(primitives);
        this.fireModelChange(8, null, null);
    }

    public void sendToBack(PFDPrimitive p) {
        this.getDefaultLayer().sendToBack(p);
        this.fireModelChange(8, null, p);
    }

    public PFDPrimitive pickPrimitive(int x, int y) {
        for (int i = this.getNumPrimitives() - 1; i >= 0; --i) {
            PFDPrimitive p = this.getPrimitive(i);
            if (!p.isVisible() || !p.contains(x, y)) continue;
            return p.pickPrimitive(x, y);
        }
        return null;
    }

    public PFDPrimitive pickPrimitive(int x, int y, Class c) {
        for (int i = this.getNumPrimitives() - 1; i >= 0; --i) {
            PFDGroup g;
            PFDPrimitive pp;
            PFDPrimitive p = this.getPrimitive(i);
            if (!p.isVisible()) continue;
            if (c.isInstance(p) && p.contains(x, y)) {
                return p;
            }
            if (!(p instanceof PFDGroup) || (pp = (g = (PFDGroup)p).pickPrimitive(x, y, c)) == null) continue;
            return pp;
        }
        return null;
    }

    public PFDPrimitive pickPrimitive(int x, int y, int width, int height, Class c) {
        for (int i = this.getNumPrimitives() - 1; i >= 0; --i) {
            PFDGroup g;
            PFDPrimitive pp;
            PFDPrimitive p = this.getPrimitive(i);
            if (!p.isVisible()) continue;
            if (c.isInstance(p) && p.intersects(x, y, width, height)) {
                return p;
            }
            if (!(p instanceof PFDGroup) || (pp = (g = (PFDGroup)p).pickPrimitive(x, y, width, height, c)) == null) continue;
            return pp;
        }
        return null;
    }

    public static int getPrimitiveType(PFDPrimitive p) {
        if (p instanceof PFDComponentPrimitive) {
            return 0;
        }
        if (p instanceof PFDEllipse) {
            return 1;
        }
        if (p instanceof PFDImage) {
            return 3;
        }
        if (p instanceof PFDImageNode) {
            return 4;
        }
        if (p instanceof PFDLink) {
            return 5;
        }
        if (p instanceof PFDLinkLabel) {
            return 6;
        }
        if (p instanceof PFDPolygon) {
            return 7;
        }
        if (p instanceof PFDPort) {
            return 8;
        }
        if (p instanceof PFDRectangle) {
            return 9;
        }
        if (p instanceof PFDRoundRectangle) {
            return 10;
        }
        if (p instanceof PFDShapeIconNode) {
            return 11;
        }
        if (p instanceof PFDShapeNode) {
            return 12;
        }
        if (p instanceof PFDSimpleNode) {
            return 13;
        }
        if (p instanceof PFDTableNode) {
            return 14;
        }
        if (p instanceof PFDText) {
            return 15;
        }
        if (p instanceof PFDAbstractNode) {
            return 17;
        }
        if (p instanceof PFDSubdiagram) {
            return 19;
        }
        if (p instanceof PFDGroup) {
            return 2;
        }
        return 18;
    }

    public PFDPrimitive getNamedPrimitive(String name) {
        if (name == null) {
            return null;
        }
        for (int i = this.getNumPrimitives() - 1; i >= 0; --i) {
            PFDGroup g;
            PFDPrimitive pr;
            PFDPrimitive p = this.getPrimitive(i);
            if (name.equals(p.getName())) {
                return p;
            }
            if (!(p instanceof PFDGroup) || (pr = (g = (PFDGroup)p).getNamedPrimitive(name)) == null) continue;
            return pr;
        }
        return null;
    }

    @Override
    public Vector getAllLayoutNodes() {
        Vector<PFDPrimitive> v = new Vector<PFDPrimitive>();
        for (int i = 0; i < this.getNumPrimitives(); ++i) {
            PFDPrimitive p = this.getDefaultLayer().getOrderedPrimitive(i);
            if (p instanceof NodeLayoutInterface) {
                v.addElement(p);
                continue;
            }
            if (p instanceof PFDCollapsableNodeGroup) {
                PFDCollapsableNodeGroup g = (PFDCollapsableNodeGroup)p;
                v.add(g.getGroupNode());
                v.add(g.getGroupWindow().getSubdiagram());
                continue;
            }
            if (!(p instanceof PFDGroup)) continue;
            ((PFDGroup)p).accumulatePrimitive(v, NodeLayoutInterface.class);
        }
        return v;
    }

    @Override
    public Vector getAllNodes() {
        Vector<PFDPrimitive> v = new Vector<PFDPrimitive>();
        for (int i = 0; i < this.getNumPrimitives(); ++i) {
            PFDPrimitive p = this.getPrimitive(i);
            if (p instanceof PFDAbstractNode) {
                v.addElement(p);
            }
            if (!(p instanceof PFDGroup)) continue;
            ((PFDGroup)p).accumulateNodes(v);
        }
        return v;
    }

    public Vector[] getPrimitivesInVectorsByType() {
        int numberOfPrimitives = this.getNumPrimitives();
        if (numberOfPrimitives <= 0) {
            return null;
        }
        PFDPrimitive p = null;
        Class[] classList = new Class[]{PFDCompositeNode.class, PFDNote.class, PFDLink.class, PFDCollapsableNodeGroup.class};
        Vector[] vectorList = new Vector[classList.length];
        int numberOfClasses = classList.length;
        for (int i = numberOfPrimitives - 1; i >= 0; --i) {
            p = this.getPrimitive(i);
            for (int j = 0; j < numberOfClasses; ++j) {
                if (!classList[j].isInstance(p)) continue;
                if (vectorList[j] == null) {
                    vectorList[j] = new Vector();
                }
                vectorList[j].add(p);
                break;
            }
            if (!(p instanceof PFDCollapsableNodeGroup)) continue;
            this.getGroupedPrimitivesInVectorsByType((PFDCollapsableNodeGroup)p, vectorList, classList);
        }
        return vectorList;
    }

    protected void getGroupedPrimitivesInVectorsByType(PFDCollapsableNodeGroup g, Vector[] vectorList, Class[] classList) {
        int numberOfGroupItems = g.getGroupPrimitiveCount();
        int numberOfClasses = classList.length;
        for (int i = numberOfGroupItems - 1; i >= 0; --i) {
            PFDPrimitive p = g.getGroupPrimitive(i);
            for (int j = 0; j < numberOfClasses; ++j) {
                if (!classList[j].isInstance(p)) continue;
                if (vectorList[j] == null) {
                    vectorList[j] = new Vector();
                }
                vectorList[j].add(p);
            }
            if (!(p instanceof PFDCollapsableNodeGroup)) continue;
            this.getGroupedPrimitivesInVectorsByType((PFDCollapsableNodeGroup)p, vectorList, classList);
        }
    }

    @Override
    public Vector getAllLinks() {
        Vector<PFDPrimitive> v = new Vector<PFDPrimitive>();
        for (int i = 0; i < this.getNumPrimitives(); ++i) {
            PFDPrimitive p = this.getPrimitive(i);
            if (p instanceof PFDLink) {
                v.addElement(p);
            }
            if (!(p instanceof PFDGroup)) continue;
            ((PFDGroup)p).accumulatePrimitive(v, PFDLink.class);
        }
        return v;
    }

    public List getAllPrimitives() {
        Vector<PFDPrimitive> primitives = new Vector<PFDPrimitive>();
        for (int i = 0; i < this.getNumPrimitives(); ++i) {
            PFDPrimitive p = this.getPrimitive(i);
            if (p instanceof PFDCollapsableNodeGroup) {
                primitives.addAll(((PFDCollapsableNodeGroup)p).getNestedGroupPrimitives());
                continue;
            }
            primitives.add(p);
        }
        return primitives;
    }

    @Override
    public NodeLayoutInterface createDummyNode(int width, int height) {
        PFDSimpleNode sn = new PFDSimpleNode(new Point(0, 0), new Dimension(width, height), null);
        sn.getPort().setFreeSpotOffsetX(0);
        sn.getPort().setFreeSpotOffsetY(0);
        sn.setVisible(false);
        return sn;
    }

    @Override
    public String getFlowDirection() {
        return this.flowDirection;
    }

    @Override
    public void setFlowDirection(String direction) {
        PFDModel.checkFlowDirection(direction);
        if (this.flowDirection.equalsIgnoreCase(direction)) {
            return;
        }
        this.flowDirection = direction;
        for (int i = this.getNumPrimitives() - 1; i >= 0; --i) {
            PFDPrimitive p = this.getPrimitive(i);
            this.setPrimitiveFlowDirection(p);
        }
    }

    public static void checkFlowDirection(String direction) {
        if (direction == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "direction.ex.txt"));
        }
        if (direction.equalsIgnoreCase("Left") || direction.equalsIgnoreCase("Right") || direction.equalsIgnoreCase("Up") || direction.equalsIgnoreCase("Down")) {
            return;
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "direction.ex.txt"));
    }

    private void setPrimitiveFlowDirection(PFDPrimitive p) {
        if (p instanceof PFDDirectionalNodeInterface) {
            ((PFDDirectionalNodeInterface)((Object)p)).setFlowDirection(this.flowDirection);
        }
    }

    public Enumeration roots() {
        Vector<PFDAbstractNode> rv = new Vector<PFDAbstractNode>();
        Vector an = this.getAllNodes();
        for (int i = 0; i < an.size(); ++i) {
            PFDAbstractNode n = (PFDAbstractNode)an.elementAt(i);
            if (n.getParentCount() != 0) continue;
            rv.addElement(n);
        }
        return rv.elements();
    }

    public PFDAbstractNode getChild(PFDAbstractNode parent, int index) {
        if (parent.getModel() != this) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "node.ex.txt"));
        }
        return parent.getChildAt(index);
    }

    public int getChildCount(PFDAbstractNode parent) {
        if (parent.getModel() != this) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "node.ex.txt"));
        }
        return parent.getChildCount();
    }

    public int getIndexOfChild(PFDAbstractNode parent, PFDAbstractNode child) {
        if (parent.getModel() != this) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "node.ex.txt"));
        }
        return parent.getChildIndex(child);
    }

    public boolean isLeaf(PFDAbstractNode node) {
        if (node.getModel() != this) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "node.ex.txt"));
        }
        return node.isLeaf();
    }

    public PFDAbstractNode getParent(PFDAbstractNode child, int index) {
        if (child.getModel() != this) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "node.ex.txt"));
        }
        return child.getParentAt(index);
    }

    public int getParentCount(PFDAbstractNode child) {
        if (child.getModel() != this) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "node.ex.txt"));
        }
        return child.getParentCount();
    }

    public int getIndexOfParent(PFDAbstractNode child, PFDAbstractNode parent) {
        if (child.getModel() != this) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "node.ex.txt"));
        }
        return child.getParentIndex(parent);
    }

    public void setBorderSpace(int east, int south) {
        if (east < 0) {
            east = 0;
        }
        if (south < 0) {
            south = 0;
        }
        this.eastBorderSpace = east;
        this.southBorderSpace = south;
    }

    @Override
    public void setForceNodePosition(boolean force) {
        this.forceNodePosition = force;
    }

    @Override
    public boolean getForceNodePosition() {
        return this.forceNodePosition;
    }

    public boolean setStyle(Style s) {
        if (s == null) {
            return false;
        }
        if (s.equals(this.style)) {
            return true;
        }
        this.style = s;
        this.style.setFallbackEnabled(false);
        for (int i = 0; i < this.layers.size(); ++i) {
            PFDLayer layer = (PFDLayer)this.layers.get(i);
            for (int j = 0; j < layer.getNumPrimitives(); ++j) {
                PFDPrimitive p = layer.getPrimitive(i);
                p.update("style", null);
            }
        }
        this.fireModelChange(12, "style", null, this.style);
        return true;
    }

    public Style getStyle() {
        return this.style;
    }

    private Style loadStyle(String styleString) {
        if (styleString == null) {
            return null;
        }
        InputStream is = PFDModel.class.getResourceAsStream(styleString);
        if (is == null) {
            return null;
        }
        Style rc = Style.getStyle((InputStream)is);
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rc;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (int i = 0; i < this.layers.size(); ++i) {
            PFDLayer layer = (PFDLayer)this.layers.elementAt(i);
            if (layer == null) continue;
            for (int j = 0; j < layer.getNumPrimitives(); ++j) {
                PFDPrimitive p = layer.getPrimitive(j);
                p.setModel(this);
                p.setLayer(layer);
            }
        }
        this.listenerList = new EventListenerList();
        this.setStyle(this.loadStyle("/com/sas/graphics/components/pfd/styles/xml/PFDDEFAULT.xml"));
    }

    @Override
    public void removeLink(LinkLayoutInterface link) {
        this.removePrimitive((PFDPrimitive)((Object)link));
    }

    public PFDLinkValidator getLinkValidator() {
        return this.linkValidator;
    }

    public void setLinkValidator(PFDLinkValidator linkValidator) {
        this.linkValidator = linkValidator;
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public Object getDataSource(Object id) {
        if (this.filter == null || this.needNewDataModel) {
            Vector orderedPrimitives = this.getDefaultLayer().getCopyOfOrderedPrimitives();
            if (orderedPrimitives == null) {
                return null;
            }
            Vector orderedXMLDescriptions = new Vector();
            Vector orderedIds = new Vector();
            PFDParserFactory.loadPFDParsers();
            Hashtable tempContext = new Hashtable();
            this.loadPrimitivesIntoContext(orderedPrimitives, tempContext, true);
            if (this.links != null) {
                this.loadPrimitivesIntoContext(this.links, tempContext, false);
            }
            this.createOrderedVectors(tempContext, orderedPrimitives, orderedXMLDescriptions, orderedIds);
            DefaultTableModel pfdModel = new DefaultTableModel();
            pfdModel.addColumn((Object)"id", orderedIds);
            pfdModel.addColumn((Object)"pfditem", orderedXMLDescriptions);
            this.filter = FilterFactory.getDataSourceFilter((Object)pfdModel);
            if (this.filter != null) {
                this.infoFilter = (DataFilterInfoInterface)this.filter;
            }
            this.needNewDataModel = false;
        }
        return this.filter.getSource();
    }

    protected void loadPrimitivesIntoContext(Vector primitives, Hashtable context, boolean skipAndStoreLinks) {
        int numberOfPrimitives = primitives.size();
        if (numberOfPrimitives <= 0) {
            return;
        }
        PFDPrimitive p = null;
        int i = 0;
        while (i < numberOfPrimitives) {
            p = (PFDPrimitive)primitives.get(i);
            if (p instanceof PFDCollapsableNodeGroup) {
                this.loadPrimitivesIntoContext(((PFDCollapsableNodeGroup)p).getGroupWindow().getSubdiagram().children, context, true);
            }
            if (skipAndStoreLinks && p instanceof PFDLink) {
                if (((PFDLink)p).isCollapsed) {
                    primitives.remove(p);
                    --numberOfPrimitives;
                    continue;
                }
                if (this.links == null) {
                    this.links = new Vector();
                }
                this.links.add(p);
            } else {
                PFDParserFactory.loadParser((Object)p).putToXML(context, (Object)p);
            }
            ++i;
        }
    }

    protected void createOrderedVectors(Hashtable context, Vector orderedPrimitives, Vector orderedXMLDescriptions, Vector orderedIds) {
        int numberOfPrimitives = orderedPrimitives.size();
        if (numberOfPrimitives <= 0) {
            return;
        }
        PFDPrimitive p = null;
        for (int i = 0; i < numberOfPrimitives; ++i) {
            p = (PFDPrimitive)orderedPrimitives.get(i);
            orderedIds.add(p.getPFDItemId());
            orderedXMLDescriptions.add(context.get(p.getPFDItemId()));
            if (!(p instanceof PFDCollapsableNodeGroup)) continue;
            this.createOrderedVectors(context, ((PFDCollapsableNodeGroup)p).getGroupWindow().getSubdiagram().children, orderedXMLDescriptions, orderedIds);
        }
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public boolean setDataSource(Object source, Object id) {
        if (source == null || this.filter != null && source == this.filter.getSource()) {
            return false;
        }
        this.filter = FilterFactory.getDataSourceFilter((Object)source);
        if (this.filter != null) {
            this.infoFilter = (DataFilterInfoInterface)this.filter;
        }
        String column = "pfditem";
        if (id != null) {
            column = (String)id;
        }
        Hashtable context = new Hashtable();
        int numberOfObs = this.filter.getNumberObservations(-1);
        StringBuffer dom = new StringBuffer();
        dom.append("<PFDData>");
        for (int i = 0; i < numberOfObs; ++i) {
            dom.append((String)this.filter.getValue((Object)column, (long)i));
        }
        dom.append("</PFDData>");
        Element dataroot = PFDParser.getElement((Reader)new StringReader(dom.toString()));
        NodeList childrens = dataroot.getChildNodes();
        numberOfObs = childrens.getLength();
        Vector<String> zAxisOrder = new Vector<String>(numberOfObs);
        Hashtable<String, Element> nodesAndNotes = new Hashtable<String, Element>();
        Hashtable<String, Element> links = new Hashtable<String, Element>();
        for (int i = 0; i < numberOfObs; ++i) {
            if (!(childrens.item(i) instanceof Element)) {
                System.out.println(childrens.item(i).toString());
                continue;
            }
            Element e = (Element)childrens.item(i);
            String primitiveID = e.getAttribute("id");
            if (primitiveID == null || primitiveID.trim().length() == 0) continue;
            zAxisOrder.add(primitiveID);
            String tagName = e.getTagName();
            if (tagName.equalsIgnoreCase("PFDNode") || tagName.equalsIgnoreCase("PFDNote")) {
                nodesAndNotes.put(primitiveID, e);
                continue;
            }
            if (tagName.equalsIgnoreCase("PFDLink")) {
                links.put(primitiveID, e);
                continue;
            }
            if (!tagName.equalsIgnoreCase("PFDGroup")) continue;
            GroupParser.addToUnparsedGroupList(e);
        }
        this.loadPrimitivesIntoContext(context, nodesAndNotes);
        this.loadPrimitivesIntoContext(context, links);
        if (GroupParser.hasUnparsedGroups()) {
            new GroupParser().parseGroups(context);
        }
        boolean oldBoolean = this.defaultLayer.getBringToFront();
        this.defaultLayer.setBringToFront(false);
        this.loadPrimitivesIntoGroup(context, zAxisOrder, this, 0, zAxisOrder.size());
        this.defaultLayer.setBringToFront(oldBoolean);
        return this.filter != null;
    }

    protected void loadPrimitivesIntoGroup(Hashtable context, Vector zAxisOrder, PFDListInterface group, int firstPrimitive, int lastPrimitive) {
        PFDPrimitive p = null;
        for (int i = firstPrimitive; i < lastPrimitive; ++i) {
            p = (PFDPrimitive)context.get(zAxisOrder.get(i).toString());
            if (p == null || p instanceof PFDPort) continue;
            group.addPrimitive(p);
        }
    }

    protected void loadPrimitivesIntoContext(Hashtable context, Hashtable listOfPrimitives) {
        Enumeration keys = listOfPrimitives.keys();
        while (keys.hasMoreElements()) {
            PFDPrimitive p = PFDParserUtils.getPrimitiveFromDOMElement(context, (Element)listOfPrimitives.get(keys.nextElement()));
            if (p == null) continue;
            context.put(p.getPFDItemId(), p);
        }
    }

    public boolean dataSourceIsObsolete() {
        return this.needNewDataModel;
    }

    public Object getObsoleteDataSource() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getSource();
    }

    public void destroyObsoleteDataSource() {
        if (this.filter != null) {
            this.filter.removeSource();
        }
    }

    public String getCustomParserLocation() {
        return this.customParserLocation;
    }

    public void setCustomParserLocation(String location) {
        this.customParserLocation = location;
    }
}

