/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDTextPaneWindow;
import com.sas.graphics.components.pfd.interfaces.PFDWindowContainerInterface;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import java.awt.Color;
import java.awt.Dimension;

public class PFDMessageWindow
extends PFDTextPaneWindow {
    private PFDWindowContainerInterface container;
    private String userText;
    private static final String HEAD_TAG_START = "<head><style type=\"text/css\">p{width: ";
    private static final String HEAD_TAG_END = "pt; margin: 0pt; padding: 0pt}</style></head><p>";
    private static final int SCROLL_PADDING = 18;

    public PFDMessageWindow(PFDWindowContainerInterface container) {
        this.container = container;
        this.initialize();
    }

    private void initialize() {
        this.minWindowSize = new Dimension(180, 73);
        this.maxWindowSize = new Dimension(180, 193);
        this.defaultWindowSize = this.minWindowSize;
        this.preferredSize.setSize(this.defaultWindowSize);
        this.setSelectable(false);
        this.setDraggable(false);
        this.setResizable(false);
        this.textEditable = false;
        this.textEditPane.setEditable(false);
        this.textEditPane.setContentType("text/html");
        this.textEditPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
    }

    @Override
    protected void closeWindow() {
        if (this.container != null) {
            this.container.setWindowVisible(this, false);
        }
    }

    @Override
    protected void updateStyle(Style style) {
        super.updateStyle(style);
        StyleElement se = style.getStyleElement("MessageStyle");
        if (se != null) {
            this.setFillColor(se.getColorAttribute("fillColor", defaultFillColor));
            Color lineColor = se.getColorAttribute("lineColor", defaultOutlineColor);
            Color contrastColor = se.getColorAttribute("altColor", defaultOutlineColor);
            this.setOutlineColor(lineColor);
            this.setLineColor(contrastColor);
        }
    }

    @Override
    public void setText(String text) {
        if (text == null ? this.userText == null : text.equals(this.userText)) {
            return;
        }
        this.userText = text;
        this.setHTMLText(text);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    private void setHTMLText(String text) {
        Dimension minComponentSize = this.getContentSize(this.minWindowSize);
        String formattedText = this.getHTMLText(text, minComponentSize.width);
        this.textEditPane.setText(formattedText);
        this.pack();
        if (this.needsVerticalScrollbar) {
            formattedText = this.getHTMLText(text, minComponentSize.width - 18);
            this.textEditPane.setText(formattedText);
            this.pack();
        }
    }

    private String getHTMLText(String text, int width) {
        StringBuffer formattedText = new StringBuffer();
        formattedText.append(HEAD_TAG_START);
        formattedText.append(width);
        formattedText.append(HEAD_TAG_END);
        formattedText.append(text);
        return formattedText.toString();
    }
}

