/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.text.AttributedCharacterIterator;

public class PFDLineBreakMeasurer {
    private TextMeasurer tm;
    private int position;
    private AttributedCharacterIterator txt;

    public PFDLineBreakMeasurer(AttributedCharacterIterator text, FontRenderContext frc) {
        this.txt = text;
        this.tm = new TextMeasurer(text, frc);
        this.position = this.txt.getBeginIndex();
    }

    public TextLayout nextLayout(float wrappingWidth) {
        return this.nextLayout(wrappingWidth, true);
    }

    public TextLayout nextLayout(float wrappingWidth, boolean smartBreak) {
        char positionChar = this.txt.setIndex(this.position);
        char newLine = '\n';
        while (positionChar != '\uffff' && positionChar != newLine && Character.isWhitespace(positionChar)) {
            positionChar = this.txt.next();
            ++this.position;
        }
        if (positionChar == '\uffff') {
            return null;
        }
        if (positionChar == newLine) {
            TextLayout tl = this.tm.getLayout(this.position, this.position + 1);
            ++this.position;
            return tl;
        }
        int nextPosition = this.position + 1;
        int lastBreakPosition = this.position;
        int forceBreakPosition = this.position;
        char lastChar = positionChar;
        char nextChar = this.txt.next();
        while (nextChar != '\uffff') {
            if (nextChar == newLine) {
                TextLayout tl = this.tm.getLayout(this.position, nextPosition);
                this.position = nextPosition + 1;
                return tl;
            }
            float width = this.tm.getAdvanceBetween(this.position, nextPosition + 1);
            if (width > wrappingWidth) break;
            if (Character.isWhitespace(nextChar) && !Character.isWhitespace(lastChar)) {
                lastBreakPosition = nextPosition;
            }
            if (Character.isLetter(nextChar) && !Character.isLetter(lastChar) || !Character.isLetter(nextChar) && Character.isLetter(lastChar)) {
                forceBreakPosition = nextPosition;
            }
            ++nextPosition;
            lastChar = nextChar;
            nextChar = this.txt.next();
        }
        if (smartBreak && nextChar != '\uffff' && lastBreakPosition != this.position) {
            nextPosition = lastBreakPosition;
        } else if (smartBreak && nextChar != '\uffff' && forceBreakPosition != this.position) {
            nextPosition = forceBreakPosition;
        }
        TextLayout tl = this.tm.getLayout(this.position, nextPosition);
        this.position = nextPosition;
        return tl;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int newPosition) {
        this.position = newPosition;
    }
}

