/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDSelectionList;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;

public class PFDKeyAdapter
extends KeyAdapter {
    protected Vector disabledKeys = new Vector();
    public static final String RB_KEY = "PFDKeyAdapter.";

    protected boolean isKeyDisabled(String key) {
        return this.disabledKeys.contains(key);
    }

    public void disableKeyStroke(int keyCode) {
        String str = null;
        switch (keyCode) {
            default: {
                break;
            }
            case 27: {
                str = "VK_ESCAPE";
                break;
            }
            case 37: {
                str = "VK_LEFT";
                break;
            }
            case 39: {
                str = "VK_RIGHT";
                break;
            }
            case 127: {
                str = "VK_DELETE";
                break;
            }
            case 65: {
                str = "VK_A";
                break;
            }
            case 88: {
                str = "VK_X";
                break;
            }
            case 67: {
                str = "VK_C";
                break;
            }
            case 86: {
                str = "VK_V";
            }
        }
        if (str != null && !this.disabledKeys.contains(str)) {
            this.disabledKeys.addElement(str);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        PFDView v = (PFDView)e.getSource();
        PFDModel m = v.getModel();
        PFDSelectionList sl = v.getSelectionList();
        if (e.getKeyCode() == 37) {
            this.traverse(v, false);
            return;
        }
        if (e.getKeyCode() == 39) {
            this.traverse(v, true);
            return;
        }
        if (!e.isControlDown()) {
            if (e.getKeyCode() == 127 && !this.isKeyDisabled("VK_DELETE")) {
                v.clear();
            } else if (e.getKeyCode() == 27 && !this.isKeyDisabled("VK_ESCAPE")) {
                v.clearSelections();
            }
            return;
        }
        switch (e.getKeyCode()) {
            default: {
                break;
            }
            case 65: {
                if (this.isKeyDisabled("VK_A")) {
                    return;
                }
                v.selectAll();
                break;
            }
            case 88: {
                if (this.isKeyDisabled("VK_X")) {
                    return;
                }
                v.cut();
                break;
            }
            case 67: {
                if (this.isKeyDisabled("VK_C")) {
                    return;
                }
                v.copy();
                break;
            }
            case 86: {
                if (this.isKeyDisabled("VK_V")) {
                    return;
                }
                v.paste();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void traverse(PFDView v, boolean forward) {
        PFDSelectionList sl = v.getSelectionList();
        if (sl == null) {
            return;
        }
        PFDPrimitive p = sl.getLastPrimitive();
        PFDPrimitive prev = v.getNextSelection(p, forward);
        v.setHoldDisplay(true);
        v.clearSelections();
        if (prev != null) {
            v.selectPrimitive(prev);
            Rectangle vr = v.getViewRect();
            Rectangle bb = prev.getRBBox();
            Point newViewPos = new Point(vr.x, vr.y);
            if (bb.x < vr.x) {
                newViewPos.x = bb.x;
            } else if (bb.x + bb.width > vr.x + vr.width) {
                int dx = bb.x + bb.width - (vr.x + vr.width);
                newViewPos.x += dx;
            }
            if (bb.y < vr.y) {
                newViewPos.y = bb.y;
            } else if (bb.y + bb.height > vr.y + vr.height) {
                int dy = bb.y + bb.height - (vr.y + vr.height);
                newViewPos.y += dy;
            }
            v.setViewPosition(newViewPos);
        }
        v.setHoldDisplay(false);
    }
}

