/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDImageFileFilter;
import com.sas.graphics.components.pfd.PFDImageNode;
import com.sas.graphics.components.pfd.PFDPenCustomizerPanel;
import com.sas.graphics.components.pfd.PFDTextCustomizerPanel;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class PFDImageNodePropertyDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    public static final String RB_KEY = "PFDImageNodePropertyDialog.";
    PFDImageNode node;
    PFDView view;
    JTextField path;
    JButton browse;
    JCheckBox port;
    JCheckBox portSpot;
    JButton closeButton;
    protected static String lastFileIOPath;

    public PFDImageNodePropertyDialog(Frame aFrame, String title, PFDImageNode node, PFDView viewer) {
        super(aFrame, true);
        try {
            lastFileIOPath = System.getProperty("user.dir");
        }
        catch (Exception e) {
            lastFileIOPath = null;
        }
        this.setResizable(false);
        this.node = node;
        this.view = viewer;
        this.setTitle(title);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel imagePanel = new JPanel();
        imagePanel.setLayout(new BoxLayout(imagePanel, 0));
        JLabel imageLabel = new JLabel(RB.getStringResource(RB_KEY, "image.txt"));
        this.path = new JTextField();
        this.path.setPreferredSize(new Dimension(100, imageLabel.getPreferredSize().height + 5));
        this.path.addActionListener(this);
        this.browse = new JButton(RB.getStringResource(RB_KEY, "browse.txt"));
        this.browse.addActionListener(this);
        imagePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        imagePanel.add(imageLabel);
        imagePanel.add(Box.createRigidArea(new Dimension(10, 0)));
        imagePanel.add(this.path);
        imagePanel.add(this.browse);
        if (lastFileIOPath == null) {
            this.path.setEnabled(false);
            this.browse.setEnabled(false);
        }
        contentPane.add(imagePanel);
        contentPane.add(new PFDTextCustomizerPanel(node.getLabel()));
        contentPane.add(new PFDPenCustomizerPanel(node.getIcon().getPen()));
        JPanel portPanel = new JPanel();
        portPanel.setLayout(new BoxLayout(portPanel, 0));
        this.port = new JCheckBox(RB.getStringResource(RB_KEY, "port.txt"));
        this.port.addActionListener(this);
        portPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        portPanel.add(this.port);
        portPanel.add(Box.createHorizontalGlue());
        contentPane.add(portPanel);
        JPanel portSpotPanel = new JPanel();
        portSpotPanel.setLayout(new BoxLayout(portSpotPanel, 0));
        this.portSpot = new JCheckBox(RB.getStringResource(RB_KEY, "portSpot.txt"));
        this.portSpot.addActionListener(this);
        portSpotPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        portSpotPanel.add(this.portSpot);
        portSpotPanel.add(Box.createHorizontalGlue());
        contentPane.add(portSpotPanel);
        contentPane.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel closePanel = new JPanel();
        closePanel.setLayout(new BoxLayout(closePanel, 0));
        this.closeButton = new JButton(RB.getStringResource(RB_KEY, "close.txt"));
        closePanel.add(Box.createHorizontalGlue());
        closePanel.add(this.closeButton);
        contentPane.add(closePanel);
        this.closeButton.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(contentPane);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.path.setText(lastFileIOPath);
        this.port.setSelected(this.node.isForceShowPorts());
        this.node.getIcon().getPen().addPropertyChangeListener(this);
        this.portSpot.setSelected(this.node.isForceFixedAngleConnectionPorts());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.browse) {
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(new PFDImageFileFilter(0));
            fc.setFileSelectionMode(0);
            if (lastFileIOPath != null) {
                fc.setCurrentDirectory(new File(lastFileIOPath));
            }
            int returnVal = fc.showOpenDialog(this);
            File file = null;
            if (returnVal != 0) {
                return;
            }
            file = fc.getSelectedFile();
            lastFileIOPath = file.getAbsolutePath();
            this.path.setText(lastFileIOPath);
            Image image = Toolkit.getDefaultToolkit().getImage(file.getPath());
            MediaTracker imageTracker = new MediaTracker(this.view);
            imageTracker.addImage(image, 0);
            try {
                imageTracker.waitForAll();
            }
            catch (InterruptedException ie) {
                System.out.println(ie.getMessage());
            }
            this.node.getIcon().setImage(image);
        } else if (source == this.port) {
            this.node.setForceShowPorts(this.port.isSelected());
        } else if (source == this.portSpot) {
            this.node.setForceFixedAngleConnectionPorts(this.portSpot.isSelected());
        } else if (source == this.closeButton) {
            this.dispose();
            this.view.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.node.getIcon().getPen()) {
            this.view.repaint();
        }
    }
}

