/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public class PFDImage
extends PFDDrawablePrimitive {
    transient Image image;
    static final Color overviewColor = Color.gray;

    public PFDImage() {
        this((Image)null);
    }

    public PFDImage(Image icon) {
        this.image = icon;
        this.pen.setStyle(0);
        this.shadowSize = 2;
        this.shadowShift = 2;
        this.shadowOpacity = 0.16f;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image icon) {
        if (this.image == icon) {
            return;
        }
        this.image = icon;
        this.firePropertyChange("image");
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        if (this.image == null) {
            return;
        }
        if (this.shadowOn) {
            int oldStyle = this.pen.getStyle();
            this.pen.setStyle(0);
            this.drawShadow(g2d, v);
            this.pen.setStyle(oldStyle);
        }
        g2d.drawImage(this.image, this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height, null, v);
        if (this.pen.getStyle() != 0) {
            this.pen.apply(g2d);
            g2d.drawRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        }
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDImage clone = new PFDImage();
        table.put(this, clone);
        this.copyObject(clone);
        return clone;
    }

    public void copyObject(PFDImage toObject) {
        super.copyObject(toObject);
        toObject.setImage(this.getImage());
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        g2d.setColor(overviewColor);
        g2d.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        g2d.setColor(Color.black);
        g2d.drawRect(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.bbox.height - 1);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.image == null ? null : new ImageIcon(this.image));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ImageIcon imgIcon = (ImageIcon)in.readObject();
        this.image = imgIcon == null ? null : imgIcon.getImage();
    }
}

