/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDSelectionList;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class PFDHandle
extends PFDDrawablePrimitive {
    public static final String RB_KEY = "PFDHandle.";
    static final float[] dash1 = new float[]{5.0f};
    static final int[] cursors = new int[]{6, 8, 7, 11, 5, 9, 4, 10};
    int fillStyle = 0;
    Color handleColor = PFDSelectionList.defaultHandleColor;
    Color glassColor = PFDSelectionList.defaultGlassColor;
    int handleSize = 7;
    PFDPrimitive selected = null;
    Rectangle selectedBBox = null;
    boolean drawFilledHandles = true;
    transient Rectangle2D.Double[] bboxHandles = new Rectangle2D.Double[8];
    transient Rectangle2D.Double[] linkHandles;
    boolean bboxIncludeHandle = true;
    public static final int CROSS = 0;
    public static final int INSIDE = 1;
    public static final int OUTSIDE = 2;
    int handleSpot = 0;
    private boolean customEditorStyle = false;

    public boolean isCustomEditorStyle() {
        return this.customEditorStyle;
    }

    public void setCustomEditorStyle(boolean customEditorStyle) {
        this.customEditorStyle = customEditorStyle;
    }

    public PFDHandle(PFDPrimitive p) {
        this.selected = p;
    }

    public int getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(int style) {
        this.checkFillStyle(style);
        this.fillStyle = style;
    }

    private void checkFillStyle(int style) {
        switch (style) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "fill.ex.txt"));
            }
        }
    }

    public Color getHandleColor() {
        return this.handleColor;
    }

    public void setHandleColor(Color c) {
        this.handleColor = c;
        this.brush.setColor(this.handleColor);
    }

    public Color getGlassColor() {
        return this.glassColor;
    }

    public void setGlassColor(Color c) {
        this.glassColor = c;
    }

    protected boolean isBBoxIncludeHandle() {
        return this.bboxIncludeHandle;
    }

    protected void setBBoxIncludeHandle(boolean b) {
        this.bboxIncludeHandle = b;
    }

    protected void createHandles() {
        this.selectedBBox = this.selected.getBBox();
        if (this.selected instanceof PFDLink) {
            Point[] bp = ((PFDLink)this.selected).getElbowPoints();
            this.linkHandles = new Rectangle2D.Double[bp.length];
            for (int i = 0; i < bp.length; ++i) {
                if (bp[i] == null) continue;
                this.linkHandles[i] = new Rectangle2D.Double(bp[i].x - this.handleSize / 2, bp[i].y - this.handleSize / 2, this.handleSize - 1, this.handleSize - 1);
            }
        } else {
            Rectangle r = this.selected.getRBBox();
            this.bbox.setBounds(r);
            Rectangle glassBounds = new Rectangle(r);
            Point p = new Point();
            int halfSize = this.handleSize / 2;
            switch (this.handleSpot) {
                default: {
                    if (this.bboxIncludeHandle) {
                        glassBounds.x -= halfSize;
                        glassBounds.y -= halfSize;
                        glassBounds.width += halfSize * 2;
                        glassBounds.height += halfSize * 2;
                    }
                    this.getSpotLocation(1, p);
                    this.bboxHandles[0] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(2, p);
                    this.bboxHandles[1] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(3, p);
                    this.bboxHandles[2] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(4, p);
                    this.bboxHandles[3] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(5, p);
                    this.bboxHandles[4] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(6, p);
                    this.bboxHandles[5] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(7, p);
                    this.bboxHandles[6] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(8, p);
                    this.bboxHandles[7] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize - 1, this.handleSize - 1);
                    break;
                }
                case 1: {
                    this.getSpotLocation(1, p);
                    this.bboxHandles[0] = new Rectangle2D.Double(p.x, p.y, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(2, p);
                    this.bboxHandles[1] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(3, p);
                    this.bboxHandles[2] = new Rectangle2D.Double(p.x - this.handleSize + 1, p.y, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(4, p);
                    this.bboxHandles[3] = new Rectangle2D.Double(p.x - this.handleSize + 1, p.y - this.handleSize / 2, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(5, p);
                    this.bboxHandles[4] = new Rectangle2D.Double(p.x - this.handleSize + 1, p.y - this.handleSize + 1, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(6, p);
                    this.bboxHandles[5] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize + 1, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(7, p);
                    this.bboxHandles[6] = new Rectangle2D.Double(p.x, p.y - this.handleSize + 1, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(8, p);
                    this.bboxHandles[7] = new Rectangle2D.Double(p.x, p.y - this.handleSize / 2, this.handleSize - 1, this.handleSize - 1);
                    break;
                }
                case 2: {
                    if (this.bboxIncludeHandle) {
                        glassBounds.x -= this.handleSize;
                        glassBounds.y -= this.handleSize;
                        glassBounds.width += this.handleSize * 2;
                        glassBounds.height += this.handleSize * 2;
                    }
                    this.getSpotLocation(1, p);
                    this.bboxHandles[0] = new Rectangle2D.Double(p.x - this.handleSize, p.y - this.handleSize, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(2, p);
                    this.bboxHandles[1] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(3, p);
                    this.bboxHandles[2] = new Rectangle2D.Double(p.x + 1, p.y - this.handleSize, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(4, p);
                    this.bboxHandles[3] = new Rectangle2D.Double(p.x + 1, p.y - this.handleSize / 2, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(5, p);
                    this.bboxHandles[4] = new Rectangle2D.Double(p.x + 1, p.y + 1, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(6, p);
                    this.bboxHandles[5] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y + 1, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(7, p);
                    this.bboxHandles[6] = new Rectangle2D.Double(p.x - this.handleSize, p.y + 1, this.handleSize - 1, this.handleSize - 1);
                    this.getSpotLocation(8, p);
                    this.bboxHandles[7] = new Rectangle2D.Double(p.x - this.handleSize, p.y - this.handleSize / 2, this.handleSize - 1, this.handleSize - 1);
                }
            }
            this.bbox.setBounds(glassBounds);
        }
    }

    protected void updateHandles() {
        if (this.selectedBBox.equals(this.selected.getRBBox())) {
            return;
        }
        this.selectedBBox = this.selected.getBBox();
        if (this.selected instanceof PFDLink) {
            Point[] bp = ((PFDLink)this.selected).getElbowPoints();
            if (this.linkHandles == null || this.linkHandles.length != bp.length) {
                this.linkHandles = new Rectangle2D.Double[bp.length];
                for (int i = 0; i < bp.length; ++i) {
                    if (bp[i] == null) continue;
                    this.linkHandles[i] = new Rectangle2D.Double(bp[i].x - this.handleSize / 2, bp[i].y - this.handleSize / 2, this.handleSize, this.handleSize);
                }
            } else {
                for (int i = 0; i < bp.length; ++i) {
                    if (bp[i] == null) continue;
                    this.linkHandles[i].setFrame(bp[i].x - this.handleSize / 2, bp[i].y - this.handleSize / 2, this.handleSize, this.handleSize);
                }
            }
        } else {
            Point p = new Point();
            switch (this.handleSpot) {
                default: {
                    if (this.bboxIncludeHandle) {
                        this.bbox.x = this.selectedBBox.x - this.handleSize / 2;
                        this.bbox.y = this.selectedBBox.y - this.handleSize / 2;
                        this.bbox.width = this.selectedBBox.width + this.handleSize;
                        this.bbox.height = this.selectedBBox.height + this.handleSize;
                    } else {
                        this.bbox.x = this.selectedBBox.x;
                        this.bbox.y = this.selectedBBox.y;
                        this.bbox.width = this.selectedBBox.width;
                        this.bbox.height = this.selectedBBox.height;
                    }
                    this.getSpotLocation(1, p);
                    this.bboxHandles[0] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize, this.handleSize);
                    this.getSpotLocation(2, p);
                    this.bboxHandles[1] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize, this.handleSize);
                    this.getSpotLocation(3, p);
                    this.bboxHandles[2] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize, this.handleSize);
                    this.getSpotLocation(4, p);
                    this.bboxHandles[3] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize, this.handleSize);
                    this.getSpotLocation(5, p);
                    this.bboxHandles[4] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize, this.handleSize);
                    this.getSpotLocation(6, p);
                    this.bboxHandles[5] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize, this.handleSize);
                    this.getSpotLocation(7, p);
                    this.bboxHandles[6] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize, this.handleSize);
                    this.getSpotLocation(8, p);
                    this.bboxHandles[7] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize / 2, this.handleSize, this.handleSize);
                    break;
                }
                case 1: {
                    this.bbox.x = this.selectedBBox.x;
                    this.bbox.y = this.selectedBBox.y;
                    this.bbox.width = this.selectedBBox.width;
                    this.bbox.height = this.selectedBBox.height;
                    this.getSpotLocation(1, p);
                    this.bboxHandles[0] = new Rectangle2D.Double(p.x, p.y, this.handleSize, this.handleSize);
                    this.getSpotLocation(2, p);
                    this.bboxHandles[1] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y, this.handleSize, this.handleSize);
                    this.getSpotLocation(3, p);
                    this.bboxHandles[2] = new Rectangle2D.Double(p.x - this.handleSize, p.y, this.handleSize, this.handleSize);
                    this.getSpotLocation(4, p);
                    this.bboxHandles[3] = new Rectangle2D.Double(p.x - this.handleSize, p.y - this.handleSize / 2, this.handleSize, this.handleSize);
                    this.getSpotLocation(5, p);
                    this.bboxHandles[4] = new Rectangle2D.Double(p.x - this.handleSize, p.y - this.handleSize, this.handleSize, this.handleSize);
                    this.getSpotLocation(6, p);
                    this.bboxHandles[5] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize, this.handleSize, this.handleSize);
                    this.getSpotLocation(7, p);
                    this.bboxHandles[6] = new Rectangle2D.Double(p.x, p.y - this.handleSize, this.handleSize, this.handleSize);
                    this.getSpotLocation(8, p);
                    this.bboxHandles[7] = new Rectangle2D.Double(p.x, p.y - this.handleSize / 2, this.handleSize, this.handleSize);
                    break;
                }
                case 2: {
                    if (this.bboxIncludeHandle) {
                        this.bbox.x = this.selectedBBox.x - this.handleSize;
                        this.bbox.y = this.selectedBBox.y - this.handleSize;
                        this.bbox.width = this.selectedBBox.width + 2 * this.handleSize;
                        this.bbox.height = this.selectedBBox.height + 2 * this.handleSize;
                    } else {
                        this.bbox.x = this.selectedBBox.x;
                        this.bbox.y = this.selectedBBox.y;
                        this.bbox.width = this.selectedBBox.width;
                        this.bbox.height = this.selectedBBox.height;
                    }
                    this.getSpotLocation(1, p);
                    this.bboxHandles[0] = new Rectangle2D.Double(p.x - this.handleSize, p.y - this.handleSize, this.handleSize, this.handleSize);
                    this.getSpotLocation(2, p);
                    this.bboxHandles[1] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y - this.handleSize, this.handleSize, this.handleSize);
                    this.getSpotLocation(3, p);
                    this.bboxHandles[2] = new Rectangle2D.Double(p.x, p.y - this.handleSize, this.handleSize, this.handleSize);
                    this.getSpotLocation(4, p);
                    this.bboxHandles[3] = new Rectangle2D.Double(p.x, p.y - this.handleSize / 2, this.handleSize, this.handleSize);
                    this.getSpotLocation(5, p);
                    this.bboxHandles[4] = new Rectangle2D.Double(p.x, p.y, this.handleSize, this.handleSize);
                    this.getSpotLocation(6, p);
                    this.bboxHandles[5] = new Rectangle2D.Double(p.x - this.handleSize / 2, p.y, this.handleSize, this.handleSize);
                    this.getSpotLocation(7, p);
                    this.bboxHandles[6] = new Rectangle2D.Double(p.x - this.handleSize, p.y, this.handleSize, this.handleSize);
                    this.getSpotLocation(8, p);
                    this.bboxHandles[7] = new Rectangle2D.Double(p.x - this.handleSize, p.y - this.handleSize / 2, this.handleSize, this.handleSize);
                }
            }
        }
    }

    public int getHandleSize() {
        return this.handleSize;
    }

    public void setHandleSize(int size) {
        this.handleSize = size;
    }

    public int getHandleSpot() {
        return this.handleSpot;
    }

    public void setHandleSpot(int spot) {
        this.checkHandleSpot(spot);
        this.handleSpot = spot;
    }

    private void checkHandleSpot(int spot) {
        switch (spot) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "spot.ex.txt"));
            }
        }
    }

    public boolean isDrawFilledHandles() {
        return this.drawFilledHandles;
    }

    public void setDrawFilledHandles(boolean filled) {
        this.drawFilledHandles = filled;
    }

    public PFDPrimitive getModelPrimitive() {
        return this.selected;
    }

    public int getSelectedResizeHandle(Point p) {
        if (!this.isVisible() || !this.selected.isResizable()) {
            return -1;
        }
        for (int i = 0; i < 8; ++i) {
            if (this.bboxHandles[i] == null || !this.bboxHandles[i].contains(p.x, p.y)) continue;
            return i;
        }
        return -1;
    }

    public static int getCursor(int index) {
        return cursors[index];
    }

    @Override
    protected boolean isRenderNeeded(PFDView v) {
        if (v == null || this.forceRender) {
            return true;
        }
        switch (v.renderMode) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return true;
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        if (this.selected.isCustomSelection()) {
            return;
        }
        this.createHandles();
        if (this.selected instanceof PFDLink) {
            int i;
            if (this.drawFilledHandles) {
                for (i = 0; i < this.linkHandles.length; ++i) {
                    boolean doFill = true;
                    if (((PFDLink)this.selected).getNumBreakPoints() > 0 && ((PFDLink)this.selected).isCustomBreakPointsDragable() || i == 0 || i == this.linkHandles.length - 1) {
                        if (this.customEditorStyle) {
                            if (((PFDLink)this.selected).isSelectedBreak(i)) {
                                this.brush.apply(g2d);
                            } else {
                                g2d.setPaint(Color.white);
                            }
                        } else if (((PFDLink)this.selected).isSelectedBreak(i)) {
                            g2d.setPaint(this.handleColor.brighter());
                        } else {
                            this.brush.apply(g2d);
                        }
                    } else {
                        g2d.setPaint(this.handleColor.darker());
                    }
                    if (!doFill) continue;
                    g2d.fill(this.linkHandles[i]);
                }
            }
            this.pen.apply(g2d);
            for (i = 0; i < this.linkHandles.length; ++i) {
                g2d.draw(this.linkHandles[i]);
            }
        } else {
            int i;
            if (this.fillStyle == 1) {
                g2d.setColor(this.glassColor);
                g2d.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                g2d.setStroke(new BasicStroke());
                g2d.setColor(this.glassColor.brighter());
                g2d.drawLine(this.bbox.x, this.bbox.y, this.bbox.x, this.bbox.y + this.bbox.height - 2);
                g2d.drawLine(this.bbox.x, this.bbox.y, this.bbox.x + this.bbox.width - 2, this.bbox.y);
                g2d.setColor(this.glassColor.darker());
                g2d.drawLine(this.bbox.x + this.bbox.width - 1, this.bbox.y, this.bbox.x + this.bbox.width - 1, this.bbox.y + this.bbox.height - 1);
                g2d.drawLine(this.bbox.x, this.bbox.y + this.bbox.height - 1, this.bbox.x + this.bbox.width - 1, this.bbox.y + this.bbox.height - 1);
            }
            if (this.drawFilledHandles) {
                this.brush.apply(g2d);
                for (i = 0; i < 8; ++i) {
                    g2d.fill(this.bboxHandles[i]);
                }
            }
            this.pen.apply(g2d);
            for (i = 0; i < 8; ++i) {
                g2d.draw(this.bboxHandles[i]);
            }
        }
    }

    @Override
    protected Rectangle getVisualRBBox() {
        this.updateVisualBBox();
        return super.getVisualRBBox();
    }

    @Override
    protected void updateVisualBBox() {
        Rectangle bounds = this.selected.getRBBox();
        this.visualBBox.setBounds(bounds.x - this.handleSize, bounds.y - this.handleSize, bounds.width + this.handleSize * 2, bounds.height + this.handleSize * 2);
    }
}

