/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDButton;
import com.sas.graphics.components.pfd.PFDCollapsableNodeGroup;
import com.sas.graphics.components.pfd.PFDDirectionalNodeInterface;
import com.sas.graphics.components.pfd.PFDEmptyPrimitive;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDMessageWindow;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPortGroup;
import com.sas.graphics.components.pfd.PFDRoundRectangle;
import com.sas.graphics.components.pfd.PFDStatus;
import com.sas.graphics.components.pfd.PFDStatusUtil;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDUniversalPort;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDWindow;
import com.sas.graphics.components.pfd.interfaces.PFDGroupElementInterface;
import com.sas.graphics.components.pfd.interfaces.PFDPortStyleInterface;
import com.sas.graphics.components.pfd.interfaces.PFDStatusInterface;
import com.sas.graphics.components.pfd.interfaces.PFDWindowContainerInterface;
import com.sas.graphics.components.pfd.ui.actions.PFDAbstractAction;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.Style;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Vector;
import javax.swing.event.HyperlinkListener;

public class PFDGroupNode
extends PFDAbstractNode
implements PFDDirectionalNodeInterface,
PFDGroupElementInterface,
PFDStatusInterface,
PFDWindowContainerInterface,
PFDPortStyleInterface {
    protected String flowDirection = "Right";
    protected PFDPortGroup inputPortGroup;
    protected PFDPortGroup outputPortGroup;
    protected PFDRoundRectangle nodeShape1;
    protected PFDRoundRectangle nodeShape2;
    protected PFDRoundRectangle nodeShape3;
    protected PFDText titleText;
    private static final int rectOffset = 5;
    private static final Dimension rectSize = new Dimension(100, 60);
    private static final Dimension nodeSize = new Dimension(110, 70);
    private static final int cornerRadius = 10;
    private static final int textBorder = 8;
    private static final int maxTextLines = 2;
    private static final int stubOffset = 2;
    private static final Color defaultFillColor = Color.gray;
    private static final Color defaultOutlineColor = Color.black;
    private static final int rect2Alpha = 192;
    private static final int rect3Alpha = 128;
    protected Color gradientColorTop = defaultFillColor;
    protected Color gradientColorBottom = defaultFillColor;
    protected Color gradientColorTop2;
    protected Color gradientColorBottom2 = this.gradientColorTop2 = PFDGroupNode.getAlphaColor(defaultFillColor, 192);
    protected Color gradientColorTop3;
    protected Color gradientColorBottom3 = this.gradientColorTop3 = PFDGroupNode.getAlphaColor(defaultFillColor, 128);
    protected boolean useGradientFill = false;
    private PFDCollapsableNodeGroup collapsableGroup;
    protected PFDStatusUtil statusUtil;
    protected PFDButton statusButton;
    protected PFDMessageWindow statusWindow;
    protected static final Dimension statusDetailsOffset = new Dimension(-12, -12);
    protected boolean highlightOn = false;
    protected static final int linkClipNodePadding = 4;
    protected static final int linkClipStatusPadding = 1;
    protected static final int linkClipNodeCornerRadius = 18;
    protected int portStyle = 0;
    protected PFDPort inputCenterPort;
    protected PFDPort outputCenterPort;
    protected PFDEmptyPrimitive linkDragHotspot;
    protected PFDEmptyPrimitive nodeDragHotspot;
    protected boolean linkDragShadingVisible = false;
    private static final int linkDragShadingOpacity = 13;
    protected static final int linkHotspotOuterPadding = 5;
    protected static final int linkHotspotCornerRadius = 20;
    protected static final float dragHotspotSizePct = 0.25f;
    protected static final int nodeDragHotspotCornerRadius = 6;

    public PFDGroupNode(PFDCollapsableNodeGroup group) {
        this.collapsableGroup = group;
        this.initialize();
    }

    private void initialize() {
        this.setParent(this.collapsableGroup);
        this.setCustomSelection(true);
        this.setBreakable(false);
        this.titleText = new PFDText();
        this.titleText.setFontSize(10);
        this.titleText.setSelectable(false);
        this.titleText.setFontStyle(1);
        this.titleText.setForeground(new Color(60, 60, 60));
        this.nodeShape1 = new PFDRoundRectangle();
        this.nodeShape1.getBrush().setColor(defaultFillColor);
        this.nodeShape1.getPen().setColor(defaultOutlineColor);
        this.nodeShape1.setArcHeight(10);
        this.nodeShape1.setArcWidth(10);
        this.nodeShape1.setSize(rectSize);
        this.nodeShape1.addMouseListener(this);
        this.nodeShape1.addMouseMotionListener(this);
        this.nodeShape2 = new PFDRoundRectangle();
        this.nodeShape2.getBrush().setColor(defaultFillColor);
        this.nodeShape2.getPen().setColor(defaultOutlineColor);
        this.nodeShape2.setArcHeight(10);
        this.nodeShape2.setArcWidth(10);
        this.nodeShape2.setSize(rectSize);
        this.nodeShape2.addMouseListener(this);
        this.nodeShape2.addMouseMotionListener(this);
        this.nodeShape3 = new PFDRoundRectangle();
        this.nodeShape3.getBrush().setColor(defaultFillColor);
        this.nodeShape3.getPen().setColor(defaultOutlineColor);
        this.nodeShape3.setArcHeight(10);
        this.nodeShape3.setArcWidth(10);
        this.nodeShape3.setSize(rectSize);
        this.nodeShape3.addMouseListener(this);
        this.nodeShape3.addMouseMotionListener(this);
        this.statusUtil = new PFDStatusUtil(this);
        this.statusButton = new PFDButton();
        PFDGroupInputPort inputPort = new PFDGroupInputPort();
        PFDGroupOutputPort outputPort = new PFDGroupOutputPort();
        this.inputPortGroup = new PFDPortGroup(0);
        this.inputPortGroup.addPort(inputPort);
        this.inputPortGroup.setPortOffset(2);
        this.outputPortGroup = new PFDPortGroup(1);
        this.outputPortGroup.addPort(outputPort);
        this.outputPortGroup.setPortOffset(2);
        this.addPrimitive(this.nodeShape3);
        this.addPrimitive(this.nodeShape2);
        this.addPrimitive(this.nodeShape1);
        this.addPrimitive(this.titleText);
        this.addPrimitive(this.inputPortGroup);
        this.addPrimitive(this.outputPortGroup);
    }

    protected void layoutChildren() {
        this.disableChangeUpdate();
        Point p = this.nodeShape1.getSpotLocation(1, null);
        int titleWidth = PFDGroupNode.rectSize.width - 16;
        if (this.titleText.isVisible() && this.titleText.getText() != null && this.titleText.getText().length() > 0) {
            this.titleText.setVerticalAlignment(0);
            this.titleText.setHorizontalAlignment(0);
            this.titleText.setMultiline(true);
            this.titleText.setWrapWidth(titleWidth);
            this.titleText.setMaxLines(2);
            this.titleText.setClipping(true);
            this.titleText.setBBox(p.x + PFDGroupNode.rectSize.width / 2, p.y + PFDGroupNode.rectSize.height / 2, 0, 0);
            this.titleText.forceUpdate();
            if (this.titleText.getNumLines() > 1) {
                this.titleText.setHorizontalAlignment(1);
                this.titleText.setBBox(p.x + 8, p.y + PFDGroupNode.rectSize.height / 2, 0, 0);
            }
        }
        this.nodeShape2.setLocation(p.x + 5, p.y - 5);
        this.nodeShape3.setLocation(p.x + 10, p.y - 10);
        this.layoutStatusButton();
        this.layoutPorts();
        this.enableChangeUpdate();
        this.calculateBBox();
    }

    protected void layoutStatusButton() {
        Point p = this.nodeShape1.getSpotLocation(5, null);
        this.statusButton.setLocation(p.x - this.statusButton.getWidth() / 2, p.y - this.statusButton.getHeight() / 2);
    }

    protected void layoutPorts() {
        switch (this.portStyle) {
            case 0: {
                this.layoutDirectionalPorts();
                break;
            }
            case 1: {
                this.layoutNonDirectionalPort();
            }
        }
    }

    protected void layoutNonDirectionalPort() {
        Rectangle shape1Bounds = this.nodeShape1.getRBBox();
        Rectangle bounds = shape1Bounds.union(this.nodeShape3.getRBBox());
        this.inputCenterPort.setBBox((int)bounds.getCenterX(), (int)bounds.getCenterY(), 0, 0);
        this.outputCenterPort.setBBox((int)bounds.getCenterX(), (int)bounds.getCenterY(), 0, 0);
        this.linkDragHotspot.setBBox(bounds.x - 5, bounds.y - 5, bounds.width + 10, bounds.height + 10);
        int padding = (int)Math.min((float)shape1Bounds.width * 0.25f, (float)shape1Bounds.height * 0.25f);
        this.nodeDragHotspot.setBBox(shape1Bounds.x + padding, shape1Bounds.y + padding, shape1Bounds.width - padding * 2, shape1Bounds.height - padding * 2);
        Shape linkDragShape = this.linkDragHotspot.getShape();
        Rectangle linkDragBounds = this.linkDragHotspot.getRBBox();
        if (linkDragShape == null) {
            linkDragShape = new RoundRectangle2D.Float();
        }
        ((RoundRectangle2D)linkDragShape).setRoundRect(0.0, 0.0, linkDragBounds.width, linkDragBounds.height, 20.0, 20.0);
        this.linkDragHotspot.setShape(linkDragShape);
        Shape nodeDragShape = this.nodeDragHotspot.getShape();
        Rectangle nodeDragBounds = this.nodeDragHotspot.getRBBox();
        if (nodeDragShape == null) {
            nodeDragShape = new RoundRectangle2D.Float();
        }
        ((RoundRectangle2D)nodeDragShape).setRoundRect(0.0, 0.0, nodeDragBounds.width, nodeDragBounds.height, 6.0, 6.0);
        this.nodeDragHotspot.setShape(nodeDragShape);
        this.updatePortClipArea();
    }

    protected void updatePortClipArea() {
        Rectangle node1Bounds = this.nodeShape1.getRBBox();
        Rectangle node2Bounds = this.nodeShape2.getRBBox();
        Rectangle node3Bounds = this.nodeShape3.getRBBox();
        Rectangle portBounds = this.inputCenterPort.getRBBox();
        RoundRectangle2D.Double inputNode1Rect = new RoundRectangle2D.Double(node1Bounds.x - 4 - portBounds.x, node1Bounds.y - 4 - portBounds.y, node1Bounds.width - 1 + 8, node1Bounds.height - 1 + 8, 18.0, 18.0);
        RoundRectangle2D.Double outputNode1Rect = new RoundRectangle2D.Double(node1Bounds.x - portBounds.x, node1Bounds.y - portBounds.y, node1Bounds.width - 1, node1Bounds.height - 1, 10.0, 10.0);
        RoundRectangle2D.Double inputNode2Rect = new RoundRectangle2D.Double(node2Bounds.x - 4 - portBounds.x, node2Bounds.y - 4 - portBounds.y, node2Bounds.width - 1 + 8, node2Bounds.height - 1 + 8, 18.0, 18.0);
        RoundRectangle2D.Double outputNode2Rect = new RoundRectangle2D.Double(node2Bounds.x - portBounds.x, node2Bounds.y - portBounds.y, node2Bounds.width - 1, node2Bounds.height - 1, 10.0, 10.0);
        RoundRectangle2D.Double inputNode3Rect = new RoundRectangle2D.Double(node3Bounds.x - 4 - portBounds.x, node3Bounds.y - 4 - portBounds.y, node3Bounds.width - 1 + 8, node3Bounds.height - 1 + 8, 18.0, 18.0);
        RoundRectangle2D.Double outputNode3Rect = new RoundRectangle2D.Double(node3Bounds.x - portBounds.x, node3Bounds.y - portBounds.y, node3Bounds.width - 1, node3Bounds.height - 1, 10.0, 10.0);
        Area inputNodeArea = new Area(inputNode1Rect);
        inputNodeArea.add(new Area(inputNode2Rect));
        inputNodeArea.add(new Area(inputNode3Rect));
        Area outputNodeArea = new Area(outputNode1Rect);
        outputNodeArea.add(new Area(outputNode2Rect));
        outputNodeArea.add(new Area(outputNode3Rect));
        if (this.containsPrimitive(this.statusButton)) {
            Rectangle statusBounds = this.statusButton.getRBBox();
            Rectangle inputStatusRect = new Rectangle(statusBounds.x - 1 - portBounds.x, statusBounds.y - 1 - portBounds.y, statusBounds.width - 1 + 2, statusBounds.height - 1 + 2);
            Rectangle outputStatusRect = new Rectangle(statusBounds.x - portBounds.x, statusBounds.y - portBounds.y, statusBounds.width - 1, statusBounds.height - 1);
            inputNodeArea.add(new Area(inputStatusRect));
            outputNodeArea.add(new Area(outputStatusRect));
        }
        this.inputCenterPort.setClipArea(inputNodeArea);
        this.outputCenterPort.setClipArea(outputNodeArea);
    }

    protected void layoutDirectionalPorts() {
        Point p = this.nodeShape1.getSpotLocation(7, null);
        if (this.flowDirection.equalsIgnoreCase("right")) {
            this.inputPortGroup.disableChangeUpdate();
            this.inputPortGroup.setDirection(3);
            this.inputPortGroup.setAnchorPoint(new Point(p.x, p.y - PFDGroupNode.nodeSize.height / 2));
            this.inputPortGroup.enableChangeUpdate();
            this.outputPortGroup.disableChangeUpdate();
            this.outputPortGroup.setDirection(4);
            this.outputPortGroup.setAnchorPoint(new Point(p.x + PFDGroupNode.nodeSize.width, p.y - PFDGroupNode.nodeSize.height / 2));
            this.outputPortGroup.enableChangeUpdate();
        } else if (this.flowDirection.equalsIgnoreCase("left")) {
            this.inputPortGroup.disableChangeUpdate();
            this.inputPortGroup.setDirection(4);
            this.inputPortGroup.setAnchorPoint(new Point(p.x + PFDGroupNode.nodeSize.width, p.y - PFDGroupNode.nodeSize.height / 2));
            this.inputPortGroup.enableChangeUpdate();
            this.outputPortGroup.disableChangeUpdate();
            this.outputPortGroup.setDirection(3);
            this.outputPortGroup.setAnchorPoint(new Point(p.x, p.y - PFDGroupNode.nodeSize.height / 2));
            this.outputPortGroup.enableChangeUpdate();
        } else if (this.flowDirection.equalsIgnoreCase("down")) {
            this.inputPortGroup.disableChangeUpdate();
            this.inputPortGroup.setDirection(1);
            this.inputPortGroup.setAnchorPoint(new Point(p.x + PFDGroupNode.nodeSize.width / 2, p.y - PFDGroupNode.nodeSize.height));
            this.inputPortGroup.enableChangeUpdate();
            this.outputPortGroup.disableChangeUpdate();
            this.outputPortGroup.setDirection(2);
            this.outputPortGroup.setAnchorPoint(new Point(p.x + PFDGroupNode.nodeSize.width / 2, p.y));
            this.outputPortGroup.enableChangeUpdate();
        } else if (this.flowDirection.equalsIgnoreCase("up")) {
            this.inputPortGroup.disableChangeUpdate();
            this.inputPortGroup.setDirection(2);
            this.inputPortGroup.setAnchorPoint(new Point(p.x + PFDGroupNode.nodeSize.width / 2, p.y));
            this.inputPortGroup.enableChangeUpdate();
            this.outputPortGroup.disableChangeUpdate();
            this.outputPortGroup.setDirection(1);
            this.outputPortGroup.setAnchorPoint(new Point(p.x + PFDGroupNode.nodeSize.width / 2, p.y - PFDGroupNode.nodeSize.height));
            this.outputPortGroup.enableChangeUpdate();
        }
    }

    @Override
    protected void updateStyle(Style style) {
        super.updateStyle(style);
        FillStyleElement fse = style.getFillStyleElement("NodeStyleGroup");
        if (fse != null) {
            String hctString = System.getProperty("HIGH_CONTRAST_TESTING");
            if (hctString != null) {
                this.setUseGradientFill(false);
            } else {
                this.setUseGradientFill(fse.getFillType() == 1);
            }
            this.setFillColor(fse.getFillColor());
            this.setGradientColorTop(fse.getFillGradientStartColor());
            this.setGradientColorBottom(fse.getFillGradientEndColor());
        }
        this.updateStatusOutline();
    }

    private void setUseGradientFill(boolean useGradientFill) {
        if (useGradientFill != this.useGradientFill) {
            this.useGradientFill = useGradientFill;
            if (useGradientFill) {
                this.nodeShape1.getBrush().setStyle(1);
                this.nodeShape2.getBrush().setStyle(1);
                this.nodeShape3.getBrush().setStyle(1);
            } else {
                this.nodeShape1.getBrush().setStyle(2);
                this.nodeShape2.getBrush().setStyle(2);
                this.nodeShape3.getBrush().setStyle(2);
            }
        }
    }

    private void setGradientColorBottom(Color clr) {
        if (clr == null || clr.equals(this.gradientColorBottom)) {
            return;
        }
        this.gradientColorBottom = clr;
        this.gradientColorBottom2 = PFDGroupNode.getAlphaColor(clr, 192);
        this.gradientColorBottom3 = PFDGroupNode.getAlphaColor(clr, 128);
    }

    private void setGradientColorTop(Color clr) {
        if (clr == null || clr.equals(this.gradientColorTop)) {
            return;
        }
        this.gradientColorTop = clr;
        this.gradientColorTop2 = PFDGroupNode.getAlphaColor(clr, 192);
        this.gradientColorTop3 = PFDGroupNode.getAlphaColor(clr, 128);
    }

    private void setFillColor(Color clr) {
        this.nodeShape1.getBrush().setColor(clr);
        this.nodeShape2.getBrush().setColor(clr);
        this.nodeShape3.getBrush().setColor(clr);
    }

    private void setOutlineColor(Color clr) {
        if (clr == null || clr.equals(this.nodeShape1.getPen().getColor())) {
            return;
        }
        this.nodeShape1.getPen().setColor(clr);
        this.nodeShape2.getPen().setColor(PFDGroupNode.getAlphaColor(clr, 192));
        this.nodeShape3.getPen().setColor(PFDGroupNode.getAlphaColor(clr, 128));
    }

    private void setOutlineWidth(float width) {
        if (width == this.nodeShape1.getPen().getLineWidth()) {
            return;
        }
        this.nodeShape1.getPen().setLineWidth(width);
        this.nodeShape2.getPen().setLineWidth(width);
        this.nodeShape3.getPen().setLineWidth(width);
    }

    private static Color getAlphaColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        this.draw(g2d, v, false);
    }

    @Override
    protected synchronized void renderSelected(Graphics2D g2d, PFDView v) {
        this.draw(g2d, v, true);
    }

    @Override
    protected synchronized void renderFocused(Graphics2D g2d, PFDView v) {
        this.renderSelected(g2d, v);
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        this.nodeShape3.renderOverview(g2d, v);
        this.nodeShape2.renderOverview(g2d, v);
        this.nodeShape1.renderOverview(g2d, v);
    }

    protected void draw(Graphics2D g2d, PFDView v, boolean selected) {
        if (this.useGradientFill) {
            this.updateNodeGradient();
        }
        this.nodeShape3.paint(g2d);
        this.nodeShape2.paint(g2d);
        this.nodeShape1.paint(g2d);
        this.drawLinkDragShading(g2d);
        this.titleText.paint(g2d);
        if (this.inputPortGroup != null) {
            this.inputPortGroup.paint(g2d);
        }
        if (this.outputPortGroup != null) {
            this.outputPortGroup.paint(g2d);
        }
        if (selected) {
            this.drawSelection(g2d);
        }
        this.drawStatusButton(g2d);
        this.drawStatusWindow(g2d);
    }

    protected void drawStatusButton(Graphics2D g) {
        if (this.statusButton != null && this.containsPrimitive(this.statusButton)) {
            this.statusButton.paint(g);
        }
    }

    protected void drawStatusWindow(Graphics2D g) {
        if (this.statusWindow != null && this.containsPrimitive(this.statusWindow)) {
            this.statusWindow.paint(g);
        }
    }

    protected void drawLinkDragShading(Graphics2D g) {
        if (this.linkDragShadingVisible) {
            RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float(this.nodeShape1.getX(), this.nodeShape1.getY(), this.nodeShape1.getWidth(), this.nodeShape1.getHeight(), this.nodeShape1.getArcWidth(), this.nodeShape1.getArcHeight());
            Area area = new Area(roundRect);
            RoundRectangle2D.Float innerRect = new RoundRectangle2D.Float(this.nodeDragHotspot.getX(), this.nodeDragHotspot.getY(), this.nodeDragHotspot.getWidth(), this.nodeDragHotspot.getHeight(), 6.0f, 6.0f);
            area.subtract(new Area(innerRect));
            g.setColor(new Color(0, 0, 0, 13));
            g.fill(area);
        }
    }

    protected void updateNodeGradient() {
        Rectangle bounds = this.nodeShape1.getRBBox();
        this.nodeShape1.getBrush().paint = new GradientPaint(new Point(bounds.x, bounds.y), this.gradientColorTop, new Point(bounds.x, bounds.y + bounds.height), this.gradientColorBottom, false);
        bounds = this.nodeShape2.getRBBox();
        this.nodeShape2.getBrush().paint = new GradientPaint(new Point(bounds.x, bounds.y), this.gradientColorTop2, new Point(bounds.x, bounds.y + bounds.height), this.gradientColorBottom2, false);
        bounds = this.nodeShape3.getRBBox();
        this.nodeShape3.getBrush().paint = new GradientPaint(new Point(bounds.x, bounds.y), this.gradientColorTop3, new Point(bounds.x, bounds.y + bounds.height), this.gradientColorBottom3, false);
    }

    protected void drawSelection(Graphics2D g) {
        Rectangle bounds = this.nodeShape1.getRBBox().union(this.nodeShape3.getRBBox());
        int halfStrokeWidth = (int)Math.floor((double)this.selectionPen.getLineWidth() / 2.0);
        if (g.hitClip(bounds.x - 4 - halfStrokeWidth, bounds.y - 4 - halfStrokeWidth, bounds.width + 8 + halfStrokeWidth * 2, bounds.height + 8 + halfStrokeWidth * 2)) {
            this.selectionPen.apply(g);
            g.drawRoundRect(bounds.x - 4, bounds.y - 4, bounds.width + 7, bounds.height + 7, 18, 18);
        }
    }

    @Override
    protected Rectangle getCustomSelectionBBox() {
        Rectangle bounds = this.nodeShape1.getRBBox().union(this.nodeShape3.getRBBox());
        int halfStrokeWidth = (int)Math.floor((double)this.selectionPen.getLineWidth() / 2.0);
        bounds.x -= 4 + halfStrokeWidth;
        bounds.y -= 4 + halfStrokeWidth;
        bounds.width += 8 + halfStrokeWidth * 2;
        bounds.height += 8 + halfStrokeWidth * 2;
        return bounds;
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("children") || property.equals("flowDirection") || property.equals("titleText") || property.equals("all")) {
            this.layoutChildren();
        } else if (property.equals("status")) {
            this.updateStatusOutline();
        }
        super.update(property, v);
    }

    public String getTitleText() {
        return this.titleText.getText();
    }

    public void setTitleText(String text) {
        String curText = this.titleText.getText();
        if (curText != null && curText.equals(text) || curText == null && text == null) {
            return;
        }
        this.titleText.setText(text);
        this.firePropertyChange("titleText");
    }

    @Override
    public void addPort(String name, int position) {
    }

    @Override
    public Point getCenterLocation() {
        return this.getSpotLocation(0, null);
    }

    @Override
    public Point getSpotLocation(int spot, Point p) {
        return PFDGroupNode.getSpotLocation(this.getLayoutBounds(), spot, p);
    }

    private Rectangle getLayoutBounds() {
        Rectangle bounds = this.nodeShape1.getRBBox().union(this.nodeShape2.getRBBox());
        bounds = bounds.union(this.nodeShape3.getRBBox());
        return bounds;
    }

    @Override
    public int getLayoutWidth() {
        return this.getLayoutBounds().width;
    }

    @Override
    public int getLayoutHeight() {
        return this.getLayoutBounds().height;
    }

    @Override
    public Vector getInputLinks() {
        PFDPort p = this.getInputPort();
        if (p != null) {
            return p.getToLinks();
        }
        return new Vector();
    }

    @Override
    public Vector getOutputLinks() {
        PFDPort p = this.getOutputPort();
        if (p != null) {
            return p.getFromLinks();
        }
        return new Vector();
    }

    @Override
    protected Vector getChildren() {
        Vector<NodeLayoutInterface> cv = new Vector<NodeLayoutInterface>();
        Vector outLinks = this.getOutputLinks();
        for (int j = 0; j < outLinks.size(); ++j) {
            PFDLink l = (PFDLink)outLinks.elementAt(j);
            if (l.getToNode() == null || cv.contains(l.getToNode())) continue;
            cv.addElement(l.getToNode());
        }
        return cv;
    }

    @Override
    protected Vector getParents() {
        Vector<NodeLayoutInterface> pv = new Vector<NodeLayoutInterface>();
        Vector inLinks = this.getInputLinks();
        for (int j = 0; j < inLinks.size(); ++j) {
            PFDLink l = (PFDLink)inLinks.elementAt(j);
            if (l.getFromNode() == null || pv.contains(l.getFromNode())) continue;
            pv.addElement(l.getFromNode());
        }
        return pv;
    }

    @Override
    public PFDPort getInputPort() {
        if (this.portStyle == 0) {
            if (this.inputPortGroup.getNumPorts() > 0) {
                return this.inputPortGroup.getPort(0);
            }
            return null;
        }
        return this.inputCenterPort;
    }

    @Override
    public PFDPort getOutputPort() {
        if (this.portStyle == 0) {
            if (this.outputPortGroup.getNumPorts() > 0) {
                return this.outputPortGroup.getPort(0);
            }
            return null;
        }
        return this.outputCenterPort;
    }

    @Override
    public PFDPort getPort(String name) {
        return null;
    }

    @Override
    public boolean isForceShowPorts() {
        return false;
    }

    @Override
    public void removePort(String name) {
    }

    @Override
    public void setCenterLocation(Point p) {
        this.setSpotLocation(0, p);
    }

    @Override
    public void setForceShowPorts(boolean visible) {
    }

    @Override
    public void setLayoutLocation(int spot, Point p) {
        if (this.collapsableGroup == null) {
            super.setLayoutLocation(spot, p);
        } else {
            this.collapsableGroup.setLayoutLocation(spot, p);
        }
    }

    @Override
    public Point getLayoutLocation(int spot, Point p) {
        if (this.collapsableGroup == null) {
            return super.getLayoutLocation(spot, p);
        }
        return this.collapsableGroup.getLayoutLocation(spot, p);
    }

    @Override
    public String getFlowDirection() {
        return this.flowDirection;
    }

    @Override
    public void setFlowDirection(String direction) {
        PFDModel.checkFlowDirection(direction);
        if (this.flowDirection == direction) {
            return;
        }
        this.flowDirection = direction;
        this.firePropertyChange("flowDirection");
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean useLinkHotspot;
        e.consume();
        PFDView v = this.theView;
        int mouseMode = v.getMouseExtendedMode();
        v.setMouseOverPrimitive(this, e);
        boolean bl = useLinkHotspot = this.theView.isEditMode() && this.outputCenterPort != null && this.outputCenterPort.canDragNewLink();
        if (this.isNodeShape(e.getSource()) || e.getSource() == this.nodeDragHotspot || e.getSource() == this.linkDragHotspot && !useLinkHotspot) {
            if (this.isSelectable()) {
                if (mouseMode == 4) {
                    if (!v.isSelected(this.collapsableGroup)) {
                        v.clearSelections();
                        v.selectPrimitive(this.collapsableGroup);
                    }
                } else if (mouseMode == 2) {
                    if (v.isSelected(this.collapsableGroup)) {
                        v.deselectPrimitive(this.collapsableGroup);
                    } else {
                        v.selectPrimitive(this.collapsableGroup);
                        if (this.theView.isEditMode() && this.isDraggable()) {
                            v.setDragMode(0);
                        }
                    }
                } else {
                    if (!v.isSelected(this.collapsableGroup)) {
                        v.clearSelections();
                        v.selectPrimitive(this.collapsableGroup);
                    }
                    if (this.theView.isEditMode() && this.isDraggable()) {
                        v.setDragMode(0);
                    }
                }
            }
        } else if (e.getSource() == this.linkDragHotspot) {
            if (mouseMode == 4) {
                if (!v.isSelected(this)) {
                    v.clearSelections();
                    v.selectPrimitive(this);
                }
            } else if (this.theView.isEditMode() && this.outputCenterPort != null && this.outputCenterPort.canDragNewLink()) {
                if (v.getMouseExtendedMode() == 2) {
                    v.dragNewLink(this.outputCenterPort, true);
                } else {
                    v.dragNewLink(this.outputCenterPort, false);
                }
            }
            this.setLinkDragShadingVisible(false);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean useLinkHotspot;
        e.consume();
        PFDView v = this.theView;
        v.setMouseOverPrimitive(this, e);
        if (!this.theView.isEditMode()) {
            return;
        }
        boolean bl = useLinkHotspot = this.theView.isEditMode() && this.outputCenterPort != null && this.outputCenterPort.canDragNewLink();
        if (this.isNodeShape(e.getSource()) || e.getSource() == this.nodeDragHotspot || e.getSource() == this.linkDragHotspot && !useLinkHotspot) {
            this.setPortsOpen(true, false);
            if (this.theView.isEditMode() && this.selectable && this.draggable) {
                v.setCursor(1);
            }
            this.setLinkDragShadingVisible(false);
        } else if (e.getSource() == this.linkDragHotspot) {
            if (this.theView.isEditMode() && this.outputCenterPort != null && this.outputCenterPort.canDragNewLink()) {
                v.setCursor(2);
                this.setLinkDragShadingVisible(true);
            } else {
                this.setLinkDragShadingVisible(false);
            }
        } else {
            this.setPortsOpen(false, false);
            this.setLinkDragShadingVisible(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
        PFDView v = this.theView;
        v.setMouseOverPrimitive(this, e);
        if (!this.theView.isEditMode()) {
            return;
        }
        if (this.portStyle == 0 && this.isNodeShape(e.getSource())) {
            int mode = v.getDragMode();
            if (mode == 3) {
                this.inputPortGroup.snapLinkToPort(v.getDraggedLink(), v);
            } else {
                PFDLink link = v.getDraggedLink();
                if (mode == 1) {
                    if (link.isOriginalLink(link.getFromPort(), this.inputPortGroup.getPort(0))) {
                        this.inputPortGroup.snapLinkToPort(v.getDraggedLink(), v);
                    } else {
                        link.setValidationStatus(12);
                        v.rejectLinkDrag(this, null);
                    }
                } else if (mode == 2) {
                    if (link.isOriginalLink(this.outputPortGroup.getPort(0), link.getToPort())) {
                        this.outputPortGroup.snapLinkFromPort(v.getDraggedLink(), v);
                    } else {
                        link.setValidationStatus(13);
                        v.rejectLinkDrag(this, null);
                    }
                }
            }
        } else if (e.getSource() == this.linkDragHotspot || e.getSource() == this.nodeDragHotspot) {
            int mode = v.getDragMode();
            if (mode == 3) {
                PFDLink l = v.getDraggedLink();
                if (this.inputCenterPort != null && this.inputCenterPort.canDropToLink(l)) {
                    v.snapLinkToPort(this.inputCenterPort);
                } else {
                    v.rejectLinkDrag(this, this.inputCenterPort);
                }
            } else {
                v.rejectLinkDrag(this, this.inputCenterPort);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
        this.theView.setMouseOverPrimitive(this, e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isNodeShape(e.getSource())) {
            this.theView.setMouseOverPrimitive(this, e);
            e.consume();
            if (e.getClickCount() == 2) {
                this.collapsableGroup.setCollapsed(false);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setPortsOpen(false, false);
        this.setLinkDragShadingVisible(false);
    }

    private boolean isNodeShape(Object source) {
        return source == this.nodeShape1 || source == this.nodeShape2 || source == this.nodeShape3;
    }

    public boolean canUnGroup() {
        return this.collapsableGroup.canUngroup();
    }

    public void unGroup() {
        this.collapsableGroup.ungroup();
    }

    @Override
    public void setStatus(int status) {
        this.setStatus(status, null, null, null, null);
    }

    @Override
    public void setStatus(int status, String tooltip) {
        this.setStatus(status, tooltip, null, null, null);
    }

    @Override
    public void setStatus(int status, String tooltip, String title, String content, HyperlinkListener listener) {
        PFDStatus newStatus = PFDStatus.getInstance(status);
        newStatus.putValue("Tooltip", tooltip);
        newStatus.putValue("MessageTitle", title);
        newStatus.putValue("MessgeContent", content);
        newStatus.putValue("MessageHyperlinkListener", listener);
        this.setStatus(newStatus);
    }

    @Override
    public void setStatus(PFDStatus status) {
        this.statusUtil.setStatus(status);
        PFDAbstractAction action = this.statusUtil.getAction();
        this.statusButton.setAction(action);
        if (action == null) {
            if (this.containsPrimitive(this.statusButton)) {
                this.removePrimitive(this.statusButton);
            }
        } else if (!this.containsPrimitive(this.statusButton)) {
            int index = this.portStyle == 0 ? this.indexOfPrimitive(this.outputPortGroup) + 1 : this.indexOfPrimitive(this.titleText) + 1;
            index = Math.min(index, this.getNumPrimitives());
            this.addPrimitive(index, this.statusButton);
            this.statusButton.setVisible(this.visible);
        } else {
            this.layoutStatusButton();
            this.firePropertyChange("bbox");
        }
        PFDMessageWindow newWindow = this.statusUtil.getMessageWindow();
        if (this.statusWindow != null && this.containsPrimitive(this.statusWindow)) {
            this.removePrimitive(this.statusWindow);
        }
        this.statusWindow = newWindow;
        this.firePropertyChange("status");
    }

    @Override
    public int getStatus() {
        return this.statusUtil.getStatus();
    }

    @Override
    public PFDStatus getStatusObject() {
        return this.statusUtil.getStatusObject();
    }

    @Override
    public void setWindowVisible(PFDWindow window, boolean visible) {
        if (window != this.statusWindow) {
            return;
        }
        if (visible) {
            if (!this.containsPrimitive(this.statusWindow)) {
                this.statusWindow.setLocation(this.statusButton.getX() + this.statusButton.getWidth() / 2 + PFDGroupNode.statusDetailsOffset.width, this.statusButton.getY() + this.statusButton.getHeight() / 2 + PFDGroupNode.statusDetailsOffset.height);
                this.addPrimitive(this.statusWindow);
            }
        } else {
            this.removePrimitive(this.statusWindow);
        }
    }

    private void updateStatusOutline() {
        if (this.model == null) {
            return;
        }
        Style style = this.model.getStyle();
        this.statusUtil.updateStatusObject(style);
        if (style == null) {
            return;
        }
        PFDStatus status = this.statusUtil.getStatusObject();
        Color statusLineColor = null;
        Number statusLineThickness = null;
        if (status != null) {
            statusLineColor = (Color)status.getValue("LineColor");
            statusLineThickness = (Number)status.getValue("LineThickness");
        }
        String context = this.highlightOn ? "Highlight" : "NodeStyleGroup";
        LineStyleElement lse = style.getLineStyleElement(context);
        if (statusLineColor != null) {
            this.setOutlineColor(statusLineColor);
        } else if (lse != null) {
            this.setOutlineColor(lse.getLineColor());
        } else {
            this.setOutlineColor(Color.BLACK);
        }
        if (statusLineThickness != null) {
            this.setOutlineWidth(statusLineThickness.floatValue());
        } else if (lse != null) {
            this.setOutlineWidth(lse.getLineThickness().toPixels(0, 0));
        } else {
            this.setOutlineWidth(1.0f);
        }
    }

    @Override
    public void setPortStyle(int portStyle) {
        if (this.portStyle == portStyle) {
            return;
        }
        if (portStyle != 0 && portStyle != 1) {
            throw new IllegalArgumentException("Specified portStyle is not supported");
        }
        this.portStyle = portStyle;
        this.initPortStyle();
        this.layoutChildren();
        this.firePropertyChange("portStyle");
    }

    @Override
    public int getPortStyle() {
        return this.portStyle;
    }

    private void initPortStyle() {
        if (this.portStyle == 1) {
            PFDLink link;
            int i;
            PFDPort port;
            this.inputCenterPort = new PFDGroupInputPort();
            this.inputCenterPort.removeMouseListener(this.inputCenterPort);
            this.inputCenterPort.removeMouseMotionListener(this.inputCenterPort);
            this.inputCenterPort.setFromLinkSpot(9);
            this.inputCenterPort.setToLinkSpot(9);
            this.inputCenterPort.setValidFromPort(false);
            this.inputCenterPort.setValidToPort(true);
            this.inputCenterPort.setType(0);
            this.outputCenterPort = new PFDGroupOutputPort();
            this.outputCenterPort.removeMouseListener(this.outputCenterPort);
            this.outputCenterPort.removeMouseMotionListener(this.outputCenterPort);
            this.outputCenterPort.setFromLinkSpot(9);
            this.outputCenterPort.setToLinkSpot(9);
            this.outputCenterPort.setValidFromPort(true);
            this.outputCenterPort.setValidToPort(false);
            this.outputCenterPort.setType(0);
            if (this.inputPortGroup.getNumPorts() > 0) {
                port = this.inputPortGroup.getPort(0);
                for (i = 0; i < port.getNumLinks(); ++i) {
                    link = port.getLink(i);
                    link.setToPort(this.inputCenterPort);
                }
            }
            if (this.outputPortGroup.getNumPorts() > 0) {
                port = this.outputPortGroup.getPort(0);
                for (i = 0; i < port.getNumLinks(); ++i) {
                    link = port.getLink(i);
                    link.setFromPort(this.outputCenterPort);
                }
            }
            this.linkDragHotspot = new PFDEmptyPrimitive();
            this.nodeDragHotspot = new PFDEmptyPrimitive();
            this.linkDragHotspot.addMouseListener(this);
            this.linkDragHotspot.addMouseMotionListener(this);
            this.nodeDragHotspot.addMouseListener(this);
            this.nodeDragHotspot.addMouseMotionListener(this);
            this.addPrimitive(0, this.inputCenterPort);
            this.addPrimitive(1, this.outputCenterPort);
            int titleTextIndex = this.indexOfPrimitive(this.titleText);
            this.addPrimitive(titleTextIndex + 1, this.linkDragHotspot);
            this.addPrimitive(titleTextIndex + 2, this.nodeDragHotspot);
            this.removePrimitive(this.inputPortGroup);
            this.removePrimitive(this.outputPortGroup);
            this.inputPortGroup.removeAllPorts();
            this.inputPortGroup = null;
            this.outputPortGroup.removeAllPorts();
            this.outputPortGroup = null;
        } else {
            this.inputPortGroup = new PFDPortGroup(0);
            this.inputPortGroup.addPort(new PFDPort());
            this.outputPortGroup = new PFDPortGroup(1);
            this.outputPortGroup.addPort(new PFDPort());
            int titleTextIndex = this.indexOfPrimitive(this.titleText);
            this.addPrimitive(titleTextIndex + 1, this.inputPortGroup);
            this.addPrimitive(titleTextIndex + 2, this.outputPortGroup);
            this.removePrimitive(this.inputCenterPort);
            this.removePrimitive(this.outputCenterPort);
            this.removePrimitive(this.linkDragHotspot);
            this.removePrimitive(this.nodeDragHotspot);
            if (this.linkDragHotspot != null) {
                this.linkDragHotspot.removeMouseListener(this);
                this.linkDragHotspot.removeMouseMotionListener(this);
            }
            if (this.nodeDragHotspot != null) {
                this.nodeDragHotspot.removeMouseListener(this);
                this.nodeDragHotspot.removeMouseMotionListener(this);
            }
            this.linkDragHotspot = null;
            this.nodeDragHotspot = null;
            this.inputCenterPort = null;
            this.outputCenterPort = null;
        }
    }

    protected void setPortsOpen(boolean open, boolean forceImmediate) {
        if (this.portStyle != 0) {
            return;
        }
        if (open) {
            if (!this.outputPortGroup.hasValidInteractivePort()) {
                return;
            }
            if (this.outputPortGroup.getNumVisiblePorts() == 1) {
                if (this.theView.isEditMode()) {
                    this.outputPortGroup.setRenderMode(1, forceImmediate);
                }
            } else {
                this.outputPortGroup.setRenderMode(2, forceImmediate);
            }
        } else {
            this.inputPortGroup.setRenderMode(0, forceImmediate);
            this.outputPortGroup.setRenderMode(0, forceImmediate);
        }
    }

    protected void setLinkDragShadingVisible(boolean visible) {
        if (this.linkDragShadingVisible == visible) {
            return;
        }
        this.linkDragShadingVisible = visible;
        if (this.theView != null) {
            this.theView.repaint(this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setStatus(0);
    }

    public class PFDGroupInputPort
    extends PFDGroupPort {
        @Override
        public List getExpandedPorts() {
            return PFDGroupNode.this.collapsableGroup.getGroupWindow().getSubdiagram().getInputPorts();
        }

        @Override
        public boolean canDropToLink(PFDLink link) {
            if (!PFDGroupNode.this.collapsableGroup.isInteractiveInputEnabled()) {
                link.setValidationStatus(11);
                return false;
            }
            return super.canDropToLink(link);
        }
    }

    public class PFDGroupOutputPort
    extends PFDGroupPort {
        @Override
        public List getExpandedPorts() {
            return PFDGroupNode.this.collapsableGroup.getGroupWindow().getSubdiagram().getOutputPorts();
        }

        @Override
        public boolean canDragNewLink() {
            if (PFDGroupNode.this.collapsableGroup.isInteractiveOutputEnabled() && super.canDragNewLink()) {
                List outports = this.getExpandedPorts();
                if (outports != null) {
                    for (int i = 0; i < outports.size(); ++i) {
                        PFDPort port = (PFDPort)outports.get(i);
                        if (!port.canDragNewLink()) continue;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        @Override
        public PFDLink createDragLink() {
            List outports = this.getExpandedPorts();
            if (outports != null && outports.size() > 0) {
                PFDPort port = (PFDPort)outports.get(0);
                return port.createDragLink();
            }
            return super.createDragLink();
        }
    }

    public abstract class PFDGroupPort
    extends PFDUniversalPort {
        public abstract List getExpandedPorts();
    }
}

