/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

class PFDFlowChartShapes {
    PFDFlowChartShapes() {
    }

    public static Vector createDiamond(Rectangle bbox) {
        Vector<Point> v = new Vector<Point>();
        v.addElement(new Point(bbox.x, bbox.y + bbox.height / 2));
        v.addElement(new Point(bbox.x + bbox.width / 2, bbox.y));
        v.addElement(new Point(bbox.x + bbox.width, bbox.y + bbox.height / 2));
        v.addElement(new Point(bbox.x + bbox.width / 2, bbox.y + bbox.height));
        return v;
    }

    public static Vector createRightTriangle(Rectangle bbox) {
        Vector<Point> v = new Vector<Point>();
        v.addElement(new Point(bbox.x, bbox.y + bbox.height / 2));
        v.addElement(new Point(bbox.x + bbox.width / 2, bbox.y));
        v.addElement(new Point(bbox.x + bbox.width, bbox.y + bbox.height / 2));
        return v;
    }

    public static Vector createLeftTriangle(Rectangle bbox) {
        Vector<Point> v = new Vector<Point>();
        v.addElement(new Point(bbox.x, bbox.y + bbox.height / 2));
        v.addElement(new Point(bbox.x + bbox.width, bbox.y));
        v.addElement(new Point(bbox.x + bbox.width, bbox.y + bbox.height));
        return v;
    }

    public static Vector createTopTriangle(Rectangle bbox) {
        Vector<Point> v = new Vector<Point>();
        v.addElement(new Point(bbox.x + bbox.width / 2, bbox.y));
        v.addElement(new Point(bbox.x + bbox.width, bbox.y + bbox.height));
        v.addElement(new Point(bbox.x, bbox.y + bbox.height));
        return v;
    }

    public static Vector createBottomTriangle(Rectangle bbox) {
        Vector<Point> v = new Vector<Point>();
        v.addElement(new Point(bbox.x, bbox.y));
        v.addElement(new Point(bbox.x + bbox.width, bbox.y));
        v.addElement(new Point(bbox.x + bbox.width / 2, bbox.y + bbox.height));
        return v;
    }

    public static Vector createParallelogram(Rectangle bbox) {
        Vector<Point> v = new Vector<Point>();
        v.addElement(new Point(bbox.x, bbox.y + bbox.height));
        v.addElement(new Point(bbox.x + bbox.width / 4, bbox.y));
        v.addElement(new Point(bbox.x + bbox.width, bbox.y));
        v.addElement(new Point(bbox.x + 3 * bbox.width / 4, bbox.y + bbox.height));
        return v;
    }

    public static Vector createTrapezoid(Rectangle bbox) {
        Vector<Point> v = new Vector<Point>();
        v.addElement(new Point(bbox.x, bbox.y + bbox.height));
        v.addElement(new Point(bbox.x + bbox.width / 4, bbox.y));
        v.addElement(new Point(bbox.x + bbox.width, bbox.y));
        v.addElement(new Point(bbox.x + 3 * bbox.width / 4, bbox.y + bbox.height));
        return v;
    }

    public static Vector createHexagon(Rectangle bbox) {
        Vector<Point> v = new Vector<Point>();
        v.addElement(new Point(bbox.x, bbox.y + bbox.height / 2));
        v.addElement(new Point(bbox.x + bbox.width / 4, bbox.y));
        v.addElement(new Point(bbox.x + 3 * bbox.width / 4, bbox.y));
        v.addElement(new Point(bbox.x + bbox.width, bbox.y + bbox.height / 2));
        v.addElement(new Point(bbox.x + 3 * bbox.width / 4, bbox.y + bbox.height));
        v.addElement(new Point(bbox.x + bbox.width / 4, bbox.y + bbox.height));
        return v;
    }

    public static Vector createRightPentagon(Rectangle bbox) {
        Vector<Point> v = new Vector<Point>();
        v.addElement(new Point(bbox.x, bbox.y));
        v.addElement(new Point(bbox.x + bbox.width / 2, bbox.y));
        v.addElement(new Point(bbox.x + bbox.width, bbox.y + bbox.height / 2));
        v.addElement(new Point(bbox.x + bbox.width / 2, bbox.y + bbox.height));
        v.addElement(new Point(bbox.x, bbox.y + bbox.height));
        return v;
    }

    public static Vector createOctagon(Rectangle bbox) {
        double ss = (double)Math.min(bbox.width, bbox.height) / 2.414;
        Vector<Point> v = new Vector<Point>();
        v.addElement(new Point(bbox.x, bbox.y + (int)(0.707 * ss)));
        v.addElement(new Point(bbox.x + (int)(0.707 * ss), bbox.y));
        v.addElement(new Point(bbox.x + bbox.width - (int)(0.707 * ss), bbox.y));
        v.addElement(new Point(bbox.x + bbox.width, bbox.y + (int)(0.707 * ss)));
        v.addElement(new Point(bbox.x + bbox.width, bbox.y + bbox.height - (int)(0.707 * ss)));
        v.addElement(new Point(bbox.x + bbox.width - (int)(0.707 * ss), bbox.y + bbox.height));
        v.addElement(new Point(bbox.x + (int)(0.707 * ss), bbox.y + bbox.height));
        v.addElement(new Point(bbox.x, bbox.y + bbox.height - (int)(0.707 * ss)));
        return v;
    }
}

