/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;

public class PFDEllipse
extends PFDDrawablePrimitive {
    transient Ellipse2D.Double e2d = new Ellipse2D.Double();

    public PFDEllipse() {
    }

    public PFDEllipse(Point p, Dimension size) {
        super(p, size);
    }

    public PFDEllipse(Rectangle r) {
        super(r);
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        this.e2d.setFrame(this.bbox);
        if (this.shadowOn) {
            this.drawShadow(g2d, v);
        }
        if (this.pen.getStyle() == 0) {
            if (this.brush.getStyle() != 0) {
                this.brush.apply(g2d);
                g2d.fillOval(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
            }
        } else {
            if (this.brush.getStyle() != 0) {
                this.brush.apply(g2d);
                g2d.fillOval(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.bbox.height - 1);
            }
            this.pen.apply(g2d);
            g2d.drawOval(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.bbox.height - 1);
        }
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        this.e2d.setFrame(this.bbox);
        if (this.pen.getStyle() == 0) {
            if (this.brush.getStyle() != 0) {
                g2d.setColor(this.brush.getColor());
                g2d.fillOval(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
            }
        } else {
            if (this.brush.getStyle() != 0) {
                g2d.setColor(this.brush.getColor());
                g2d.fillOval(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.bbox.height - 1);
            }
            g2d.setColor(this.pen.getColor());
            g2d.drawOval(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.bbox.height - 1);
        }
    }

    @Override
    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        return this.e2d.contains(x, y);
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDEllipse clone = new PFDEllipse();
        table.put(this, clone);
        this.copyObject(clone);
        return clone;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeDouble(this.e2d.x);
        out.writeDouble(this.e2d.y);
        out.writeDouble(this.e2d.width);
        out.writeDouble(this.e2d.height);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        double x = in.readDouble();
        double y = in.readDouble();
        double w = in.readDouble();
        double h = in.readDouble();
        this.e2d = new Ellipse2D.Double(x, y, w, h);
    }
}

