/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDPen;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDUtil;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.util.ShadowRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public abstract class PFDDrawablePrimitive
extends PFDPrimitive
implements PropertyChangeListener {
    public static final int NONE = 0;
    public static final int CUSTOM = 1;
    public static final int RECTANGLE = 2;
    public static final int ROUND_RECTANGLE = 3;
    public static final int TRIANGLE = 4;
    public static final int ELLIPSE = 5;
    public static final int DIAMOND = 6;
    public static final int HEXAGON = 7;
    public static final int PARALLELOGRAM = 8;
    public static final int PENTAGON = 9;
    public static final int OCTAGON = 10;
    protected boolean shadowOn = false;
    protected int shadowSize = 3;
    protected int shadowShift = 4;
    protected float shadowOpacity = 0.117f;

    public PFDDrawablePrimitive() {
        this.pen.addPropertyChangeListener(this);
    }

    public PFDDrawablePrimitive(Point p, Dimension size) {
        super(p, size);
        this.pen.addPropertyChangeListener(this);
    }

    public PFDDrawablePrimitive(Rectangle r) {
        super(r);
        this.pen.addPropertyChangeListener(this);
    }

    public boolean isShadowOn() {
        return this.shadowOn;
    }

    public void setShadowOn(boolean b) {
        if (this.shadowOn == b) {
            return;
        }
        this.shadowOn = b;
        this.updateVisualBBox();
        this.firePropertyChange("shadowOn");
    }

    protected void drawShadow(Graphics2D g2d, PFDView v) {
        BufferedImage primitiveImage = PFDUtil.createCompatibleImage(this.bbox.width, this.bbox.height, 3);
        Graphics2D primitiveGraphics = primitiveImage.createGraphics();
        this.shadowOn = false;
        primitiveGraphics.translate(-this.bbox.x, -this.bbox.y);
        this.paint(primitiveGraphics);
        this.shadowOn = true;
        primitiveGraphics.dispose();
        BufferedImage shadowImage = ShadowRenderer.createShadow((BufferedImage)primitiveImage, (int)this.shadowSize, (float)this.shadowOpacity, (Color)Color.BLACK, (int)0);
        g2d.drawImage((Image)shadowImage, this.bbox.x - this.shadowSize + this.shadowShift, this.bbox.y - this.shadowSize + this.shadowShift, null);
    }

    protected void drawRect(Graphics2D g2d, Rectangle r) {
        g2d.drawRect(r.x, r.y, r.width, r.height);
    }

    protected void drawRect(Graphics2D g2d, int x, int y, int w, int h) {
        g2d.drawRect(x, y, w, h);
    }

    protected void fillRect(Graphics2D g2d, Rectangle r) {
        g2d.fillRect(r.x, r.y, r.width, r.height);
    }

    protected void fillRect(Graphics2D g2d, int x, int y, int w, int h) {
        g2d.fillRect(x, y, w, h);
    }

    protected void fillEllipse(Graphics2D g2d, Rectangle r) {
        g2d.fillOval(r.x, r.y, r.width, r.height);
    }

    protected void drawEllipse(Graphics2D g2d, Rectangle r) {
        g2d.drawOval(r.x, r.y, r.width, r.height);
    }

    protected void drawLine(Graphics2D g2d, Point p1, Point p2) {
        g2d.drawLine(p1.x, p1.y, p2.x, p2.y);
    }

    protected void drawLine(Graphics2D g2d, int x1, int y1, int x2, int y2) {
        g2d.drawLine(x1, y1, x2, y2);
    }

    protected void fillDiamond(Graphics2D g2d, Rectangle r) {
        int[] x = new int[4];
        int[] y = new int[4];
        x[0] = r.x + r.width / 2;
        y[0] = r.y;
        x[1] = r.x + r.width;
        y[1] = r.y + r.height / 2;
        x[2] = x[0];
        y[2] = r.y + r.height;
        x[3] = r.x;
        y[3] = y[1];
        g2d.fillPolygon(x, y, 4);
    }

    protected void drawDiamond(Graphics2D g2d, Rectangle r) {
        int[] x = new int[4];
        int[] y = new int[4];
        x[0] = r.x + r.width / 2;
        y[0] = r.y;
        x[1] = r.x + r.width;
        y[1] = r.y + r.height / 2;
        x[2] = x[0];
        y[2] = r.y + r.height;
        x[3] = r.x;
        y[3] = y[1];
        g2d.drawPolygon(x, y, 4);
    }

    public void copyObject(PFDDrawablePrimitive toObject) {
        super.copyObject(toObject);
        toObject.setShadowOn(this.isShadowOn());
    }

    @Override
    protected void updateVisualBBox() {
        super.updateVisualBBox();
        if (this.pen.getStyle() != 0) {
            int halfWidth = (int)Math.floor((double)this.pen.getLineWidth() / 2.0);
            this.visualBBox.x -= halfWidth;
            this.visualBBox.y -= halfWidth;
            this.visualBBox.width += halfWidth * 2;
            this.visualBBox.height += halfWidth * 2;
        }
        if (this.shadowOn) {
            Rectangle shadowBBox = new Rectangle(this.bbox);
            shadowBBox.x += this.shadowShift - this.shadowSize;
            shadowBBox.y += this.shadowShift - this.shadowSize;
            shadowBBox.width += 2 * this.shadowSize;
            shadowBBox.height += 2 * this.shadowSize;
            this.visualBBox.add(shadowBBox);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.pen && (evt.getPropertyName().equals("lineWidth") || evt.getPropertyName().equals("stroke"))) {
            this.updateVisualBBox();
        }
    }

    @Override
    public void setPen(PFDPen pen) {
        PFDPen oldPen = this.pen;
        super.setPen(pen);
        if (oldPen != pen) {
            if (oldPen != null) {
                oldPen.removePropertyChangeListener(this);
            }
            if (pen != null) {
                pen.addPropertyChangeListener(this);
            }
        }
    }
}

