/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDSelectionList;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;

public class PFDDnDAdapter
implements DropTargetListener,
DragGestureListener,
DragSourceListener {
    PFDView view = null;
    DropTarget dropTarget = null;
    DragSource dragSource = null;

    public PFDDnDAdapter() {
    }

    public PFDDnDAdapter(PFDView view) {
        this.attachView(view);
    }

    public void attachView(PFDView view) {
        this.view = view;
        this.dropTarget = new DropTarget(view, this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(view, 0x40000000, this);
    }

    public void detachView(PFDView view) {
        if (view != null && this.dropTarget != null) {
            this.dropTarget.setComponent(null);
            this.dropTarget.removeDropTargetListener(this);
            this.dropTarget = null;
            this.dragSource = null;
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.view.isDragSource()) {
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(0x40000000);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.view.isDragSource()) {
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(0x40000000);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable tr = dtde.getTransferable();
        DataFlavor[] df = tr.getTransferDataFlavors();
        if (dtde.isDataFlavorSupported(PFDSelectionList.PFD_FLAVOR)) {
            if (this.view.isDragSource()) {
                dtde.rejectDrop();
                return;
            }
            dtde.acceptDrop(0x40000000);
            Point p = dtde.getLocation();
            boolean success = this.view.drop(p.x, p.y, tr);
            dtde.getDropTargetContext().dropComplete(success);
        } else {
            dtde.rejectDrop();
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        PFDSelectionList selection;
        InputEvent ie = dge.getTriggerEvent();
        MouseEvent mie = null;
        if (ie instanceof MouseEvent) {
            mie = (MouseEvent)ie;
        }
        if (mie == null) {
            return;
        }
        int dndOnMask = 4096;
        int dndOffMask = 3776;
        if ((mie.getModifiersEx() & (dndOnMask | dndOffMask)) == dndOnMask && (selection = this.view.getSelectionList()) != null && selection.getNumPrimitives() > 0) {
            this.view.startDrag();
            this.dragSource.startDrag(dge, DragSource.DefaultLinkDrop, this.view.getSelectionList(), this);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.view.endDrag();
    }
}

