/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPort;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.QuadCurve2D;

public class PFDCurvedLink
extends PFDLink {
    private static final long serialVersionUID = -569469445040383675L;
    protected Point controlPoint;
    boolean controlPointSelected = false;

    public PFDCurvedLink(PFDPort from, PFDPort to, Point controlPoint) {
        super(from, to);
        this.controlPoint = controlPoint;
        this.layoutAffected = true;
    }

    public PFDCurvedLink(PFDPort from, PFDPort to, boolean isControl, Point controlPoint) {
        super(from, to, isControl);
        this.controlPoint = controlPoint;
        this.layoutAffected = true;
    }

    public void setControlPoint(Point controlPoint) {
        this.controlPoint = controlPoint;
        this.linkChanged();
        this.arrowChanged();
        this.labelChanged();
        this.calculateBBox();
        this.layoutAffected = true;
    }

    public Point getControlPoint() {
        return this.controlPoint;
    }

    @Override
    protected void linkChanged() {
        if (this.controlPoint == null) {
            super.linkChanged();
            return;
        }
        if (this.fromPort == null || this.toPort == null) {
            return;
        }
        this.points.removeAllElements();
        this.elbowPoints.removeAllElements();
        this.segments.removeAllElements();
        this.toPort.getLinkPointFromPoint(this.controlPoint, this.toPoint);
        this.fromPort.getLinkPointFromPoint(this.controlPoint, this.fromPoint);
        this.points.addElement(this.fromPoint);
        this.points.addElement(this.toPoint);
        this.elbowPoints.add(this.controlPoint);
        this.segments.addElement(new QuadCurve2D.Double(this.fromPoint.x, this.fromPoint.y, this.controlPoint.x, this.controlPoint.y, this.toPoint.x, this.toPoint.y));
    }

    @Override
    protected Point firstElbowPoint() {
        return this.controlPoint == null ? super.firstElbowPoint() : this.controlPoint;
    }

    @Override
    protected Point lastElbowPoint() {
        return this.controlPoint == null ? super.lastElbowPoint() : this.controlPoint;
    }

    @Override
    protected void labelChanged() {
        super.labelChanged();
        if (this.controlPoint != null && this.middleLabel == null) {
            return;
        }
        PFDModel m = this.getModel();
        if (m == null) {
            return;
        }
        this.middleLabel.disableChangeUpdate();
        this.middleLabel.setHorizontalAlignment(0);
        this.middleLabel.setVerticalAlignment(0);
        this.middleLabel.enableChangeUpdate();
        if (Math.abs(this.toPoint.x - this.fromPoint.x) > Math.abs(this.toPoint.y - this.fromPoint.y)) {
            Point labelPos = this.getMidpointOfQuadCurveDefinedBy(this.fromPoint.x, this.fromPoint.y, this.controlPoint.x, this.controlPoint.y, this.toPoint.x, this.toPoint.y);
            if (this.middleLabelPosition != 0) {
                Rectangle label_bbox = this.middleLabel.getBBox();
                if (this.fromPoint.x == this.toPoint.x) {
                    labelPos.x += label_bbox.width / 2 + 2;
                } else if (this.fromPoint.y < this.toPoint.y) {
                    labelPos.x += label_bbox.width / 2;
                } else if (this.fromPoint.y > this.toPoint.y) {
                    labelPos.x -= label_bbox.width / 2;
                }
                labelPos.y = this.middleLabelPosition == 3 ? (labelPos.y += label_bbox.height / 2) : (labelPos.y -= label_bbox.height / 2);
            }
            this.middleLabel.setBBox(labelPos.x, labelPos.y, 0, 0);
        } else {
            Point labelPos = this.getMidpointOfQuadCurveDefinedBy(this.fromPoint.y, this.fromPoint.x, this.controlPoint.y, this.controlPoint.x, this.toPoint.y, this.toPoint.x);
            if (labelPos != null) {
                if (this.middleLabelPosition != 0) {
                    Rectangle label_bbox = this.middleLabel.getBBox();
                    if (this.fromPoint.x == this.toPoint.x) {
                        labelPos.y += label_bbox.width / 2 + 2;
                    } else if (this.fromPoint.y < this.toPoint.y) {
                        labelPos.y += label_bbox.width / 2;
                    } else if (this.fromPoint.y > this.toPoint.y) {
                        labelPos.y -= label_bbox.width / 2;
                    }
                    labelPos.x = this.middleLabelPosition == 3 ? (labelPos.x += label_bbox.height / 2) : (labelPos.x -= label_bbox.height / 2);
                }
                this.middleLabel.setBBox(labelPos.y, labelPos.x, 0, 0);
            }
        }
        if (!m.containsPrimitive(this.middleLabel)) {
            m.addPrimitive(this.middleLabel);
        }
    }

    protected Point getMidpointOfQuadCurveDefinedBy(double start1, double start2, double control1, double control2, double end1, double end2) {
        double midpoint = (start1 + end1) / 2.0;
        double[] equation = new double[3];
        equation[2] = start1 - 2.0 * control1 + end1;
        equation[1] = 2.0 * control1 - 2.0 * start1;
        equation[0] = start1 - midpoint;
        int numberOfRoots = QuadCurve2D.solveQuadratic(equation);
        if (numberOfRoots != -1) {
            double value;
            if (equation[0] >= 0.0 && equation[0] <= 1.0) {
                value = this.evaluateQuadraticCurve(start2, control2, end2, equation[0]);
            } else if (numberOfRoots == 2) {
                value = this.evaluateQuadraticCurve(start2, control2, end2, equation[1]);
            } else {
                return null;
            }
            return new Point((int)midpoint, (int)value);
        }
        return null;
    }

    protected Rectangle getBounds() {
        int extreme;
        int[] x = new int[2];
        int[] y = new int[2];
        x[0] = Math.min(this.fromPoint.x, Math.min(this.controlPoint.x, this.toPoint.x));
        x[1] = Math.max(this.fromPoint.x, Math.max(this.controlPoint.x, this.toPoint.x));
        y[0] = Math.min(this.fromPoint.y, Math.min(this.controlPoint.y, this.toPoint.y));
        y[1] = Math.max(this.fromPoint.y, Math.max(this.controlPoint.y, this.toPoint.y));
        Rectangle bounds = new Rectangle(x[0], y[0], x[1] - x[0], y[1] - y[0]);
        bounds.width = Math.max(bounds.width, 1);
        bounds.height = Math.max(bounds.height, 1);
        if (this.fromPoint.x - 2 * this.controlPoint.x + this.toPoint.x == 0) {
            return bounds;
        }
        double t = ((double)this.fromPoint.x - (double)this.controlPoint.x) / ((double)this.fromPoint.x - 2.0 * (double)this.controlPoint.x + (double)this.toPoint.x);
        if (0.0 <= t && t <= 1.0) {
            extreme = (int)this.evaluateQuadraticCurve(this.fromPoint.x, this.controlPoint.x, this.toPoint.x, t);
            int w = Math.max(Math.abs(extreme - this.fromPoint.x), Math.abs(extreme - this.toPoint.x));
            bounds.width = Math.max(w, Math.abs(this.fromPoint.x - this.toPoint.x));
        }
        if (this.fromPoint.y - 2 * this.controlPoint.y + this.toPoint.y == 0) {
            return bounds;
        }
        t = ((double)this.fromPoint.y - (double)this.controlPoint.y) / ((double)this.fromPoint.y - 2.0 * (double)this.controlPoint.y + (double)this.toPoint.y);
        if (0.0 <= t && t <= 1.0) {
            extreme = (int)this.evaluateQuadraticCurve(this.fromPoint.y, this.controlPoint.y, this.toPoint.y, t);
            int h = Math.max(Math.abs(extreme - this.fromPoint.y), Math.abs(extreme - this.toPoint.y));
            bounds.height = Math.max(h, Math.abs(this.fromPoint.y - this.toPoint.y));
        }
        bounds.width = Math.max(bounds.width, 1);
        bounds.height = Math.max(bounds.height, 1);
        return bounds;
    }

    private double evaluateQuadraticCurve(double start, double control, double end, double valueAtWhichToEvaluate) {
        double u = 1.0 - valueAtWhichToEvaluate;
        return start * u * u + 2.0 * control * valueAtWhichToEvaluate * u + end * valueAtWhichToEvaluate * valueAtWhichToEvaluate;
    }

    @Override
    protected void calculateBBox() {
        if (this.fromPort == null || this.toPort == null) {
            return;
        }
        this.setBBox(this.getBounds());
        this.oldVisualBBox.setBounds(this.visualBBox);
        this.visualBBox.setBounds(this.bbox);
    }

    @Override
    public void move(int dx, int dy) {
        super.move(dx, dy);
        this.controlPoint.x += dx;
        this.controlPoint.y += dy;
    }

    @Override
    public boolean contains(int x, int y) {
        if (super.contains(x, y) && this.curveIntersects(new QuadCurve2D.Double(this.fromPoint.x, this.fromPoint.y, this.controlPoint.x, this.controlPoint.y, this.toPoint.x, this.toPoint.y), x - 1, y - 1, 2.0, 2.0)) {
            return true;
        }
        double dist = (x - this.controlPoint.x) * (x - this.controlPoint.x) + (y - this.controlPoint.y) * (y - this.controlPoint.y);
        return (dist = Math.sqrt(dist)) < 5.0;
    }

    @Override
    public void selectBreakPoint(int x, int y, boolean toggle) {
        double dist = (x - this.controlPoint.x) * (x - this.controlPoint.x) + (y - this.controlPoint.y) * (y - this.controlPoint.y);
        if ((dist = Math.sqrt(dist)) < 5.0) {
            this.controlPointSelected = toggle ? !this.controlPointSelected : true;
        }
    }

    @Override
    public void clearSelectedBreaks() {
        this.controlPointSelected = false;
    }

    @Override
    public boolean isCustomBreakPointsUsed() {
        return true;
    }

    @Override
    public boolean isCustomBreakPointsDragable() {
        return true;
    }

    @Override
    protected boolean isSelectedBreak(int elbowPointIndex) {
        return this.controlPointSelected;
    }

    public boolean curveIntersects(QuadCurve2D curve, double rx, double ry, double rw, double rh) {
        double ctrlX;
        double y1 = curve.getY1();
        double y2 = curve.getY2();
        double x1 = curve.getX1();
        double x2 = curve.getX2();
        if (this.rectangleContains(x1, y1, rx, ry, rw, rh) || this.rectangleContains(x2, y2, rx, ry, rw, rh)) {
            return true;
        }
        double[] eqn = new double[3];
        double ctrlY = curve.getCtrlY();
        return PFDCurvedLink.intersectsLine(eqn, y1, ctrlY, y2, ry, x1, ctrlX = curve.getCtrlX(), x2, rx, rx + rw) || PFDCurvedLink.intersectsLine(eqn, y1, ctrlY, y2, ry + rh, x1, ctrlX, x2, rx, rx + rw) || PFDCurvedLink.intersectsLine(eqn, x1, ctrlX, x2, rx, y1, ctrlY, y2, ry, ry + rh) || PFDCurvedLink.intersectsLine(eqn, x1, ctrlX, x2, rx + rw, y1, ctrlY, y2, ry, ry + rh);
    }

    private boolean rectangleContains(double x, double y, double rx, double ry, double rw, double rh) {
        return x >= rx && y >= ry && x < rx + rw && y < ry + rh;
    }

    private static boolean intersectsLine(double[] eqn, double p0, double p1, double p2, double c, double pb0, double pb1, double pb2, double from, double to) {
        boolean result;
        eqn[2] = p0 - 2.0 * p1 + p2;
        eqn[1] = 2.0 * p1 - 2.0 * p0;
        eqn[0] = p0 - c;
        int nRoots = QuadCurve2D.solveQuadratic(eqn);
        switch (nRoots) {
            case 1: {
                boolean bl = result = eqn[0] >= 0.0 && eqn[0] <= 1.0;
                if (!result) break;
                double intersection = PFDCurvedLink.evalQuadraticCurve(pb0, pb1, pb2, eqn[0]);
                result = intersection >= from && intersection <= to;
                break;
            }
            case 2: {
                double intersection;
                boolean bl = result = eqn[0] >= 0.0 && eqn[0] <= 1.0;
                if (result) {
                    intersection = PFDCurvedLink.evalQuadraticCurve(pb0, pb1, pb2, eqn[0]);
                    boolean bl2 = result = intersection >= from && intersection <= to;
                }
                if (result) break;
                boolean bl3 = result = eqn[1] >= 0.0 && eqn[1] <= 1.0;
                if (!result) break;
                intersection = PFDCurvedLink.evalQuadraticCurve(pb0, pb1, pb2, eqn[1]);
                result = intersection >= from && intersection <= to;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public static double evalQuadraticCurve(double c1, double ctrl, double c2, double t) {
        double u = 1.0 - t;
        double res = c1 * u * u + 2.0 * ctrl * t * u + c2 * t * t;
        return res;
    }
}

