/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDCompoundRectangle;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPen;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class PFDCompoundRectangleNode
extends PFDAbstractNode {
    protected PFDCompoundRectangle drawable = null;
    protected PFDPort port = null;
    protected PFDText titleText = null;
    protected Color titleAreaColor = Color.WHITE;
    protected Color contentAreaColor = Color.WHITE;
    protected Color borderColor = Color.BLACK;
    protected Color seperatorColor = Color.BLACK;
    protected PFDPen selectionPen = null;
    protected Color selectionColor = new Color(255, 204, 0);
    protected int selectionLineWidth = 2;
    protected PFDPen focusPen = null;
    protected Color focusColor = Color.BLACK;
    protected int titleBarHeight = 23;
    protected int arcRadius = 4;
    protected String fontName = "SansSerif";
    protected Color fontColor = Color.BLACK;
    protected int fontSize = 11;
    protected int titleTextSpacer = 5;
    private static final int largeTitlePosX = 5;
    private static final int largeTitlePosY = 3;

    protected void initialize() {
        this.setBreakable(false);
        this.selectionPen = new PFDPen();
        this.selectionPen.setColor(this.selectionColor);
        this.selectionPen.setLineWidth(this.selectionLineWidth);
        this.focusPen = new PFDPen();
        this.focusPen.setColor(this.focusColor);
        this.focusPen.setStyle(2);
        this.createDrawable();
        this.port = new PFDPort();
        this.port.setName("port");
        this.port.setFromLinkSpot(9);
        this.port.setToLinkSpot(9);
        this.port.setValidFromPort(true);
        this.port.setValidToPort(true);
        this.port.setType(0);
        this.addPrimitive(this.drawable);
        this.addPrimitive(this.port);
    }

    protected void createText(String text) {
        this.titleText = new PFDText(text);
        this.titleText.setSelectable(false);
        this.titleText.setFontName(this.fontName);
        this.titleText.getPen().setColor(this.fontColor);
    }

    public void setTitleText(String text) {
        if (text == null) {
            if (this.titleText != null) {
                this.removePrimitive(this.titleText);
                this.titleText = null;
            }
        } else if (this.titleText == null) {
            this.createText(text);
            this.addPrimitive(this.titleText);
        } else {
            this.titleText.setText(text);
        }
        this.layoutChildren();
    }

    protected void createDrawable() {
        int width = Math.max(this.titleTextSpacer * 2 + 2, this.arcRadius * 2);
        int height = this.titleBarHeight + this.arcRadius + 1;
        this.drawable = new PFDCompoundRectangle(new Rectangle(0, 0, width, height));
        this.drawable.setArcWidth(this.arcRadius);
        this.drawable.setArcHeight(this.arcRadius);
        this.drawable.setTopHeight(this.titleBarHeight);
        this.drawable.getBrush().setColor(this.contentAreaColor);
        this.drawable.getPen().setColor(this.borderColor);
        this.drawable.getTopBrush().setColor(this.titleAreaColor);
        this.drawable.getTopPen().setColor(this.seperatorColor);
    }

    protected void layoutChildren() {
        Rectangle r = this.drawable.getRBBox();
        this.layoutTitleBarArea(r.x + 1, r.y + 1, r.width - 2, this.titleBarHeight);
        this.layoutContentArea(r.x + 1, r.y + this.titleBarHeight + 1, r.width - 2, r.height - this.titleBarHeight - 2);
        this.port.setBBox(r.x + r.width / 2, r.y + r.height / 2, 0, 0);
        this.port.setFreeSpotBox(true);
        this.port.setFreeSpotOffsetX(r.width / 2 + 1);
        this.port.setFreeSpotOffsetY(r.height / 2 + 1);
        this.port.setSnapBox(true);
        this.port.setSnapXDistance(r.width / 2);
        this.port.setSnapYDistance(r.height / 2);
        this.port.setCustomPortArea(new Rectangle(-r.width / 2, -r.height / 2 + this.titleBarHeight, r.width, r.height - this.titleBarHeight));
        this.calculateBBox();
    }

    protected void layoutTitleBarArea(int x, int y, int width, int height) {
        this.layoutTitleText(x + this.titleTextSpacer, y + this.titleTextSpacer, width - this.titleTextSpacer * 2, height - this.titleTextSpacer * 2);
    }

    protected void layoutTitleText(int x, int y, int width, int height) {
        if (this.titleText != null) {
            this.titleText.setHorizontalAlignment(1);
            this.titleText.setVerticalAlignment(1);
            this.titleText.setMultiline(false);
            this.titleText.setClipping(true);
            this.titleText.setFontSize(this.fontSize);
            this.titleText.setLocation(x, y);
            this.titleText.setWrapWidth(width);
            this.titleText.forceUpdate();
        }
    }

    protected void layoutContentArea(int x, int y, int width, int height) {
    }

    @Override
    public void setForcedBBox(int x, int y, int w, int h) {
        if (!this.resizable) {
            return;
        }
        x = Math.max(0, x);
        y = Math.max(0, y);
        if (this.collapsable && !this.collapsed.isVisible()) {
            this.collapsed.setLocation(x, y);
        }
        this.drawable.setForcedBBox(x, y, w, h);
        this.layoutChildren();
        this.bboxDirty = true;
        this.firePropertyChange("bbox");
    }

    public void setTitleAreaColor(Color c) {
        if (c == null) {
            return;
        }
        this.titleAreaColor = c;
        this.drawable.getTopBrush().setColor(c);
    }

    public Color getTitleAreaColor() {
        return this.titleAreaColor;
    }

    public void setContentAreaColor(Color c) {
        if (c == null) {
            return;
        }
        this.contentAreaColor = c;
        this.drawable.getBrush().setColor(c);
    }

    public Color getContentAreaColor() {
        return this.contentAreaColor;
    }

    public void setBorderColor(Color c) {
        if (c == null) {
            return;
        }
        this.borderColor = c;
        this.drawable.getPen().setColor(c);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setSeperatorColor(Color c) {
        if (c == null) {
            return;
        }
        this.seperatorColor = c;
        this.drawable.getTopPen().setColor(c);
    }

    public Color getSeperatorColor() {
        return this.seperatorColor;
    }

    @Override
    public Point getCenterLocation() {
        return this.getSpotLocation(0, null);
    }

    @Override
    public void setCenterLocation(Point p) {
        this.setLocation(p.x - this.bbox.width / 2, p.y - this.bbox.height / 2);
    }

    @Override
    public PFDPort getInputPort() {
        return this.port;
    }

    @Override
    public PFDPort getOutputPort() {
        return this.port;
    }

    @Override
    public boolean isForceShowPorts() {
        return false;
    }

    @Override
    public void setForceShowPorts(boolean visible) {
    }

    @Override
    public PFDPort getPort(String name) {
        return null;
    }

    @Override
    public void addPort(String name, int position) {
    }

    @Override
    public void removePort(String name) {
    }

    @Override
    protected Vector getChildren() {
        Vector<NodeLayoutInterface> cv = new Vector<NodeLayoutInterface>();
        Vector outLinks = this.port.getFromLinks();
        for (int j = 0; j < outLinks.size(); ++j) {
            PFDLink l = (PFDLink)outLinks.elementAt(j);
            if (l.getToNode() == null || cv.contains(l.getToNode())) continue;
            cv.addElement(l.getToNode());
        }
        return cv;
    }

    @Override
    protected Vector getParents() {
        Vector<NodeLayoutInterface> pv = new Vector<NodeLayoutInterface>();
        Vector inLinks = this.port.getToLinks();
        for (int j = 0; j < inLinks.size(); ++j) {
            PFDLink l = (PFDLink)inLinks.elementAt(j);
            if (l.getFromNode() == null || pv.contains(l.getFromNode())) continue;
            pv.addElement(l.getFromNode());
        }
        return pv;
    }

    @Override
    protected synchronized void renderSelected(Graphics2D g2d, PFDView v) {
        this.render(g2d, v);
        Rectangle bounds = this.drawable.getRBBox();
        this.selectionPen.apply(g2d);
        g2d.drawRoundRect(bounds.x - 3, bounds.y - 3, bounds.width + 6, bounds.height + 6, this.arcRadius + 3, this.arcRadius + 3);
    }

    @Override
    protected synchronized void renderFocused(Graphics2D g2d, PFDView v) {
        this.render(g2d, v);
        Rectangle bounds = this.drawable.getRBBox();
        this.selectionPen.apply(g2d);
        g2d.drawRoundRect(bounds.x - 3, bounds.y - 3, bounds.width + 6, bounds.height + 6, this.arcRadius + 3, this.arcRadius + 3);
        this.focusPen.apply(g2d);
        g2d.drawRect(bounds.x + 3, bounds.y + this.titleBarHeight + 3, bounds.width - 6, bounds.height - this.titleBarHeight - 6);
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        this.drawable.renderOverview(g2d, v);
    }
}

