/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDComponentPrimitive;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDWindow;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class PFDComponentWindow
extends PFDWindow {
    protected PFDComponentPrimitive componentPrimitive;
    protected PFDPrimitive selectPrimitive;

    public PFDComponentWindow() {
        this.initialize();
    }

    private void initialize() {
        this.selectPrimitive = this;
        this.componentPrimitive = new PFDComponentPrimitive();
        this.componentPrimitive.addMouseListener(new ComponentMouseListener());
        this.addPrimitive(this.componentPrimitive);
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        this.componentPrimitive.setBBox(this.getContentBounds());
    }

    @Override
    protected void draw(Graphics2D g, PFDView v, boolean selected) {
        this.backgroundRect.paint(g);
        this.titleText.paint(g);
        this.windowIcon.paint(g);
        this.closeButton.paint(g);
        this.drawSeperator(g);
        this.componentPrimitive.paint(g);
        if (this.resizable) {
            this.drawResizeHandle(g);
        }
        if (selected) {
            this.drawSelection(g);
        }
    }

    private class ComponentMouseListener
    extends MouseAdapter {
        private ComponentMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int mouseMode = PFDComponentWindow.this.theView.getMouseExtendedMode();
            if (!PFDComponentWindow.this.selectPrimitive.isSelectable()) {
                if (mouseMode != 2) {
                    PFDComponentWindow.this.theView.clearSelections();
                }
                return;
            }
            switch (mouseMode) {
                case 4: {
                    if (PFDComponentWindow.this.theView.isSelected(PFDComponentWindow.this.selectPrimitive)) break;
                    PFDComponentWindow.this.theView.clearSelections();
                    PFDComponentWindow.this.theView.selectPrimitive(PFDComponentWindow.this.selectPrimitive);
                    break;
                }
                case 2: {
                    if (PFDComponentWindow.this.theView.isSelected(PFDComponentWindow.this.selectPrimitive)) {
                        PFDComponentWindow.this.theView.deselectPrimitive(PFDComponentWindow.this.selectPrimitive);
                        break;
                    }
                    PFDComponentWindow.this.theView.selectPrimitive(PFDComponentWindow.this.selectPrimitive);
                    break;
                }
                default: {
                    if (PFDComponentWindow.this.theView.isSelected(PFDComponentWindow.this.selectPrimitive)) break;
                    PFDComponentWindow.this.theView.clearSelections();
                    PFDComponentWindow.this.theView.selectPrimitive(PFDComponentWindow.this.selectPrimitive);
                }
            }
        }
    }
}

