/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDDirectionalNodeInterface;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDGroupNode;
import com.sas.graphics.components.pfd.PFDGroupWindow;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDStatus;
import com.sas.graphics.components.pfd.PFDSubdiagram;
import com.sas.graphics.components.pfd.PFDUtil;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.components.pfd.interfaces.PFDCollapsableInterface;
import com.sas.graphics.components.pfd.interfaces.PFDPortStyleInterface;
import com.sas.graphics.components.pfd.interfaces.PFDStatusInterface;
import com.sas.graphics.components.pfd.interfaces.PFDUngroupable;
import com.sas.graphics.components.pfd.ui.actions.PFDCloseGroupAction;
import com.sas.graphics.components.pfd.ui.actions.PFDOpenGroupAction;
import com.sas.graphics.components.pfd.ui.actions.PFDUngroupAction;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.HyperlinkListener;

public class PFDCollapsableNodeGroup
extends PFDGroup
implements PFDUngroupable,
PFDDirectionalNodeInterface,
PFDCollapsableInterface,
PFDStatusInterface,
PFDPortStyleInterface,
PropertyInterface {
    private static final long serialVersionUID = 7343727068639640062L;
    private static final String RB_KEY = "PFDCollapsableNodeGroup.";
    private static String groupNamePattern = RB.getStringResource("PFDCollapsableNodeGroup.", "groupName.fmt");
    private static int groupCount = 0;
    private PFDGroupNode groupNode;
    private PFDGroupWindow groupWindow;
    private String groupName = null;
    private boolean isCollapsed = true;
    private boolean isBuilt = false;
    private boolean preBuildIsCollapsed = false;
    private boolean interactiveInputEnabled = false;
    private boolean interactiveOutputEnabled = false;
    protected transient PropertyList pending = null;
    private Boolean DEFAULT_isCollapsed = null;
    private final int default_locationConstant = Integer.MIN_VALUE;
    protected int pendingLocationX = Integer.MIN_VALUE;
    protected int pendingLocationY = Integer.MIN_VALUE;

    public PFDCollapsableNodeGroup() {
        this.initialize();
        this.pending = new PropertyList();
    }

    public static PFDCollapsableNodeGroup createGroup(List primitives, PFDModel model) {
        if (primitives == null || primitives.isEmpty()) {
            return null;
        }
        PFDCollapsableNodeGroup pGroup = null;
        PFDModel pModel = model;
        ListIterator iterator = primitives.listIterator();
        while (iterator.hasNext()) {
            boolean first = iterator.nextIndex() == 0;
            PFDPrimitive p = (PFDPrimitive)iterator.next();
            if (!p.canGroup()) {
                return null;
            }
            if (p instanceof PFDLink) continue;
            if (first) {
                pGroup = PFDCollapsableNodeGroup.getParentNodeGroup(p);
            } else if (pGroup != PFDCollapsableNodeGroup.getParentNodeGroup(p)) {
                return null;
            }
            if (pModel != null) continue;
            pModel = p.getModel();
        }
        if (pGroup != null && primitives.size() == pGroup.getGroupPrimitiveCount()) {
            return null;
        }
        PFDCollapsableNodeGroup group = new PFDCollapsableNodeGroup();
        if (pGroup != null) {
            pGroup.addGroupPrimitive(group);
        } else if (pModel != null) {
            pModel.addPrimitive(group);
        }
        PFDCollapsableNodeGroup.movePrimitivesToGroup(primitives, group);
        group.bringToFront();
        return group;
    }

    public static PFDCollapsableNodeGroup createGroup(List primitives) {
        return PFDCollapsableNodeGroup.createGroup(primitives, null);
    }

    public static boolean canGroup(List primitives) {
        if (primitives == null || primitives.isEmpty()) {
            return false;
        }
        PFDCollapsableNodeGroup pGroup = null;
        ListIterator iterator = primitives.listIterator();
        while (iterator.hasNext()) {
            boolean first = iterator.nextIndex() == 0;
            PFDPrimitive p = (PFDPrimitive)iterator.next();
            if (!p.canGroup()) {
                return false;
            }
            if (first) {
                pGroup = PFDCollapsableNodeGroup.getParentNodeGroup(p);
                continue;
            }
            if (pGroup == PFDCollapsableNodeGroup.getParentNodeGroup(p)) continue;
            return false;
        }
        return pGroup == null || primitives.size() != pGroup.getGroupPrimitiveCount();
    }

    public void setInteractiveInputEnabled(boolean enabled) {
        this.interactiveInputEnabled = enabled;
    }

    public boolean isInteractiveInputEnabled() {
        return this.interactiveInputEnabled;
    }

    public void setInteractiveOutputEnabed(boolean enabled) {
        this.interactiveOutputEnabled = enabled;
    }

    public boolean isInteractiveOutputEnabled() {
        return this.interactiveOutputEnabled;
    }

    private void initialize() {
        this.setEditable(true);
        this.setBreakable(false);
        this.setCustomSelection(true);
        this.groupName = MessageFormat.format(groupNamePattern, new Integer(++groupCount));
        this.groupNode = new PFDGroupNode(this);
        this.groupNode.setTitleText(this.groupName);
        this.groupWindow = new PFDGroupWindow(this);
        this.groupWindow.setTitleText(this.groupName);
        this.addPrimitive(this.groupNode);
        this.groupNode.setExpanded(this.groupWindow);
        this.DEFAULT_isCollapsed = Boolean.FALSE;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
        this.groupNode.setTitleText(groupName);
        this.groupWindow.setTitleText(groupName);
    }

    public void setObjectCountVisible(boolean visible) {
        this.groupWindow.setObjectCountVisible(visible);
    }

    public boolean isObjectCountVisible() {
        return this.groupWindow.isObjectCountVisible();
    }

    protected void layoutChildren() {
        this.groupNode.setLocation(this.bbox.x, this.bbox.y);
        this.groupWindow.setLocation(this.bbox.x, this.bbox.y);
        this.calculateBBox();
    }

    public PFDGroupNode getGroupNode() {
        return this.groupNode;
    }

    public PFDGroupWindow getGroupWindow() {
        return this.groupWindow;
    }

    public void addGroupPrimitives(List primitives) {
        if (primitives == null || primitives.isEmpty()) {
            return;
        }
        this.groupWindow.getSubdiagram().addSubdiagramPrimitives(primitives);
        this.groupNode.setLocation(this.groupWindow.getLocation());
        this.resetGroup();
    }

    public void addGroupPrimitive(PFDPrimitive p) {
        this.groupWindow.getSubdiagram().addSubdiagramPrimitive(p);
        this.setPrimitiveFlowDirection(p);
        this.groupNode.setLocation(this.groupWindow.getLocation());
        this.resetGroup();
    }

    private void setPrimitiveFlowDirection(PFDPrimitive p) {
        if (p instanceof PFDDirectionalNodeInterface) {
            ((PFDDirectionalNodeInterface)((Object)p)).setFlowDirection(this.groupWindow.getModel().getFlowDirection());
        }
    }

    public List getGroupPrimitives() {
        PFDSubdiagram subdiagram = this.groupWindow.getSubdiagram();
        if (subdiagram == null || subdiagram.hasNoPrimitives()) {
            return new Vector();
        }
        return subdiagram.getSubdiagramPrimitives();
    }

    public PFDPrimitive getGroupPrimitive(int index) {
        PFDSubdiagram subdiagram = this.groupWindow.getSubdiagram();
        if (subdiagram == null) {
            return null;
        }
        return subdiagram.getPrimitive(index);
    }

    public int getGroupPrimitiveCount() {
        PFDSubdiagram subdiagram = this.groupWindow.getSubdiagram();
        if (subdiagram == null || subdiagram.hasNoPrimitives()) {
            return 0;
        }
        return subdiagram.getNumPrimitives();
    }

    public boolean containsGroupPrimitive(PFDPrimitive p) {
        PFDSubdiagram subdiagram = this.groupWindow.getSubdiagram();
        return subdiagram.containsPrimitive(p);
    }

    public boolean removeGroupPrimitive(PFDPrimitive p) {
        PFDSubdiagram subdiagram = this.groupWindow.getSubdiagram();
        boolean retVal = subdiagram.removePrimitive(p);
        this.resetGroup();
        return retVal;
    }

    public void removeGroupPrimitives(List primitives) {
        PFDSubdiagram subdiagram = this.groupWindow.getSubdiagram();
        subdiagram.removeSubdiagramPrimitives(primitives);
        this.resetGroup();
    }

    public void removeAllGroupPrimitives() {
        PFDSubdiagram subdiagram = this.groupWindow.getSubdiagram();
        subdiagram.removeAllPrimitives();
        this.resetGroup();
    }

    public List getNestedGroupPrimitives() {
        Vector<PFDPrimitive> primitives = new Vector<PFDPrimitive>();
        int count = this.getGroupPrimitiveCount();
        for (int i = 0; i < count; ++i) {
            PFDPrimitive p = this.getGroupPrimitive(i);
            if (p instanceof PFDCollapsableNodeGroup) {
                List nestedPrimitives = ((PFDCollapsableNodeGroup)p).getNestedGroupPrimitives();
                if (nestedPrimitives == null) continue;
                primitives.addAll(nestedPrimitives);
                continue;
            }
            primitives.add(p);
        }
        return primitives;
    }

    public boolean containsNestedGroupPrimitive(PFDPrimitive p) {
        int count = this.getGroupPrimitiveCount();
        for (int i = 0; i < count; ++i) {
            PFDPrimitive primitive = this.getGroupPrimitive(i);
            if (primitive == p) {
                return true;
            }
            if (!(primitive instanceof PFDCollapsableNodeGroup) || !((PFDCollapsableNodeGroup)primitive).containsNestedGroupPrimitive(p)) continue;
            return true;
        }
        return false;
    }

    public NodeLayoutInterface getLayoutNode() {
        if (!this.isCollapsed) {
            return this.groupWindow.getSubdiagram();
        }
        return this.groupNode;
    }

    @Override
    public boolean canUngroup() {
        return true;
    }

    @Override
    public void ungroup() {
        if (!this.canUngroup()) {
            return;
        }
        PFDCollapsableNodeGroup parentGroup = PFDCollapsableNodeGroup.getParentNodeGroup(this);
        if (parentGroup == null && this.model == null) {
            return;
        }
        if (this.isCollapsed) {
            this.setCollapsed(false);
        }
        List primitives = null;
        if (this.getGroupPrimitiveCount() > 0) {
            primitives = this.getGroupPrimitives();
            this.removeAllGroupPrimitives();
        }
        if (parentGroup != null) {
            parentGroup.addGroupPrimitives(primitives);
            parentGroup.removeGroupPrimitive(this);
        } else {
            PFDCollapsableNodeGroup.addPrimitivesToModel(primitives, this.model);
            this.model.removePrimitive(this);
        }
    }

    @Override
    public String getFlowDirection() {
        return this.groupNode.getFlowDirection();
    }

    @Override
    public void setFlowDirection(String direction) {
        this.groupNode.setFlowDirection(direction);
        this.groupWindow.setFlowDirection(direction);
    }

    @Override
    public List getMenuItems() {
        Vector<JComponent> items = new Vector<JComponent>();
        if (this.isCollapsed) {
            Action open = this.getAction("ACTION_OPEN_GROUP");
            items.add(new JMenuItem(open));
        } else {
            Action close = this.getAction("ACTION_CLOSE_GROUP");
            items.add(new JMenuItem(close));
        }
        Action ungroupAction = this.getAction("ACTION_UNGROUP");
        ungroupAction.setEnabled(this.canUngroup());
        items.add(new JMenuItem(ungroupAction));
        items.add(new JPopupMenu.Separator());
        items.addAll(super.getMenuItems());
        return items;
    }

    @Override
    public void setCollapsed(boolean collapsed) {
        this.setCollapsedImpl(collapsed, true);
    }

    private void setCollapsedImpl(boolean collapsed, boolean doUpdate) {
        if (!this.isBuilt) {
            this.preBuildIsCollapsed = collapsed;
            return;
        }
        if (collapsed == this.isCollapsed) {
            return;
        }
        this.isCollapsed = collapsed;
        if (this.isCollapsed) {
            this.groupWindow.collapse();
        } else {
            this.groupNode.expand();
        }
        this.snapToGrid();
        if (doUpdate) {
            this.firePropertyChange("isCollapsed");
        }
    }

    @Override
    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    @Override
    public void updateCollapsed() {
        if (!this.isBuilt) {
            if (this.preBuildIsCollapsed) {
                this.setCollapsedImpl(false, false);
                this.setCollapsedImpl(true, false);
            }
        } else if (this.isCollapsed) {
            this.setCollapsedImpl(false, false);
            this.setCollapsedImpl(true, false);
        }
    }

    @Override
    protected Action createAction(String actionKey) {
        if (actionKey == null) {
            return null;
        }
        if (actionKey.equals("ACTION_OPEN_GROUP")) {
            return new PFDOpenGroupAction(this);
        }
        if (actionKey.equals("ACTION_CLOSE_GROUP")) {
            return new PFDCloseGroupAction(this);
        }
        if (actionKey.equals("ACTION_UNGROUP")) {
            return new PFDUngroupAction(this);
        }
        return super.createAction(actionKey);
    }

    @Override
    public Object cloneObject(Hashtable table) {
        this.groupWindow.setLocation(this.getLocation());
        this.groupNode.setLocation(this.getLocation());
        --groupCount;
        PFDCollapsableNodeGroup clone = new PFDCollapsableNodeGroup();
        table.put(this, clone);
        this.copyObject(clone);
        Vector<PFDCollapsableNodeGroup> clones = new Vector<PFDCollapsableNodeGroup>();
        PFDSubdiagram sd = this.groupWindow.getSubdiagram();
        Vector<PFDPrimitive> primitives = new Vector<PFDPrimitive>(sd.getNumPrimitives());
        for (int i = 0; i < sd.getNumPrimitives(); ++i) {
            PFDPrimitive p = sd.getPrimitive(i);
            if (p instanceof PFDCollapsableNodeGroup) {
                List list = (List)p.cloneObject(table);
                if (list.isEmpty()) continue;
                primitives.add((PFDPrimitive)list.remove(list.size() - 1));
                clones.addAll(list);
                continue;
            }
            primitives.add((PFDPrimitive)p.cloneObject(table));
        }
        clone.addGroupPrimitives(primitives);
        Vector links = sd.getInternalLinks();
        for (int i = 0; i < links.size(); ++i) {
            PFDLink l = (PFDLink)links.get(i);
            this.cloneLink(l, table, clones);
        }
        clones.add(clone);
        return clones;
    }

    private void cloneLink(PFDLink l, Hashtable table, List addList) {
        if (l.isCollapsed) {
            List linkList = PFDSubdiagram.getExpandedLinks(l);
            for (int i = 0; i < linkList.size(); ++i) {
                PFDLink link = (PFDLink)linkList.get(i);
                this.cloneSingleLink(link, table, addList);
            }
        } else {
            this.cloneSingleLink(l, table, addList);
        }
    }

    private void cloneSingleLink(PFDLink l, Hashtable table, List addList) {
        if (table.containsKey(l)) {
            return;
        }
        PFDLink copiedLink = (PFDLink)l.cloneObject(table);
        copiedLink.setVisible(true);
        addList.add(copiedLink);
        PFDPort copiedFromPort = (PFDPort)table.get(l.getFromPort());
        PFDPort copiedToPort = (PFDPort)table.get(l.getToPort());
        copiedLink.setFromPort(copiedFromPort);
        copiedLink.setToPort(copiedToPort);
    }

    public void copyObject(PFDCollapsableNodeGroup toObject) {
        super.copyObject(toObject);
        toObject.setCollapsed(this.isCollapsed);
        toObject.setGroupName(this.groupName);
    }

    @Override
    protected void build(PFDView v) {
        this.groupNode.build(v);
        this.groupWindow.build(v);
        this.groupNode.setLocation(this.groupWindow.getLocation());
        this.update("all", v);
        if (!this.isBuilt) {
            this.isBuilt = true;
            this.setCollapsed(false);
            this.setCollapsed(this.preBuildIsCollapsed);
        }
        if (this.pendingLocationX != Integer.MIN_VALUE || this.pendingLocationY != Integer.MIN_VALUE) {
            Point spot = this.getSpotLocation(1, null);
            if (this.pendingLocationX != Integer.MIN_VALUE) {
                spot.x = this.pendingLocationX;
                this.pendingLocationX = Integer.MIN_VALUE;
            }
            if (this.pendingLocationY != Integer.MIN_VALUE) {
                spot.y = this.pendingLocationY;
                this.pendingLocationY = Integer.MIN_VALUE;
            }
            this.setSpotLocation(1, spot);
        }
    }

    @Override
    public void bringToFront() {
        if (this.model == null) {
            return;
        }
        if (this.group != null) {
            this.group.bringToFront(this);
        } else {
            this.model.bringToFront(this);
            Vector links = new Vector();
            this.accumulateLinks(links);
            if (links.size() > 0) {
                this.model.bringToFront(links.elements());
            }
        }
    }

    public void resetCollapsedState() {
        if (this.isCollapsed) {
            this.setCollapsed(false);
            this.resetChildrenCollapsedState();
            this.setCollapsed(true);
        } else {
            this.resetChildrenCollapsedState();
            this.setCollapsed(true);
            this.setCollapsed(false);
        }
    }

    private void resetChildrenCollapsedState() {
        PFDSubdiagram sd = this.groupWindow.getSubdiagram();
        for (int i = 0; i < sd.getNumPrimitives(); ++i) {
            PFDPrimitive p = sd.getPrimitive(i);
            if (!(p instanceof PFDCollapsableNodeGroup)) continue;
            ((PFDCollapsableNodeGroup)p).resetCollapsedState();
        }
    }

    @Override
    public void accumulateNodes(Vector v) {
        if (v == null) {
            return;
        }
        if (this.groupNode != null) {
            v.add(this.groupNode);
        }
        if (this.groupWindow != null) {
            this.groupWindow.accumulateNodes(v);
        }
    }

    @Override
    public void setStatus(int status) {
        this.groupNode.setStatus(status);
    }

    @Override
    public void setStatus(int status, String tooltip) {
        this.groupNode.setStatus(status, tooltip);
    }

    @Override
    public void setStatus(int status, String tooltip, String title, String content, HyperlinkListener listener) {
        this.groupNode.setStatus(status, tooltip, title, content, listener);
    }

    @Override
    public void setStatus(PFDStatus status) {
        this.groupNode.setStatus(status);
    }

    @Override
    public int getStatus() {
        return this.groupNode.getStatus();
    }

    @Override
    public PFDStatus getStatusObject() {
        return this.groupNode.getStatusObject();
    }

    public static PFDCollapsableNodeGroup getParentNodeGroup(PFDPrimitive p) {
        PFDGroup parent;
        if (p == null) {
            return null;
        }
        for (parent = p.getParent(); parent != null && !(parent instanceof PFDCollapsableNodeGroup); parent = parent.getParent()) {
        }
        return (PFDCollapsableNodeGroup)parent;
    }

    public static PFDCollapsableNodeGroup getTopParentNodeGroup(PFDPrimitive p) {
        if (p == null) {
            return null;
        }
        PFDCollapsableNodeGroup parentNodeGroup = PFDCollapsableNodeGroup.getParentNodeGroup(p);
        if (parentNodeGroup == null) {
            return null;
        }
        PFDCollapsableNodeGroup topParent = PFDCollapsableNodeGroup.getTopParentNodeGroup(parentNodeGroup);
        if (topParent == null) {
            return parentNodeGroup;
        }
        return topParent;
    }

    private static Map createParentMap(List primitives) {
        HashMap parentMap = new HashMap();
        for (PFDPrimitive p : primitives) {
            if (p == null) continue;
            PFDCollapsableNodeGroup pGroup = PFDCollapsableNodeGroup.getParentNodeGroup(p);
            PFDModel pModel = p.getModel();
            PFDGroup pParent = p.getParent();
            List mapList = null;
            if (pGroup != null) {
                mapList = PFDCollapsableNodeGroup.getMappedList(parentMap, pGroup);
            } else if (pParent == null) {
                mapList = pModel != null ? PFDCollapsableNodeGroup.getMappedList(parentMap, pModel) : PFDCollapsableNodeGroup.getMappedList(parentMap, null);
            }
            if (mapList == null) continue;
            mapList.add(p);
        }
        return parentMap;
    }

    private static Map createGrandparentMap(List primitives) {
        HashMap grandparentMap = new HashMap();
        for (PFDPrimitive p : primitives) {
            if (p == null) continue;
            PFDCollapsableNodeGroup pGroup = PFDCollapsableNodeGroup.getParentNodeGroup(p);
            PFDCollapsableNodeGroup pGrandParent = PFDCollapsableNodeGroup.getParentNodeGroup(pGroup);
            PFDGroup pParent = p.getParent();
            PFDModel pModel = p.getModel();
            List mapList = null;
            if (pGroup != null) {
                mapList = pGrandParent != null ? PFDCollapsableNodeGroup.getMappedList(grandparentMap, pGrandParent) : (pModel != null ? PFDCollapsableNodeGroup.getMappedList(grandparentMap, pModel) : PFDCollapsableNodeGroup.getMappedList(grandparentMap, null));
            } else if (pParent == null) {
                mapList = PFDCollapsableNodeGroup.getMappedList(grandparentMap, null);
            }
            if (mapList == null) continue;
            mapList.add(p);
        }
        return grandparentMap;
    }

    private static List getMappedList(Map map, Object key) {
        Vector mapList = (Vector)map.get(key);
        if (mapList == null) {
            mapList = new Vector();
            map.put(key, mapList);
        }
        return mapList;
    }

    private static void removePrimitivesFromModel(List primitives, PFDModel model) {
        if (primitives == null || primitives.isEmpty()) {
            return;
        }
        for (PFDPrimitive p : primitives) {
            if (p instanceof PFDLink) continue;
            model.getDefaultLayer().removePrimitive(p);
        }
    }

    private static void addPrimitivesToModel(List primitives, PFDModel model) {
        if (primitives == null || primitives.isEmpty()) {
            return;
        }
        for (PFDPrimitive p : primitives) {
            if (p instanceof PFDLink) continue;
            model.getDefaultLayer().addPrimitive(p);
            p.bringToFront();
        }
    }

    public static void movePrimitiveToGroup(PFDPrimitive p, PFDCollapsableNodeGroup group) {
        if (p == null) {
            throw new IllegalArgumentException("The specified primitive is null");
        }
        if (group == null) {
            throw new IllegalArgumentException("The specified group is null");
        }
        PFDCollapsableNodeGroup pNodeGroup = PFDCollapsableNodeGroup.getParentNodeGroup(p);
        PFDGroup pParent = p.getParent();
        PFDModel pModel = p.getModel();
        if (group == pNodeGroup) {
            return;
        }
        if (pNodeGroup != null) {
            pNodeGroup.removeGroupPrimitive(p);
            pNodeGroup.update();
        } else if (pParent == null) {
            if (pModel != null) {
                pModel.removePrimitive(p);
            }
        } else {
            return;
        }
        group.addGroupPrimitive(p);
    }

    public static void movePrimitivesToGroup(List primitives, PFDCollapsableNodeGroup group) {
        if (primitives == null) {
            throw new IllegalArgumentException("The specified primitive list is null");
        }
        if (group == null) {
            throw new IllegalArgumentException("The specified group is null");
        }
        Map parentMap = PFDCollapsableNodeGroup.createParentMap(primitives);
        parentMap.remove(group);
        Vector addPrimitives = new Vector();
        for (Object key : parentMap.keySet()) {
            if (key instanceof PFDCollapsableNodeGroup) {
                PFDCollapsableNodeGroup keyGroup = (PFDCollapsableNodeGroup)key;
                List groupPrimitives = (List)parentMap.get(key);
                keyGroup.removeGroupPrimitives(groupPrimitives);
                keyGroup.update();
                addPrimitives.addAll(groupPrimitives);
                continue;
            }
            if (key instanceof PFDModel) {
                PFDModel keyModel = (PFDModel)key;
                List modelPrimitives = (List)parentMap.get(key);
                PFDCollapsableNodeGroup.removePrimitivesFromModel(modelPrimitives, keyModel);
                addPrimitives.addAll(modelPrimitives);
                continue;
            }
            addPrimitives.addAll((Collection)parentMap.get(key));
        }
        group.addGroupPrimitives(addPrimitives);
    }

    public static void movePrimitiveToModel(PFDPrimitive p, PFDModel model) {
        if (p == null) {
            throw new IllegalArgumentException("The specified primitive is null");
        }
        if (model == null) {
            throw new IllegalArgumentException("The specified model is null");
        }
        PFDCollapsableNodeGroup pGroup = PFDCollapsableNodeGroup.getParentNodeGroup(p);
        if (pGroup == null) {
            throw new IllegalArgumentException("The specified primitive has no group");
        }
        pGroup.removeGroupPrimitive(p);
        model.addPrimitive(p);
        p.bringToFront();
        pGroup.update();
    }

    public static void movePrimitivesToModel(List primitives, PFDModel model) {
        if (primitives == null) {
            throw new IllegalArgumentException("The specified primitive list is null");
        }
        if (model == null) {
            throw new IllegalArgumentException("The specified model is null");
        }
        Map parentMap = PFDCollapsableNodeGroup.createParentMap(primitives);
        Vector addPrimitives = new Vector();
        for (Object key : parentMap.keySet()) {
            if (!(key instanceof PFDCollapsableNodeGroup)) continue;
            PFDCollapsableNodeGroup keyGroup = (PFDCollapsableNodeGroup)key;
            List groupPrimitives = (List)parentMap.get(key);
            keyGroup.removeGroupPrimitives(groupPrimitives);
            keyGroup.update();
            addPrimitives.addAll(groupPrimitives);
        }
        PFDCollapsableNodeGroup.addPrimitivesToModel(addPrimitives, model);
    }

    public static void movePrimitiveUpGroupHierarchy(PFDPrimitive p) {
        if (p == null) {
            throw new IllegalArgumentException("The specified primitive is null");
        }
        PFDCollapsableNodeGroup pGroup = PFDCollapsableNodeGroup.getParentNodeGroup(p);
        PFDCollapsableNodeGroup pGroupGroup = PFDCollapsableNodeGroup.getParentNodeGroup(pGroup);
        if (pGroupGroup == null) {
            PFDCollapsableNodeGroup.movePrimitiveToModel(p, p.getModel());
        } else {
            PFDCollapsableNodeGroup.movePrimitiveToGroup(p, pGroupGroup);
        }
    }

    public static void movePrimitivesUpGroupHierarchy(List primitives) {
        List groupPrimitives;
        PFDCollapsableNodeGroup keyGroup;
        if (primitives == null) {
            throw new IllegalArgumentException("The specified primitive list is null");
        }
        Map parentMap = PFDCollapsableNodeGroup.createParentMap(primitives);
        Map grandParentMap = PFDCollapsableNodeGroup.createGrandparentMap(primitives);
        for (Object key : parentMap.keySet()) {
            if (!(key instanceof PFDCollapsableNodeGroup)) continue;
            keyGroup = (PFDCollapsableNodeGroup)key;
            groupPrimitives = (List)parentMap.get(key);
            keyGroup.removeGroupPrimitives(groupPrimitives);
            keyGroup.update();
        }
        for (Object key : grandParentMap.keySet()) {
            if (key instanceof PFDCollapsableNodeGroup) {
                keyGroup = (PFDCollapsableNodeGroup)key;
                groupPrimitives = (List)grandParentMap.get(key);
                keyGroup.addGroupPrimitives(groupPrimitives);
                continue;
            }
            if (!(key instanceof PFDModel)) continue;
            PFDModel keyModel = (PFDModel)key;
            List modelPrimitives = (List)grandParentMap.get(key);
            PFDCollapsableNodeGroup.addPrimitivesToModel(modelPrimitives, keyModel);
        }
    }

    public void update() {
        int numPrimitives = this.getGroupPrimitiveCount();
        if (numPrimitives < 2) {
            this.ungroup();
        }
    }

    private void resetGroup() {
        if (!this.isBuilt) {
            return;
        }
        boolean isCollapsed = this.isCollapsed();
        if (isCollapsed) {
            this.setCollapsed(false);
        }
        PFDUtil.updateParentCollapsable(this);
        if (isCollapsed) {
            this.setCollapsed(true);
        }
    }

    @Override
    public Point getSpotLocation(int spot, Point p) {
        if (spot == 10) {
            if (this.isCollapsed) {
                return this.groupNode.getSpotLocation(spot, p);
            }
            return this.groupWindow.getSpotLocation(spot, p);
        }
        return super.getSpotLocation(spot, p);
    }

    @Override
    public void setLocation(int x, int y) {
        this.disableChangeUpdate();
        this.groupNode.setLocation(x, y);
        this.groupWindow.setLocation(x, y);
        this.enableChangeUpdate();
        this.calculateBBox();
        this.firePropertyChange("bbox");
    }

    private void snapToGrid() {
        if (this.theView != null && this.theView.isSnapToGrid()) {
            this.theView.snapPrimitiveToGrid(this);
        }
    }

    @Override
    public void setPortStyle(int portStyle) {
        if (portStyle == this.groupNode.portStyle) {
            return;
        }
        this.groupNode.setPortStyle(portStyle);
        if (this.isCollapsed) {
            this.groupNode.setLocation(this.groupWindow.getLocation());
            this.snapToGrid();
        }
    }

    @Override
    public int getPortStyle() {
        return this.groupNode.getPortStyle();
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        boolean rc = true;
        Vector changes = this.pending.getChangesBySource(source);
        if (changes.size() > 0) {
            rc = true;
            for (int i = 0; i < changes.size(); ++i) {
                PropertyEvent event = (PropertyEvent)changes.elementAt(i);
                int key = event.id;
                Object value = event.value;
                this.applyChange(key, value);
            }
        }
        this.pending.removeChangesBySource(source);
        return rc;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        switch (id) {
            case 500: {
                return this.getGroupName();
            }
            case 501: {
                return this.isCollapsed;
            }
            case 410: {
                return this.getPFDItemId();
            }
            case 408: {
                return this.getSpotLocation((int)1, null).x;
            }
            case 409: {
                return this.getSpotLocation((int)1, null).y;
            }
        }
        return null;
    }

    public boolean hasUserSetValue(int id) {
        switch (id) {
            case 501: {
                if (this.isCollapsed == this.DEFAULT_isCollapsed) break;
                return true;
            }
            case 408: {
                if (this.pendingLocationX != Integer.MIN_VALUE) {
                    return true;
                }
            }
            case 409: {
                if (this.pendingLocationY != Integer.MIN_VALUE) {
                    return true;
                }
            }
            case 410: 
            case 500: {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public boolean isPropertySupported(int id) {
        switch (id) {
            case 408: 
            case 409: 
            case 410: 
            case 500: 
            case 501: {
                return true;
            }
        }
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.isPropertySupported(id)) {
            return this.pending.store(id, value);
        }
        return false;
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 500: {
                if (!(value instanceof String)) break;
                this.setGroupName((String)value);
                break;
            }
            case 501: {
                if (!(value instanceof Boolean)) break;
                this.setCollapsed((Boolean)value);
                break;
            }
            case 410: {
                if (!(value instanceof String)) break;
                this.setPFDItemId((String)value);
                break;
            }
            case 408: {
                if (!(value instanceof Integer)) break;
                this.pendingLocationX = (Integer)value;
                break;
            }
            case 409: {
                if (!(value instanceof Integer)) break;
                this.pendingLocationY = (Integer)value;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.pending = new PropertyList();
    }
}

