/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDPropertyChangeSupport;
import com.sas.graphics.components.pfd.RB;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.io.Serializable;

public class PFDBrush
extends PFDPropertyChangeSupport
implements Serializable {
    public static final String RB_KEY = "PFDBrush.";
    public static final int NONE = 0;
    public static final int CUSTOM = 1;
    public static final int SOLID = 2;
    protected int style = 2;
    protected Color color = new Color(102, 153, 204);
    protected transient Paint paint = null;
    public static final Color transparentColor = new Color(0, 0, 0, 0);

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        if (this.style == style) {
            return;
        }
        this.checkStyle(style);
        this.style = style;
        this.firePropertyChange("style", null, null);
    }

    private void checkStyle(int style) {
        switch (style) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "style.ex.txt"));
            }
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.firePropertyChange("color", null, null);
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
        this.firePropertyChange("paint", null, null);
    }

    public void apply(Graphics2D g2d) {
        if (this.style == 2) {
            this.paint = this.color;
        }
        if (this.style == 0) {
            this.paint = transparentColor;
        }
        g2d.setPaint(this.paint);
    }

    public void copyObject(PFDBrush toObject) {
        toObject.setStyle(this.getStyle());
        toObject.setColor(this.getColor());
        toObject.setPaint(this.getPaint());
    }
}

