/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.interfaces.PFDAnnotateInterface;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class PFDAnnotateComponent
extends JComponent {
    private PFDAnnotateInterface pfdAnno;
    private PFDView view;

    private PFDAnnotateComponent(PFDAnnotateInterface anno, PFDView view) {
        this.pfdAnno = anno;
        this.view = view;
        anno.setAnnotateComponent(this);
        this.addMouseListener(anno);
        this.addMouseMotionListener(anno);
    }

    public void dispose() {
        if (this.pfdAnno != null) {
            this.removeMouseListener(this.pfdAnno);
            this.removeMouseMotionListener(this.pfdAnno);
            this.pfdAnno.dispose();
            this.pfdAnno = null;
        }
    }

    public static PFDAnnotateComponent createInstance(PFDView view) {
        PFDAnnotateInterface anno = PFDAnnotateComponent.createAnnotationObject(view);
        if (anno == null) {
            return null;
        }
        return new PFDAnnotateComponent(anno, view);
    }

    public static PFDAnnotateInterface createAnnotationObject(PFDView view) {
        Class<?> cls = null;
        try {
            Class.forName("com.sas.graphics.sganno.Annotate");
            Class.forName("com.sas.graphics.styles.Style");
            cls = Class.forName("com.sas.graphics.components.pfd.PFDAnnotate");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (cls == null) {
            return null;
        }
        PFDAnnotateInterface rc = null;
        try {
            rc = (PFDAnnotateInterface)cls.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (rc != null) {
            rc.setView(view);
        }
        return rc;
    }

    public PFDAnnotateInterface getPFDAnnotate() {
        return this.pfdAnno;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.pfdAnno.draw((Graphics2D)g);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.view.getMouseMode() != 0) {
            return false;
        }
        if (!this.pfdAnno.isInSelectMode()) {
            return true;
        }
        return this.pfdAnno.contains(x, y);
    }

    public Rectangle getAnnotateBounds() {
        return this.pfdAnno.getAnnotateBounds();
    }
}

