/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDQuickNoteWindow;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.components.pfd.interfaces.PFDNoteInterface;
import com.sas.graphics.components.pfd.ui.actions.PFDAddQuickNoteAction;
import com.sas.graphics.components.pfd.ui.actions.PFDOpenQuickNoteAction;
import com.sas.graphics.components.pfd.ui.actions.PFDRemoveQuickNoteAction;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JTextPane;

public abstract class PFDAbstractNode
extends PFDGroup
implements NodeLayoutInterface,
PFDNoteInterface {
    public static final String RB_KEY = "PFDAbstractNode.";
    public final String HCT_SYS_PROPERTY = "HIGH_CONTRAST_TESTING";
    private String nodeType;
    private String nodeTypeDescription;
    private Icon nodeTypeIcon;
    private static final int nodeTypeIconSize = 16;
    private boolean nodePlaced = false;
    private String[] supportedFromNodeTypes;
    protected PFDQuickNoteWindow note;

    @Override
    public abstract Point getCenterLocation();

    @Override
    public abstract void setCenterLocation(Point var1);

    public abstract PFDPort getInputPort();

    public abstract PFDPort getOutputPort();

    public abstract boolean isForceShowPorts();

    public abstract void setForceShowPorts(boolean var1);

    public abstract PFDPort getPort(String var1);

    public abstract void addPort(String var1, int var2);

    public abstract void removePort(String var1);

    public Vector getInputLinks() {
        Vector inputLinks = new Vector();
        PFDPort p = this.getInputPort();
        if (p != null) {
            inputLinks.addAll(p.getToLinks());
        }
        return inputLinks;
    }

    public Vector getOutputLinks() {
        Vector outputLinks = new Vector();
        PFDPort p = this.getOutputPort();
        if (p != null) {
            outputLinks.addAll(p.getFromLinks());
        }
        return outputLinks;
    }

    @Override
    public int getOutputEndSegmentLength() {
        PFDPort port = this.getOutputPort();
        if (port == null) {
            return 0;
        }
        return port.getEndSegmentLength();
    }

    @Override
    public int getInputEndSegmentLength() {
        PFDPort port = this.getInputPort();
        if (port == null) {
            return 0;
        }
        return port.getEndSegmentLength();
    }

    @Override
    public double getOutputLinkDirection() {
        PFDPort port = this.getOutputPort();
        if (port == null) {
            return Double.NaN;
        }
        return port.getFromLinkDirection();
    }

    @Override
    public double getInputLinkDirection() {
        PFDPort port = this.getInputPort();
        if (port == null) {
            return Double.NaN;
        }
        return port.getToLinkDirection();
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String type) {
        this.nodeType = type;
    }

    public String getNodeTypeDescription() {
        return this.nodeTypeDescription;
    }

    public void setNodeTypeDescription(String nodeTypeDescription) {
        this.nodeTypeDescription = nodeTypeDescription;
    }

    public Icon getNodeTypeIcon() {
        return this.nodeTypeIcon;
    }

    public void setNodeTypeIcon(Icon nodeTypeIcon) throws IllegalArgumentException {
        this.checkIconSize(nodeTypeIcon);
        this.nodeTypeIcon = nodeTypeIcon;
    }

    private void checkIconSize(Icon icon) throws IllegalArgumentException {
        if (icon != null && (icon.getIconWidth() != 16 || icon.getIconHeight() != 16)) {
            throw new IllegalArgumentException("The nodeTypeIcon is the incorrect size.");
        }
    }

    public String[] getSupportedFromNodeTypes() {
        return this.supportedFromNodeTypes;
    }

    public void setSupportedFromNodeTypes(String[] types) {
        this.supportedFromNodeTypes = types;
    }

    public boolean isFromNodeTypeSupported(String type) {
        if (this.supportedFromNodeTypes == null || type == null) {
            return true;
        }
        for (int i = 0; i < this.supportedFromNodeTypes.length; ++i) {
            if (!type.equals(this.supportedFromNodeTypes[i])) continue;
            return true;
        }
        return false;
    }

    protected abstract Vector getChildren();

    protected abstract Vector getParents();

    public Enumeration children() {
        return this.getChildren().elements();
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    public PFDAbstractNode getChildAt(int childIndex) {
        return (PFDAbstractNode)this.getChildren().elementAt(childIndex);
    }

    public int getChildIndex(PFDAbstractNode childNode) {
        return this.getChildren().indexOf(childNode);
    }

    public Enumeration parents() {
        return this.getParents().elements();
    }

    public int getParentCount() {
        return this.getParents().size();
    }

    public PFDAbstractNode getParentAt(int parentIndex) {
        return (PFDAbstractNode)this.getParents().elementAt(parentIndex);
    }

    public int getParentIndex(PFDAbstractNode parentNode) {
        return this.getParents().indexOf(parentNode);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public int getLayoutHeight() {
        return this.getHeight();
    }

    @Override
    public int getLayoutWidth() {
        return this.getWidth();
    }

    @Override
    public void setNodePlaced(boolean place) {
        this.nodePlaced = place;
    }

    @Override
    public boolean isNodePlaced() {
        return this.nodePlaced;
    }

    @Override
    public PFDPrimitive pickTopPrimitive(int x, int y, Class c) {
        return this.pickPrimitive(x, y, c);
    }

    @Override
    public void addNote() {
        if (this.note == null) {
            this.note = new PFDQuickNoteWindow(this);
            this.getAction("ACTION_ADD_QUICK_NOTE").setEnabled(false);
            this.getAction("ACTION_OPEN_QUICK_NOTE").setEnabled(true);
            this.getAction("ACTION_REMOVE_QUICK_NOTE").setEnabled(true);
            this.firePropertyChange("note");
        }
    }

    @Override
    public void removeNote() {
        if (this.note != null) {
            this.removePrimitive(this.note);
            this.note = null;
            this.getAction("ACTION_ADD_QUICK_NOTE").setEnabled(true);
            this.getAction("ACTION_OPEN_QUICK_NOTE").setEnabled(false);
            this.getAction("ACTION_REMOVE_QUICK_NOTE").setEnabled(false);
            this.firePropertyChange("note");
        }
    }

    @Override
    public boolean hasNote() {
        return this.note != null;
    }

    @Override
    public void setNoteVisible(boolean visible) {
        if (visible) {
            if (this.note == null) {
                this.addNote();
            }
            if (!this.containsPrimitive(this.note)) {
                this.setNoteLocation();
                this.enableUpdate = false;
                this.addPrimitive(this.note);
                this.enableUpdate = true;
                this.firePropertyChange("bbox");
                this.note.getTextPane().requestFocusInWindow();
                this.getAction("ACTION_OPEN_QUICK_NOTE").setEnabled(false);
            }
        } else if (this.note != null && this.containsPrimitive(this.note)) {
            this.removePrimitive(this.note);
            this.getAction("ACTION_OPEN_QUICK_NOTE").setEnabled(true);
        }
    }

    @Override
    public boolean isNoteVisible() {
        if (this.note == null) {
            return false;
        }
        return this.containsPrimitive(this.note);
    }

    @Override
    public void setNoteText(String text) {
        if (text == null) {
            this.removeNote();
        } else {
            if (this.note == null) {
                this.addNote();
            }
            this.note.setText(text);
        }
    }

    @Override
    public String getNoteText() {
        if (this.note == null) {
            return null;
        }
        return this.note.getText();
    }

    @Override
    public JTextPane getNoteTextPane() {
        if (this.note == null) {
            return null;
        }
        return this.note.getTextPane();
    }

    protected void setNoteLocation() {
        if (this.note != null) {
            this.note.setLocation(this.bbox.x + this.bbox.width / 2, this.bbox.y + this.bbox.height / 2);
        }
    }

    protected void drawNote(Graphics2D g) {
        if (this.note != null && this.containsPrimitive(this.note)) {
            this.note.paint(g);
        }
    }

    @Override
    protected void detachView(PFDView v) {
        super.detachView(v);
        this.removeNote();
    }

    @Override
    protected Action createAction(String actionKey) {
        if (actionKey == null) {
            return null;
        }
        if (actionKey.equals("ACTION_ADD_QUICK_NOTE")) {
            return new PFDAddQuickNoteAction(this);
        }
        if (actionKey.equals("ACTION_REMOVE_QUICK_NOTE")) {
            return new PFDRemoveQuickNoteAction(this);
        }
        if (actionKey.equals("ACTION_OPEN_QUICK_NOTE")) {
            return new PFDOpenQuickNoteAction(this);
        }
        return super.createAction(actionKey);
    }

    protected JMenu createNoteMenu() {
        JMenu noteMenu = new JMenu(RB.getStringResource(RB_KEY, "noteMenu.name.txt"));
        Action action = this.getAction("ACTION_ADD_QUICK_NOTE");
        noteMenu.add(action);
        action = this.getAction("ACTION_OPEN_QUICK_NOTE");
        noteMenu.add(action);
        action = this.getAction("ACTION_REMOVE_QUICK_NOTE");
        noteMenu.add(action);
        return noteMenu;
    }

    @Override
    public void layoutSelfLinks() {
    }
}

