/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;

public abstract class PFDAbstractButton
extends PFDGroup
implements PropertyChangeListener {
    protected Action action;
    protected String actionCommand;
    protected boolean enabled = true;
    protected boolean rolloverEnabled = false;
    protected EventListenerList listenerList = new EventListenerList();
    protected PFDIcon icon = new PFDIcon();
    protected PFDIcon rolloverIcon;

    public PFDAbstractButton() {
        this.addPrimitive(this.icon);
        this.rolloverIcon = new PFDIcon();
        this.rolloverIcon.setVisible(false);
        this.addPrimitive(this.rolloverIcon);
    }

    public void setAction(Action a) {
        if (this.action == a) {
            return;
        }
        if (this.action != null) {
            this.listenerList.remove(ActionListener.class, this.action);
            this.action.removePropertyChangeListener(this);
        }
        this.action = a;
        if (this.action != null) {
            this.listenerList.add(ActionListener.class, this.action);
            this.action.addPropertyChangeListener(this);
        }
        this.configurePropertiesFromAction();
    }

    public Action getAction() {
        return this.action;
    }

    protected void configurePropertiesFromAction() {
        if (this.action != null) {
            Object actionTooltip;
            Object actionActionCommand;
            Object actionIcon = this.action.getValue("SmallIcon");
            if (actionIcon instanceof Icon) {
                this.icon.setIcon((Icon)actionIcon);
            }
            if ((actionActionCommand = this.action.getValue("ActionCommandKey")) instanceof String) {
                this.actionCommand = (String)actionActionCommand;
            }
            if ((actionTooltip = this.action.getValue("ShortDescription")) instanceof String) {
                this.setToolTipText((String)actionTooltip);
            }
            if (this.action instanceof AbstractAction) {
                this.setEnabled(this.action.isEnabled());
            }
        } else {
            this.icon.setIcon(null);
            this.actionCommand = null;
            this.setToolTipText(null);
            this.enabled = true;
        }
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        if (this.action == l) {
            this.setAction(null);
        } else {
            this.listenerList.remove(ActionListener.class, l);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed(ActionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public Icon getIcon() {
        return this.icon.getIcon();
    }

    public void setIcon(Icon icon) {
        if (icon == this.icon.getIcon()) {
            return;
        }
        this.icon.setIcon(icon);
        this.firePropertyChange("icon");
    }

    public void setRolloverIcon(Icon icon) {
        if (icon == this.rolloverIcon.getIcon()) {
            return;
        }
        this.rolloverIcon.setIcon(icon);
        this.firePropertyChange("rolloverIcon");
    }

    public Icon getRolloverIcon() {
        return this.rolloverIcon.getIcon();
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.firePropertyChange("enabled");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setRolloverEnabled(boolean enabled) {
        if (this.rolloverEnabled == enabled) {
            return;
        }
        this.rolloverEnabled = enabled;
        this.firePropertyChange("rolloverEnabled");
    }

    public boolean isRolloveEnabled() {
        return this.rolloverEnabled;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.action) {
            this.configurePropertiesFromAction();
        }
    }

    public void copyObject(PFDAbstractButton toObject) {
        super.copyObject(toObject);
        toObject.setAction(this.action);
        toObject.setEnabled(this.enabled);
        toObject.setRolloverEnabled(this.rolloverEnabled);
        toObject.setActionCommand(this.actionCommand);
        toObject.setIcon(this.icon.getIcon());
        toObject.setRolloverIcon(this.rolloverIcon.getIcon());
    }
}

