/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDMultiLineToolTip;
import com.sas.graphics.components.pfd.PFDText;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

class MultiLineToolTipUI
extends BasicToolTipUI {
    static MultiLineToolTipUI sharedInstance = new MultiLineToolTipUI();
    private static PFDText pfdtext;
    private int xPadding = 3;

    public MultiLineToolTipUI() {
        pfdtext = new PFDText();
        pfdtext.setMultiline(true);
        pfdtext.setHorizontalAlignment(1);
        pfdtext.setVerticalAlignment(1);
    }

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Point loc = c.getLocation();
        Insets insets = c.getInsets();
        pfdtext.setLocation(loc.x + this.xPadding + insets.left, loc.y + insets.top);
        pfdtext.forceUpdate();
        pfdtext.paint((Graphics2D)g);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            return new Dimension(0, 0);
        }
        PFDMultiLineToolTip tip = (PFDMultiLineToolTip)c;
        pfdtext.setText(tip.getTipText());
        pfdtext.setFont(tip.getFont());
        pfdtext.setForeground(tip.getForeground());
        pfdtext.setWrapWidth(tip.getMaxWidth());
        pfdtext.forceUpdate();
        Insets insets = tip.getInsets();
        Dimension dim = pfdtext.getSize();
        dim.width += insets.left + insets.right + 2 * this.xPadding;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }
}

