/*
 * Decompiled with CFR 0.152.
 */
package MITI.stitching.nativeId;

import MITI.stitching.Stitcher;
import MITI.stitching.StitchingObject;
import MITI.stitching.StitchingObjectStatus;
import MITI.stitching.base.StitchingOptions;
import MITI.stitching.nativeId.NativeIdProcessor;
import MITI.stitching.nativeId.NativeIdStitchingObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class NativeIdStitcher<T extends StitchingObject<T>, E extends Exception>
extends Stitcher<T, E> {
    public abstract List<T> getDefaultLevelAttributes(T var1) throws E;

    protected abstract Collection<T> loadNativeIds(T var1) throws E;

    protected abstract Collection<T> loadExternalIds(T var1) throws E;

    public NativeIdStitcher(StitchingOptions stitchingOptions) {
        super(stitchingOptions);
    }

    @Override
    protected void stitchChildren(T t, T t2) throws E {
        this.match(t, t2);
        NativeIdProcessor nativeIdProcessor = NativeIdProcessor.getByName(this.getStitchingRule());
        Map<String, T> map = this.getNativeIds(t2);
        Map<String, List<T>> map2 = this.getExternalIds(t);
        for (Map.Entry<String, List<T>> entry : map2.entrySet()) {
            StitchingObject stitchingObject;
            String string = entry.getKey();
            if (nativeIdProcessor != null) {
                string = nativeIdProcessor.processNativeId(string);
            }
            if ((stitchingObject = (StitchingObject)map.get(string)) != null) {
                for (StitchingObject stitchingObject2 : entry.getValue()) {
                    for (StitchingObject stitchingObject3 : this.resolveSupplier(stitchingObject, true)) {
                        this.match(stitchingObject2, stitchingObject3);
                    }
                }
                continue;
            }
            for (StitchingObject stitchingObject2 : entry.getValue()) {
                this.warn(stitchingObject2, StitchingObjectStatus.MISSING_SUPPLIER);
            }
        }
    }

    private Map<String, T> getNativeIds(T t) throws E {
        HashMap<String, StitchingObject> hashMap = new HashMap<String, StitchingObject>();
        Collection collection = ((StitchingObject)t).getChildren();
        if (collection == null) {
            collection = this.loadNativeIds(t);
            ((StitchingObject)t).setChildren(collection);
        }
        for (StitchingObject stitchingObject : collection) {
            String string = ((NativeIdStitchingObject)((Object)stitchingObject)).getNativeId();
            if (string.isEmpty()) continue;
            hashMap.put(string, stitchingObject);
        }
        return hashMap;
    }

    private Map<String, List<T>> getExternalIds(T t) throws E {
        HashMap<String, List<T>> hashMap = new HashMap<String, List<T>>();
        Collection collection = ((StitchingObject)t).getChildren();
        if (collection == null) {
            collection = this.loadExternalIds(t);
            ((StitchingObject)t).setChildren(collection);
        }
        for (StitchingObject stitchingObject : collection) {
            String string = ((NativeIdStitchingObject)((Object)stitchingObject)).getNativeId();
            if (string.isEmpty()) continue;
            ArrayList<StitchingObject> arrayList = (ArrayList<StitchingObject>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<StitchingObject>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(stitchingObject);
        }
        return hashMap;
    }

    private Collection<T> resolveSupplier(T t, boolean bl) throws E {
        ArrayList arrayList = new ArrayList();
        if (((StitchingObject)t).isHierarchy()) {
            for (StitchingObject stitchingObject : this.getChildren(t, true)) {
                arrayList.addAll(this.resolveSupplier(stitchingObject, false));
            }
        } else if (((StitchingObject)t).isClassifier()) {
            for (StitchingObject stitchingObject : this.getDefaultLevelAttributes(t)) {
                arrayList.addAll(this.resolveSupplier(stitchingObject, false));
            }
        } else if (((StitchingObject)t).isFeature()) {
            for (StitchingObject stitchingObject : this.getReferences(t)) {
                arrayList.add(stitchingObject);
            }
        }
        if (arrayList.isEmpty() && bl) {
            arrayList.add(t);
        }
        return arrayList;
    }
}

