/*
 * Decompiled with CFR 0.152.
 */
package MITI.stitching.memory.nativeId;

import MITI.MIRException;
import MITI.lineage.links.Link;
import MITI.lineage.links.Links;
import MITI.sdk.MIRConnectionElement;
import MITI.sdk.MIRConnectionFeature;
import MITI.sdk.MIRElement;
import MITI.sdk.mix.MIRObjectCache;
import MITI.sdk.util.ObjectCollector;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.stitching.base.StitchingOptions;
import MITI.stitching.memory.nativeId.NativeIdStitchableObject;
import MITI.stitching.nativeId.NativeIdStitcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class NativeIdMemoryStitcher
extends NativeIdStitcher<NativeIdStitchableObject, MIRException> {
    private MIRObjectCache cache;
    private Links links;

    public NativeIdMemoryStitcher(MIRObjectCache mIRObjectCache, Links links, StitchingOptions stitchingOptions) {
        super(stitchingOptions);
        this.cache = mIRObjectCache;
        this.links = links;
    }

    @Override
    public String getPath(NativeIdStitchableObject nativeIdStitchableObject) throws MIRException {
        return nativeIdStitchableObject.getPath();
    }

    @Override
    public List<NativeIdStitchableObject> listChildren(NativeIdStitchableObject nativeIdStitchableObject, boolean bl) throws MIRException {
        ArrayList<NativeIdStitchableObject> arrayList = new ArrayList<NativeIdStitchableObject>();
        ObjectIdentifier objectIdentifier = this.cache.getObjectIdentifier(nativeIdStitchableObject.getObject());
        for (Link link : this.links.getLinksFromSourceObject(objectIdentifier, Collections.singleton(7))) {
            arrayList.add(new NativeIdStitchableObject(this.cache.getMirObject(link.getDestinationId())));
        }
        return arrayList;
    }

    @Override
    public List<NativeIdStitchableObject> listReferences(NativeIdStitchableObject nativeIdStitchableObject) throws MIRException {
        ArrayList<NativeIdStitchableObject> arrayList = new ArrayList<NativeIdStitchableObject>();
        ObjectIdentifier objectIdentifier = this.cache.getObjectIdentifier(nativeIdStitchableObject.getObject());
        for (Link link : this.links.getLinksFromSourceObject(objectIdentifier, Collections.singleton(20))) {
            arrayList.add(new NativeIdStitchableObject(this.cache.getMirObject(link.getDestinationId())));
        }
        return arrayList;
    }

    @Override
    public List<NativeIdStitchableObject> getDefaultLevelAttributes(NativeIdStitchableObject nativeIdStitchableObject) throws MIRException {
        ArrayList<NativeIdStitchableObject> arrayList = new ArrayList<NativeIdStitchableObject>();
        ObjectIdentifier objectIdentifier = this.cache.getObjectIdentifier(nativeIdStitchableObject.getObject());
        for (Link link : this.links.getLinksFromSourceObject(objectIdentifier, Collections.singleton(22))) {
            arrayList.add(new NativeIdStitchableObject(this.cache.getMirObject(link.getDestinationId())));
        }
        return arrayList;
    }

    @Override
    protected Collection<NativeIdStitchableObject> loadNativeIds(NativeIdStitchableObject nativeIdStitchableObject) throws MIRException {
        ArrayList<NativeIdStitchableObject> arrayList = new ArrayList<NativeIdStitchableObject>();
        ObjectCollector objectCollector = new ObjectCollector(new short[]{0});
        for (MIRElement mIRElement : objectCollector.collect(nativeIdStitchableObject.getObject())) {
            if (mIRElement.getNativeId().isEmpty()) continue;
            arrayList.add(new NativeIdStitchableObject(mIRElement));
        }
        return arrayList;
    }

    @Override
    protected Collection<NativeIdStitchableObject> loadExternalIds(NativeIdStitchableObject nativeIdStitchableObject) throws MIRException {
        ArrayList<NativeIdStitchableObject> arrayList = new ArrayList<NativeIdStitchableObject>();
        ObjectCollector objectCollector = new ObjectCollector(new short[]{317, 329});
        for (MIRElement mIRElement : objectCollector.collect(nativeIdStitchableObject.getObject())) {
            String string = "";
            if (mIRElement instanceof MIRConnectionElement) {
                string = ((MIRConnectionElement)mIRElement).getExternalId();
            } else if (mIRElement instanceof MIRConnectionFeature) {
                string = ((MIRConnectionFeature)mIRElement).getExternalId();
            }
            if (string.isEmpty()) continue;
            arrayList.add(new NativeIdStitchableObject(mIRElement));
        }
        return arrayList;
    }
}

