/*
 * Decompiled with CFR 0.152.
 */
package MITI.stitching.memory.generic;

import MITI.MIRException;
import MITI.lineage.links.Link;
import MITI.lineage.links.Links;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperation;
import MITI.sdk.MIRSynonym;
import MITI.sdk.mix.MIRObjectCache;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.stitching.base.StitchingOptions;
import MITI.stitching.generic.GenericStitcher;
import MITI.stitching.memory.generic.GenericStitchableObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GenericMemoryStitcher
extends GenericStitcher<GenericStitchableObject, MIRException> {
    private MIRObjectCache cache;
    private Links links;

    public GenericMemoryStitcher(MIRObjectCache mIRObjectCache, Links links, StitchingOptions stitchingOptions) {
        super(stitchingOptions);
        this.cache = mIRObjectCache;
        this.links = links;
    }

    @Override
    public String getPath(GenericStitchableObject genericStitchableObject) throws MIRException {
        return genericStitchableObject.getPath();
    }

    @Override
    public List<GenericStitchableObject> listChildren(GenericStitchableObject genericStitchableObject, boolean bl) throws MIRException {
        ArrayList<GenericStitchableObject> arrayList = new ArrayList<GenericStitchableObject>();
        ObjectIdentifier objectIdentifier = this.cache.getObjectIdentifier(genericStitchableObject.getObject());
        for (Link link : this.links.getLinksFromSourceObject(objectIdentifier, Collections.singleton(7))) {
            MIRObject mIRObject = this.cache.getMirObject(link.getDestinationId());
            if (mIRObject instanceof MIROperation) {
                for (Link link2 : this.links.getLinksFromSourceObject(link.getDestinationId(), Collections.singleton(7))) {
                    arrayList.add(new GenericStitchableObject(this.cache.getMirObject(link2.getDestinationId())));
                }
                continue;
            }
            arrayList.add(new GenericStitchableObject(mIRObject));
        }
        return arrayList;
    }

    @Override
    public List<GenericStitchableObject> listReferences(GenericStitchableObject genericStitchableObject) throws MIRException {
        ArrayList<GenericStitchableObject> arrayList = new ArrayList<GenericStitchableObject>();
        ObjectIdentifier objectIdentifier = this.cache.getObjectIdentifier(genericStitchableObject.getObject());
        for (Link link : this.links.getLinksFromSourceObject(objectIdentifier, Collections.singleton(20))) {
            arrayList.add(new GenericStitchableObject(this.cache.getMirObject(link.getDestinationId())));
        }
        return arrayList;
    }

    @Override
    public GenericStitchableObject getResolvedSynonym(GenericStitchableObject genericStitchableObject) throws MIRException {
        MIRObject mIRObject = genericStitchableObject.getObject();
        while (mIRObject instanceof MIRSynonym) {
            mIRObject = ((MIRSynonym)mIRObject).getParent();
        }
        return new GenericStitchableObject(mIRObject);
    }
}

