/*
 * Decompiled with CFR 0.152.
 */
package MITI.lineage.links;

import MITI.expression.util.Util;
import MITI.messages.MIRBridgeConstants.MBLST;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRSQLViewEntity;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.util.ObjectCollector;
import MITI.util.text.BridgeSpecificationLiteral;
import java.util.Set;
import java.util.TreeSet;

public class UpdatableViewDetector {
    public static Set<MIRSQLViewEntity> list(MIRModel mIRModel) {
        TreeSet<MIRSQLViewEntity> treeSet = new TreeSet<MIRSQLViewEntity>();
        if (UpdatableViewDetector.isDatabaseModel(mIRModel)) {
            TreeSet<MIRSQLViewEntity> treeSet2 = new TreeSet<MIRSQLViewEntity>();
            ObjectCollector objectCollector = new ObjectCollector(new short[]{25});
            for (MIRSQLViewEntity mIRSQLViewEntity : objectCollector.collect(mIRModel)) {
                UpdatableViewDetector.processView(mIRSQLViewEntity, treeSet2, treeSet);
            }
        }
        return treeSet;
    }

    private static boolean isDatabaseModel(MIRModel mIRModel) {
        MIRStoreModel mIRStoreModel;
        if (mIRModel != null && mIRModel instanceof MIRStoreModel && (mIRStoreModel = (MIRStoreModel)mIRModel).getStoreType() == 0) {
            BridgeSpecificationLiteral bridgeSpecificationLiteral;
            if (mIRStoreModel.getSystemType().equals("DENODO") || mIRStoreModel.getSystemType().equals("SAP HANA")) {
                return false;
            }
            MIRMetadataOrigin mIRMetadataOrigin = mIRStoreModel.getMetadataOrigin();
            String string = mIRMetadataOrigin.getBridgeName().split(";")[0];
            if (string.endsWith("Import")) {
                string = string.substring(0, string.length() - 6);
            }
            if ((bridgeSpecificationLiteral = MBLST.getBridgeSpecification(string, false)) != null && bridgeSpecificationLiteral.getBridge_Direction().equals("Import") && bridgeSpecificationLiteral.getMethodology_ToolCategory().equals("Relational Database") && bridgeSpecificationLiteral.getBridge_Id().equals(string)) {
                return true;
            }
        }
        return false;
    }

    private static void processView(MIRSQLViewEntity mIRSQLViewEntity, TreeSet<MIRSQLViewEntity> treeSet, TreeSet<MIRSQLViewEntity> treeSet2) {
        MIRExpression mIRExpression;
        if (treeSet.contains(mIRSQLViewEntity)) {
            return;
        }
        treeSet.add(mIRSQLViewEntity);
        MIRClassifierMap mIRClassifierMap = mIRSQLViewEntity.getDestinationOfClassifierMap();
        if (mIRClassifierMap == null || mIRClassifierMap.getSourceClassifierCount() != 1) {
            return;
        }
        MIRClassifier mIRClassifier = mIRClassifierMap.getSourceClassifiers().first();
        if (mIRClassifier instanceof MIRSQLViewEntity) {
            UpdatableViewDetector.processView((MIRSQLViewEntity)mIRClassifier, treeSet, treeSet2);
            if (!treeSet2.contains(mIRClassifier)) {
                return;
            }
        }
        if ((mIRExpression = mIRClassifierMap.getExpression()) != null ? !UpdatableViewDetector.isSimpleViewEntity(mIRExpression) : !mIRClassifierMap.getOperation().isEmpty()) {
            return;
        }
        for (MIRFeature mIRFeature : mIRSQLViewEntity.getFeatures()) {
            if (mIRFeature.getElementType() != 26 || UpdatableViewDetector.processViewAttribute(mIRFeature)) continue;
            return;
        }
        treeSet2.add(mIRSQLViewEntity);
    }

    private static boolean isSimpleViewEntity(MIRExpression mIRExpression) {
        if (mIRExpression == null || mIRExpression.getStatementNodeCount() != 1) {
            return false;
        }
        int n = 0;
        ObjectCollector objectCollector = new ObjectCollector(new short[]{113});
        for (MIRExpressionNode mIRExpressionNode : objectCollector.collect(mIRExpression)) {
            if (mIRExpressionNode.getElementType() == 134) {
                int n2 = ((MIRStatementNode)mIRExpressionNode).getStatementType();
                if (n2 == 5) continue;
                if (n2 == 1) {
                    if (++n <= 1) continue;
                    return false;
                }
                return false;
            }
            if (mIRExpressionNode.getElementType() == 115 || mIRExpressionNode.getElementType() != 107 || !mIRExpressionNode.getName().equals("GROUP BY")) continue;
            return false;
        }
        return true;
    }

    private static boolean processViewAttribute(MIRFeature mIRFeature) {
        MIRFeatureMap mIRFeatureMap = mIRFeature.getDestinationOfFeatureMap();
        if (mIRFeatureMap != null && mIRFeatureMap.getSourceFeatureCount() == 1 && mIRFeatureMap.getControlFeatureCount() == 0) {
            MIRExpression mIRExpression = mIRFeatureMap.getExpression();
            if (mIRExpression != null) {
                return UpdatableViewDetector.isSimpleViewAttribute(mIRExpression);
            }
            return mIRFeatureMap.getOperation().isEmpty();
        }
        return false;
    }

    private static boolean isSimpleViewAttribute(MIRExpression mIRExpression) {
        if (mIRExpression == null || mIRExpression.getStatementNodeCount() != 1) {
            return false;
        }
        MIRStatementNode mIRStatementNode = mIRExpression.getStatementNodes().first();
        MIRExpressionNode mIRExpressionNode = null;
        if (mIRStatementNode.getStatementType() == 4 && mIRStatementNode.getReferencedExpressionNodeCount() == 1) {
            mIRExpressionNode = Util.getRefNode(mIRStatementNode.getReferencedExpressionNodes().first());
        } else if (mIRStatementNode.getStatementType() == 0 && mIRStatementNode.getExpressionNodeCount() == 1) {
            mIRExpressionNode = mIRStatementNode.getExpressionNodes().first();
        }
        if (mIRExpressionNode != null) {
            ObjectCollector objectCollector = new ObjectCollector(new short[]{113});
            for (MIRExpressionNode mIRExpressionNode2 : objectCollector.collect(mIRExpressionNode)) {
                if (mIRExpressionNode2.getElementType() == 111 || mIRExpressionNode2.getElementType() == 115 || mIRExpressionNode2.getElementType() == 104) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

