/*
 * Decompiled with CFR 0.152.
 */
package MITI.lineage.links;

import MITI.lineage.links.Link;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;

public class Links {
    private TreeMap<Integer, ModelLinks> modelLinks = new TreeMap();

    public void addLinks(Links links) {
        for (ModelLinks modelLinks : links.modelLinks.values()) {
            for (TreeSet treeSet : modelLinks.fromSource.values()) {
                for (Link link : treeSet) {
                    this.addLink(link);
                }
            }
        }
    }

    public void addLink(Link link) {
        TreeSet<Link> treeSet;
        ObjectIdentifier objectIdentifier = link.getSourceId();
        ModelLinks modelLinks = this.modelLinks.get(objectIdentifier.getModelId());
        if (modelLinks == null) {
            modelLinks = new ModelLinks();
            this.modelLinks.put(objectIdentifier.getModelId(), modelLinks);
        }
        if ((treeSet = (TreeSet<Link>)modelLinks.fromSource.get(link.getSourceId())) == null) {
            treeSet = new TreeSet<Link>();
            modelLinks.fromSource.put(link.getSourceId(), treeSet);
        }
        treeSet.add(link);
        ObjectIdentifier objectIdentifier2 = link.getDestinationId();
        modelLinks = this.modelLinks.get(objectIdentifier2.getModelId());
        if (modelLinks == null) {
            modelLinks = new ModelLinks();
            this.modelLinks.put(objectIdentifier2.getModelId(), modelLinks);
        }
        if ((treeSet = (TreeSet<Link>)modelLinks.toDestination.get(link.getDestinationId())) == null) {
            treeSet = new TreeSet<Link>();
            modelLinks.toDestination.put(link.getDestinationId(), treeSet);
        }
        treeSet.add(link);
    }

    public List<Link> getLinksFromSourceObject(ObjectIdentifier objectIdentifier, Collection<Integer> collection) {
        TreeSet treeSet;
        ArrayList<Link> arrayList = new ArrayList<Link>();
        ModelLinks modelLinks = this.modelLinks.get(objectIdentifier.getModelId());
        if (modelLinks != null && (treeSet = (TreeSet)modelLinks.fromSource.get(objectIdentifier)) != null) {
            if (collection == null) {
                arrayList.addAll(treeSet);
            } else {
                for (Link link : treeSet) {
                    if (!collection.contains(link.getType())) continue;
                    arrayList.add(link);
                }
            }
        }
        return arrayList;
    }

    public List<Link> getLinksToDestinationObject(ObjectIdentifier objectIdentifier, Collection<Integer> collection) {
        TreeSet treeSet;
        ArrayList<Link> arrayList = new ArrayList<Link>();
        ModelLinks modelLinks = this.modelLinks.get(objectIdentifier.getModelId());
        if (modelLinks != null && (treeSet = (TreeSet)modelLinks.toDestination.get(objectIdentifier)) != null) {
            if (collection == null) {
                arrayList.addAll(treeSet);
            } else {
                for (Link link : treeSet) {
                    if (!collection.contains(link.getType())) continue;
                    arrayList.add(link);
                }
            }
        }
        return arrayList;
    }

    public ObjectIdentifier getParentId(ObjectIdentifier objectIdentifier) {
        TreeSet treeSet;
        ModelLinks modelLinks = this.modelLinks.get(objectIdentifier.getModelId());
        if (modelLinks != null && (treeSet = (TreeSet)modelLinks.toDestination.get(objectIdentifier)) != null) {
            for (Link link : (TreeSet)modelLinks.toDestination.get(objectIdentifier)) {
                if (link.getType() != 7) continue;
                return link.getSourceId();
            }
        }
        return null;
    }

    public void getAllLinks(Collection<Link> collection) {
        for (ModelLinks modelLinks : this.modelLinks.values()) {
            for (TreeSet treeSet : modelLinks.fromSource.values()) {
                collection.addAll(treeSet);
            }
        }
    }

    class ModelLinks {
        int modelId;
        private TreeMap<ObjectIdentifier, TreeSet<Link>> fromSource = new TreeMap();
        private TreeMap<ObjectIdentifier, TreeSet<Link>> toDestination = new TreeMap();

        ModelLinks() {
        }
    }
}

