/*
 * Decompiled with CFR 0.152.
 */
package MITI.lineage.links;

import MITI.server.services.common.mir.ObjectIdentifier;

public class Link
implements Comparable<Link> {
    public static final int UNDEFINED_FLOW = -1;
    public static final int PASS_THROUGH_DATA_FLOW = 0;
    public static final int EXPRESSION_DATA_FLOW = 14;
    public static final int BULK_DATA_FLOW = 24;
    public static final int SUMMARY_PASS_THROUGH_DATA_FLOW = 12;
    public static final int SUMMARY_EXPRESSION_DATA_FLOW = 15;
    public static final int SUMMARY_BULK_DATA_FLOW = 25;
    public static final int ROW_CONTROL_FLOW = 2;
    public static final int COLUMN_CONTROL_FLOW = 16;
    public static final int SUMMARY_ROW_CONTROL_FLOW = 13;
    public static final int SUMMARY_COLUMN_CONTROL_FLOW = 17;
    public static final int SEMANTIC_FLOW = 1;
    public static final int DOMAIN_FLOW = 8;
    public static final int ACTIVITY_FLOW = 3;
    public static final int CONNECTION_FLOW = 4;
    public static final int TRANSFORMATION_FLOW = 23;
    public static final int CLIENT_TO_SUPPLIER_FLOW = 5;
    public static final int SUPPLIER_TO_CLIENT_FLOW = 6;
    public static final int DATA_QUALITY_FLOW = 9;
    public static final int JOIN_FLOW = 11;
    public static final int __PARENT_CHILD_FLOW = 7;
    public static final int __REFERENCE = 20;
    public static final int __SYNONYM = 21;
    public static final int __DEFAULT_LEVEL_ATTRIBUTE = 22;
    private ObjectIdentifier sourceId = null;
    private ObjectIdentifier destinationId = null;
    private ObjectIdentifier linkId = null;
    private static final int[] MERGING_LINK_RANKS = new int[]{15, 25, 12, 17, 14, 24, 0, 16, 1, 13, 2, 4, 3, 11};
    private int type = 0;

    public static int _getLinkMergingRank(int n) {
        for (int i = 0; i < MERGING_LINK_RANKS.length; ++i) {
            if (MERGING_LINK_RANKS[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static boolean isDataFlow(int n) {
        return n == 0 || n == 14 || n == 24 || n == 2 || n == 16 || n == 12 || n == 15 || n == 25 || n == 13 || n == 17;
    }

    public static boolean isControlFlow(int n) {
        return n == 2 || n == 16 || n == 13;
    }

    public static boolean isStitchingFlow(int n) {
        return n == 5 || n == 6;
    }

    public static boolean isSummaryFlow(int n) {
        return n == 12 || n == 15 || n == 25 || n == 13 || n == 17;
    }

    public boolean isAggregation() {
        return this.type == 7 || this.type == 20 || this.type == 22 || this.type == 21;
    }

    public Link(ObjectIdentifier objectIdentifier, ObjectIdentifier objectIdentifier2, ObjectIdentifier objectIdentifier3, int n) {
        this.sourceId = objectIdentifier;
        this.destinationId = objectIdentifier2;
        this.linkId = objectIdentifier3;
        this.type = n;
    }

    public Link(ObjectIdentifier objectIdentifier, byte by) {
        this.sourceId = objectIdentifier;
        this.destinationId = objectIdentifier;
        this.linkId = objectIdentifier;
        this.type = by;
    }

    public boolean equals(Object object) {
        if (object instanceof Link) {
            Link link = (Link)object;
            return link.sourceId.equals(this.sourceId) && link.destinationId.equals(this.destinationId) && link.linkId.equals(this.linkId) && link.type == this.type;
        }
        return false;
    }

    public int hashCode() {
        return this.sourceId.hashCode() ^ this.destinationId.hashCode() ^ this.linkId.hashCode() ^ this.type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.sourceId.toString()).append("-->").append(this.destinationId.toString()).append(" (").append(this.linkId.toString()).append(") [").append(this.type).append("]");
        return stringBuffer.toString();
    }

    @Override
    public int compareTo(Link link) {
        int n = this.linkId.compareTo(link.linkId);
        if (n != 0) {
            return n;
        }
        n = this.sourceId.compareTo(link.sourceId);
        if (n != 0) {
            return n;
        }
        n = this.destinationId.compareTo(link.destinationId);
        if (n != 0) {
            return n;
        }
        if (this.type < link.type) {
            return -1;
        }
        if (this.type > link.type) {
            return 1;
        }
        return 0;
    }

    public ObjectIdentifier getSourceId() {
        return this.sourceId;
    }

    public ObjectIdentifier getDestinationId() {
        return this.destinationId;
    }

    public ObjectIdentifier getLinkId() {
        return this.linkId;
    }

    public int getType() {
        return this.type;
    }
}

