/*
 * Decompiled with CFR 0.152.
 */
package MITI.lineage.links;

import MITI.bridges.profiles.ProfileIds;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRReportField;
import MITI.sdk.MIRReportItem;
import MITI.sdk.MIRStoreModel;

public class LineageUtil {
    public static boolean isHierarchialModel(MIRModel mIRModel) {
        if (mIRModel instanceof MIRStoreModel) {
            MIRStoreModel mIRStoreModel = (MIRStoreModel)mIRModel;
            return mIRStoreModel.getStoreType() == 2 || mIRStoreModel.getStoreType() == 0 && LineageUtil.isHierarchialDatabase(mIRStoreModel.getSystemType());
        }
        return false;
    }

    private static boolean isHierarchialDatabase(String string) {
        return "GOOGLE BIGQUERY".equals(string) || "HIVE".equals(string);
    }

    private static boolean isHierarchialProfile(int n) {
        return n == ProfileIds.FILE_SYSTEM__JSON_FILE || n == ProfileIds.GRAPHQL__SCHEMA || n == ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE;
    }

    public static boolean isHierarchicalFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null) {
            MIRModel mIRModel = mIRFeature.getRootModel();
            return LineageUtil.isHierarchialModel(mIRModel) && LineageUtil.isHierarchialProfile(mIRModel.getMetadataOrigin().getProfileId());
        }
        return false;
    }

    public static boolean isHeaderReportField(MIRReportField mIRReportField) {
        MIRReportItem mIRReportItem = mIRReportField.getParentReportItem();
        return mIRReportItem != null && mIRReportItem.getNativeType().contains("Title");
    }

    public static MIRObject getReportItemParent(MIRObject mIRObject) {
        mIRObject = mIRObject.getParent();
        while (mIRObject.isInstanceOf((short)131)) {
            mIRObject = mIRObject.getParent();
        }
        if (mIRObject.isInstanceOf((short)124)) {
            return mIRObject;
        }
        return mIRObject.getRootModel();
    }
}

