/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.baseinteg;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.MonthType;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.StringType;
import com.sas.datatypes.WeekType;
import com.sas.datatypes.YearType;
import com.sas.entities.AttributeDescriptor;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeType;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.Entity;
import com.sas.entities.EntityInterface;
import com.sas.iom.SASIOMDefs.VariableArray2dOfAnyHolder;
import com.sas.iquery.baseinteg.BaseIntegResourceBundle;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.dataservices.IQDataServicesFactory;
import com.sas.iquery.metadata.Cardinality;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.AssociationMatrix;
import com.sas.iquery.metadata.business.AssociationRule;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessRule;
import com.sas.iquery.metadata.business.CopyFromInterface;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.DrillThroughToDetail;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.FilterSet;
import com.sas.iquery.metadata.business.FilterSetMember;
import com.sas.iquery.metadata.business.FilterSetRuleItems;
import com.sas.iquery.metadata.business.FilterSetRulesContainer;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.InformationMapFactory;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.JoinType;
import com.sas.iquery.metadata.business.JoinTypeList;
import com.sas.iquery.metadata.business.Lookup;
import com.sas.iquery.metadata.business.LookupByDataItem;
import com.sas.iquery.metadata.business.LookupList;
import com.sas.iquery.metadata.business.LookupNotAllowed;
import com.sas.iquery.metadata.business.LookupValue;
import com.sas.iquery.metadata.business.MapFolder;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.RequiredDataSources;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.RunStoredProcess;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.impl.InformationMapImpl2;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.OLAPStringExpressionUtil;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifier;
import com.sas.iquery.metadata.expr.relational.ConditionalExpressionAdapter;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.OMRBriefInformationMap;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.CalculatedMember;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.JFSResourceFactory;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.Member;
import com.sas.iquery.metadata.physical.NamedSet;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.OlapServer;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SASOlapServer;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.StoredProcess;
import com.sas.iquery.metadata.physical.oma.OMAMeasure;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.metadata.serverprop.formats.SASFormatAttributes;
import com.sas.iquery.metadata.serverprop.formats.SASFormatCategory;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescription;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptionUtil;
import com.sas.iquery.metadata.serverprop.formats.SASFormatException;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.PersistenceUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.meta.SASOMI.ISecurityAdminHelper;
import com.sas.metadata.promotion.BatchExporter;
import com.sas.metadata.promotion.BatchImporter;
import com.sas.metadata.remote.AccessControlEntry;
import com.sas.metadata.remote.AccessControlTemplate;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Permission;
import com.sas.metadata.remote.PermissionCondition;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.models.OLAPMemberName;
import com.sas.prompts.definitions.DateDefinition;
import com.sas.prompts.definitions.DoubleDefinition;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.definitions.remote.OLAPMemberNameDefinition;
import com.sas.prompts.valueprovider.dynamic.iq.RelationalDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider;
import com.sas.report.config.MetadataSourceDef;
import com.sas.report.config.StartPFS;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.services.information.metadata.OMRPhysicalTable;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.search.PublicTypeFilter;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SectionedPropertyList;
import com.sas.storage.editableproperties.SectionedPropertyMap;
import com.sas.storage.iquery.IQUeryUtil;
import com.sas.storage.simplesqlmodel.ColumnInfo;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.util.BaseStringComparator;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.ValueItem;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.fs.ServicesLogFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.omg.CORBA.Any;

public class ProcInfoMaps {
    private SessionContextInterface _session;
    private IntelligentQueryMetadataServiceInterface _service;
    private String _mapName;
    private String _customRepos = null;
    private ServerInterface _server;
    private String _mapPath = "/";
    private FolderInterface _folder;
    private InformationMap _map = null;
    private boolean _isRelational;
    private Properties _options;
    private boolean _createTargetFolder = false;
    private boolean _MLS_Id = false;
    private boolean _hasDataSource;
    private boolean _noVerify = false;
    private boolean _updateMap = false;
    private boolean _autoReplaceMap = false;
    private boolean _drillThrough = true;
    private ServerProperties _serverProperties = null;
    private IQDataServices _dataServices = null;
    private MetadataSourceDef _srcDef = null;
    private DataSourceCube _cube = null;
    private Map<String, String> _AggFunctionsMap = null;
    private static final String SBIP = "SBIP://";
    public static final String SLASH = "/";
    private static final String _mapNotExistMsg = "ProcInfoMaps.MapNotExist.txt";
    private static final String _invalidFolderMsg = "ProcInfoMaps.InvalidFolder.fmt.txt";
    private static final String _briefIMapText = "BriefInformationMap";
    private static final String _folderType = "(Folder)";
    private static final String _MVA_WarningFormatCode = "%2z";
    private static final String _MVA_NoteFormatCode = "%3z";
    private static final String _MVA_NewLineFormatCode = "%n";
    private static final String LOCALIZABLE_FILE_EXTENSION = ".locprop";
    private static final String[] JOIN_TYPES = new String[]{"NONE", "INNER", "LEFT", "RIGHT", "FULL"};
    private static final String[] CARDINALITY = new String[]{"", "ONE_TO_ONE", "ONE_TO_MANY", "MANY_TO_ONE", "MANY_TO_MANY", "UNKNOWN"};
    private static List<?> _SASIdentityPromptDefs = null;
    private static final String YES_VAL = "YES";
    private static final String NO_VAL = "NO";
    private static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
    static final Comparator MAPNAME_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            int result = 0;
            if (o1 == null) {
                result = o2 == null ? 0 : -1;
            } else if (o2 == null) {
                result = 1;
            } else {
                try {
                    String o1string = ((BriefInformationMap)o1).getName();
                    String o2string = ((BriefInformationMap)o2).getName();
                    result = o1string.compareToIgnoreCase(o2string);
                }
                catch (Exception e) {
                    _infoLogger.info("RemoteException from ProcInfoMaps:Comparator:Compare:getName");
                }
            }
            return result;
        }
    };
    public static final int JOIN_TYPE_NONE = 0;
    public static final int JOIN_TYPE_INNER = 1;
    public static final int JOIN_TYPE_LEFT = 2;
    public static final int JOIN_TYPE_RIGHT = 3;
    public static final int JOIN_TYPE_FULL = 4;
    public static final int JOIN_TYPE_CROSS = 5;
    public static final int RELATION_TYPE_NONE = 0;
    public static final int RELATION_TYPE_AND = 1;
    public static final int RELATION_TYPE_OR = 2;
    public static final int DEFAULT_PROPERTY = 0;
    public static final int SET_PROPERTY = 1;
    public static final int RESET_PROPERTY = 2;
    public static final int LIST_DEFAULT = 0;
    public static final int LIST_DATAITEMS = 1;
    public static final int LIST_FILTERS = 2;
    public static final int LIST_DATASOURCES = 4;
    public static final int LIST_RELATIONSHIPS = 5;
    public static final int NOT_SET = 0;
    public static final int ONE_TO_ONE = 1;
    public static final int ONE_TO_MANY = 2;
    public static final int MANY_TO_ONE = 3;
    public static final int MANY_TO_MANY = 4;
    public static final int UNKNOWN = 5;
    public static final int SELECT_ALL_FUNCTIONS = 1;
    public static final int REPLACE_FUNCTIONS = 2;
    public static final int ADD_FUNCTIONS = 4;
    public static final int REMOVE_FUNCTIONS = 8;
    public static final int CLEAR_LIST = 1;
    public static final int REPLACE_LIST = 2;
    public static final int ADD_TO_LIST = 4;
    public static final int REMOVE_LIST = 8;
    public static final int SELECT_ALL_TABLES = 16;
    public static final int GRANT = 1;
    public static final int DENY = 2;
    public static final int REMOVE = 3;
    public static final int READMETADATA = 0;
    public static final int WRITEMETADATA = 1;
    public static final int READ = 2;
    public static final String SQ = "\"";
    public static final String NA = "\"N/A\"";
    public static final String LOGON = "Logon";
    public static final String LOGOFF = "Logoff";
    public static final String SUCCESS = "Success";
    public static final String FAILED = "Failed";
    private static final Logger _infoLogger = LogManager.getLogger(ProcInfoMaps.class);
    private static final Logger _auditLogger = LogManager.getLogger((String)"com.sas.iquery.audit");
    private static final int KEYACTIONS_DELETE_ID = 5;
    private static final int KEYACTIONS_LOGONSUCCESS_ID = 0;
    private static final int KEYACTIONS_LOGONFAILED_ID = 1;
    private static final int KEYACTIONS_LOGOFF_ID = 2;
    private static final int KEYACTIONS_CLOSE_ID = 14;
    private static final int SINGLE_SELECTION = 1;
    private static final int MULTIPLE_SELECTION = 2;
    private static final int MULTIPLE_ORDERED_SELECTION = 3;
    private Locale _computationalLocale = null;

    public ProcInfoMaps(SessionContextInterface session, String reposName) throws Exception {
        this._session = session;
        this._service = IntelligentQueryMetadataServiceFactory.newService();
        this._dataServices = IQDataServicesFactory.newService();
        this._server = session.getUserContext().getAuthServer();
    }

    public ProcInfoMaps(String[] stringParms, boolean sspiEnabled) throws Exception {
        this(stringParms[0], stringParms[1], stringParms[2], stringParms[3], stringParms[4], stringParms[5], stringParms[6], stringParms[7], stringParms[8], stringParms[9], sspiEnabled);
    }

    private ProcInfoMaps(String host, String port, String reposName, String user, String pwd, String authDomain, String SasLocale, String securityPackage, String securityPackageList, String spn, boolean sspiEnabled) throws Exception {
        String MLS_IdOption;
        _infoLogger.info("ProcInfoMaps beings to make a connection.");
        Locale locale = IOMServerUtils.ConvertSASLocaleToJavaLocale((String)SasLocale);
        if (locale != null) {
            this.setComputationalLocale(locale);
        }
        String component = StartPFS.getDefaultSoftwareComponentName();
        if (authDomain == null) {
            authDomain = "DefaultAuth";
        }
        if ((MLS_IdOption = System.getProperty("ProcInfoMaps.MLS_ID")) != null && MLS_IdOption.equalsIgnoreCase(YES_VAL)) {
            this._MLS_Id = true;
        }
        this._srcDef = StartPFS.getMetadataSourceDef((String)host, (String)port, null, (String)authDomain);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("holdopenconnection", "true");
        if (sspiEnabled) {
            properties.put("idpropagation", "sspi");
            if (securityPackage != null) {
                properties.put("securityPackage", securityPackage);
            }
            if (securityPackageList != null) {
                properties.put("securityPackageList", securityPackageList);
            }
            if (spn != null) {
                properties.put("sspispn", spn);
            }
        }
        ThreadContext.put((String)"action", (String)LOGON);
        ThreadContext.put((String)"transID", (String)NA);
        ThreadContext.put((String)"folder", (String)NA);
        ThreadContext.put((String)"map", (String)NA);
        this._session = StartPFS.openConnection((MetadataSourceDef)this._srcDef, (String)component, (String)user, (String)pwd, properties);
        if (this._session == null) {
            ThreadContext.put((String)"actionID", (String)String.valueOf(1));
            ThreadContext.put((String)"actionType", (String)FAILED);
            ThreadContext.put((String)"sessionID", (String)NA);
            ThreadContext.put((String)"user", (String)user);
            _auditLogger.info("");
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.Connect.Exception.fmt.txt", host);
            throw new MetadataException(errorMsg);
        }
        ThreadContext.put((String)"actionID", (String)String.valueOf(0));
        ThreadContext.put((String)"actionType", (String)SUCCESS);
        ThreadContext.put((String)"sessionID", (String)this._session.getEntityKey());
        ThreadContext.put((String)"user", (String)this._session.getUserContext().getResolvedUserId());
        if (locale != null) {
            LocaleUtilities.SetDefaultViewerLocale((SessionContextInterface)this._session, (Locale)locale);
        }
        _infoLogger.info("ProcInfoMaps on return from making a connection.");
        _auditLogger.info("");
        this._service = IntelligentQueryMetadataServiceFactory.newService();
        if (reposName != null && reposName.trim().length() != 0) {
            this._customRepos = SLASH + reposName;
        }
        this._dataServices = IQDataServicesFactory.newService();
        this._server = this._session.getUserContext().getAuthServer();
        ThreadContext.put((String)"Host name: ", (String)this._server.getHost());
    }

    public InformationMap getMap() {
        return this._map;
    }

    public String getConnectionServerName() throws ServiceException, RemoteException {
        return this._server.getHost();
    }

    public Object[] newMap(String[] stringParms, String[] customProperties, boolean[] booleanParms) throws Exception {
        String[] retInfo2;
        this.checkStringArraySize(stringParms, 4);
        this.checkBooleanArraySize(booleanParms, 9);
        String mapPath = stringParms[0];
        String mapName = stringParms[1];
        String description = stringParms[2];
        String dataLocale = stringParms[3];
        _infoLogger.info("In newMap() method.");
        boolean create_folder = booleanParms[5];
        boolean autoReplace = booleanParms[6];
        boolean MFT = booleanParms[7];
        this._drillThrough = booleanParms[8];
        this._mapName = mapName;
        this._autoReplaceMap = autoReplace;
        this._mapPath = mapPath = this.getRelativePath(mapPath);
        this._folder = this.getMetadataInterface(mapPath, create_folder);
        BriefInformationMap briefMap = (BriefInformationMap)this._folder.getItemByType(mapName, _briefIMapText);
        if (briefMap != null && !autoReplace) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MapExistsError.fmt.txt", mapName, mapPath);
            throw new MetadataException(errorMsg);
        }
        Locale computationalLocale = dataLocale != null && !dataLocale.isEmpty() ? IOMServerUtils.ConvertSASLocaleToJavaLocale((String)dataLocale) : this.getComputationalLocale();
        this._map = this._service.newInformationMap(this._session, computationalLocale);
        this._computationalLocale = computationalLocale;
        this._map.setLabel(mapName);
        this._map.setID("root");
        this._isRelational = false;
        this._hasDataSource = false;
        MapFolder rootFolder = this._map.getRootMapFolder();
        rootFolder.setLabel(mapName);
        MessageFormatter rootFolderDesc = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.RootFolderDescription.txt", new Object[0]);
        rootFolder.setDescription(rootFolderDesc.toString());
        this._updateMap = false;
        int action = customProperties == null ? 0 : 2;
        Object[] retInfo = this.setMap(mapName, description, booleanParms, action, customProperties, null);
        if (MFT && (retInfo2 = this.addAssociationRule(null, null, null, null))[0] != null) {
            retInfo[0] = retInfo[0] == null ? retInfo2[0] : (String)retInfo[0] + retInfo2[0];
        }
        _infoLogger.info("On return from newMap() method.");
        return retInfo;
    }

    public Object[] openMap(String[] stringArray, boolean[] booleanArray, int[] intArray, String[][] objectArray) throws Exception {
        String[] retInfo2;
        String message;
        boolean isUpdate;
        this.checkStringArraySize(stringArray, 4);
        this.checkBooleanArraySize(booleanArray, 7);
        this.checkIntArraySize(intArray, 4);
        this.checkObjectArraySize((Object[])objectArray, 4);
        String mapPath = stringArray[0];
        String mapName = stringArray[1];
        String description = stringArray[2];
        String dataLocale = stringArray[3];
        int actionOnCustomProperties = intArray[0];
        int actionsOnRequiredTables = intArray[1];
        int joinModel = intArray[2];
        int drillThroughOpt = intArray[3];
        String[] customProperties = objectArray[0];
        String[] propertiesToDelete = objectArray[1];
        String[] requiredTablesToAdd = objectArray[2];
        String[] requiredTablesToRemove = objectArray[3];
        _infoLogger.info("In openMap() method.");
        this._mapName = mapName;
        boolean create_folder = booleanArray[5];
        this._updateMap = isUpdate = booleanArray[6];
        this._mapPath = mapPath = this.getRelativePath(mapPath);
        this._folder = this.getMetadataInterface(mapPath, create_folder);
        Locale newLocale = null;
        if (dataLocale != null && !dataLocale.isEmpty()) {
            newLocale = IOMServerUtils.ConvertSASLocaleToJavaLocale((String)dataLocale);
        }
        BriefInformationMap briefMap = (BriefInformationMap)this._folder.getItemByType(mapName, _briefIMapText);
        String localeWarning = null;
        if (briefMap != null) {
            this._map = InformationMapFactory.getInstance().newInformationMap(this._session, this._service, briefMap);
            this._computationalLocale = this._map.getComputationalLocale();
            this.checkDataSource();
            if (newLocale != null && newLocale != this._computationalLocale) {
                MessageFormatter messageString = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.changeComputationalLocale.fmt.txt", newLocale, this._computationalLocale);
                localeWarning = _MVA_WarningFormatCode + messageString + _MVA_NewLineFormatCode;
            }
        } else {
            if (isUpdate) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MapNotExistsError.fmt.txt", mapName, mapPath);
                throw new MetadataException(errorMsg);
            }
            this._map = this._service.newInformationMap(this._session, newLocale != null ? newLocale : this.getComputationalLocale());
            this._map.setLabel(mapName);
            this._map.setID("root");
            this._isRelational = false;
            this._hasDataSource = false;
            MapFolder rootFolder = this._map.getRootMapFolder();
            rootFolder.setLabel(mapName);
            MessageFormatter rootFolderDesc = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.RootFolderDescription.txt", new Object[0]);
            rootFolder.setDescription(rootFolderDesc.toString());
        }
        if (newLocale != null) {
            this.setComputationalLocale(newLocale);
        }
        Object[] retInfo = this.setMap(mapName, description, booleanArray, actionOnCustomProperties, customProperties, propertiesToDelete);
        if (localeWarning != null) {
            Object object = retInfo[0] = retInfo[0] == null ? localeWarning : ((String)retInfo[0]).concat(localeWarning);
        }
        if (actionsOnRequiredTables > 0 && (message = this.editRequiredTables(actionsOnRequiredTables, requiredTablesToAdd, requiredTablesToRemove)) != null) {
            retInfo[0] = retInfo[0] == null ? message : ((String)retInfo[0]).concat(message);
        }
        List associationRules = this._map.getObjects(false, AssociationRule.class);
        if (joinModel == 1) {
            if (associationRules.size() != 0) {
                AssociationRule associationRule = (AssociationRule)associationRules.get(0);
                this._map.removeBusinessRule((BusinessRule)associationRule);
            }
        } else if (joinModel == 2 && (associationRules == null || associationRules.size() == 0) && (retInfo2 = this.addAssociationRule(null, null, null, null))[0] != null) {
            Object object = retInfo[0] = retInfo[0] == null ? retInfo2[0] : ((String)retInfo[0]).concat(retInfo2[0]);
        }
        if (drillThroughOpt != 0) {
            this.setDrillThrough(drillThroughOpt);
        }
        _infoLogger.info("On return from openMap() method.");
        return retInfo;
    }

    public InformationMap openMap(String mapPath, String mapName, boolean initCap, boolean replaceUnderscores, boolean useLabels, boolean createTargetFolder) throws Exception {
        String[] stringArray = new String[]{mapPath, mapName, null, null};
        boolean[] booleanArray = new boolean[]{initCap, replaceUnderscores, useLabels, createTargetFolder, false, false, false};
        int[] intArray = new int[]{0, 0, 0, 0};
        String[][] objectArray = new String[][]{null, null, null, null};
        Object[] retInfo = this.openMap(stringArray, booleanArray, intArray, objectArray);
        return (InformationMap)retInfo[1];
    }

    public String[] editCurrentMap(String[] stringArray, boolean[] booleanArray, int[] intArray, Object[] objectArray) throws Exception {
        String[] retInfo2;
        String warning;
        Locale oldLocale;
        Locale newLocale;
        this.checkStringArraySize(stringArray, 2);
        this.checkBooleanArraySize(booleanArray, 5);
        this.checkIntArraySize(intArray, 4);
        this.checkObjectArraySize(objectArray, 4);
        String description = stringArray[0];
        String dataLocale = stringArray[1];
        int actionsOnCustomProperties = intArray[0];
        int actionsOnRequiredTables = intArray[1];
        int joinModel = intArray[2];
        int drillThroughOpt = intArray[3];
        String[] customProperties = (String[])objectArray[0];
        String[] propertiesToDelete = (String[])objectArray[1];
        String[] requiredTablesToAdd = (String[])objectArray[2];
        String[] requiredTablesToRemove = (String[])objectArray[3];
        _infoLogger.info("In editCurrentMap() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        String[] retInfo = new String[]{null};
        if (description != null) {
            this._map.setDescription(description);
        }
        if (dataLocale != null && !dataLocale.isEmpty() && (newLocale = IOMServerUtils.ConvertSASLocaleToJavaLocale((String)dataLocale)) != (oldLocale = this.getComputationalLocale())) {
            MessageFormatter messageFormatter = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.changeComputationalLocale.fmt.txt", newLocale, oldLocale);
            warning = _MVA_WarningFormatCode + messageFormatter + _MVA_NewLineFormatCode;
            retInfo[0] = retInfo[0] == null ? warning : retInfo[0].concat(warning);
            this.setComputationalLocale(newLocale);
        }
        if (actionsOnCustomProperties > 0) {
            retInfo[0] = this.editCustomProperties(actionsOnCustomProperties, customProperties, propertiesToDelete);
        }
        if (actionsOnRequiredTables > 0 && (warning = this.editRequiredTables(actionsOnRequiredTables, requiredTablesToAdd, requiredTablesToRemove)) != null) {
            retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
            warning = null;
        }
        boolean initCap = booleanArray[0];
        boolean replaceUnderscores = booleanArray[1];
        boolean useLabels = booleanArray[2];
        boolean createTargetFolder = booleanArray[3];
        boolean noVerify = booleanArray[4];
        this.setBooleanOptions(initCap, replaceUnderscores, useLabels, createTargetFolder, noVerify, this._MLS_Id);
        List associationRules = this._map.getObjects(false, AssociationRule.class);
        if (joinModel == 1 && associationRules.size() > 0) {
            for (AssociationRule associationRule : associationRules) {
                this._map.removeBusinessRule((BusinessRule)associationRule);
            }
        } else if (joinModel == 2 && (associationRules == null || associationRules.size() == 0) && (retInfo2 = this.addAssociationRule(null, null, null, null))[0] != null) {
            String string = retInfo[0] = retInfo[0] == null ? retInfo2[0] : retInfo[0] + retInfo2[0];
        }
        if (drillThroughOpt != 0) {
            this.setDrillThrough(drillThroughOpt);
        }
        _infoLogger.info("On return from editCurrentMap() method.");
        return retInfo;
    }

    public String addDataSourceTable(String relationalServerName, String libraryName, String tableName, boolean addAll) throws MetadataException {
        String[] retInfo = this.addDataSourceTable(relationalServerName, libraryName, tableName, null, addAll, null, null, 0);
        return retInfo[0];
    }

    public String[] addDataSourceTable(String relationalServerName, String libraryName, String tableName, String imid, boolean addAll, String label, String description, int requiredTable) throws MetadataException {
        String messages;
        _infoLogger.info("In addDataSourceTable() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        String imid2 = imid;
        if (imid != null) {
            this.validateImid(imid);
        } else {
            imid2 = tableName;
        }
        DataSourceTable dsTable = this._map.newDataSourceTable(relationalServerName, libraryName, tableName);
        imid2 = this.addDataSource((DataSource)dsTable, imid2, label, description);
        this._isRelational = true;
        this._hasDataSource = true;
        if (requiredTable == 1) {
            ArrayList<DataSourceTable> dsTableList = new ArrayList<DataSourceTable>();
            dsTableList.add(dsTable);
            this.setRequiredTables(dsTableList, 4);
        }
        String[] retInfo = new String[]{null};
        if (imid == null || !imid.equalsIgnoreCase(imid2)) {
            String message;
            MessageFormatter messageFormatter = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DataSourceInserted.fmt.txt", libraryName + "." + tableName, imid2);
            retInfo[0] = message = _MVA_NoteFormatCode + messageFormatter + _MVA_NewLineFormatCode;
        }
        if (addAll && (messages = this.addAllColumnsToMap((DataSource)dsTable)) != null) {
            retInfo[0] = retInfo[0] == null ? messages : retInfo[0] + messages;
        }
        _infoLogger.info("On return from addDataSourceTable() method.");
        return retInfo;
    }

    public String[] addDataSourceTable(String serverName, String libraryName, String tableName, String[] columnArray) throws MetadataException {
        return this.addDataSourceTable(serverName, libraryName, tableName, columnArray, null, null, null, 0);
    }

    public String[] addDataSourceTable(String serverName, String libraryName, String tableName, String[] columnArray, String imid, String label, String description, int requiredTable) throws MetadataException {
        int i;
        String imid2;
        String[] retInfo = new String[]{null};
        _infoLogger.info("In addDataSourceTable() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (imid != null) {
            this.validateImid(imid);
            imid2 = imid;
        } else {
            imid2 = tableName;
        }
        DataSourceTable dsTable = this._map.newDataSourceTable(serverName, libraryName, tableName);
        this._hasDataSource = true;
        imid2 = this.addDataSource((DataSource)dsTable, imid2, label, description);
        this._isRelational = true;
        StringBuffer buf = null;
        if (imid == null || !imid.equalsIgnoreCase(imid2)) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DataSourceInserted.fmt.txt", libraryName + "." + tableName, imid2);
            buf = new StringBuffer(_MVA_NoteFormatCode);
            buf.append(message).append(_MVA_NewLineFormatCode);
        }
        if (requiredTable == 1) {
            ArrayList<DataSourceTable> dsTableList = new ArrayList<DataSourceTable>();
            dsTableList.add(dsTable);
            this.setRequiredTables(dsTableList, 4);
        }
        List columns = dsTable.getQualifiedColumns();
        int ncols = columnArray.length;
        MapFolder mapFolder = this._map.getRootMapFolder();
        QualifiedColumn[] columnList = new QualifiedColumn[ncols];
        for (i = 0; i < ncols; ++i) {
            String name = columnArray[i];
            boolean found = false;
            for (QualifiedColumn thisColumn : columns) {
                String column = thisColumn.getSasName();
                if (!name.equalsIgnoreCase(column)) continue;
                columnList[i] = thisColumn;
                found = true;
                break;
            }
            if (found) continue;
            this._map.removeDataSource((DataSource)dsTable);
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ColumnNotExist.fmt.txt", name, libraryName, tableName);
            throw new MetadataException(errorMsg);
        }
        for (i = 0; i < ncols; ++i) {
            RootDataItem di = null;
            di = this._map.newDataItem((PhysicalResource)columnList[i], this._options);
            this._map.addBusinessItem((BusinessItem)di);
            mapFolder.addBusinessItem((BusinessItem)di);
            String name = dsTable.getLabel() + "." + columnList[i].getSasName();
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DataItemInsertedNote.fmt.txt", 1, name, di.getIntraModelID());
            if (buf == null) {
                buf = new StringBuffer(_MVA_NoteFormatCode);
            } else {
                buf.append(_MVA_NoteFormatCode);
            }
            buf.append(message).append(_MVA_NewLineFormatCode);
            String warning = this.checkDuplicateName(di.getIntraModelID(), di.getLabel(), RootDataItem.class, mapFolder);
            if (warning == null) continue;
            buf.append(warning);
        }
        retInfo[0] = buf.toString();
        _infoLogger.info("On return from addDataSourceTable() method.");
        return retInfo;
    }

    public int addDataItem(String name, int exprType, String expressionText, String folderName, String desc, String format, boolean isAggregate, String aggregation, String[] aggregationsToDrop) throws MetadataException, DataServicesException, SASFormatException {
        String[] stringArray = new String[]{name, expressionText, folderName, desc, format, aggregation, null, null, null};
        int[] intArray = new int[]{exprType, 0, 0, 0, 0, 0, 0, 0, 0};
        String[][] objectArray = new String[][]{null, null, null};
        this.addDataItem(stringArray, intArray, objectArray);
        return 0;
    }

    public String[] addDataItem(String[] stringArray, int[] intArray, String[][] objectArray) throws MetadataException, DataServicesException, SASFormatException {
        int nFunctions;
        String warning;
        this.checkStringArraySize(stringArray, 9);
        this.checkIntArraySize(intArray, 9);
        this.checkObjectArraySize((Object[])objectArray, 3);
        RootDataItem dataItem = null;
        String name = stringArray[0];
        String expressionText = stringArray[1];
        String folderPath = stringArray[2];
        String desc = stringArray[3];
        String format = stringArray[4];
        String aggregation = stringArray[5];
        String dataSourceName = stringArray[6];
        String columnName = stringArray[7];
        String imid = stringArray[8];
        String[] aggFunctionsList = objectArray[0];
        String[] valuesList = objectArray[1];
        String[] customProperties = objectArray[2];
        int exprType = intArray[0];
        int usageType = intArray[1];
        int rank = intArray[2];
        int sort = intArray[3];
        int navigate = intArray[4];
        int filter = intArray[5];
        boolean toDropAggregations = intArray[6] == 1;
        int lookupType = intArray[7];
        boolean create_folder = intArray[8] == 1;
        DataItemActionType actionType = null;
        String[] retInfo = new String[]{null, null};
        _infoLogger.info("In addDataItem() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (imid != null) {
            this.validateImid(imid);
        }
        if (this._hasDataSource && !this._isRelational && expressionText != null && exprType != 2 && exprType != 3) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidExprType.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (usageType != 0) {
            Object object = usageType == 1 ? DataItemActionType.USAGE_AGGREGATE : (actionType = usageType == 2 ? DataItemActionType.USAGE_CATEGORY : null);
        }
        if (expressionText != null) {
            String warning2;
            dataItem = this._map.newDataItem();
            String dItemName = name;
            if (dItemName == null || dItemName.length() == 0) {
                List itemList = this._map.getObjects(false, DataItem.class);
                dItemName = "DataItem" + (itemList.size() + 1);
            }
            if (imid == null) {
                retInfo[1] = imid = this._map.generateIntraModelID(dItemName);
            }
            if (imid != null) {
                dataItem.setIntraModelID(imid);
            }
            if ((warning2 = this.setDataItemExpression(dataItem, expressionText, exprType)) != null) {
                retInfo[0] = retInfo[0] == null ? warning2 : retInfo[0] + warning2;
            }
            dataItem.setLabel(dItemName);
            if (dataItem.getUsage() == DataItemActionType.USAGE_DETAIL) {
                this.setDefaultActionsSupported((DataItem)dataItem);
            }
            if (this._isRelational && lookupType == 0) {
                LookupNotAllowed lookup = new LookupNotAllowed();
                dataItem.setLookupType((Lookup)lookup);
            }
            if (usageType != 0 && dataItem.getUsage() != actionType) {
                dataItem.setUsage(actionType);
            }
        } else {
            dataItem = this._isRelational ? (RootDataItem)this.getDataItemFromColumn(dataSourceName, columnName) : (dataSourceName == null ? (RootDataItem)this.getDataItemFromMeasure(columnName) : (RootDataItem)this.getDataItemFromHierarchy(dataSourceName, columnName));
            if (name != null && name.trim().length() != 0) {
                dataItem.setLabel(name);
                if (imid == null) {
                    retInfo[1] = imid = this._map.generateIntraModelID(name);
                }
            }
            if (imid != null) {
                dataItem.setIntraModelID(imid);
            } else {
                retInfo[1] = dataItem.getIntraModelID();
            }
            ExpressionInterface expression = dataItem.getExpression();
            if (exprType != 0 && exprType != expression.getExpressionType()) {
                if (!this._isRelational) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.IncompatibleExprType.txt", new Object[0]);
                    throw new MetadataException(errorMsg);
                }
                StringExpressionUtil exprUtil = StringExpressionUtil.getInstance();
                warning = this.setDataItemExpression(dataItem, exprUtil.getText(expression), exprType);
                if (warning != null) {
                    String string = retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
                }
            }
            if (usageType == 0 && dataItem.getUsage() == DataItemActionType.USAGE_DETAIL) {
                dataItem.setUsage(DataItemActionType.USAGE_CATEGORY);
            }
            if (usageType != 0 && dataItem.getUsage() != actionType) {
                dataItem.setUsage(actionType);
            }
        }
        if (desc != null) {
            dataItem.setDescription(desc);
        }
        if (lookupType > 0) {
            LookupNotAllowed lookup = null;
            switch (lookupType) {
                case 1: {
                    lookup = new LookupNotAllowed();
                    break;
                }
                case 2: {
                    lookup = new LookupByDataItem();
                    break;
                }
                case 3: {
                    int nPair = valuesList.length / 2;
                    ArrayList<LookupValue> lookupValues = new ArrayList<LookupValue>(nPair);
                    for (int i = 0; i < nPair; ++i) {
                        String unformatted = valuesList[i * 2];
                        LookupValue lookupValue = new LookupValue(valuesList[i * 2 + 1], unformatted, true);
                        lookupValues.add(lookupValue);
                    }
                    LookupList lookupList = new LookupList();
                    lookupList.setValuesList(lookupValues);
                    lookup = lookupList;
                    break;
                }
            }
            if (lookup != null) {
                dataItem.setLookupType((Lookup)lookup);
            }
        }
        int n = nFunctions = aggFunctionsList == null ? 0 : aggFunctionsList.length;
        if (dataItem.getUsage() != DataItemActionType.USAGE_AGGREGATE && (nFunctions != 0 || aggregation != null)) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoAggregation.fmt.txt", dataItem.getIntraModelID());
            throw new MetadataException(errorMsg);
        }
        this.setAggregateForInsert((DataItem)dataItem, aggregation, aggFunctionsList, toDropAggregations);
        if (format != null && format.length() > 0) {
            boolean validFormat = this.isValidFormat((DataItem)dataItem, format, true);
            if (!validFormat) {
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidFormat.fmt.txt", format, dataItem.getIntraModelID());
                throw new MetadataException(message);
            }
            dataItem.setFormat(format);
        } else {
            this.setFormatValue((DataItem)dataItem);
        }
        this.setPermissions((DataItem)dataItem, rank, sort, filter, navigate);
        if (customProperties != null) {
            Entity entityAttr = this.newEntity(customProperties);
            dataItem.setExtendedAttributes((EntityInterface)entityAttr);
        }
        MapFolder mapFolder = this.getMapFolder(folderPath, create_folder);
        mapFolder.addBusinessItem((BusinessItem)dataItem);
        this._map.addBusinessItem((BusinessItem)dataItem);
        name = dataItem.getLabel();
        warning = this.checkDuplicateName(dataItem.getIntraModelID(), name, RootDataItem.class, mapFolder);
        if (warning != null) {
            retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
        }
        _infoLogger.info("On return from addDataItem() method.");
        return retInfo;
    }

    public String[] addDataSourceCube(String serverName, String schemaName, String cubeName, String imid, boolean addAll, String label, String description) throws MetadataException {
        String messages;
        List cubeList;
        _infoLogger.info("In addDataSourceCube method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (imid != null) {
            this.validateImid(imid);
        }
        if ((cubeList = this._map.getObjects(false, DataSourceCube.class)).size() != 0) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MultiCubeError.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        DataSourceCube cube = schemaName == null || schemaName.length() == 0 ? this.newDataSourceCube(serverName, cubeName) : this._map.newDataSourceCube(serverName, schemaName, cubeName);
        String imid2 = this.addDataSource((DataSource)cube, imid == null ? cubeName : imid, label, description);
        this._hasDataSource = true;
        this._cube = cube;
        String[] retInfo = new String[]{null};
        if (addAll && (messages = this.addAllColumnsToMap((DataSource)cube)) != null) {
            String string = retInfo[0] = retInfo[0] == null ? messages : retInfo[0] + messages;
        }
        if (cube.isDrillThroughEnabled() && this._drillThrough) {
            DrillThroughToDetail drillThrough = this._map.newDrillThroughToDetail();
            drillThrough.setIsDrillThroughAllowed(true);
            this._map.addBusinessRule((BusinessRule)drillThrough);
        }
        _infoLogger.info("On return from addDataSourceCube method.");
        return retInfo;
    }

    private String addDataSource(DataSource dSource, String name, String label, String description) throws MetadataException {
        BusinessModel bModel = dSource.getBusinessModel();
        String imid = bModel.generateIntraModelID(name);
        dSource.setIntraModelID(imid);
        if (label != null) {
            dSource.setLabel(label);
        }
        if (description != null) {
            dSource.setDescription(description);
        }
        this._map.addDataSource(dSource);
        return imid;
    }

    public int addRelationship(String table1, String table2, int type, String conditions, String description, String[] customProperties) throws MetadataException, DataServicesException, DataRetrievalException {
        _infoLogger.info("In addDRelationship() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        int rc = 0;
        DataSourceTable leftDS = null;
        DataSourceTable rightDS = null;
        List tableList = this._map.getObjects(false, DataSourceTable.class);
        for (DataSourceTable ds : tableList) {
            String imid = ds.getIntraModelID();
            if (imid.equalsIgnoreCase(table1)) {
                leftDS = ds;
            } else if (imid.equalsIgnoreCase(table2)) {
                rightDS = ds;
            }
            if (leftDS == null || rightDS == null) continue;
        }
        if (rightDS == null || leftDS == null) {
            MessageFormatter errorMsg = leftDS == null ? BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.LeftTableNotExist.fmt.txt", table1) : BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.RightTableNotExist.fmt.txt", table2);
            throw new MetadataException(errorMsg);
        }
        JoinType joinType = JoinType.NONE;
        switch (type) {
            case 1: {
                joinType = JoinType.INNER;
                break;
            }
            case 2: {
                joinType = JoinType.LEFT;
                break;
            }
            case 3: {
                joinType = JoinType.RIGHT;
                break;
            }
            case 4: {
                joinType = JoinType.FULL;
                break;
            }
            case 5: {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.UnsupportedOperationException.fmt.txt", "JOIN TYPE CROSS");
                throw new MetadataException(errorMsg);
            }
            default: {
                joinType = JoinType.INNER;
            }
        }
        List joinList = this._map.getObjects(0, Join.class);
        Join join = null;
        if (joinList.size() != 0) {
            Iterator it = joinList.iterator();
            Join tjoin = null;
            while (it.hasNext()) {
                tjoin = (Join)it.next();
                DataSourceTable leftDataSource = tjoin.getLeftDataSource();
                DataSourceTable rightDataSource = tjoin.getRightDataSource();
                if (leftDS == leftDataSource && rightDS == rightDataSource) {
                    join = tjoin;
                    break;
                }
                if (leftDS != rightDataSource || rightDS != leftDataSource) continue;
                tjoin.setLeftDataSource(leftDS);
                tjoin.setRightDataSource(rightDS);
                join = tjoin;
                break;
            }
        }
        if (join != null) {
            rc = 1;
        } else {
            join = this._map.newJoin();
            join.setLeftDataSource(leftDS);
            join.setRightDataSource(rightDS);
        }
        join.setType(joinType);
        if (description != null && description.length() != 0) {
            join.setDescription(description);
        }
        JoinTypeList joinTypeList = new JoinTypeList();
        joinTypeList.addAll((Collection)JoinTypeList.ALL_JOIN_TYPES);
        join.setAllowedTypes(joinTypeList);
        ExpressionInterface expression = StringExpressionUtil.getInstance().newExpression((BusinessModel)this._map, conditions, 9, ResourceScope.PHYSICAL_SCOPE);
        ConditionalExpressionAdapter jce = new ConditionalExpressionAdapter();
        jce.setExpression(expression);
        join.setJoinCondition((ConditionalExpression)jce);
        List tablesInExpr = ExpressionUtil.getTables((ExpressionInterface)jce);
        ArrayList<DataSourceTable> tablesToJoin = new ArrayList<DataSourceTable>();
        tablesToJoin.add(leftDS);
        tablesToJoin.add(rightDS);
        this.verifyTables(tablesToJoin, tablesInExpr);
        if (customProperties != null) {
            Entity entityAttr = this.newEntity(customProperties);
            join.setExtendedAttributes((EntityInterface)entityAttr);
        }
        this._map.addBusinessRule((BusinessRule)join);
        if (this._noVerify) {
            _infoLogger.info("On return from addDRelationship() method.");
            return rc;
        }
        try {
            _infoLogger.info("In verifying a relationship() method.");
            this._dataServices.verify(join);
            _infoLogger.info("On return from verifying a relationship() method.");
        }
        catch (MetadataException me) {
            this._map.removeBusinessRule((BusinessRule)join);
            throw me;
        }
        catch (DataServicesException dse) {
            this._map.removeBusinessRule((BusinessRule)join);
            throw dse;
        }
        catch (DataRetrievalException dre) {
            this._map.removeBusinessRule((BusinessRule)join);
            throw dre;
        }
        _infoLogger.info("On return from addDRelationship() method.");
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] addRelationship(String table1, String table2, int type, String conditions, String description, String imid, int cardinalityType, String[] customProperties) throws MetadataException, DataServicesException, DataRetrievalException {
        Cardinality cardinality;
        _infoLogger.info("In addDRelationship() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        String[] retInfo = new String[]{null, null};
        DataSourceTable leftDS = null;
        DataSourceTable rightDS = null;
        if (imid != null) {
            this.validateImid(imid);
        }
        List tableList = this._map.getObjects(false, DataSourceTable.class);
        for (DataSourceTable ds : tableList) {
            String dsid = ds.getIntraModelID();
            if (dsid.equalsIgnoreCase(table1)) {
                leftDS = ds;
            } else if (dsid.equalsIgnoreCase(table2)) {
                rightDS = ds;
            }
            if (leftDS == null || rightDS == null) continue;
        }
        if (rightDS == null || leftDS == null) {
            MessageFormatter errorMsg;
            if (leftDS == null) {
                errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.LeftTableNotExist.fmt.txt", table1);
                throw new MetadataException(errorMsg);
            }
            errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.RightTableNotExist.fmt.txt", table2);
            throw new MetadataException(errorMsg);
        }
        JoinType joinType = JoinType.NONE;
        boolean redefine = false;
        switch (type) {
            case 1: {
                joinType = JoinType.INNER;
                break;
            }
            case 2: {
                joinType = JoinType.LEFT;
                break;
            }
            case 3: {
                joinType = JoinType.RIGHT;
                break;
            }
            case 4: {
                joinType = JoinType.FULL;
                break;
            }
            case 5: {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.UnsupportedOperationException.fmt.txt", "JOIN TYPE CROSS");
                throw new MetadataException(errorMsg);
            }
            default: {
                joinType = JoinType.INNER;
            }
        }
        List joinList = this._map.getObjects(0, Join.class);
        Join join = null;
        if (joinList.size() != 0) {
            Iterator it = joinList.iterator();
            Join tjoin = null;
            while (it.hasNext()) {
                tjoin = (Join)it.next();
                DataSourceTable leftDataSource = tjoin.getLeftDataSource();
                DataSourceTable rightDataSource = tjoin.getRightDataSource();
                if (leftDS == leftDataSource && rightDS == rightDataSource) {
                    join = tjoin;
                    break;
                }
                if (leftDS != rightDataSource || rightDS != leftDataSource) continue;
                tjoin.setLeftDataSource(leftDS);
                tjoin.setRightDataSource(rightDS);
                join = tjoin;
                break;
            }
        }
        if (join != null) {
            if (imid != null) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DuplicateJoin.fmt.txt", table1, table2);
                throw new MetadataException(errorMsg);
            }
            MessageFormatter messageFormatter = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.RedefinedJoin.fmt.txt", table1, table2);
            retInfo[0] = _MVA_WarningFormatCode + messageFormatter + _MVA_NewLineFormatCode;
            redefine = true;
        } else {
            join = this._map.newJoin();
            join.setLeftDataSource(leftDS);
            join.setRightDataSource(rightDS);
        }
        join.setType(joinType);
        if (description != null && description.length() != 0) {
            join.setDescription(description);
        }
        JoinTypeList joinTypeList = new JoinTypeList();
        joinTypeList.addAll((Collection)JoinTypeList.ALL_JOIN_TYPES);
        join.setAllowedTypes(joinTypeList);
        ExpressionInterface expression = StringExpressionUtil.getInstance().newExpression((BusinessModel)this._map, conditions, 9, ResourceScope.PHYSICAL_SCOPE);
        ConditionalExpressionAdapter jce = new ConditionalExpressionAdapter();
        jce.setExpression(expression);
        join.setJoinCondition((ConditionalExpression)jce);
        List tablesInExpr = ExpressionUtil.getTables((ExpressionInterface)jce);
        ArrayList<DataSourceTable> tablesToJoin = new ArrayList<DataSourceTable>();
        tablesToJoin.add(leftDS);
        tablesToJoin.add(rightDS);
        this.verifyTables(tablesToJoin, tablesInExpr);
        if (customProperties != null) {
            Entity entityAttr = this.newEntity(customProperties);
            join.setExtendedAttributes((EntityInterface)entityAttr);
        }
        switch (cardinalityType) {
            case 1: {
                cardinality = Cardinality.ONE_TO_ONE;
                break;
            }
            case 2: {
                cardinality = Cardinality.ONE_TO_MANY;
                break;
            }
            case 3: {
                cardinality = Cardinality.MANY_TO_ONE;
                break;
            }
            case 4: {
                cardinality = Cardinality.MANY_TO_MANY;
                break;
            }
            default: {
                cardinality = Cardinality.UNKNOWN;
            }
        }
        join.setCardinality(cardinality);
        if (imid != null) {
            join.setIntraModelID(imid);
        } else if (!redefine) {
            retInfo[1] = join.getIntraModelID();
        }
        this._map.addBusinessRule((BusinessRule)join);
        if (this._noVerify) {
            return retInfo;
        }
        try {
            this._dataServices.verify(join);
        }
        catch (MetadataException me) {
            this._map.removeBusinessRule((BusinessRule)join);
            throw me;
        }
        catch (DataServicesException dse) {
            this._map.removeBusinessRule((BusinessRule)join);
            throw dse;
        }
        catch (DataRetrievalException dre) {
            this._map.removeBusinessRule((BusinessRule)join);
            throw dre;
        }
        _infoLogger.info("On return from addDRelationship() method.");
        return retInfo;
    }

    public String[] addAssociationRule(String imid, String name, String matrixId, String description) throws Exception {
        String[] retInfo = new String[]{null};
        _infoLogger.info("In addAssociationRule() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        AssociationRule associationRule = this._map.newAssociationRule();
        if (matrixId != null) {
            BusinessRule brule = this._map.getBusinessRuleByID(matrixId);
            if (brule == null || !(brule instanceof AssociationMatrix)) {
                throw new MetadataException("Cannot locate the matrix " + matrixId);
            }
            AssociationMatrix matrix = (AssociationMatrix)brule;
            associationRule.setAssociationMatrix(matrix);
        }
        if (imid == null) {
            associationRule.setIntraModelID(this._map.generateIntraModelID("_JOIN_MODEL"));
        } else {
            this.validateImid(imid);
            associationRule.setIntraModelID(imid);
        }
        associationRule.setLabel(name == null ? associationRule.getIntraModelID() : name);
        if (description != null) {
            associationRule.setDescription(description);
        }
        this._map.addBusinessRule((BusinessRule)associationRule);
        if (imid == null) {
            MessageFormatter messageFormatter = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NewJoinModel.fmt.txt", associationRule.getIntraModelID());
            retInfo[0] = _MVA_NoteFormatCode + messageFormatter + _MVA_NewLineFormatCode;
        }
        _infoLogger.info("On return from addAssociationRule() method.");
        return retInfo;
    }

    private void verifyTables(List tablesToJoin, List tablesInExpr) throws MetadataException {
        int tablesInExprSize;
        int joinTablesSize = tablesToJoin.size();
        if (joinTablesSize > (tablesInExprSize = tablesInExpr.size())) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.AllTablesNotJoinedByCondition.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (joinTablesSize < tablesInExprSize) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NotAllTablesInJoinReferenced.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (joinTablesSize == tablesInExprSize && !tablesInExpr.containsAll(tablesToJoin)) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.AllTablesNotJoinedByCondition.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
    }

    public int addFilter(String filterName, String condition, String folderName, String desc) throws MetadataException, DataServicesException {
        FilterItem filterItem = null;
        int rc = 0;
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        filterItem = this._map.newFilterItem();
        if (filterName == null) {
            List filterList = this._map.getObjects(false, FilterItem.class);
            filterName = "Filter" + (filterList.size() + 1);
        }
        filterItem.setLabel(filterName);
        filterItem.setDescription(desc);
        if (this._isRelational) {
            ExpressionInterface expression = IQModelImplUtilities.newPredicate((BusinessModel)this._map, (String)condition, (ResourceScope)ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
            filterItem.setExpression(expression);
        } else {
            ResourceAwareStringExpression rase = (ResourceAwareStringExpression)StringExpressionUtil.getInstance().newExpression((BusinessModel)this._map, condition);
            MemberFilterExpression filterExpression = this.parseForMemberFilterExpression(rase);
            filterItem.setExpression((ExpressionInterface)filterExpression);
        }
        if (filterName != null && this._map.getBusinessItemByID(filterName) != null) {
            rc = 1;
        }
        String imid = this._map.generateIntraModelID(filterName);
        filterItem.setIntraModelID(imid);
        if (!this._noVerify) {
            this._dataServices.verify((BusinessItem)filterItem);
        }
        MapFolder mapFolder = this.getMapFolder(folderName, false);
        mapFolder.addBusinessItem((BusinessItem)filterItem);
        this._map.addBusinessItem((BusinessItem)filterItem);
        return rc;
    }

    public String[] addFilter(String filterName, String condition, String folderPath, String desc, String imid, String[] customProperties, boolean createMapFolder, boolean hidden) throws MetadataException, DataServicesException {
        FilterItem filterItem = null;
        boolean notOlapPromptedFilter = true;
        String[] retInfo = new String[]{null, null};
        _infoLogger.info("In addFilter() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (imid != null) {
            this.validateImid(imid);
        }
        filterItem = this._map.newFilterItem();
        if (filterName == null) {
            List filterList = this._map.getObjects(false, FilterItem.class);
            filterName = "Filter" + (filterList.size() + 1);
        }
        filterItem.setLabel(filterName);
        filterItem.setDescription(desc);
        filterItem.setIsHidden(hidden);
        if (this._isRelational) {
            ExpressionInterface expression = IQModelImplUtilities.newPredicate((BusinessModel)this._map, (String)condition, (ResourceScope)ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
            filterItem.setExpression(expression);
        } else {
            ResourceAwareStringExpression rase = (ResourceAwareStringExpression)StringExpressionUtil.getInstance().newExpression((BusinessModel)this._map, condition);
            MemberFilterExpression filterExpression = this.parseForMemberFilterExpression(rase);
            filterItem.setExpression((ExpressionInterface)filterExpression);
            List members = filterExpression.getMemberNames();
            for (Object member : members) {
                if (!(member instanceof Prompt)) continue;
                notOlapPromptedFilter = false;
                break;
            }
        }
        if (imid == null) {
            retInfo[1] = imid = this._map.generateIntraModelID(filterName);
        }
        filterItem.setIntraModelID(imid);
        if (customProperties != null) {
            Entity entityAttr = this.newEntity(customProperties);
            filterItem.setExtendedAttributes((EntityInterface)entityAttr);
        }
        if (!this._noVerify && notOlapPromptedFilter) {
            _infoLogger.info("In verifying a filter");
            this._dataServices.verify((BusinessItem)filterItem);
            _infoLogger.info("return from verifying a filter");
        }
        MapFolder mapFolder = this.getMapFolder(folderPath, createMapFolder);
        mapFolder.addBusinessItem((BusinessItem)filterItem);
        this._map.addBusinessItem((BusinessItem)filterItem);
        filterName = filterItem.getLabel();
        String warning = this.checkDuplicateName(filterItem.getIntraModelID(), filterName, FilterItem.class, mapFolder);
        if (warning != null) {
            retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
        }
        _infoLogger.info("On return from addFilter() method.");
        return retInfo;
    }

    private void addLookupValues(LookupList lookupList, String[] valuesList, boolean replace) throws MetadataException {
        int nPair = valuesList.length / 2;
        ArrayList<LookupValue> lookupValues = lookupList.getValuesList();
        if (lookupValues == null) {
            lookupValues = new ArrayList<LookupValue>();
        } else if (replace) {
            lookupValues.clear();
        }
        for (int i = 0; i < nPair; ++i) {
            String unformatted = valuesList[i * 2];
            LookupValue lookupValue = new LookupValue(valuesList[i * 2 + 1], unformatted, true);
            lookupValues.add(lookupValue);
        }
        lookupList.setValuesList(lookupValues);
    }

    public String[] addNewFolder(String folderName, String parentFolder, String description, String[] customProperties, boolean createMapFolder) throws MetadataException {
        String[] retInfo = new String[]{null};
        _infoLogger.info("In addNewFolder() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        MapFolder parentMapFolder = this.getMapFolder(parentFolder, createMapFolder);
        MapFolder newFolder = parentMapFolder.getSubfolder(folderName);
        if (newFolder != null) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DuplicateFolderName.fmt.txt", folderName);
            throw new MetadataException(message);
        }
        Entity entityAttr = null;
        if (customProperties != null) {
            entityAttr = this.newEntity(customProperties);
        }
        newFolder = parentMapFolder.newSubfolder();
        try {
            newFolder.setLabel(folderName);
            if (description != null) {
                newFolder.setDescription(description);
            }
            if (customProperties != null) {
                newFolder.setExtendedAttributes((EntityInterface)entityAttr);
            }
        }
        catch (MetadataException e) {
            parentMapFolder.deleteSubfolder(newFolder);
            throw e;
        }
        if (this.countOfFolderName(parentMapFolder, folderName) > 1) {
            MessageFormatter messageFormatter = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DupFolderName.fmt.txt", folderName, parentMapFolder.getDisplayPath());
            retInfo[0] = _MVA_WarningFormatCode + messageFormatter + _MVA_NewLineFormatCode;
        }
        _infoLogger.info("On return from  addNewFolder() method.");
        return retInfo;
    }

    public int addFolder(String folderName, String parentFolder, String description, String[] customProperties, boolean createMapFolder) throws MetadataException {
        this.addNewFolder(folderName, parentFolder, description, customProperties, createMapFolder);
        return 0;
    }

    public int saveMapToFolder(String mapName, String mapPath, String changeHistoryNote, boolean create_folder, boolean allowMajorVersionIncrease, boolean allowMinorVersionIncrease) throws Exception {
        List list;
        BriefInformationMap briefMap;
        _infoLogger.info("In saveMapToFolder() method.");
        FolderInterface folder = this._folder;
        int rc = 0;
        if (this._map == null) {
            return 0;
        }
        boolean saveAs = false;
        if (mapPath != null && mapPath.length() != 0) {
            if (!(mapPath = this.getRelativePath(mapPath)).equals(this._mapPath) || this._folder == null) {
                folder = this.getMetadataInterface(mapPath, create_folder);
            }
            if (folder != this._folder) {
                saveAs = true;
            }
        }
        String currentMapName = this._map.getLabel();
        if (mapName != null && mapName.length() > 0) {
            if (!mapName.equalsIgnoreCase(currentMapName)) {
                saveAs = true;
            }
            this._map.setLabel(mapName);
            if ((saveAs || !this._updateMap && !this._autoReplaceMap) && (briefMap = (BriefInformationMap)folder.getItemByType(mapName, _briefIMapText)) != null) {
                rc = 2;
            }
            MapFolder root = this._map.getRootMapFolder();
            root.setLabel(mapName);
        }
        briefMap = (BriefInformationMap)folder.getItemByType(this._map.getLabel(), _briefIMapText);
        if (this._autoReplaceMap && briefMap != null) {
            folder.deleteItem((MetadataInterface)briefMap);
        }
        BriefInformationMap origBriefMap = this._map.getBriefMap();
        if (briefMap == null && origBriefMap != null) {
            this._map.setBriefMap(null);
        }
        try {
            this._map.save(folder, changeHistoryNote);
        }
        catch (MetadataException e) {
            if ((allowMajorVersionIncrease || allowMinorVersionIncrease) && (e.hasReasonWithCodes(1, 234) || e.hasReasonWithCodes(1, 235))) {
                HashMap<String, String> saveOptions = new HashMap<String, String>();
                if (allowMajorVersionIncrease) {
                    saveOptions.put("AllowMajorVersionIncrease", "true");
                }
                if (allowMinorVersionIncrease) {
                    saveOptions.put("AllowMinorVersionIncrease", "true");
                }
                this._map.save(folder, changeHistoryNote, saveOptions);
            }
            if (briefMap == null && origBriefMap != null) {
                this._map.setBriefMap(origBriefMap);
            }
            if (saveAs && mapName != null) {
                this._map.setLabel(currentMapName);
                MapFolder root = this._map.getRootMapFolder();
                root.setLabel(currentMapName);
                throw new MetadataException((Throwable)e);
            }
            throw e;
        }
        this._folder = folder;
        this._mapPath = mapPath;
        BriefInformationMap toBriefMap = this._map.getBriefMap();
        if (saveAs && origBriefMap != null && origBriefMap.isObjectAlive()) {
            try {
                this.copyAllExplicitPermissions((MetadataInterface)origBriefMap, (MetadataInterface)toBriefMap);
            }
            catch (Exception e) {
                folder.deleteItem((MetadataInterface)toBriefMap);
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ErrorOnSaveRLP.fmt.txt", mapName);
                throw new MetadataException(message, (Throwable)e);
            }
        }
        if ((list = this._map.getObjects(true, BusinessItem.class)).size() == 0) {
            rc |= 1;
        }
        this._autoReplaceMap = false;
        this._updateMap = true;
        _infoLogger.info("On return from saveMapToFolder() method.");
        return rc;
    }

    public int saveMapToFolder(String mapName, String mapPath, String changeHistoryNote, boolean create_folder) throws Exception {
        return this.saveMapToFolder(mapName, mapPath, changeHistoryNote, create_folder, false, false);
    }

    public int delMapFromFolder(String mapName, String mapPath) throws Exception {
        BriefInformationMap briefMap;
        FolderInterface folder = this._folder;
        _infoLogger.info("In deleteMapFromFolder() method.");
        if (!(mapPath == null || mapPath.length() == 0 || (mapPath = this.getRelativePath(mapPath)).equals(this._mapPath) && this._folder != null)) {
            folder = this.getMetadataInterface(mapPath, false);
        }
        if ((briefMap = (BriefInformationMap)folder.getItemByType(mapName, _briefIMapText)) == null) {
            return 1;
        }
        folder.deleteItem((MetadataInterface)briefMap);
        String folderPath = null;
        folderPath = folder.getPath();
        folderPath = folderPath != null ? SQ + (folderPath.indexOf(SLASH) == 0 ? folderPath : SLASH + folderPath) + SQ : NA;
        ThreadContext.put((String)"actionID", (String)String.valueOf(5));
        ThreadContext.put((String)"action", (String)"Delete");
        ThreadContext.put((String)"actionType", (String)"Persisted");
        ThreadContext.put((String)"sessionID", (String)this._session.getEntityKey());
        ThreadContext.put((String)"user", (String)this._session.getUserContext().getResolvedUserId());
        ThreadContext.put((String)"transID", (String)briefMap.getReposId());
        ThreadContext.put((String)"folder", (String)folderPath);
        ThreadContext.put((String)"map", (String)(SQ + mapName + SQ));
        _auditLogger.info("");
        _infoLogger.info("On return from deleteMapFromFolder() method.");
        return 0;
    }

    public String[] deleteBMO(String imid, int type, boolean cascadeDelete) throws MetadataException {
        _infoLogger.info("In deleteBMO() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        String[] retInfo = new String[]{null};
        String message = null;
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Class itemClass;
                if (imid == null) {
                    Class objectType = type == 1 ? DataItem.class : (type == 2 ? FilterItem.class : Prompt.class);
                    List itemsList = type == 4 ? this._map.getIdentityDrivenPropertyPrompts() : this._map.getObjects(0, objectType);
                    for (BusinessItem item : itemsList) {
                        message = this.deleteOneBItem(item, type, cascadeDelete);
                        if (message == null) continue;
                        retInfo[0] = retInfo[0] == null ? message : retInfo[0] + message;
                    }
                    return retInfo;
                }
                BusinessItem item = this._map.getBusinessItemByID(imid);
                Class clazz = type == 1 ? DataItem.class : (itemClass = type == 2 ? FilterItem.class : Prompt.class);
                if (item == null || !itemClass.isInstance(item)) {
                    MessageFormatter message1 = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoBMO.fmt.txt", type, imid);
                    retInfo[0] = _MVA_WarningFormatCode + message1 + _MVA_NewLineFormatCode;
                    return retInfo;
                }
                retInfo[0] = this.deleteOneBItem(item, type, cascadeDelete);
                break;
            }
            case 6: 
            case 7: {
                Class ruleClass;
                Class clazz = ruleClass = type == 6 ? Join.class : AssociationRule.class;
                if (imid == null) {
                    List rulesList = this._map.getObjects(0, ruleClass);
                    for (BusinessRule rule : rulesList) {
                        this._map.removeBusinessRule(rule);
                    }
                    return retInfo;
                }
                BusinessRule rule = this._map.getBusinessRuleByID(imid);
                if (rule == null || !ruleClass.isInstance(rule)) {
                    MessageFormatter message6 = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoBMO.fmt.txt", type, imid);
                    retInfo[0] = _MVA_WarningFormatCode + message6 + _MVA_NewLineFormatCode;
                    return retInfo;
                }
                this._map.removeBusinessRule(rule);
                break;
            }
            case 9: {
                if (imid == null) {
                    List itemsList = this._map.getObjects(0, DataSource.class);
                    for (DataSource ds : itemsList) {
                        message = this.deleteOneDataSource(ds, type, cascadeDelete);
                        if (message == null) continue;
                        retInfo[0] = retInfo[0] == null ? message : retInfo[0] + message;
                    }
                    return retInfo;
                }
                DataSource ds = this._map.getDataSourceByID(imid);
                if (ds == null) {
                    MessageFormatter message9 = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoBMO.fmt.txt", type, imid);
                    retInfo[0] = _MVA_WarningFormatCode + message9 + _MVA_NewLineFormatCode;
                    return retInfo;
                }
                retInfo[0] = this.deleteOneDataSource(ds, type, cascadeDelete);
                break;
            }
        }
        _infoLogger.info("On return from deleteBMO() method.");
        return retInfo;
    }

    public int delFolder(String folder, String mapPath) throws MetadataException {
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        return 0;
    }

    private String addAllColumnsToMap(DataSource dataSource) throws MetadataException {
        _infoLogger.info("In addAllColumnsToMap() method.");
        List itemList = this._map.newDataItems(dataSource, this._options);
        MapFolder mapFolder = this._map.getRootMapFolder();
        MapFolder subFolder = null;
        if (this._createTargetFolder) {
            String imid = dataSource.getIntraModelID();
            if (mapFolder.getSubfolder(imid) != null) {
                imid = this._map.generateIntraModelID(imid);
            }
            subFolder = mapFolder.newSubfolder();
            subFolder.setLabel(imid);
        }
        MapFolder mapFolder2 = mapFolder = subFolder == null ? mapFolder : subFolder;
        if (dataSource instanceof DataSourceTable) {
            BaseStringComparator comparator = new BaseStringComparator(true, true);
            Collections.sort(itemList, comparator);
        }
        Iterator iterator = itemList.iterator();
        StringBuffer messages = new StringBuffer();
        while (iterator.hasNext()) {
            List resources;
            DataItem di = (DataItem)iterator.next();
            int structureType = 1;
            String name = null;
            StructureOfDataItem itemStruct = di.getStructure();
            ExpressionInterface expr = di.getExpression();
            if (itemStruct == StructureOfDataItem.STRUCTURE_COLUMN) {
                QualifiedColumn column;
                structureType = 1;
                if (expr instanceof QualifiedColumn) {
                    column = (QualifiedColumn)expr;
                    name = dataSource.getLabel() + "." + column.getSasName();
                } else if (expr instanceof ResourceAwareStringExpression) {
                    ResourceAwareStringExpression rase = (ResourceAwareStringExpression)expr;
                    List resources2 = rase.getResources(QualifiedColumn.class, 0);
                    if (resources2.size() == 1) {
                        column = (QualifiedColumn)resources2.get(0);
                        name = dataSource.getLabel() + "." + column.getSasName();
                    }
                } else {
                    _infoLogger.info("Unexpected class of data item expressionInterface from ProcInfoMaps.addAllColumnsToMap");
                    name = dataSource.getLabel() + "." + di.getLabel();
                }
            } else if (itemStruct == StructureOfDataItem.STRUCTURE_HIERARCHY) {
                structureType = 2;
                resources = di.getResources(Hierarchy.class, 0);
                if (resources.size() == 1) {
                    Hierarchy hierarchy = (Hierarchy)expr;
                    name = hierarchy.getDimensionName() + "." + hierarchy.getHierarchyName();
                }
            } else if (itemStruct == StructureOfDataItem.STRUCTURE_MEASURE) {
                structureType = 3;
                resources = di.getResources(Measure.class, 0);
                if (resources.size() == 1) {
                    Measure measure = (Measure)expr;
                    name = measure.getMeasureName();
                }
            } else if (itemStruct == StructureOfDataItem.STRUCTURE_NAMED_SET) {
                structureType = 4;
                NamedSet namedSet = (NamedSet)expr;
                name = namedSet.getDimensionName() + "." + namedSet.getLabel();
            } else if (itemStruct == StructureOfDataItem.STRUCTURE_CALCULATED_MEMBER) {
                structureType = 5;
                CalculatedMember calculatedMember = (CalculatedMember)expr;
                name = calculatedMember.getDimensionName() + "." + calculatedMember.getLabel();
            } else {
                if (_infoLogger.isDebugEnabled()) {
                    _infoLogger.info("Unexpected data item struct from ProcInfoMaps.addAllColumnsToMap: " + itemStruct);
                }
                name = dataSource.getLabel() + "." + di.getLabel();
            }
            this._map.addBusinessItem((BusinessItem)di);
            mapFolder.addBusinessItem((BusinessItem)di);
            MessageFormatter messageFormatter = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DataItemInsertedNote.fmt.txt", structureType, name, this.percentSignHandling(di.getIntraModelID()));
            messages.append(_MVA_NoteFormatCode).append(messageFormatter).append(_MVA_NewLineFormatCode);
            String warning = this.checkDuplicateName(di.getIntraModelID(), di.getLabel(), RootDataItem.class, mapFolder);
            if (warning == null) continue;
            messages.append(warning);
        }
        _infoLogger.info("On return from addAllColumnsToMap() method.");
        return messages.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String exportInformationMap(String mapName, String mapPath) throws Exception {
        FolderInterface folder = this._folder;
        InformationMap map = null;
        _infoLogger.info("In exportInformationMap() method.");
        if (mapPath == null && mapName == null) {
            return PersistenceUtilities.getMapText((InformationMap)this._map, (int)4);
        }
        if (mapPath == null) {
            if (this._folder == null) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MapPathMissing.txt", new Object[0]);
                throw new MetadataException(errorMsg);
            }
            folder = this._folder;
        } else {
            if (mapName == null) {
                mapName = this._mapName;
            }
            if (!(mapPath == null || mapPath.length() == 0 || (mapPath = this.getRelativePath(mapPath)).equals(this._mapPath) && this._folder != null)) {
                folder = this.getMetadataInterface(mapPath, false);
            }
        }
        BriefInformationMap briefMap = (BriefInformationMap)folder.getItemByType(mapName, _briefIMapText);
        if (briefMap != null) {
            map = InformationMapFactory.getInstance().newInformationMap(this._session, this._service, briefMap);
            _infoLogger.info("On return from exportInformationMap() method.");
            return PersistenceUtilities.getMapText((InformationMap)map, (int)4);
        }
        MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MapNotExist2.fmt.txt", mapName);
        throw new MetadataException(errorMsg);
    }

    public Object[] importInformationMap(String mapName, String mapPath, String filename, boolean noVerify) throws Exception {
        _infoLogger.info("In importInformationMap() method.");
        String XML = this.importXML(filename);
        InformationMap imap = PersistenceUtilities.importMap((String)XML, (SessionContextInterface)this._session, (IntelligentQueryMetadataServiceInterface)this._service, null);
        if (imap == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.FailToImport.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        this._map = imap;
        this._computationalLocale = this._map.getComputationalLocale();
        this.setAggFunctionsMap();
        this._mapName = this._map.getLabel();
        this.checkDataSource();
        this._noVerify = noVerify;
        Object[] retInfo = new Object[]{null, null, null, null};
        StringBuffer warnings = null;
        warnings = this.checkDupNamesInFolders(this._map.getRootMapFolder(), warnings);
        retInfo[0] = warnings == null ? null : warnings.toString();
        retInfo[1] = imap;
        retInfo[2] = this._mapName;
        if (this._hasDataSource) {
            retInfo[3] = this._isRelational ? "TABLE" : "CUBE";
        }
        _infoLogger.info("On return from importInformationMap() method.");
        return retInfo;
    }

    private MapFolder getNestedMapFolder(MapFolder root, String folderName, boolean create_folder) throws MetadataException {
        MapFolder mapFolder = root;
        String[] folderNames = folderName.split(SLASH);
        int levels = folderNames.length;
        for (int i = 0; i < levels; ++i) {
            mapFolder = this.getMapFolderByName(mapFolder, folderNames[i], create_folder);
        }
        return mapFolder;
    }

    private MapFolder getMapFolder(String folderName, boolean create_folder) throws MetadataException {
        _infoLogger.info("In getMapFolder() method.");
        MapFolder root = this._map.getRootMapFolder();
        if (folderName == null || folderName.trim().length() == 0 || folderName.equals(SLASH)) {
            return root;
        }
        if (folderName.charAt(0) == '/') {
            return this.getNestedMapFolder(root, folderName.substring(1), create_folder);
        }
        _infoLogger.info("On return from getMapFolder() method.");
        return this.getMapFolderByName(root, folderName, create_folder);
    }

    private MapFolder getMapFolderByName(MapFolder parent, String folderName, boolean create_folder) throws MetadataException {
        _infoLogger.info("In getMapFolderByName() method.");
        MapFolder mapFolder = parent.getSubfolder(folderName);
        if (mapFolder == null) {
            String path = parent.getDisplayPath();
            if (!path.equals(SLASH)) {
                path = path + SLASH;
            }
            if (!create_folder) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_invalidFolderMsg, path + folderName);
                throw new MetadataException(errorMsg);
            }
            mapFolder = parent.newSubfolder();
            if (!mapFolder.isValidLabel(folderName)) {
                parent.deleteSubfolder(mapFolder);
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidFolderName.fmt.txt", folderName);
                throw new MetadataException(errorMsg);
            }
            mapFolder.setLabel(folderName);
        }
        _infoLogger.info("On return from getMapFolderByName() method.");
        return mapFolder;
    }

    private int countOfFolderName(MapFolder parent, String folderName) {
        List folderList = parent.getSubfolders();
        Iterator iterator = folderList.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            MapFolder folder = (MapFolder)iterator.next();
            if (!folder.getLabel().equalsIgnoreCase(folderName)) continue;
            ++count;
        }
        return count;
    }

    public String[][] getDataInfo(int what) throws MetadataException {
        int totalAttributes = what == 1 ? 9 : (what == 4 ? 5 : 6);
        String[][] contentsInfo = null;
        List dataList = new ArrayList();
        StringExpressionUtil exprUtil = StringExpressionUtil.getInstance();
        _infoLogger.info("In getDataInfo() method.");
        dataList = what == 1 ? this._map.getObjects(false, DataItem.class) : (what == 4 ? this._map.getObjects(false, DataSource.class) : (what == 2 ? this._map.getObjects(2, FilterItem.class) : this._map.getObjects(false, Join.class)));
        BaseStringComparator comparator = new BaseStringComparator(true, true);
        Collections.sort(dataList, comparator);
        int totalItems = dataList.size();
        contentsInfo = new String[totalItems][totalAttributes];
        for (int i = 0; i < totalItems; ++i) {
            ExpressionInterface expr;
            String lib;
            SASLibrary sasLibrary;
            DataSourceTable table;
            Object item = null;
            if (what == 4) {
                DataSource dataSource = (DataSource)dataList.get(i);
                contentsInfo[i][1] = dataSource.getIntraModelID();
                contentsInfo[i][3] = dataSource.getDescription();
                if (this._isRelational) {
                    RequiredDataSources requiredDS;
                    List dataSources;
                    table = (DataSourceTable)dataSource;
                    sasLibrary = (SASLibrary)table.getAccessPath().getSchema();
                    lib = sasLibrary.getLabel();
                    contentsInfo[i][0] = lib + "." + table.getSasName();
                    contentsInfo[i][2] = table.getLabel();
                    List rdsList = this._map.getObjects(false, RequiredDataSources.class);
                    contentsInfo[i][4] = NO_VAL;
                    if (rdsList == null || rdsList.size() <= 0 || !(dataSources = (requiredDS = (RequiredDataSources)rdsList.get(0)).getDataSources()).contains(table)) continue;
                    contentsInfo[i][4] = YES_VAL;
                    continue;
                }
                DataSourceCube cube = (DataSourceCube)dataSource;
                Schema schema = cube.getAccessPath().getSchema();
                String schemaName = schema.getLabel();
                contentsInfo[i][0] = schemaName + "." + cube.getCubeName();
                contentsInfo[i][2] = cube.getLabel();
                continue;
            }
            if (what == 5) {
                Join join = (Join)dataList.get(i);
                contentsInfo[i][0] = join.getIntraModelID();
                table = join.getLeftDataSource();
                sasLibrary = (SASLibrary)table.getAccessPath().getSchema();
                lib = sasLibrary.getLabel();
                contentsInfo[i][1] = lib + "." + table.getSasName();
                table = join.getRightDataSource();
                sasLibrary = (SASLibrary)table.getAccessPath().getSchema();
                lib = sasLibrary.getLabel();
                contentsInfo[i][2] = lib + "." + table.getSasName();
                ConditionalExpression condition = join.getJoinCondition();
                Cardinality cardinality = join.getCardinality();
                contentsInfo[i][3] = cardinality == Cardinality.ONE_TO_ONE ? CARDINALITY[1] : (cardinality == Cardinality.ONE_TO_MANY ? CARDINALITY[2] : (cardinality == Cardinality.MANY_TO_ONE ? CARDINALITY[3] : (cardinality == Cardinality.MANY_TO_MANY ? CARDINALITY[3] : (cardinality == Cardinality.UNKNOWN ? CARDINALITY[5] : CARDINALITY[0]))));
                JoinType joinType = join.getType();
                String string = joinType == JoinType.INNER ? JOIN_TYPES[1] : (joinType == JoinType.LEFT ? JOIN_TYPES[2] : (joinType == JoinType.RIGHT ? JOIN_TYPES[3] : (contentsInfo[i][4] = joinType == JoinType.FULL ? JOIN_TYPES[4] : JOIN_TYPES[0])));
                if (condition instanceof ConditionalExpressionAdapter) {
                    ConditionalExpressionAdapter jce = (ConditionalExpressionAdapter)condition;
                    contentsInfo[i][5] = exprUtil.getReadableText(jce.getExpression());
                    continue;
                }
                if (!(condition instanceof CompoundConditionalExpression)) continue;
                CompoundConditionalExpression compound = (CompoundConditionalExpression)condition;
                contentsInfo[i][5] = exprUtil.getReadableText(compound.getExpression());
                continue;
            }
            item = what == 1 ? (DataItem)dataList.get(i) : (FilterItem)dataList.get(i);
            contentsInfo[i][0] = item.getLabel();
            contentsInfo[i][1] = item.getIntraModelID();
            MapFolder mapFolder = this._map.getMapFolderContaining((BusinessItem)item);
            contentsInfo[i][2] = mapFolder.getDisplayPath();
            contentsInfo[i][3] = item.getDescription();
            if (what == 1) {
                String typeString;
                DataItem di = item;
                expr = di.getExpression();
                contentsInfo[i][4] = this._isRelational ? exprUtil.getReadableText(expr) : OLAPStringExpressionUtil.getReadableText((ExpressionInterface)expr);
                int type = expr.getExpressionType();
                switch (type) {
                    case 3: {
                        typeString = "CHARACTER";
                        break;
                    }
                    case 2: {
                        typeString = "NUMERIC";
                        break;
                    }
                    case 4: {
                        typeString = "DATE";
                        break;
                    }
                    case 5: {
                        typeString = "TIME";
                        break;
                    }
                    case 6: {
                        typeString = "TIMESTAMP";
                        break;
                    }
                    default: {
                        typeString = "Not Set";
                    }
                }
                contentsInfo[i][5] = typeString;
                contentsInfo[i][6] = di.getUsage() == DataItemActionType.USAGE_CATEGORY ? "CATEGORY" : "MEASURE";
                contentsInfo[i][7] = di.getFormat();
                contentsInfo[i][8] = this._isRelational ? (di.getAggregationType() != null ? di.getAggregationType().getNameID() : null) : null;
                continue;
            }
            FilterItem filter = (FilterItem)item;
            expr = filter.getExpression();
            contentsInfo[i][4] = exprUtil.getReadableText(expr);
            contentsInfo[i][5] = NO_VAL;
            if (!filter.isHidden()) continue;
            contentsInfo[i][5] = YES_VAL;
        }
        _infoLogger.info("On return from getDataInfo() method.");
        return contentsInfo;
    }

    public void destroySession() throws Exception {
        ThreadContext.put((String)"action", (String)LOGOFF);
        ThreadContext.put((String)"transID", (String)NA);
        ThreadContext.put((String)"folder", (String)NA);
        ThreadContext.put((String)"map", (String)NA);
        ThreadContext.put((String)"actionID", (String)String.valueOf(2));
        ThreadContext.put((String)"actionType", (String)SUCCESS);
        ThreadContext.put((String)"sessionID", (String)this._session.getEntityKey());
        ThreadContext.put((String)"user", (String)this._session.getUserContext().getResolvedUserId());
        _auditLogger.info("");
        this._session.destroy();
        this._session = null;
    }

    private void setAggregateForInsert(DataItem dataItem, String aggregation, String[] aggregationsList, boolean toDrop) throws MetadataException {
        List functions;
        Function aggFunction = null;
        Function savedAggregationType = null;
        StructureOfDataItem itemStruct = dataItem.getStructure();
        if (itemStruct != StructureOfDataItem.STRUCTURE_COLUMN) {
            return;
        }
        if (aggregationsList != null) {
            savedAggregationType = dataItem.getAggregationType();
            if (savedAggregationType != null) {
                dataItem.setAggregationType(null);
            }
            if (!toDrop) {
                functions = dataItem.getValidAggregationTypes();
                for (Function function : functions) {
                    dataItem.setAggregationTypeSupported(function, false);
                }
            }
            this.addRemoveAggregations(dataItem, aggregationsList, false, toDrop);
        }
        if (aggregation == null || aggregation.length() == 0) {
            if (savedAggregationType == null) {
                this.configureAggFunctions(dataItem);
                return;
            }
            if (!dataItem.isAggregationTypeSupported(savedAggregationType)) {
                this.configureAggFunctions(dataItem);
            } else {
                dataItem.setAggregationType(savedAggregationType);
            }
            return;
        }
        functions = dataItem.getSupportedAggregationTypesList();
        if (functions.size() == 0) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.AggregationNotSupported.fmt.txt", dataItem.getIntraModelID(), aggregation);
            throw new MetadataException(errorMsg);
        }
        aggFunction = null;
        Iterator i = functions.iterator();
        while (aggFunction == null && i.hasNext()) {
            Function function;
            function = (Function)i.next();
            if (!function.getNameID().equalsIgnoreCase(aggregation)) continue;
            aggFunction = function;
        }
        if (aggFunction == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.AggregationNotSupported.fmt.txt", dataItem.getIntraModelID(), aggregation);
            throw new MetadataException(errorMsg);
        }
        Function defFunction = dataItem.getAggregationType();
        if (!aggFunction.equals((Object)defFunction)) {
            dataItem.setAggregationType(aggFunction);
        }
    }

    private void setAggregateForUpdate(DataItem dataItem, String aggregation, String[] functionsToAdd, String[] functionsToRemove, int actions) throws MetadataException {
        List functions = dataItem.getValidAggregationTypes();
        Function aggFunction = null;
        Function defaultAggregation = dataItem.getAggregationType();
        StructureOfDataItem itemStruct = dataItem.getStructure();
        if (itemStruct != StructureOfDataItem.STRUCTURE_COLUMN) {
            return;
        }
        if (actions == 2) {
            dataItem.setAggregationType(null);
            for (Function function : functions) {
                dataItem.setAggregationTypeSupported(function, false);
            }
            this.addRemoveAggregations(dataItem, functionsToAdd, true, false);
        } else {
            if ((actions & 1) == 1) {
                for (Function function : functions) {
                    dataItem.setAggregationTypeSupported(function, true);
                }
            }
            if ((actions & 8) == 8) {
                this.addRemoveAggregations(dataItem, functionsToRemove, true, true);
            }
            if ((actions & 4) == 4) {
                this.addRemoveAggregations(dataItem, functionsToAdd, true, false);
            }
        }
        if (aggregation == null || aggregation.length() == 0) {
            if (!dataItem.isAggregationTypeSupported(defaultAggregation)) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.FunctionInUse.fmt.txt", defaultAggregation, dataItem.getIntraModelID());
                throw new MetadataException(errorMsg);
            }
            dataItem.setAggregationType(defaultAggregation);
            return;
        }
        functions = dataItem.getSupportedAggregationTypesList();
        if (functions.size() == 0) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.AggregationNotSupported.fmt.txt", dataItem.getIntraModelID(), aggregation);
            throw new MetadataException(errorMsg);
        }
        aggFunction = null;
        Iterator i = functions.iterator();
        while (aggFunction == null && i.hasNext()) {
            Function function;
            function = (Function)i.next();
            if (!function.getNameID().equalsIgnoreCase(aggregation)) continue;
            aggFunction = function;
        }
        if (aggFunction == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.AggregationNotSupported.fmt.txt", dataItem.getIntraModelID(), aggregation);
            throw new MetadataException(errorMsg);
        }
        dataItem.setAggregationType(aggFunction);
    }

    private void addRemoveAggregations(DataItem dataItem, String[] aggregationsList, boolean update, boolean toRemove) throws MetadataException {
        if (aggregationsList == null) {
            return;
        }
        int nFunctions = aggregationsList.length;
        int nError = 0;
        ArrayList<String> invalidFunctionIds = null;
        List validAggregations = dataItem.getValidAggregationTypes();
        if (this._serverProperties == null) {
            this._serverProperties = this._map.getServerProperties();
        }
        if (nFunctions > 0) {
            invalidFunctionIds = new ArrayList<String>();
            boolean selected = !toRemove;
            for (int i = 0; i < nFunctions; ++i) {
                String functionName = aggregationsList[i];
                String functionID = this._AggFunctionsMap.get(functionName.toUpperCase());
                Function function = null;
                if (functionID != null) {
                    function = this._serverProperties.getFunctionByID(functionID);
                    if (validAggregations.contains(function)) {
                        dataItem.setAggregationTypeSupported(function, selected);
                    } else {
                        function = null;
                    }
                }
                if (function != null) continue;
                invalidFunctionIds.add(functionName);
                ++nError;
            }
        }
        if (nError > 0) {
            String msgID = update ? "ProcInfoMaps.InvalidFunctionsForUpdate.fmt.txt" : "ProcInfoMaps.InvalidFunctionsForInsert.fmt.txt";
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(msgID, dataItem.getIntraModelID(), new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_LONG, invalidFunctionIds.toArray()));
            throw new MetadataException(errorMsg);
        }
    }

    private void configureAggFunctions(DataItem item) throws MetadataException {
        if (this._serverProperties == null) {
            this._serverProperties = this._map.getServerProperties();
        }
        if (this._serverProperties != null) {
            int type = item.getExpressionType();
            StructureOfDataItem itemStruct = item.getStructure();
            if (itemStruct == StructureOfDataItem.STRUCTURE_COLUMN) {
                List supportedFunctions = item.getSupportedAggregationTypesList();
                Function newAggFunction = item.getAggregationType();
                if (newAggFunction != null) {
                    if (!item.isAggregationTypeSupported(newAggFunction)) {
                        newAggFunction = (Function)supportedFunctions.get(0);
                        item.setAggregationType(newAggFunction);
                    }
                    return;
                }
                Function countFunction = this._serverProperties.getFunctionByNameID(FunctionNameID.COUNT);
                Function sumFunction = this._serverProperties.getFunctionByNameID(FunctionNameID.SUM);
                newAggFunction = countFunction;
                if (type == 2) {
                    QualifiedColumn column;
                    newAggFunction = sumFunction;
                    ExpressionInterface expr = item.getExpression();
                    if (expr instanceof QualifiedColumn && (column = (QualifiedColumn)expr).getExpressionType() == 3) {
                        newAggFunction = countFunction;
                    }
                }
                if (!item.isAggregationTypeSupported(newAggFunction)) {
                    if (supportedFunctions.size() == 0) {
                        MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.EmptyAggregationsList.fmt.txt", item.getIntraModelID());
                        throw new MetadataException(errorMsg);
                    }
                    newAggFunction = (Function)supportedFunctions.get(0);
                }
                item.setAggregationType(newAggFunction);
            }
        }
    }

    private void setDefaultActionsSupported(DataItem item) throws MetadataException {
        StructureOfDataItem struct = item.getStructure();
        _infoLogger.info("In setDefaultActionsSupported() method.");
        if (struct == StructureOfDataItem.STRUCTURE_COLUMN) {
            item.setActionSupported(DataItemActionType.USAGE_DETAIL, true);
            item.setActionSupported(DataItemActionType.USAGE_CATEGORY, true);
            item.setActionSupported(DataItemActionType.USAGE_AGGREGATE, true);
            item.setActionSupported(DataItemActionType.SORT_NONE, true);
            item.setActionSupported(DataItemActionType.SORT_DESCENDING, true);
            item.setActionSupported(DataItemActionType.SORT_ASCENDING, true);
            item.setUsage(DataItemActionType.USAGE_CATEGORY);
            item.setSortDirection(DataItemActionType.SORT_NONE);
        } else if (struct == StructureOfDataItem.STRUCTURE_DIMENSION || struct == StructureOfDataItem.STRUCTURE_HIERARCHY || struct == StructureOfDataItem.STRUCTURE_LEVEL) {
            item.setActionSupported(DataItemActionType.SORT_HIERARCHICAL_ASCENDING, true);
            item.setActionSupported(DataItemActionType.SORT_HIERARCHICAL_DESCENDING, true);
            item.setActionSupported(DataItemActionType.USAGE_DETAIL, true);
            item.setActionSupported(DataItemActionType.USAGE_CATEGORY, true);
            item.setActionSupported(DataItemActionType.USAGE_AGGREGATE, true);
            item.setActionSupported(DataItemActionType.SORT_NONE, true);
            item.setActionSupported(DataItemActionType.SORT_DESCENDING, true);
            item.setActionSupported(DataItemActionType.SORT_ASCENDING, true);
            item.setUsage(DataItemActionType.USAGE_CATEGORY);
            item.setSortDirection(DataItemActionType.SORT_NONE);
        } else if (struct == StructureOfDataItem.STRUCTURE_MEASURE) {
            item.setActionSupported(DataItemActionType.USAGE_DETAIL, true);
            item.setActionSupported(DataItemActionType.USAGE_CATEGORY, false);
            item.setActionSupported(DataItemActionType.USAGE_AGGREGATE, true);
            item.setUsage(DataItemActionType.USAGE_AGGREGATE);
        }
    }

    private void setFormatValue(DataItem dataItem) throws MetadataException, SASFormatException {
        int actualDataItemType = dataItem.getExpressionType();
        ExpressionInterface expr = dataItem.getExpression();
        StructureOfDataItem itemStruct = dataItem.getStructure();
        if (itemStruct != StructureOfDataItem.STRUCTURE_COLUMN && itemStruct != StructureOfDataItem.STRUCTURE_MEASURE) {
            return;
        }
        List formatsList = null;
        if (this._serverProperties == null) {
            this._serverProperties = this._map.getServerProperties();
        }
        SASFormatCategory formatType = actualDataItemType == 2 ? SASFormatCategory.NUMERIC_CATEGORY : (actualDataItemType == 3 ? SASFormatCategory.CHARACTER_CATEGORY : SASFormatCategory.DATE_TIME_CATEGORY);
        formatsList = this._serverProperties.getSASFormatDescriptions(formatType);
        String firstValidFormat = null;
        Iterator iter = formatsList.iterator();
        if (iter.hasNext()) {
            SASFormatDescription fmtDescription = (SASFormatDescription)iter.next();
            firstValidFormat = fmtDescription.getBaseFormatName() + fmtDescription.getDefaultWidth() + ".";
            int d = fmtDescription.getDefaultDecimalWidth();
            if (d > -1) {
                firstValidFormat = firstValidFormat + d;
            }
        }
        DataItemActionType usageType = dataItem.getUsage();
        Class expressionClass = itemStruct == StructureOfDataItem.STRUCTURE_MEASURE ? Measure.class : Column.class;
        List exprResources = dataItem.getResources(expressionClass, 0);
        List businessResources = dataItem.getResources(DataItem.class, 0);
        if (businessResources.size() > 1) {
            dataItem.setFormat(null);
            return;
        }
        if (businessResources.size() == 1) {
            if (exprResources.size() == 0 && dataItem.getExpressionType() == ((DataItem)businessResources.get(0)).getExpressionType()) {
                dataItem.setFormat(((DataItem)businessResources.get(0)).getFormat());
                return;
            }
            dataItem.setFormat(null);
            return;
        }
        if (businessResources.size() == 0) {
            if (itemStruct == StructureOfDataItem.STRUCTURE_COLUMN) {
                List columns = exprResources;
                if (columns.size() > 1) {
                    int type = dataItem.getExpression().getExpressionType();
                    switch (type) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            if (usageType != DataItemActionType.USAGE_AGGREGATE) break;
                            dataItem.setFormat(firstValidFormat);
                            return;
                        }
                    }
                    dataItem.setFormat(null);
                    return;
                }
                if (columns.size() == 1 || expr instanceof QualifiedColumn) {
                    QualifiedColumn thisColumn = columns.size() == 0 ? (QualifiedColumn)expr : (QualifiedColumn)columns.get(0);
                    String SASFormat = thisColumn.getSasFormat();
                    if (SASFormat != null && SASFormat.length() > 0) {
                        if (this.isValidFormat(dataItem, SASFormat, false)) {
                            dataItem.setFormat(SASFormat);
                        } else {
                            dataItem.setFormat(firstValidFormat);
                        }
                    } else if (actualDataItemType != 2 && actualDataItemType != 3) {
                        dataItem.setFormat(firstValidFormat);
                    } else {
                        dataItem.setFormat(null);
                    }
                    return;
                }
            }
            if (itemStruct == StructureOfDataItem.STRUCTURE_MEASURE) {
                OMAMeasure measure;
                String SASFormat;
                List measures = exprResources;
                if ((measures.size() == 1 || expr instanceof OMAMeasure) && (SASFormat = (measure = measures.size() == 0 ? (OMAMeasure)expr : (OMAMeasure)measures.get(0)).getSasFormat()) != null && SASFormat.length() > 0 && this.isValidFormat(dataItem, SASFormat, false)) {
                    dataItem.setFormat(SASFormat);
                    return;
                }
                dataItem.setFormat(null);
            }
            return;
        }
    }

    private DataSourceCube newDataSourceCube(String serverName, String cubeName) throws MetadataException {
        MessageFormatter message;
        Object[] msgArgs;
        DataSourceCube dataSourceCube = null;
        String schemaName = null;
        _infoLogger.info("In newDataSourceCube() method.");
        ArrayList<Class<SASOlapServer>> serverTypes = new ArrayList<Class<SASOlapServer>>();
        serverTypes.add(SASOlapServer.class);
        List servers = this._service.getSoftwareServers(this._session, serverTypes);
        SASOlapServer server = null;
        OlapSchema schema = null;
        block0: for (SASOlapServer thisServer : servers) {
            if (!thisServer.getLabel().equals(serverName)) continue;
            server = thisServer;
            List schemas = thisServer.getOlapSchemas();
            Iterator itSchemas = schemas.iterator();
            schema = (OlapSchema)itSchemas.next();
            schemaName = schema.getLabel();
            List cubes = schema.getCubes();
            for (Cube thisCube : cubes) {
                if (!thisCube.getCubeName().equals(cubeName)) continue;
                dataSourceCube = this._map.newDataSourceCube((OlapServer)server, schema, thisCube);
                dataSourceCube.setLabel(cubeName);
                break block0;
            }
        }
        if (server == null) {
            msgArgs = new String[]{serverName};
            message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ServerNotFound.fmt.txt", msgArgs);
            throw new MetadataException(message);
        }
        if (dataSourceCube == null) {
            msgArgs = new String[]{cubeName, schemaName, serverName};
            message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.CubeNotFound.fmt.txt", msgArgs);
            throw new MetadataException(message);
        }
        _infoLogger.info("On return from newDataSourceCube() method.");
        return dataSourceCube;
    }

    private void checkDataSource() {
        List dsList = this._map.getObjects(false, DataSource.class);
        if (dsList != null && dsList.size() != 0) {
            this._hasDataSource = true;
            DataSource dataSource = (DataSource)dsList.get(0);
            StructureOfData dataSourceStruct = dataSource.getStructure();
            this._isRelational = dataSourceStruct.isRelational();
            if (!this._isRelational) {
                this._cube = (DataSourceCube)dataSource;
            }
        }
    }

    private MemberFilterExpression parseForMemberFilterExpression(ResourceAwareStringExpression rase) throws MetadataException {
        _infoLogger.info("In parseForMemberFilterExpression() method.");
        List idents = rase.getExpressionIdentifiers();
        boolean isNegated = false;
        int indexOfCond = -1;
        for (int i = 0; i < idents.size(); ++i) {
            ExpressionIdentifier ei = (ExpressionIdentifier)idents.get(i);
            String value = ei.getStringValue();
            if (!ei.isString() || value == null) continue;
            if (value.trim().toUpperCase().indexOf("NOT IN") != -1 || value.trim().toUpperCase().indexOf("<>") != -1 || value.trim().toUpperCase().indexOf("!=") != -1) {
                indexOfCond = i;
                isNegated = true;
                break;
            }
            if (value.trim().toUpperCase().indexOf("IN") == -1 && value.trim().toUpperCase().indexOf("=") == -1) continue;
            indexOfCond = i;
            break;
        }
        if (indexOfCond == -1) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidOlapOperator.txt", new Object[0]);
            throw new MetadataException(message);
        }
        DataItem dataItem = null;
        for (int i = 0; i < indexOfCond; ++i) {
            ExpressionIdentifier ei = (ExpressionIdentifier)idents.get(i);
            if (ei.isResource()) {
                BusinessModelResource bmo = ei.getBusinessModelResource();
                if (dataItem == null) {
                    if (!(bmo instanceof DataItem)) {
                        MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DataItemExpectedOnLHS.fmt.txt", bmo.getIdentityString());
                        throw new MetadataException(message);
                    }
                    dataItem = (DataItem)bmo;
                    continue;
                }
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoExpressionsOnLHS.fmt.txt", dataItem.getIdentityString(), bmo.getIdentityString());
                throw new MetadataException(message);
            }
            if (ei.isString()) continue;
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DataItemExpectedOnLHS.fmt.txt", ei.getStringValue());
            throw new MetadataException(message);
        }
        if (dataItem == null) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoDataItemInFilter.txt", new Object[0]);
            throw new MetadataException(message);
        }
        int type = dataItem.getExpressionType();
        ArrayList<Object> members = new ArrayList<Object>();
        for (int i = indexOfCond + 1; i < idents.size(); ++i) {
            ExpressionIdentifier ei = (ExpressionIdentifier)idents.get(i);
            String value = ei.getStringValue();
            if (ei.isOlapMember()) {
                String value1 = "[" + value + "]";
                String value2 = value1.replaceAll("^[\\[]*", "[");
                String value3 = value2.replaceAll("[\\]]+$", "]");
                StringExpression memberExpression = new StringExpression();
                memberExpression.setText(value3);
                memberExpression.setExpressionType(type);
                members.add(memberExpression);
                continue;
            }
            if (ei.isResource()) {
                BusinessModelResource bmo = ei.getBusinessModelResource();
                if (!(bmo instanceof Prompt)) {
                    MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.OlapMemberExpectedOnRHS.fmt.txt", value);
                    throw new MetadataException(message);
                }
                Prompt prompt = (Prompt)bmo;
                members.add(prompt);
                continue;
            }
            if (ei.isString()) continue;
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.OlapMemberExpectedOnRHS.fmt.txt", value);
            throw new MetadataException(message);
        }
        MemberFilterExpression mfe = new MemberFilterExpression();
        mfe.setWhatToCompare((ExpressionInterface)dataItem);
        mfe.setIsNegated(isNegated);
        mfe.setMemberNames(members);
        _infoLogger.info("On return from parseForMemberFilterExpression() method.");
        return mfe;
    }

    public int setStoredProcess(String storedProcess, String storedProcessLoc) throws Exception {
        if (!this._hasDataSource) {
            return 1;
        }
        _infoLogger.info("In setStoredProcess() method.");
        StoredProcessInterface spi = null;
        storedProcessLoc = storedProcessLoc.trim();
        List spList = this._map.getAvailableStoredProcesses(true);
        boolean found = false;
        boolean hasLocation = storedProcessLoc != null && storedProcessLoc.trim().length() > 0;
        storedProcess = storedProcess.trim();
        if (storedProcess.length() == 0) {
            found = true;
        }
        if (hasLocation && !storedProcessLoc.endsWith(SLASH)) {
            storedProcessLoc = storedProcessLoc + SLASH;
        }
        Iterator it = spList.iterator();
        while (!found && it.hasNext()) {
            spi = (StoredProcessInterface)it.next();
            if (!spi.getName().equalsIgnoreCase(storedProcess)) continue;
            if (!hasLocation) {
                found = true;
                break;
            }
            PathUrl url = spi.getPathUrl();
            String sbipPath = SLASH + url.getRootTree() + SLASH;
            if (url.getPath() != null && !(sbipPath = sbipPath + url.getPath()).endsWith(SLASH)) {
                sbipPath = sbipPath + SLASH;
            }
            if (!sbipPath.equalsIgnoreCase(storedProcessLoc)) continue;
            found = true;
            break;
        }
        if (!found) {
            return 2;
        }
        List rules = this._map.getObjects(false, BusinessRule.class);
        for (BusinessRule rule : rules) {
            if (!(rule instanceof RunStoredProcess)) continue;
            this._map.removeBusinessRule(rule);
            break;
        }
        if (spi != null) {
            StoredProcess spr = (StoredProcess)JFSResourceFactory.newJFSResource((MetadataInterface)spi);
            RunStoredProcess rsp = this._map.newRunStoredProcess();
            rsp.setStoredProcess(spr);
            rsp.setLabel(spi.getName());
            this._map.addBusinessRule((BusinessRule)rsp);
        }
        _infoLogger.info("On return from setStoredProcess() method.");
        return 0;
    }

    private String setDataItemExpression(RootDataItem dItem, String expressionText, int exprType) throws MetadataException, DataServicesException {
        _infoLogger.info("In setDataItemExpression() method.");
        ExpressionInterface expression = null;
        String warning = null;
        try {
            expression = StringExpressionUtil.getInstance().newExpression((BusinessModel)this._map, expressionText, exprType, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
            if (!this._noVerify) {
                this._dataServices.verify((BusinessModel)this._map, expression);
            }
        }
        catch (DataServicesException e) {
            if (e.getReasonCode() == -2) {
                warning = _MVA_WarningFormatCode + e.getMessage() + _MVA_NewLineFormatCode;
            }
            throw e;
        }
        dItem.setExpression(expression);
        _infoLogger.info("On return from setDataItemExpression() method.");
        return warning;
    }

    private DataItem getDataItemFromColumn(String dsName, String columnName) throws MetadataException {
        _infoLogger.info("In getDataItemFromColumn() method.");
        RootDataItem dItem = null;
        DataSourceTable dsTable = (DataSourceTable)this._map.getDataSourceByID(dsName);
        if (dsTable == null) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidDataSource.fmt.txt", dsName);
            throw new MetadataException(message);
        }
        List columns = dsTable.getColumns();
        for (QualifiedColumn thisColumn : columns) {
            String column = thisColumn.getSasName();
            if (!columnName.equalsIgnoreCase(column)) continue;
            dItem = this._map.newDataItem((PhysicalResource)thisColumn, this._options);
            break;
        }
        if (dItem == null) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidColumn.fmt.txt", columnName, dsName);
            throw new MetadataException(message);
        }
        _infoLogger.info("On return from getDataItemFromColumn() method.");
        return dItem;
    }

    private void setPermissions(DataItem item, int rank, int sort, int filter, int navigate) throws MetadataException {
        StructureOfDataItem struct = item.getStructure();
        _infoLogger.info("In setPermissions() method.");
        if (struct == StructureOfDataItem.STRUCTURE_COLUMN || struct == StructureOfDataItem.STRUCTURE_DIMENSION || struct == StructureOfDataItem.STRUCTURE_HIERARCHY || struct == StructureOfDataItem.STRUCTURE_LEVEL) {
            boolean current_status;
            boolean supported;
            if (rank != 0 && (supported = rank == 1) != (current_status = item.isActionSupported(DataItemActionType.STEP_RANK))) {
                item.setActionSupported(DataItemActionType.STEP_RANK, supported);
            }
            if (sort != 0 && (supported = sort == 1) != this.getAllowedSortTypes(item).size() > 1) {
                item.setActionSupported(DataItemActionType.SORT_ASCENDING, supported);
                item.setActionSupported(DataItemActionType.SORT_DESCENDING, supported);
                item.setActionSupported(DataItemActionType.SORT_NONE, supported);
                if (struct != StructureOfDataItem.STRUCTURE_COLUMN) {
                    item.setActionSupported(DataItemActionType.SORT_CRITERIA, supported);
                    item.setActionSupported(DataItemActionType.SORT_HIERARCHICAL_ASCENDING, supported);
                    item.setActionSupported(DataItemActionType.SORT_HIERARCHICAL_DESCENDING, supported);
                }
                if (!supported) {
                    item.setActionSupported(DataItemActionType.SORT_NONE, true);
                }
            }
            if (struct == StructureOfDataItem.STRUCTURE_COLUMN && (filter != 0 || navigate != 0)) {
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.Permissions.RankAndSortOnly.fmt.txt", item.getIntraModelID());
                throw new MetadataException(message);
            }
            if (navigate != 0 && (supported = navigate == 1) != (current_status = item.isActionSupported(DataItemActionType.STEP_NAVIGATE))) {
                item.setActionSupported(DataItemActionType.STEP_NAVIGATE, supported);
            }
            if (filter != 0 && (supported = filter == 1) != (current_status = item.isActionSupported(DataItemActionType.STEP_MEMBER_FILTER))) {
                item.setActionSupported(DataItemActionType.STEP_DATABASED_FILTER, supported);
                item.setActionSupported(DataItemActionType.STEP_DATE_FILTER, supported);
                item.setActionSupported(DataItemActionType.STEP_MEMBER_FILTER, supported);
                item.setActionSupported(DataItemActionType.STEP_MEMBER_PROPERTY_FILTER, supported);
            }
        } else if (struct == StructureOfDataItem.STRUCTURE_MEASURE && (rank != 0 || sort != 0 || filter != 0 || navigate != 0)) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.Permissions.NotApplied.fmt.txt", item.getIntraModelID());
            throw new MetadataException(message);
        }
        _infoLogger.info("On return from setPermissions() method.");
    }

    private List getAllowedSortTypes(DataItem item) {
        List validActions = item.getSupportedActionsList();
        ArrayList<DataItemActionType> allowedSorts = new ArrayList<DataItemActionType>();
        Iterator actionIterator = validActions.iterator();
        StructureOfDataItem struct = item.getStructure();
        while (actionIterator.hasNext()) {
            DataItemActionType sortType = (DataItemActionType)actionIterator.next();
            if (sortType.equals(DataItemActionType.SORT_ASCENDING)) {
                allowedSorts.add(DataItemActionType.SORT_ASCENDING);
                continue;
            }
            if (sortType.equals(DataItemActionType.SORT_DESCENDING)) {
                allowedSorts.add(DataItemActionType.SORT_DESCENDING);
                continue;
            }
            if (sortType.equals(DataItemActionType.SORT_HIERARCHICAL_ASCENDING)) {
                allowedSorts.add(DataItemActionType.SORT_HIERARCHICAL_ASCENDING);
                continue;
            }
            if (!sortType.equals(DataItemActionType.SORT_HIERARCHICAL_DESCENDING)) continue;
            allowedSorts.add(DataItemActionType.SORT_HIERARCHICAL_DESCENDING);
        }
        if (struct != StructureOfDataItem.STRUCTURE_MEASURE) {
            allowedSorts.add(DataItemActionType.SORT_NONE);
        }
        return allowedSorts;
    }

    private Entity newEntity(String[] customProperties) throws MetadataException {
        int nAttr = customProperties.length / 3;
        Entity entity = new Entity();
        AttributeGroupInterface attGroup = entity.getAttributeGroup();
        for (int i = 0; i < nAttr; ++i) {
            AttributeDescriptor attrDesc = new AttributeDescriptor();
            attrDesc.setVisible(true);
            String name = customProperties[i * 3];
            if (attGroup.containsAttributeDescriptorNamed(name, false)) {
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NameNotUnique.fmt.txt", name);
                throw new MetadataException(message);
            }
            attrDesc.setName(customProperties[i * 3]);
            attrDesc.setType((AttributeTypeInterface)new AttributeType("String", 12));
            attrDesc.setDefault((Object)customProperties[i * 3 + 1]);
            String description = customProperties[i * 3 + 2] == null ? "" : customProperties[i * 3 + 2];
            Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale((SessionContextInterface)this._session);
            attrDesc.setDescription(viewerLocale, description);
            Locale computationalLocale = this.getComputationalLocale();
            if (!viewerLocale.equals(computationalLocale)) {
                attrDesc.setDescription(computationalLocale, description);
            }
            attGroup.addAttributeDescriptor((AttributeDescriptorInterface)attrDesc, i);
        }
        return entity;
    }

    private void validateImid(String imid) throws MetadataException {
        String imid2 = this._map.generateIntraModelID(imid);
        if (!imid.equalsIgnoreCase(imid2)) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NonUniqueID.fmt.txt", imid);
            MetadataException e = new MetadataException(errorMsg);
            throw e;
        }
    }

    public String[] updDataSource(String identifier, String imid, String label, String description, int requiredTable) throws MetadataException, DataServicesException, CloneNotSupportedException {
        String[] retInfo = new String[]{null};
        _infoLogger.info("In updDataSource() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        DataSource oldDS = this._map.getDataSourceByID(identifier);
        if (oldDS == null) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidDataSourceId.fmt.txt", identifier);
            throw new MetadataException(message);
        }
        DataSource newDS = (DataSource)oldDS.clone();
        if (imid != null) {
            if (!imid.equalsIgnoreCase(identifier)) {
                this.validateImid(imid);
            }
            newDS.setIntraModelID(imid);
        }
        if (label != null) {
            newDS.setLabel(label);
        }
        if (description != null) {
            newDS.setDescription(description);
        }
        ((CopyFromInterface)oldDS).copyFrom((Object)newDS);
        if (requiredTable != 0 && newDS instanceof DataSourceTable) {
            ArrayList<DataSource> dsTableList = new ArrayList<DataSource>();
            dsTableList.add(oldDS);
            this.setRequiredTables(dsTableList, requiredTable == 1 ? 4 : 8);
        }
        _infoLogger.info("On return from updDataSource() method.");
        return retInfo;
    }

    public String[] updDataItem(String[] stringArray, int[] intArray, String[][] objectArray) throws MetadataException, DataServicesException, SASFormatException, CloneNotSupportedException {
        Entity entity2;
        Entity entity;
        boolean emptyList;
        String currentFormat;
        String warning;
        this.checkStringArraySize(stringArray, 9);
        this.checkIntArraySize(intArray, 10);
        this.checkObjectArraySize((Object[])objectArray, 6);
        RootDataItem dataItem = null;
        String name = stringArray[0];
        String expressionText = stringArray[1];
        String desc = stringArray[3];
        String format = stringArray[4];
        String aggregation = stringArray[5];
        String identifier = stringArray[7];
        String imid = stringArray[8];
        String[] aggregationsToAdd = objectArray[0];
        String[] valuesList = objectArray[1];
        String[] customProperties = objectArray[2];
        String[] valuesToDelete = objectArray[3];
        String[] propertiesToDelete = objectArray[4];
        String[] aggregationsToRemove = objectArray[5];
        int exprType = intArray[0];
        int usageType = intArray[1];
        int rank = intArray[2];
        int sort = intArray[3];
        int navigate = intArray[4];
        int filter = intArray[5];
        int actionsOnAggregations = intArray[6];
        int lookupType = intArray[7];
        int actionsOnLookupList = intArray[8];
        int actionsOnCustomProperties = intArray[9];
        DataItemActionType actionType = null;
        String[] retInfo = new String[]{null, null};
        _infoLogger.info("In updDataItem() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        BusinessItem bItem = this._map.getBusinessItemByID(identifier);
        if (bItem == null || !(bItem instanceof DataItem)) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidDataItemId.fmt.txt", identifier);
            throw new MetadataException(message);
        }
        if (expressionText != null) {
            int type = ((RootDataItem)bItem).getExpression().getExpressionType();
            ExpressionInterface inputExpr = StringExpressionUtil.getInstance().newExpression((BusinessModel)this._map, expressionText, exprType, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
            List resources = inputExpr.getResources(DataItem.class, 65535);
            if (resources.contains(bItem)) {
                throw new MetadataException(BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DataItemExpressionCyclicReference.fmt.txt", bItem, inputExpr));
            }
        }
        dataItem = (RootDataItem)bItem.clone();
        if (imid != null) {
            if (!imid.equalsIgnoreCase(identifier)) {
                this.validateImid(imid);
            }
            dataItem.setIntraModelID(imid);
        }
        int savedDataItemType = dataItem.getExpressionType();
        if (this._hasDataSource && !this._isRelational && exprType != 0 && exprType != 2 && exprType != 3) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidExprType.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (name != null) {
            dataItem.setLabel(name);
        }
        boolean actionTypeChanged = false;
        actionType = dataItem.getUsage();
        if (usageType != 0) {
            if (actionType == DataItemActionType.USAGE_AGGREGATE) {
                if (usageType != 1) {
                    actionTypeChanged = true;
                    actionType = DataItemActionType.USAGE_CATEGORY;
                }
            } else if (actionType == DataItemActionType.USAGE_CATEGORY && usageType != 2) {
                actionTypeChanged = true;
                actionType = DataItemActionType.USAGE_AGGREGATE;
            }
        }
        if (actionTypeChanged) {
            dataItem.setUsage(actionType);
        }
        String savedFormat = dataItem.getFormat();
        boolean newType = false;
        if (expressionText != null || exprType != 0) {
            ExpressionInterface currentExpression = dataItem.getExpression();
            int type = currentExpression.getExpressionType();
            if (expressionText == null) {
                expressionText = StringExpressionUtil.getInstance().getText(currentExpression);
            }
            if (exprType == 0) {
                exprType = type;
            } else if (exprType != type) {
                newType = true;
            }
            StructureOfDataItem struct = dataItem.getStructure();
            if (struct == StructureOfDataItem.STRUCTURE_COLUMN || struct == StructureOfDataItem.STRUCTURE_DIMENSION || struct == StructureOfDataItem.STRUCTURE_HIERARCHY || struct == StructureOfDataItem.STRUCTURE_LEVEL) {
                if (rank == 0) {
                    int n = rank = dataItem.isActionSupported(DataItemActionType.STEP_RANK) ? 1 : 2;
                }
                if (sort == 0) {
                    int n = sort = dataItem.isActionSupported(DataItemActionType.SORT_ASCENDING) ? 1 : 2;
                }
                if (struct != StructureOfDataItem.STRUCTURE_COLUMN) {
                    if (filter == 0) {
                        int n = filter = dataItem.isActionSupported(DataItemActionType.STEP_MEMBER_FILTER) ? 1 : 2;
                    }
                    if (navigate == 0) {
                        navigate = dataItem.isActionSupported(DataItemActionType.STEP_NAVIGATE) ? 1 : 2;
                    }
                }
            }
            Function savedAggregation = dataItem.getAggregationType();
            List supportedAggregations = dataItem.getSupportedAggregationTypesList();
            List oldValidAggregations = dataItem.getValidAggregationTypes();
            warning = this.setDataItemExpression(dataItem, expressionText, exprType);
            if (warning != null) {
                retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
            }
            dataItem.setFormat(savedFormat);
            if (dataItem.getUsage() == DataItemActionType.USAGE_DETAIL) {
                dataItem.setUsage(actionType);
            }
            List validAggregations = dataItem.getValidAggregationTypes();
            boolean retainAggregations = validAggregations.equals(oldValidAggregations);
            for (int i = 0; i < validAggregations.size(); ++i) {
                Function function = (Function)validAggregations.get(i);
                if (retainAggregations) {
                    if (supportedAggregations.contains(function)) {
                        dataItem.setAggregationTypeSupported(function, true);
                    } else {
                        dataItem.setAggregationTypeSupported(function, false);
                    }
                } else {
                    dataItem.setAggregationTypeSupported(function, true);
                }
                if (function != savedAggregation) continue;
                dataItem.setAggregationType(savedAggregation);
                savedAggregation = null;
            }
            if (savedAggregation != null && aggregation == null) {
                this.configureAggFunctions((DataItem)dataItem);
            }
        }
        if (newType) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.SettingsChanged.fmt.txt", dataItem.getIntraModelID());
            warning = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
            String string = retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
        }
        if (desc != null) {
            dataItem.setDescription(desc);
        }
        if (lookupType > 0) {
            Lookup oldLookup = dataItem.getLookupType();
            LookupNotAllowed lookup = null;
            switch (lookupType) {
                case 1: {
                    if (oldLookup instanceof LookupNotAllowed) break;
                    lookup = new LookupNotAllowed();
                    break;
                }
                case 2: {
                    if (oldLookup instanceof LookupByDataItem) break;
                    lookup = new LookupByDataItem();
                    break;
                }
                case 3: {
                    LookupList oldLookupList = null;
                    LookupList lookupList = oldLookup instanceof LookupList ? (oldLookupList = (LookupList)oldLookup) : new LookupList();
                    lookup = lookupList;
                    if ((actionsOnLookupList & 8) == 8 && valuesToDelete != null) {
                        if (oldLookupList == null) {
                            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoDataItemCustomValues.fmt.txt", identifier);
                            warning = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
                            retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
                        } else {
                            this.deleteLookupValues(lookupList, valuesToDelete);
                        }
                    }
                    if ((actionsOnLookupList & 2) == 2) {
                        this.addLookupValues(lookupList, valuesList, true);
                    }
                    if ((actionsOnLookupList & 4) == 4 && valuesList != null) {
                        this.addLookupValues(lookupList, valuesList, false);
                    }
                    if (lookupList.getValuesList().size() != 0) break;
                    if (this._isRelational) {
                        lookup = new LookupNotAllowed();
                        break;
                    }
                    lookup = new LookupByDataItem();
                    break;
                }
            }
            if (lookup != null) {
                dataItem.setLookupType(lookup);
            }
        }
        if (dataItem.getUsage() != DataItemActionType.USAGE_AGGREGATE && (actionsOnAggregations != 0 || aggregation != null)) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoAggregation.fmt.txt", dataItem.getIntraModelID());
            throw new MetadataException(errorMsg);
        }
        if (aggregation != null || actionsOnAggregations != 0) {
            this.setAggregateForUpdate((DataItem)dataItem, aggregation, aggregationsToAdd, aggregationsToRemove, actionsOnAggregations);
        }
        if (format != null) {
            if (!format.isEmpty()) {
                boolean validFormat = this.isValidFormat((DataItem)dataItem, format, true);
                if (!validFormat) {
                    MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidFormat.fmt.txt", format, dataItem.getIntraModelID());
                    throw new MetadataException(message);
                }
                dataItem.setFormat(format);
            } else {
                dataItem.setFormat(null);
            }
        } else if (!(dataItem.getExpressionType() == savedDataItemType && !newType || (currentFormat = dataItem.getFormat()) != null && this.isValidFormat((DataItem)dataItem, currentFormat, false))) {
            this.setFormatValue((DataItem)dataItem);
        }
        if (rank != 0 || sort != 0 || filter != 0 || navigate != 0) {
            this.setPermissions((DataItem)dataItem, rank, sort, filter, navigate);
        }
        boolean bl = emptyList = (entity = (Entity)dataItem.getExtendedAttributes()) == null;
        if ((actionsOnCustomProperties & 1) == 1) {
            dataItem.setExtendedAttributes(null);
            emptyList = true;
        }
        if ((actionsOnCustomProperties & 8) == 8 && propertiesToDelete != null) {
            if (!emptyList) {
                this.deleteCustomAttributes(entity, propertiesToDelete);
            } else {
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoDataItemCustomAttributes.fmt.txt", identifier);
                warning = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
                String string = retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
            }
        }
        if ((actionsOnCustomProperties & 2) == 2) {
            Entity entityAttr = this.newEntity(customProperties);
            dataItem.setExtendedAttributes((EntityInterface)entityAttr);
        }
        if ((actionsOnCustomProperties & 4) == 4 && customProperties != null && (entity2 = this.addCustomAttributes(entity, customProperties)) != entity) {
            dataItem.setExtendedAttributes((EntityInterface)entity2);
        }
        ((CopyFromInterface)bItem).copyFrom((Object)dataItem);
        if (name != null) {
            MapFolder mapFolder = this._map.getMapFolderContaining(bItem);
            warning = this.checkDuplicateName(dataItem.getIntraModelID(), name, RootDataItem.class, mapFolder);
            if (warning != null) {
                retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
            }
        }
        _infoLogger.info("On return from updDataItem() method.");
        return retInfo;
    }

    public String[] updFilter(String identifier, String filterName, String condition, String description, String imid, int actionOnCustomProperties, String[] customProperties, String[] propertiesToDelete, boolean hidden) throws MetadataException, DataServicesException, CloneNotSupportedException {
        Entity entity2;
        Entity entity;
        boolean emptyList;
        boolean isHidden;
        FilterItem filterItem = null;
        String[] retInfo = new String[]{null};
        _infoLogger.info("In updFilter() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        BusinessItem bItem = this._map.getBusinessItemByID(identifier);
        if (bItem == null || !(bItem instanceof FilterItem)) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidFilterId.fmt.txt", identifier);
            throw new MetadataException(message);
        }
        filterItem = (FilterItem)bItem.clone();
        if (imid != null) {
            if (!imid.equalsIgnoreCase(identifier)) {
                this.validateImid(imid);
            }
            filterItem.setIntraModelID(imid);
        }
        if (filterName != null) {
            filterItem.setLabel(filterName);
        }
        if (description != null) {
            filterItem.setDescription(description);
        }
        if ((isHidden = filterItem.isHidden()) != hidden) {
            filterItem.setIsHidden(hidden);
        }
        if (condition != null) {
            if (this._isRelational) {
                ExpressionInterface expression = IQModelImplUtilities.newPredicate((BusinessModel)this._map, (String)condition, (ResourceScope)ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
                filterItem.setExpression(expression);
            } else {
                ResourceAwareStringExpression rase = (ResourceAwareStringExpression)StringExpressionUtil.getInstance().newExpression((BusinessModel)this._map, condition);
                MemberFilterExpression filterExpression = this.parseForMemberFilterExpression(rase);
                filterItem.setExpression((ExpressionInterface)filterExpression);
            }
        }
        boolean bl = emptyList = (entity = (Entity)filterItem.getExtendedAttributes()) == null;
        if ((actionOnCustomProperties & 1) == 1) {
            filterItem.setExtendedAttributes(null);
            emptyList = true;
        }
        if ((actionOnCustomProperties & 8) == 8 && propertiesToDelete != null) {
            if (!emptyList) {
                this.deleteCustomAttributes(entity, propertiesToDelete);
            } else {
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoFilterCustomAttributes.fmt.txt", identifier);
                retInfo[0] = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
            }
        }
        if ((actionOnCustomProperties & 2) == 2) {
            Entity entityAttr = this.newEntity(customProperties);
            filterItem.setExtendedAttributes((EntityInterface)entityAttr);
        }
        if ((actionOnCustomProperties & 4) == 4 && customProperties != null && (entity2 = this.addCustomAttributes(entity, customProperties)) != entity) {
            filterItem.setExtendedAttributes((EntityInterface)entity2);
        }
        if (!this._noVerify) {
            _infoLogger.info("In verifying a FilterItem.");
            this._dataServices.verify((BusinessItem)filterItem);
            _infoLogger.info("On return from verifying a FilterItem.");
        }
        ((CopyFromInterface)bItem).copyFrom((Object)filterItem);
        if (filterName != null) {
            MapFolder mapFolder = this._map.getMapFolderContaining(bItem);
            String warning = this.checkDuplicateName(filterItem.getIntraModelID(), filterName, FilterItem.class, mapFolder);
            if (warning != null) {
                retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
            }
        }
        _infoLogger.info("On return from  updFilter() method.");
        return retInfo;
    }

    public String[] updFolder(String identifier, String location, String newFolderName, String description, int actionOnCustomProperties, String[] customProperties, String[] propertiesToDelete) throws MetadataException {
        String warning;
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        String[] retInfo = new String[]{null};
        _infoLogger.info("In updFolder() method.");
        MapFolder parentFolder = this.getMapFolder(location, false);
        MapFolder folder = parentFolder.getSubfolder(identifier);
        if (folder == null) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidFolderId.fmt.txt", identifier);
            throw new MetadataException(message);
        }
        if (newFolderName != null) {
            if (parentFolder.getSubfolder(newFolderName) != null) {
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DuplicateFolderName.fmt.txt", newFolderName);
                throw new MetadataException(message);
            }
            folder.setLabel(newFolderName);
        }
        String oldDescription = null;
        if (description != null) {
            oldDescription = folder.getDescription();
            folder.setDescription(description);
        }
        Entity oldEntity = (Entity)folder.getExtendedAttributes();
        Entity entity = null;
        boolean emptyList = oldEntity == null;
        try {
            if ((actionOnCustomProperties & 1) == 1) {
                folder.setExtendedAttributes(null);
                emptyList = true;
            }
            if (!emptyList) {
                entity = (Entity)Utils.copy((EntityInterface)oldEntity);
            }
            if ((actionOnCustomProperties & 8) == 8 && propertiesToDelete != null) {
                if (!emptyList) {
                    this.deleteCustomAttributes(entity, propertiesToDelete);
                    folder.setExtendedAttributes((EntityInterface)entity);
                } else {
                    MessageFormatter messageFormatter = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoFolderCustomAttributes.fmt.txt", identifier);
                    warning = _MVA_WarningFormatCode + messageFormatter + _MVA_NewLineFormatCode;
                    String string = retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
                }
            }
            if ((actionOnCustomProperties & 2) == 2) {
                Entity entityAttr = this.newEntity(customProperties);
                folder.setExtendedAttributes((EntityInterface)entityAttr);
            }
            if ((actionOnCustomProperties & 4) == 4 && customProperties != null) {
                Entity entity2 = this.addCustomAttributes(entity, customProperties);
                folder.setExtendedAttributes((EntityInterface)entity2);
            }
        }
        catch (MetadataException e) {
            if (newFolderName != null) {
                folder.setLabel(identifier);
            }
            if (description != null) {
                folder.setDescription(oldDescription);
            }
            throw e;
        }
        if (this.countOfFolderName(parentFolder, newFolderName) > 1) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DupFolderName.fmt.txt", newFolderName, parentFolder.getDisplayPath());
            warning = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
            retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
        }
        _infoLogger.info("On return from updFolder() method.");
        return retInfo;
    }

    public String[] updRelationship(String identifier, int type, String conditions, String description, String imid, int cardinalityType, int actionOnCustomProperties, String[] customProperties, String[] propertiesToDelete) throws MetadataException, DataServicesException, DataRetrievalException, CloneNotSupportedException {
        Entity entity;
        _infoLogger.info("In updRelationship() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        Join join = null;
        String[] retInfo = new String[]{null};
        BusinessRule bRule = this._map.getBusinessRuleByID(identifier);
        if (bRule == null || !(bRule instanceof Join)) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidJoinId.fmt.txt", identifier);
            throw new MetadataException(message);
        }
        join = (Join)bRule;
        Join clonedJoin = (Join)join.clone();
        if (imid != null) {
            if (!imid.equalsIgnoreCase(identifier)) {
                this.validateImid(imid);
            }
            join.setIntraModelID(imid);
        }
        if (type != 0) {
            switch (type) {
                case 1: {
                    join.setType(JoinType.INNER);
                    break;
                }
                case 2: {
                    join.setType(JoinType.LEFT);
                    break;
                }
                case 3: {
                    join.setType(JoinType.RIGHT);
                    break;
                }
                case 4: {
                    join.setType(JoinType.FULL);
                    break;
                }
                case 5: {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.UnsupportedOperationException.fmt.txt", "JOIN TYPE CROSS");
                    throw new MetadataException(errorMsg);
                }
            }
        }
        if (description != null && description.length() != 0) {
            join.setDescription(description);
        }
        if (conditions != null) {
            ExpressionInterface expression = StringExpressionUtil.getInstance().newExpression((BusinessModel)this._map, conditions, 9, ResourceScope.PHYSICAL_SCOPE);
            ConditionalExpressionAdapter jce = new ConditionalExpressionAdapter();
            jce.setExpression(expression);
            join.setJoinCondition((ConditionalExpression)jce);
        }
        if (cardinalityType != 0) {
            switch (cardinalityType) {
                case 1: {
                    join.setCardinality(Cardinality.ONE_TO_ONE);
                    break;
                }
                case 2: {
                    join.setCardinality(Cardinality.ONE_TO_MANY);
                    break;
                }
                case 3: {
                    join.setCardinality(Cardinality.MANY_TO_ONE);
                    break;
                }
                case 4: {
                    join.setCardinality(Cardinality.MANY_TO_MANY);
                    break;
                }
                case 5: {
                    join.setCardinality(Cardinality.UNKNOWN);
                    break;
                }
            }
        }
        boolean emptyList = (entity = (Entity)join.getExtendedAttributes()) == null;
        try {
            Entity entity2;
            if ((actionOnCustomProperties & 1) == 1) {
                join.setExtendedAttributes(null);
                emptyList = true;
            }
            if ((actionOnCustomProperties & 8) == 8 && propertiesToDelete != null) {
                if (!emptyList) {
                    this.deleteCustomAttributes(entity, propertiesToDelete);
                } else {
                    MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoJoinCustomAttributes.fmt.txt", identifier);
                    retInfo[0] = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
                }
            }
            if ((actionOnCustomProperties & 2) == 2) {
                Entity entityAttr = this.newEntity(customProperties);
                join.setExtendedAttributes((EntityInterface)entityAttr);
            }
            if ((actionOnCustomProperties & 4) == 4 && customProperties != null && (entity2 = this.addCustomAttributes(entity, customProperties)) != entity) {
                join.setExtendedAttributes((EntityInterface)entity2);
            }
        }
        catch (MetadataException mde) {
            ((CopyFromInterface)join).copyFrom((Object)clonedJoin);
            throw mde;
        }
        if (this._noVerify) {
            _infoLogger.info("On return from updRelationship() method.");
            return retInfo;
        }
        boolean ok = false;
        try {
            _infoLogger.info("In verifying a relationship.");
            this._dataServices.verify(join);
            _infoLogger.info("Return from verifying a relationship.");
            ok = true;
        }
        catch (DataServicesException dse) {
            throw dse;
        }
        catch (DataRetrievalException dre) {
            throw dre;
        }
        catch (MetadataException mde) {
            throw mde;
        }
        finally {
            if (!ok) {
                ((CopyFromInterface)join).copyFrom((Object)clonedJoin);
            }
        }
        _infoLogger.info("On return from updRelationship() method.");
        return retInfo;
    }

    public String[] setGeneralFilterSet(String[][] filters, String imid) throws MetadataException, DataServicesException, CloneNotSupportedException {
        String[] retInfo = new String[]{null};
        _infoLogger.info("In setGeneralFilterSet() method.");
        FilterSetRulesContainer fsrContainer = (FilterSetRulesContainer)this._map;
        FilterSet currentFilterSet = fsrContainer.getGeneralFilterSet();
        if (currentFilterSet != null) {
            if (imid == null) {
                imid = currentFilterSet.getIntraModelID();
            }
            this._map.removeBusinessRule((BusinessRule)currentFilterSet);
        }
        if (filters == null) {
            fsrContainer.setGeneralFilterSet(null);
            return retInfo;
        }
        FilterSet filterSet = this.newFilterSet(filters, imid);
        fsrContainer.setGeneralFilterSet(filterSet);
        this._map.addBusinessRule((BusinessRule)filterSet);
        _infoLogger.info("On return from setGeneralFilterSet() method.");
        return retInfo;
    }

    public String[] updateRLP(int[] perms, int type, String identityName, String[][] filters) throws Exception {
        String[] retInfo = new String[]{null};
        _infoLogger.info("In updateRLP() method.");
        BriefInformationMap briefMap = this._map.getBriefMap();
        if (briefMap == null) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoSaveNoRLP.txt", new Object[0]);
            throw new MetadataException(message);
        }
        Transformation newMapTrans = (Transformation)briefMap.getRepositoryEntity();
        MdFactory mdFactory = newMapTrans.getObjectStore().getFactory();
        IOMI OMRConnection = mdFactory.getConnection().getCMRHandle();
        ISecurityAdmin iSecAdmin = null;
        if (OMRConnection != null) {
            org.omg.CORBA.Object obj = OMRConnection._duplicate();
            iSecAdmin = ISecurityAdminHelper.narrow((org.omg.CORBA.Object)obj);
        }
        if (iSecAdmin == null) {
            throw new MdException("Unable to connect to ISecurityAdmin server");
        }
        String identityType = type == 1 ? "IdentityGroup" : "Person";
        String[][] identities = new String[][]{{identityType, identityName}};
        VariableArray2dOfAnyHolder currentAuthorizations = new VariableArray2dOfAnyHolder();
        String OMR_URI_TRANSFORMATION_PREFIX = "OMSOBJ:Transformation/";
        String reposId = briefMap.getReposId();
        String resourceURI = "OMSOBJ:Transformation/" + reposId;
        iSecAdmin.GetAuthorizationsOnObj("", resourceURI, 0, identities, "ReadMetadata, WriteMetadata, Read", currentAuthorizations);
        FilterSet filterSet = null;
        String oldCondition = "";
        BusinessRule oldResource = null;
        Any[][] authorizations = currentAuthorizations.value;
        oldCondition = this.getPermCondition(iSecAdmin, authorizations);
        String condition = "";
        if (filters != null) {
            filterSet = this.newFilterSet(filters, oldCondition);
            condition = filterSet.getIntraModelID();
        }
        int nAuths = 0;
        for (int i = 0; i < perms.length; ++i) {
            if (perms[i] == 0) continue;
            ++nAuths;
        }
        if (nAuths == 0) {
            return retInfo;
        }
        String[][] auths = new String[][]{};
        auths = new String[nAuths][5];
        int n = 0;
        for (int i = 0; i < perms.length; ++i) {
            String permName;
            String permDirective;
            if (perms[i] == 0) continue;
            String string = perms[i] == 1 ? "G" : (permDirective = perms[i] == 2 ? "D" : "R");
            String string2 = i == 0 ? "ReadMetadata" : (permName = i == 1 ? "WriteMetadata" : "Read");
            if (permDirective == "R") {
                int permVal = authorizations[i][2].extract_long();
                if ((permVal & 3) <= 0) {
                    MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoOpForRemove.fmt.txt", permName, this._map, identityName);
                    String warning = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
                    retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
                }
            }
            auths[n][0] = identityType;
            auths[n][1] = identityName;
            auths[n][2] = permDirective;
            auths[n][3] = permName;
            auths[n][4] = permName.equals("Read") ? condition : "";
            ++n;
        }
        iSecAdmin.SetAuthorizationsOnObj("", resourceURI, 0, auths);
        iSecAdmin.GetAuthorizationsOnObj("", resourceURI, 0, identities, "Read", currentAuthorizations);
        authorizations = currentAuthorizations.value;
        condition = this.getPermCondition(iSecAdmin, authorizations);
        iSecAdmin._release();
        iSecAdmin = null;
        if (oldCondition.length() != 0) {
            oldResource = this._map.getBusinessRuleByID(oldCondition);
        }
        if (condition.length() != 0) {
            if (oldResource != null && oldCondition.equalsIgnoreCase(condition)) {
                this._map.replaceResource((BusinessModelResource)oldResource, (BusinessModelResource)filterSet);
            } else {
                this._map.addBusinessRule((BusinessRule)filterSet);
            }
        } else if (oldResource != null) {
            this._map.removeBusinessRule(oldResource);
        }
        _infoLogger.info("On return from updateRLP() method.");
        return retInfo;
    }

    public Object[] importLocProperties(String[] SasLocales, String locPropFileName) throws Exception {
        Object[] retInfo = new Object[]{null};
        _infoLogger.info("In importLocProperties() method.");
        if (locPropFileName == null || locPropFileName.trim().length() == 0) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidFileName.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (SasLocales == null || SasLocales.length == 0) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.LocaleMissing.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        File localizablePropertiesFile = this.getLocPropFile(locPropFileName, false);
        File parentDir = localizablePropertiesFile.getParentFile();
        String baseName = localizablePropertiesFile.getName();
        if (baseName.endsWith(LOCALIZABLE_FILE_EXTENSION)) {
            baseName = baseName.substring(0, baseName.length() - LOCALIZABLE_FILE_EXTENSION.length());
        }
        LinkedHashMap<Locale, SectionedPropertyMap> sectionMaps = new LinkedHashMap<Locale, SectionedPropertyMap>();
        Set mapsForImport = new HashSet();
        for (int j = 0; j < SasLocales.length; ++j) {
            Locale locale = IOMServerUtils.ConvertSASLocaleToJavaLocale((String)SasLocales[j]);
            if (locale == null) continue;
            SectionedPropertyMap sections = this.loadLocalizedProperties(locale, parentDir, baseName);
            sectionMaps.put(locale, sections);
            mapsForImport = this.getMapsForImport(sections, mapsForImport);
        }
        Set locales = sectionMaps.keySet();
        if (this._map != null) {
            BriefInformationMap briefMap = this._map.getBriefMap();
            if (briefMap == null) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoSaveNoImport.fmt.txt", this._map);
                throw new MetadataException(errorMsg);
            }
            String mapAbsoluteName = this.getMapAbsolutePathName(briefMap);
            if (mapsForImport.contains(mapAbsoluteName)) {
                this.setLocalizedProperties(this._map, mapAbsoluteName, sectionMaps, locales);
            } else {
                MessageFormatter message1 = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoMapEntry.fmt.txt", mapAbsoluteName);
                String warning = _MVA_WarningFormatCode + message1 + _MVA_NewLineFormatCode;
                retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
            }
            return retInfo;
        }
        for (String mapAbsoluteName : mapsForImport) {
            InformationMap iqMap;
            PathUrl pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._server, (String)mapAbsoluteName);
            try {
                iqMap = InformationMapFactory.getInstance().newInformationMap(this._session, this._service, pathUrl);
            }
            catch (Exception e) {
                MessageFormatter message2 = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoMapEntry.fmt.txt", mapAbsoluteName);
                String warning = _MVA_WarningFormatCode + message2 + _MVA_NewLineFormatCode;
                retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
                continue;
            }
            ((InformationMapImpl2)iqMap).beginLocalization();
            this.setLocalizedProperties(iqMap, mapAbsoluteName, sectionMaps, locales);
            ((InformationMapImpl2)iqMap).endLocalization();
            iqMap.dispose();
        }
        _infoLogger.info("On return from importLocProperties() method.");
        return retInfo;
    }

    public Object[] exportLocProperties(String[][] mapLocations, boolean[] drops, String locPropFileName, boolean recursive) throws Exception {
        FolderInterface folder = this._folder;
        Object map = null;
        Object[] retInfo = new Object[]{null};
        _infoLogger.info("In iexortLocProperties() method.");
        if (locPropFileName == null || locPropFileName.trim().length() == 0) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidFileName.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        MessageFormatter comment = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.LocPropFileComment.txt", new Object[0]);
        SectionedPropertyList sections = new SectionedPropertyList(comment.toString());
        if (mapLocations == null && drops == null && this._map != null) {
            String absoluteName;
            this.writeLocPropHeader(sections);
            PropertyList locProperties = ((InformationMapImpl2)this._map).getLocalizableProperties(null);
            BriefInformationMap briefMap = this._map.getBriefMap();
            if (briefMap == null) {
                absoluteName = this._map.getLabel();
                comment = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MapNotPersisted.fmt.txt", absoluteName);
                locProperties.addComment(comment.toString());
            } else {
                absoluteName = this.getMapAbsolutePathName(briefMap);
            }
            sections.addSection(absoluteName, locProperties);
            this.writeToLocPropFile(sections, locPropFileName);
            return retInfo;
        }
        if (mapLocations != null && this._map != null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.AnotherMapOpen.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        boolean firstSection = true;
        for (int i = 0; mapLocations != null && i < mapLocations.length && mapLocations[i] != null; ++i) {
            List exportList;
            String warning;
            String[] mapArray = mapLocations[i];
            String mapPath = mapArray[0];
            try {
                folder = this.getMetadataInterface(mapPath, false);
            }
            catch (Exception e) {
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter(_invalidFolderMsg, mapPath);
                warning = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
                retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
                continue;
            }
            Object[] retInfo2 = this.getMapsForExport(mapArray, drops[i], folder);
            if (retInfo2[0] != null) {
                warning = (String)retInfo2[0];
                Object object = retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
            }
            if ((exportList = (List)retInfo2[1]) == null || exportList.size() == 0) {
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MapMissing.fmt.txt", mapPath);
                warning = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
                retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
                continue;
            }
            if (firstSection) {
                this.writeLocPropHeader(sections);
                firstSection = false;
            }
            for (OMRBriefInformationMap briefInfoMap : exportList) {
                PropertyList locProperties = briefInfoMap.getLocalizableProperties();
                String absoluteName = this.getMapAbsolutePathName((BriefInformationMap)briefInfoMap);
                sections.addSection(absoluteName, locProperties);
            }
            if (!recursive) continue;
        }
        this.writeToLocPropFile(sections, locPropFileName);
        _infoLogger.info("On return from iexortLocProperties() method.");
        return retInfo;
    }

    private void setLocalizedProperties(InformationMap imap, String mapAbsoluteName, LinkedHashMap localeSections, Collection locales) throws Exception {
        for (Locale locale : locales) {
            SectionedPropertyMap sections = (SectionedPropertyMap)localeSections.get(locale);
            PropertyMap locPropertyMap = sections.getSection(mapAbsoluteName);
            if (locPropertyMap == null) continue;
            ((InformationMapImpl2)imap).setLocalizableProperties(locale, locPropertyMap);
        }
    }

    private void writeLocPropHeader(SectionedPropertyList sections) {
        PropertyList locProperties = new PropertyList();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        locProperties.addProperty("ExportTime", sdf.format(cal.getTime()));
        sections.addSection("", locProperties);
    }

    private Set getMapsForImport(SectionedPropertyMap propertyMap, Set mapsForImport) {
        Collection sectionList = propertyMap.getSections();
        Iterator iterator = sectionList.iterator();
        ArrayList<String> sectionsToRemove = new ArrayList<String>();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key.endsWith("(InformationMap)")) continue;
            sectionsToRemove.add(key);
        }
        if (!sectionsToRemove.isEmpty()) {
            sectionList.removeAll(sectionsToRemove);
        }
        mapsForImport.addAll(sectionList);
        return mapsForImport;
    }

    private Object[] getMapsForExport(String[] mapArray, boolean toDrop, FolderInterface folder) throws Exception {
        ArrayList<OMRBriefInformationMap> completeList = folder.getItemsByType("InformationMap");
        Collections.sort(completeList, MAPNAME_COMPARATOR);
        Object[] retInfo = new Object[]{null, null};
        if (mapArray.length == 1) {
            retInfo[1] = completeList.size() == 0 ? null : completeList;
            return retInfo;
        }
        ArrayList<OMRBriefInformationMap> selectedMaps = !toDrop ? new ArrayList<OMRBriefInformationMap>() : completeList;
        block0: for (int i = 1; i < mapArray.length; ++i) {
            OMRBriefInformationMap briefMap = (OMRBriefInformationMap)folder.getItemByType(mapArray[i], "InformationMap");
            if (briefMap == null) {
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MapNotExistsError.fmt.txt", mapArray[i], folder.getPath());
                String warning = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
                retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
                continue;
            }
            String reposIdFind = briefMap.getReposId();
            for (OMRBriefInformationMap bmap : completeList) {
                String reposIdTest = bmap.getReposId();
                if (!reposIdFind.equals(reposIdTest)) continue;
                if (!toDrop) {
                    selectedMaps.add(bmap);
                    continue block0;
                }
                selectedMaps.remove(bmap);
                continue block0;
            }
        }
        retInfo[1] = selectedMaps.size() == 0 ? null : selectedMaps;
        return retInfo;
    }

    private FilterSet newFilterSet(String[][] filtersArray, String imid) throws MetadataException {
        _infoLogger.info("In newFilterSet() method.");
        FilterSet filterSet = null;
        if (imid != null && imid.length() != 0) {
            filterSet = (FilterSet)this._map.getBusinessRuleByID(imid);
        }
        FilterSetRulesContainer fsrContainer = (FilterSetRulesContainer)this._map;
        if (filterSet == null) {
            filterSet = fsrContainer.newFilterSet();
            if (imid != null && imid.length() != 0) {
                this.validateImid(imid);
                filterSet.setIntraModelID(imid);
            }
        } else {
            this._map.removeBusinessRule((BusinessRule)filterSet);
        }
        for (int i = 0; i < filtersArray.length; ++i) {
            String[] dsFilters = filtersArray[i];
            DataSource ds = this._map.getDataSourceByID(dsFilters[0]);
            if (ds == null || !(ds instanceof DataSourceTable)) {
                MessageFormatter errorMsg = ds == null ? BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidDataSourceId.fmt.txt", dsFilters[0]) : BaseIntegResourceBundle.getMessageFormatter("FilterSetQueryGeneration._generateFilteredDataSelection.CannotFilterNonRelationalTables.fmt.txt", dsFilters[0]);
                throw new MetadataException(errorMsg);
            }
            FilterSetMember filterSetMember = (FilterSetMember)ds;
            ArrayList<FilterItem> preFilterList = new ArrayList<FilterItem>();
            ArrayList postFilterList = null;
            String startOfPostFilters = "...";
            ArrayList<FilterItem> filterList = preFilterList;
            for (int j = 1; j < dsFilters.length; ++j) {
                String filterName = dsFilters[j];
                if ("...".equals(filterName)) {
                    postFilterList = new ArrayList();
                    filterList = postFilterList;
                    continue;
                }
                FilterItem filter = (FilterItem)this._map.getBusinessItemByID(filterName);
                if (filter == null) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidFilterId.fmt.txt", dsFilters[j]);
                    throw new MetadataException(errorMsg);
                }
                List prompts = filter.getPrompts(-1);
                for (Prompt prompt : prompts) {
                    PromptDefinitionInterface pd = prompt.getPromptDefinition();
                    List di = pd.getReferencedResources(DataItem.class, true);
                    if (di == null || di.isEmpty()) continue;
                    throw new MetadataException(BaseIntegResourceBundle.getMessageFormatter("FilterSetQueryGeneration._generateFilteredDataSelection.DynamicPromptCannotBaseOnDateItem.txt", new Object[0]));
                }
                if (filterList.contains(filter)) continue;
                filterList.add(filter);
            }
            FilterSetRuleItems combinedRuleItems = this.createRuleItems(fsrContainer, preFilterList, postFilterList);
            filterSet.setFilterSetRuleItems(filterSetMember, combinedRuleItems);
        }
        _infoLogger.info("On return from newFilterSet() method.");
        return filterSet;
    }

    FilterSetRuleItems createRuleItems(FilterSetRulesContainer fsrContainer, List preFilterList, List postFilterList) throws MetadataException {
        FilterSetRuleItems ruleItems = null;
        FilterSetRuleItems preRuleItems = null;
        if (preFilterList != null && preFilterList.size() > 0) {
            preRuleItems = fsrContainer.newFilterSetRuleItems(preFilterList, false);
        }
        FilterSetRuleItems postRuleItems = null;
        if (postFilterList != null && postFilterList.size() > 0) {
            postRuleItems = fsrContainer.newFilterSetRuleItems(postFilterList, false);
            postRuleItems.setPostFilters(true);
        }
        if (preRuleItems != null && postRuleItems != null) {
            ArrayList<FilterSetRuleItems> allList = new ArrayList<FilterSetRuleItems>();
            allList.add(preRuleItems);
            allList.add(postRuleItems);
            ruleItems = fsrContainer.newFilterSetRuleItems(allList, false);
        } else if (preRuleItems != null) {
            ruleItems = preRuleItems;
        } else if (postRuleItems != null) {
            ruleItems = postRuleItems;
        }
        return ruleItems;
    }

    private String getPermCondition(ISecurityAdmin iSecAdmin, Any[][] authorizations) {
        String pc = "";
        for (int i = 0; i < authorizations.length; ++i) {
            String permName = authorizations[i][3].extract_string();
            if (!permName.equalsIgnoreCase("Read")) continue;
            int permType = authorizations[i][2].extract_long();
            if (permType != 2) continue;
            pc = authorizations[i][4].extract_string();
            break;
        }
        return pc;
    }

    private String printRuleItems(FilterSetRulesContainer fsrContainer, FilterSetMember filterSetMember) throws MetadataException {
        StringBuilder sBuilder = new StringBuilder("[FSM: ");
        sBuilder.append(filterSetMember.toString()).append("]\n[FSRC: ");
        sBuilder.append(fsrContainer.toString()).append("]\n");
        FilterSetRuleItems combined = fsrContainer.getCombinedFilterSetRuleList(filterSetMember);
        this.printFilterSetRuleItems(combined, "  ", sBuilder);
        return sBuilder.append("\n").toString();
    }

    private void printFilterSetRuleItems(FilterSetRuleItems fsri, String indent, StringBuilder sBuilder) throws MetadataException {
        sBuilder.append(indent).append("[FSRI: ").append(fsri.isPostFilters() ? "isPostList=True,\n" : "'n");
        sBuilder.append(indent).append("  items={\n");
        List items = fsri.getList();
        for (Object item : items) {
            if (item instanceof FilterSetRuleItems) {
                this.printFilterSetRuleItems((FilterSetRuleItems)item, indent + "    ", sBuilder);
                continue;
            }
            sBuilder.append(indent).append("    ").append(item != null ? "(" + item.getClass().getSimpleName() + ") " : "").append(item);
            sBuilder.append(item instanceof BusinessModelObject ? " [" + ((BusinessModelObject)item).getID() + "]\n" : "\n");
        }
        sBuilder.append(indent).append("  }").append(fsri.isUnionList() ? ", isUnion=True\n" : "\n");
        sBuilder.append(indent).append("]\n");
    }

    private String editCustomProperties(int actions, String[] listToAdd, String[] listToRemove) throws MetadataException {
        Entity entity2;
        boolean emptyList;
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        Entity entity = (Entity)this._map.getExtendedAttributes();
        boolean bl = emptyList = entity == null;
        if (!emptyList && (actions & 1) == 1) {
            this._map.setExtendedAttributes(null);
            emptyList = true;
        }
        String msgText = null;
        if ((actions & 8) == 8) {
            if (!emptyList) {
                this.deleteCustomAttributes(entity, listToRemove);
            } else {
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoMapCustomAttributes.txt", new Object[0]);
                msgText = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
            }
        }
        if ((actions & 2) == 2) {
            Entity entityAttr = this.newEntity(listToAdd);
            this._map.setExtendedAttributes((EntityInterface)entityAttr);
        }
        if ((actions & 4) == 4 && (entity2 = this.addCustomAttributes(entity, listToAdd)) != entity) {
            this._map.setExtendedAttributes((EntityInterface)entity2);
        }
        return msgText;
    }

    private String editRequiredTables(int actions, String[] listToAdd, String[] listToRemove) throws MetadataException {
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        ArrayList<DataSource> dsTablesToAdd = null;
        if (listToAdd != null && listToAdd.length > 0) {
            dsTablesToAdd = new ArrayList<DataSource>(listToAdd.length);
            for (int i = 0; i < listToAdd.length; ++i) {
                DataSource dsTable = this._map.getDataSourceByID(listToAdd[i]);
                if (dsTable == null) {
                    MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidDataSourceId.fmt.txt", listToAdd[i]);
                    throw new MetadataException(message);
                }
                if (dsTablesToAdd.contains(dsTable)) continue;
                dsTablesToAdd.add(dsTable);
            }
        }
        ArrayList<DataSource> dsTablesToRemove = null;
        if (listToRemove != null && listToRemove.length > 0) {
            dsTablesToRemove = new ArrayList<DataSource>(listToRemove.length);
            for (int i = 0; i < listToRemove.length; ++i) {
                DataSource dsTable = this._map.getDataSourceByID(listToRemove[i]);
                if (dsTable == null) {
                    MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidDataSourceId.fmt.txt", listToRemove[i]);
                    throw new MetadataException(message);
                }
                if (dsTablesToRemove.contains(dsTable)) continue;
                dsTablesToRemove.add(dsTable);
            }
        }
        List dataSources = null;
        List rdsList = this._map.getObjects(false, RequiredDataSources.class);
        RequiredDataSources requiredDS = null;
        String message = null;
        if (rdsList != null && rdsList.size() > 0) {
            requiredDS = (RequiredDataSources)rdsList.get(rdsList.size() - 1);
            dataSources = requiredDS.getDataSources();
        }
        if ((actions & 1) == 1) {
            dataSources = null;
        }
        if ((actions & 0x10) == 16) {
            dataSources = this._map.getObjects(false, DataSourceTable.class);
        }
        if ((actions & 8) == 8 && dsTablesToRemove != null) {
            if (dataSources == null) {
                String warning;
                MessageFormatter message1 = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoRequiredDataSources.fmt.txt", this._map);
                message = warning = _MVA_WarningFormatCode + message1 + _MVA_NewLineFormatCode;
            } else {
                dataSources = this.setRequiredTables(dataSources, dsTablesToRemove, 8);
            }
        }
        if ((actions & 2) == 2) {
            dataSources = dsTablesToAdd;
        }
        if ((actions & 4) == 4 && dsTablesToAdd != null) {
            dataSources = this.setRequiredTables(dataSources, dsTablesToAdd, 4);
        }
        if (requiredDS == null) {
            if (dataSources != null && dataSources.size() > 0) {
                requiredDS = this._map.newRequiredDataSources();
                requiredDS.setDataSources(dataSources);
                this._map.addBusinessRule((BusinessRule)requiredDS);
            }
        } else if (dataSources != null && dataSources.size() > 0) {
            requiredDS.setDataSources(dataSources);
        } else if (dataSources == null || dataSources.size() == 0) {
            this._map.removeBusinessRule((BusinessRule)requiredDS);
        }
        return message;
    }

    private Entity addCustomAttributes(Entity entity, String[] customProperties) throws MetadataException {
        int nAttr = customProperties.length / 3;
        AttributeDescriptor[] attrDesc = new AttributeDescriptor[nAttr];
        if (entity == null) {
            entity = new Entity();
        }
        AttributeGroupInterface attGroup = entity.getAttributeGroup();
        int index = attGroup.count(false);
        for (int i = 0; i < nAttr; ++i) {
            String name = customProperties[i * 3];
            if (attGroup.containsAttributeDescriptorNamed(name, false)) {
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NameNotUnique.fmt.txt", name);
                throw new MetadataException(message);
            }
            attrDesc[i] = new AttributeDescriptor();
            attrDesc[i].setVisible(true);
            attrDesc[i].setType((AttributeTypeInterface)new AttributeType("String", 12));
            attrDesc[i].setName(name);
            attrDesc[i].setDefault((Object)customProperties[i * 3 + 1]);
            String description = customProperties[i * 3 + 2] == null ? "" : customProperties[i * 3 + 2];
            Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale((SessionContextInterface)this._session);
            attrDesc[i].setDescription(viewerLocale, description);
            Locale computationalLocale = this.getComputationalLocale();
            if (!viewerLocale.equals(computationalLocale)) {
                attrDesc[i].setDescription(computationalLocale, description);
            }
            attGroup.addAttributeDescriptor((AttributeDescriptorInterface)attrDesc[i], index++);
        }
        return entity;
    }

    private void deleteCustomAttributes(Entity entity, String[] customProperties) throws MetadataException {
        AttributeGroupInterface attrGroup = entity.getAttributeGroup();
        String[] deletedProperties = attrGroup.removeAttributeDescriptors(customProperties, true);
        MessageFormatter message = null;
        ArrayList<String> undeleted = new ArrayList<String>();
        if (deletedProperties.length == customProperties.length) {
            return;
        }
        if (deletedProperties.length == 0) {
            message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.UndefinedPropertyNames.txt", new Object[0]);
            throw new MetadataException(message);
        }
        for (int i = 0; i < customProperties.length; ++i) {
            int j;
            String name = customProperties[i];
            if (name.length() == 0) continue;
            for (j = 0; j < deletedProperties.length && !deletedProperties[j].equalsIgnoreCase(name); ++j) {
            }
            if (j != deletedProperties.length) continue;
            undeleted.add(name);
        }
        if (undeleted.size() != 0) {
            ArrayMessageFormatter arrayMsf = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_LONG, ArrayMessageFormatter.QUOTESTYLE_TEXT, (Object[])undeleted.toArray(new String[undeleted.size()]));
            message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.PropertyNamesNotFound.fmt.txt", arrayMsf);
            throw new MetadataException(message);
        }
    }

    private void deleteLookupValues(LookupList lookupList, String[] valuesList) throws MetadataException {
        List lookupValues = lookupList.getValuesList();
        ArrayList<String> undeletedList = new ArrayList<String>();
        for (int i = 0; i < valuesList.length; ++i) {
            String valueToDelete = valuesList[i];
            boolean deleted = false;
            for (int j = 0; j < lookupValues.size(); ++j) {
                LookupValue lookupValue = (LookupValue)lookupValues.get(j);
                String unformattedValue = lookupValue.getUnformattedValue();
                if (!unformattedValue.equals(valueToDelete)) continue;
                lookupValues.remove(lookupValue);
                deleted = true;
                break;
            }
            if (deleted) continue;
            undeletedList.add(valueToDelete);
        }
        if (undeletedList.size() != 0) {
            ArrayMessageFormatter arrayMsf = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_LONG, ArrayMessageFormatter.QUOTESTYLE_TEXT, (Object[])undeletedList.toArray(new String[undeletedList.size()]));
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.LookUpNamesNotFound.fmt.txt", arrayMsf);
            throw new MetadataException(message);
        }
        lookupList.setValuesList(lookupValues);
    }

    private FolderInterface getMetadataInterface(String mapPath, boolean autoCreate) throws Exception {
        FolderInterface folder = null;
        PathUrl pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._server, (String)(mapPath + _folderType));
        try {
            folder = (FolderInterface)this._service.getMetadataInterface(this._session, pathUrl);
        }
        catch (MetadataException me) {
            if (!autoCreate) {
                throw me;
            }
            List reasons = me.getReasons();
            if (reasons.size() <= 0) {
                throw me;
            }
            Reason first = (Reason)reasons.get(0);
            if (first.getSubReason() != 216 && first.getReason() != 9) {
                throw me;
            }
            int index = mapPath.lastIndexOf(SLASH);
            String folderName = null;
            String subPath = mapPath.substring(0, index);
            folderName = mapPath.substring(index + 1);
            folder = this.getMetadataInterface(subPath, autoCreate);
            FolderInterface subFolder = folder.makeSubfolder(folderName);
            folder.update();
            return subFolder;
        }
        return folder;
    }

    private DataItem getDataItemFromHierarchy(String dimensionName, String hierarchyName) throws MetadataException {
        String name;
        RootDataItem dItem = null;
        List dimensions = this._cube.getDimensions();
        Dimension thisDimension = null;
        Iterator itDimension = dimensions.iterator();
        while (itDimension.hasNext() && !dimensionName.equalsIgnoreCase(name = (thisDimension = (Dimension)itDimension.next()).getLabel())) {
        }
        if (thisDimension == null) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidDimension.fmt.txt", dimensionName);
            throw new MetadataException(message);
        }
        List hierarchies = thisDimension.getHierarchies();
        for (Hierarchy thisHierarchy : hierarchies) {
            String name2 = thisHierarchy.getLabel();
            if (!hierarchyName.equalsIgnoreCase(name2)) continue;
            dItem = this._map.newDataItem((PhysicalResource)thisHierarchy, this._options);
            break;
        }
        if (dItem == null) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidHierarchy.fmt.txt", dimensionName, hierarchyName);
            throw new MetadataException(message);
        }
        return dItem;
    }

    private DataItem getDataItemFromMeasure(String measureName) throws MetadataException {
        RootDataItem dItem = null;
        List measures = this._cube.getMeasures();
        for (Measure thisMeasure : measures) {
            String name = thisMeasure.getLabel();
            if (!measureName.equalsIgnoreCase(name)) continue;
            dItem = this._map.newDataItem((PhysicalResource)thisMeasure, this._options);
            break;
        }
        if (dItem == null) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidMeasure.fmt.txt", measureName);
            throw new MetadataException(message);
        }
        return dItem;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void exportInformationMap(String mapName, String mapPath, String fileName) throws Exception {
        FolderInterface folder = this._folder;
        InformationMap map = null;
        if (mapPath == null && mapName == null) {
            String XML = PersistenceUtilities.getMapText((InformationMap)this._map, (int)4);
            this.exportXML(XML, fileName);
            return;
        }
        if (mapPath == null) {
            if (this._folder == null) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MapPathMissing.txt", new Object[0]);
                throw new MetadataException(errorMsg);
            }
            folder = this._folder;
        } else {
            if (mapName == null) {
                mapName = this._mapName;
            }
            if (!(mapPath == null || mapPath.length() == 0 || (mapPath = this.getRelativePath(mapPath)).equals(this._mapPath) && this._folder != null)) {
                folder = this.getMetadataInterface(mapPath, false);
            }
        }
        BriefInformationMap briefMap = (BriefInformationMap)folder.getItemByType(mapName, _briefIMapText);
        if (briefMap != null) {
            map = InformationMapFactory.getInstance().newInformationMap(this._session, this._service, briefMap);
            String XML = PersistenceUtilities.getMapText((InformationMap)map, (int)4);
            this.exportXML(XML, fileName);
            return;
        }
        MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MapNotExist2.fmt.txt", mapName);
        throw new MetadataException(errorMsg);
    }

    public Object[] exportToPackage(String[][] mapLocations, boolean[] drops, String spkFileName, boolean generateLocalizableProperties, boolean includeDependencies, boolean externalSubstitutionPropFile) throws Exception {
        String warning;
        Object[] retInfo = new Object[]{null};
        BatchExporter exporter = new BatchExporter(this._session);
        exporter.initialize();
        exporter.setPackageFileName(spkFileName);
        exporter.setGenerateLocalizableProperties(generateLocalizableProperties);
        exporter.setIncludeDependencies(includeDependencies);
        exporter.setGenerateExternalSubstitutionProperties(externalSubstitutionPropFile);
        ArrayList<String> types = new ArrayList<String>();
        types.add("InformationMap");
        types.add("InformationMap.OLAP");
        types.add("InformationMap.Relational");
        PublicTypeFilter filter = new PublicTypeFilter(types);
        exporter.addSearchFilter((SearchFilter)filter);
        int rc = 0;
        if (mapLocations == null && drops == null && this._map != null) {
            BriefInformationMap briefMap = this._map.getBriefMap();
            String mapName = this._map.getLabel();
            if (briefMap == null) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NotSavedForExport.fmt.txt", mapName);
                throw new MetadataException(errorMsg);
            }
            String absoluteName = this.getMapAbsolutePathName(briefMap);
            exporter.setObjectPath(absoluteName);
            rc = exporter.exportPackage();
            if (rc > 0) {
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.FailedToExport.fmt.txt", rc);
                String warning2 = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
                retInfo[0] = retInfo[0] == null ? warning2 : retInfo[0] + warning2;
            }
            return retInfo;
        }
        if (mapLocations != null && this._map != null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.AnotherMapOpen.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        ArrayList<String> exportList = new ArrayList<String>();
        for (int i = 0; mapLocations != null && i < mapLocations.length && mapLocations[i] != null; ++i) {
            List mapList;
            FolderInterface folder;
            String[] mapArray = mapLocations[i];
            String mapPath = mapArray[0];
            try {
                folder = this.getMetadataInterface(mapPath, false);
            }
            catch (Exception e) {
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter(_invalidFolderMsg, mapPath);
                warning = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
                retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
                continue;
            }
            if (mapArray.length == 1) {
                exportList.add(mapArray[0]);
                continue;
            }
            Object[] retInfo2 = this.getMapsForExport(mapArray, drops[i], folder);
            if (retInfo2[0] != null) {
                warning = (String)retInfo2[0];
                Object object = retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
            }
            if ((mapList = (List)retInfo2[1]) == null) {
                MessageFormatter messageFormatter = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MapMissing.fmt.txt", mapPath);
                warning = _MVA_WarningFormatCode + messageFormatter + _MVA_NewLineFormatCode;
                retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
                continue;
            }
            for (OMRBriefInformationMap briefInfoMap : mapList) {
                String absoluteName = this.getMapAbsolutePathName((BriefInformationMap)briefInfoMap);
                exportList.add(absoluteName);
            }
        }
        if (exportList == null || exportList.size() == 0) {
            return retInfo;
        }
        String[] objectPaths = exportList.toArray(new String[exportList.size()]);
        exporter.setObjectPaths(objectPaths);
        rc = exporter.exportPackage();
        if (rc > 0) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.FailedToExport.fmt.txt", rc);
            warning = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
            retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
        }
        return retInfo;
    }

    public Object[] importFromPackage(String[] stringParms, boolean[] booleanParms, int importType) throws Exception {
        this.checkStringArraySize(stringParms, 4);
        this.checkBooleanArraySize(booleanParms, 5);
        String spkFileName = stringParms[0];
        String targetFolder = stringParms[1];
        String subPropFileName = stringParms[2];
        String directory = stringParms[3];
        boolean setApplySubs = booleanParms[0];
        boolean setLocalize = booleanParms[1];
        boolean includeSecurity = booleanParms[2];
        boolean multiLocale = booleanParms[3];
        boolean preservePaths = booleanParms[4];
        Object[] retInfo = new Object[]{null};
        int rc = 0;
        BatchImporter importer = new BatchImporter(this._session);
        importer.initialize();
        importer.setTargetFolder(targetFolder);
        importer.setPackageFileName(spkFileName);
        importer.setApplySubstitutions(setApplySubs, subPropFileName);
        if (includeSecurity) {
            importer.setIncludeSecurity(includeSecurity);
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add("InformationMap");
        types.add("InformationMap.OLAP");
        types.add("InformationMap.Relational");
        importer.setFilteredTypes(types);
        if (importType != 0) {
            importer.setImportType(1);
        }
        if (setLocalize) {
            if (directory != null) {
                importer.setLocalize(setLocalize, directory);
            } else {
                importer.setLocalize(setLocalize);
            }
        }
        if (multiLocale) {
            importer.setLocalizeForAllLocales(setLocalize);
        }
        if ((rc = importer.importPackage()) > 0) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.FailedToExport.fmt.txt", rc);
            String warning = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
            retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
        }
        return retInfo;
    }

    public void closeCurrentMap() {
        if (this._map != null) {
            try {
                BriefInformationMap briefMap;
                String mapName = this._map.getLabel();
                String folderPath = NA;
                String objID = null;
                boolean logRecord = false;
                if (mapName != null && this._folder != null && _briefIMapText != null && (briefMap = (BriefInformationMap)this._folder.getItemByType(mapName, _briefIMapText)) != null) {
                    folderPath = this._folder.getPath();
                    if (folderPath != null) {
                        folderPath = SQ + (folderPath.indexOf(SLASH) == 0 ? folderPath : SLASH + folderPath) + SQ;
                    }
                    if ((objID = briefMap.getReposId()) == null) {
                        objID = NA;
                    }
                    mapName = SQ + mapName + SQ;
                    logRecord = true;
                }
                if (logRecord) {
                    ThreadContext.put((String)"actionID", (String)String.valueOf(14));
                    ThreadContext.put((String)"action", (String)"Close");
                    ThreadContext.put((String)"actionType", (String)"Map");
                    ThreadContext.put((String)"sessionID", (String)this._session.getEntityKey());
                    ThreadContext.put((String)"user", (String)this._session.getUserContext().getResolvedUserId());
                    ThreadContext.put((String)"transID", (String)objID);
                    ThreadContext.put((String)"folder", (String)folderPath);
                    ThreadContext.put((String)"map", (String)mapName);
                    _auditLogger.info("");
                }
            }
            catch (RemoteException remoteException) {
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            this._map.dispose();
            this._map = null;
            this._autoReplaceMap = false;
        }
    }

    private void exportXML(String xml, String file) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
        out.write(xml);
        ((Writer)out).close();
    }

    private String importXML(String file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        String input = in.readLine();
        if (input == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoInputForImport.fmt.txt", file);
            throw new MetadataException(errorMsg);
        }
        StringBuffer xmlBuf = null;
        while (input != null) {
            if (xmlBuf == null) {
                xmlBuf = new StringBuffer(input);
            } else {
                xmlBuf.append(input);
            }
            input = in.readLine();
        }
        in.close();
        if (xmlBuf == null) {
            return null;
        }
        return xmlBuf.toString();
    }

    public String[] moveBusinessItems(String[] idList, String newLocation, boolean isFilter, boolean createMapFolder) throws MetadataException {
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        String[] retInfo = new String[]{null};
        Class itemClass = isFilter ? FilterItem.class : DataItem.class;
        List invalidIDs = this.validateIdentifiers(idList, itemClass);
        if (invalidIDs != null) {
            String messageID = isFilter ? "ProcInfoMaps.InvalidFilterIds.fmt.txt" : "ProcInfoMaps.InvalidDataItemIds.fmt.txt";
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(messageID, new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_LONG, invalidIDs.toArray()));
            throw new MetadataException(errorMsg);
        }
        for (int i = 0; i < idList.length; ++i) {
            String identifier = idList[i];
            BusinessItem bItem = this._map.getBusinessItemByID(identifier);
            String warning = this.moveBItem(identifier, bItem, newLocation, itemClass, createMapFolder);
            if (warning == null) continue;
            retInfo[0] = retInfo[0] == null ? warning : retInfo[0] + warning;
        }
        return retInfo;
    }

    public String[] moveBusinessItem(String identifier, String newLocation, boolean isFilter, boolean createMapFolder) throws MetadataException {
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        Class itemClass = isFilter ? FilterItem.class : DataItem.class;
        BusinessItem bItem = this._map.getBusinessItemByID(identifier);
        if (bItem == null || !itemClass.isInstance(bItem)) {
            String messageID = isFilter ? "ProcInfoMaps.InvalidFilterId.fmt.txt" : "ProcInfoMaps.InvalidDataItemId.fmt.txt";
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter(messageID, identifier);
            throw new MetadataException(message);
        }
        String[] retInfo = new String[]{null};
        retInfo[0] = this.moveBItem(identifier, bItem, newLocation, itemClass, createMapFolder);
        return retInfo;
    }

    public String[] moveFolder(String identifier, String location, String newLocation, boolean createMapFolder) throws MetadataException {
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        String[] retInfo = new String[]{null};
        MapFolder parentFolder = this.getMapFolder(location, false);
        MapFolder folder = parentFolder.getSubfolder(identifier);
        if (folder == null) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidFolderId.fmt.txt", identifier);
            throw new MetadataException(message);
        }
        if (newLocation != null) {
            MapFolder newParent = this.getMapFolder(newLocation, createMapFolder);
            if (newParent != parentFolder) {
                String folderName = folder.getLabel();
                if (newParent.getSubfolder(folderName) != null) {
                    MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DuplicateFolderName.fmt.txt", folderName);
                    throw new MetadataException(message);
                }
                folder.moveTo(newParent);
            }
            if (this.countOfFolderName(newParent, identifier) > 1) {
                // empty if block
            }
            if (this.countOfFolderName(parentFolder, identifier) > 1) {
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DupFolderName.fmt.txt", identifier, parentFolder.getDisplayPath());
                retInfo[0] = _MVA_WarningFormatCode + message + _MVA_NewLineFormatCode;
            }
        }
        return retInfo;
    }

    private String moveBItem(String identifier, BusinessItem bItem, String newLocation, Class itemClass, boolean createMapFolder) throws MetadataException {
        String warning = null;
        if (newLocation != null) {
            MapFolder oldMapFolder;
            MapFolder mapFolder = this.getMapFolder(newLocation, createMapFolder);
            if (mapFolder == (oldMapFolder = this._map.getMapFolderContaining(bItem))) {
                return warning;
            }
            oldMapFolder.removeBusinessItem(bItem);
            mapFolder.addBusinessItem(bItem);
            String name = bItem.getLabel();
            warning = this.checkDuplicateName(identifier, name, itemClass, mapFolder);
        }
        return warning;
    }

    public String[] addIdentityProperty(String identityType, String imid) throws Exception {
        String[] retInfo = new String[]{null};
        boolean rc = false;
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        SASIdentityProperty identityEnum = SASIdentityProperty.toEnum(identityType);
        String key = null;
        switch (identityEnum) {
            case EXTERNAL_IDENTITY: {
                key = "SAS.ExternalIdentity";
                break;
            }
            case IDENTITY_GROUP_NAME: {
                key = "SAS.IdentityGroupName";
                break;
            }
            case IDENTITY_GROUPS: {
                key = "SAS.IdentityGroups";
                break;
            }
            case IDENTITY_NAME: {
                key = "SAS.IdentityName";
                break;
            }
            case PERSON_NAME: {
                key = "SAS.PersonName";
                break;
            }
            case USERID: {
                key = "SAS.Userid";
                break;
            }
        }
        String message = this.addIdentityPropertiesBasedOnKey(key, imid);
        retInfo[0] = retInfo[0] == null ? message : retInfo[0] + message;
        return retInfo;
    }

    public String[] addTextPrompt(String[] stringArray, int[] intArray, boolean[] booleanArray, String[][] objectArray) throws MetadataException {
        this.checkStringArraySize(stringArray, 8);
        this.checkIntArraySize(intArray, 8);
        this.checkBooleanArraySize(booleanArray, 8);
        this.checkObjectArraySize((Object[])objectArray, 2);
        String displayedText = stringArray[0];
        String imid = stringArray[1];
        String desc = stringArray[2];
        String promptName = stringArray[3];
        String valueSource = stringArray[4];
        String formattedValueSource = stringArray[5];
        String format = stringArray[6];
        String tableUrl = stringArray[7];
        Object[] defaultValues = objectArray[0];
        String[] staticValues = objectArray[1];
        int pageSize = intArray[0];
        int selectionType = intArray[1];
        int minValueCount = intArray[2];
        int maxValueCount = intArray[3];
        int minLength = intArray[4];
        int maxLength = intArray[5];
        int valueProviderType = intArray[7];
        boolean isHidden = booleanArray[0];
        boolean isReadOnly = booleanArray[1];
        boolean isValueDisplayed = booleanArray[2];
        boolean allowMissingValues = booleanArray[3];
        boolean allowAllValues = booleanArray[4];
        boolean isAllowUserValues = booleanArray[5];
        boolean isDistinct = booleanArray[6];
        boolean defaultToAll = booleanArray[7];
        Object defaultValue = null;
        String[] retInfo = new String[]{null, null};
        _infoLogger.info("In addTextPrompt() method.");
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (imid != null) {
            this.validateImid(imid);
        }
        TextDefinition definition = new TextDefinition();
        if (selectionType == 0) {
            int n = selectionType = minValueCount > 1 || maxValueCount > 1 || defaultToAll || defaultValues != null && defaultValues.length > 1 ? 2 : 1;
            maxValueCount = selectionType == 1 ? 1 : (maxValueCount > 1 ? maxValueCount : Integer.MAX_VALUE);
            minValueCount = minValueCount > 1 ? minValueCount : 1;
        }
        this.seMinMaxCount((PromptDefinition)definition, maxValueCount, minValueCount, selectionType, 1, defaultValues, defaultToAll);
        maxValueCount = definition.getMaximumValueCount();
        minValueCount = definition.getMinimumValueCount();
        if (maxLength < minLength && maxLength != -1) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidMaxLength.fmt.txt", maxLength);
            throw new MetadataException(errorMsg);
        }
        if (maxLength > 0) {
            definition.setMaximumLength(maxLength);
        }
        if (minLength > 0) {
            definition.setMinimumLength(minLength);
        }
        if (pageSize > 0) {
            definition.setPageSize(pageSize);
        }
        if (promptName == null || promptName.trim().length() == 0) {
            if (imid != null) {
                promptName = imid;
            } else {
                List prompts = this._map.getObjects(false, Prompt.class);
                promptName = "Prompt" + (prompts.size() + 1);
            }
        }
        definition.setPromptName(promptName);
        definition.setPromptLabel(displayedText, this._computationalLocale);
        definition.setAllowUserValues(isAllowUserValues);
        definition.setHidden(isHidden);
        definition.setFixed(isReadOnly);
        definition.setSelectionOrdered(selectionType == 3);
        if (desc != null && !desc.isEmpty()) {
            definition.setPromptDescription(desc, this._computationalLocale);
        }
        StaticValueProvider provider = null;
        switch (valueProviderType) {
            case 2: {
                if (staticValues == null || staticValues.length == 0) break;
                provider = this.getStaticTextValueProvider((PromptDefinition)definition, staticValues, isValueDisplayed, allowMissingValues);
                break;
            }
            case 3: {
                provider = this.getDataItemValueProvider((PromptDefinition)definition, 3, valueSource, formattedValueSource, format, intArray[6], isValueDisplayed, isDistinct);
                break;
            }
            case 4: {
                provider = this.getColumnValueProvider((PromptDefinition)definition, 3, valueSource, formattedValueSource, tableUrl, format, intArray[6], isValueDisplayed, isDistinct);
                break;
            }
        }
        definition.setValueProvider(provider);
        if (allowMissingValues || allowAllValues) {
            SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
            if (allowMissingValues) {
                supportedSpecialValues.setMissingValuesSupported(true);
            }
            if (allowAllValues) {
                if (selectionType == 1 || valueProviderType == 0 || valueProviderType == 1) {
                    allowAllValues = false;
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoAllValues.txt", new Object[0]);
                    throw new MetadataException(errorMsg);
                }
                supportedSpecialValues.setAllSupported(true);
            }
            supportedSpecialValues.setOtherSupported(false);
            definition.setSupportedSpecialValues(supportedSpecialValues);
        }
        if (defaultToAll && allowAllValues) {
            Object[] objects = new Object[]{null};
            SpecialValues allValue = SpecialValues.ALL;
            objects[0] = allValue;
            this.setDefaultTextPromptValues(definition, objects, allowMissingValues, maxValueCount, minValueCount);
        } else if (defaultValues != null && defaultValues.length > 0) {
            this.setDefaultTextPromptValues(definition, defaultValues, allowMissingValues, maxValueCount, minValueCount);
        } else if (isReadOnly || isHidden) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.PromptNeedsDefaultValue.txt", new Object[0]);
            throw new MetadataException(message);
        }
        Prompt prompt = this._map.newPrompt();
        prompt.setLabel(promptName);
        if (imid == null) {
            retInfo[1] = imid = this._map.generateIntraModelID(promptName);
        }
        prompt.setIntraModelID(imid);
        prompt.setIsHidden(isHidden);
        prompt.setPromptDefinition((PromptDefinitionInterface)definition);
        this._map.addBusinessItem((BusinessItem)prompt);
        _infoLogger.info("On return from addTextPrompt() method.");
        return retInfo;
    }

    public String[] addNumericPrompt(String[] stringArray, int[] intArray, boolean[] booleanArray, Object[][] objectArray) throws MetadataException {
        IntegerDefinition definition;
        this.checkStringArraySize(stringArray, 8);
        this.checkIntArraySize(intArray, 8);
        this.checkBooleanArraySize(booleanArray, 11);
        this.checkObjectArraySize((Object[])objectArray, 3);
        _infoLogger.info("In addNumericPrompt() method.");
        String displayedText = stringArray[0];
        String imid = stringArray[1];
        String desc = stringArray[2];
        String promptName = stringArray[3];
        String valueSource = stringArray[4];
        String formattedValueSource = stringArray[5];
        String format = stringArray[6];
        String tableUrl = stringArray[7];
        Object[] defaultValues = objectArray[0];
        Object[] staticValuesArray = objectArray[1];
        Object[] minMaxValuesArray = objectArray[2];
        int pageSize = intArray[0];
        int selectionType = intArray[1];
        int minValueCount = intArray[2];
        int maxValueCount = intArray[3];
        int minDecimal = intArray[4];
        int maxDecimal = intArray[5];
        int valueProviderType = intArray[7];
        double minValue = Double.MIN_VALUE;
        double maxValue = Double.MAX_VALUE;
        boolean isHidden = booleanArray[0];
        boolean isReadOnly = booleanArray[1];
        boolean isValueDisplayed = booleanArray[2];
        boolean allowMissingValues = booleanArray[3];
        boolean allowAllValues = booleanArray[4];
        boolean isAllowUserValues = booleanArray[5];
        boolean isDistinct = booleanArray[6];
        boolean integerOnly = booleanArray[7];
        boolean defaultToAll = booleanArray[10];
        Object defaultValue = null;
        String[] retInfo = new String[]{null, null};
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (imid != null) {
            this.validateImid(imid);
        }
        if (minMaxValuesArray != null && minMaxValuesArray.length > 0) {
            Double doubleObj = null;
            Object obj = minMaxValuesArray[0];
            if (obj != null) {
                doubleObj = (Double)obj;
                this.validateNumber((Double)obj, maxDecimal, integerOnly);
                minValue = doubleObj;
            } else if (integerOnly) {
                minValue = -2.147483648E9;
            }
            obj = minMaxValuesArray[1];
            if (obj != null) {
                doubleObj = (Double)obj;
                this.validateNumber((Double)obj, maxDecimal, integerOnly);
                maxValue = doubleObj;
            } else if (integerOnly) {
                maxValue = 2.147483647E9;
            }
            if (maxValue < minValue) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidMinMAxValues.fmt.txt", minValue, maxValue);
                throw new MetadataException(errorMsg);
            }
        }
        if (selectionType == 0) {
            int n = selectionType = minValueCount > 1 || maxValueCount > 1 || defaultToAll || defaultValues != null && defaultValues.length > 1 ? 2 : 1;
            maxValueCount = selectionType == 1 ? 1 : (maxValueCount > 1 ? maxValueCount : Integer.MAX_VALUE);
            minValueCount = minValueCount > 1 ? minValueCount : 1;
        }
        SupportedSpecialValues specialValues = null;
        if (allowMissingValues || allowAllValues) {
            specialValues = new SupportedSpecialValues();
            if (allowMissingValues) {
                specialValues.setMissingValuesSupported(true);
            }
            if (allowAllValues) {
                if (selectionType == 1 || valueProviderType == 0 || valueProviderType == 1) {
                    allowAllValues = false;
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoAllValues.txt", new Object[0]);
                    throw new MetadataException(errorMsg);
                }
                specialValues.setAllSupported(true);
            }
            specialValues.setOtherSupported(false);
        }
        if (integerOnly) {
            IntegerDefinition integerDefinition;
            definition = integerDefinition = new IntegerDefinition();
            this.seMinMaxCount((PromptDefinition)integerDefinition, maxValueCount, minValueCount, selectionType, 2, defaultValues, defaultToAll);
            maxValueCount = integerDefinition.getMaximumValueCount();
            minValueCount = integerDefinition.getMinimumValueCount();
            integerDefinition.setSelectionOrdered(selectionType == 3);
            if (pageSize != -1) {
                integerDefinition.setPageSize(pageSize);
            }
            if (maxValue != 2.147483647E9) {
                integerDefinition.setMaximum(Double.valueOf(maxValue).intValue());
            }
            if (minValue != -2.147483648E9) {
                integerDefinition.setMinimum(Double.valueOf(minValue).intValue());
            }
            integerDefinition.setAllowUserValues(isAllowUserValues);
            if (specialValues != null) {
                integerDefinition.setSupportedSpecialValues(specialValues);
            }
        } else {
            DoubleDefinition doubleDefinition = new DoubleDefinition();
            definition = doubleDefinition;
            this.seMinMaxCount((PromptDefinition)doubleDefinition, maxValueCount, minValueCount, selectionType, 3, defaultValues, defaultToAll);
            maxValueCount = doubleDefinition.getMaximumValueCount();
            minValueCount = doubleDefinition.getMinimumValueCount();
            if (minDecimal > maxDecimal && maxDecimal != -1) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidMinMAxDecimalPlaces.fmt.txt", minDecimal, maxDecimal);
                throw new MetadataException(errorMsg);
            }
            if (pageSize != -1) {
                doubleDefinition.setPageSize(pageSize);
            }
            if (maxDecimal != -1) {
                doubleDefinition.setMaximumDecimalPlaces(maxDecimal);
            }
            if (minDecimal != -1) {
                doubleDefinition.setMinimumDecimalPlaces(minDecimal);
            }
            if (maxValue != Double.MAX_VALUE) {
                doubleDefinition.setMaximum(maxValue);
            }
            if (minValue != Double.MIN_VALUE) {
                doubleDefinition.setMinimum(minValue);
            }
            doubleDefinition.setSelectionOrdered(selectionType == 3);
            doubleDefinition.setAllowUserValues(isAllowUserValues);
            if (specialValues != null) {
                doubleDefinition.setSupportedSpecialValues(specialValues);
            }
        }
        RelationalDataItemValueProvider provider = null;
        switch (valueProviderType) {
            case 2: {
                if (staticValuesArray == null || staticValuesArray.length == 0) break;
                provider = this.getStaticNumericValueProvider((PromptDefinition)definition, staticValuesArray, maxDecimal, maxValue, minValue, isValueDisplayed, integerOnly, allowMissingValues);
                break;
            }
            case 3: {
                provider = this.getDataItemValueProvider((PromptDefinition)definition, 2, valueSource, formattedValueSource, format, intArray[6], isValueDisplayed, isDistinct);
                break;
            }
            case 4: {
                provider = this.getColumnValueProvider((PromptDefinition)definition, 2, valueSource, formattedValueSource, tableUrl, format, intArray[6], isValueDisplayed, isDistinct);
                break;
            }
        }
        if (integerOnly) {
            definition.setValueProvider(provider);
        } else {
            ((DoubleDefinition)definition).setValueProvider(provider);
        }
        if (promptName == null || promptName.trim().length() == 0) {
            if (imid != null) {
                promptName = imid;
            } else {
                List prompts = this._map.getObjects(false, Prompt.class);
                promptName = "Prompt" + (prompts.size() + 1);
            }
        }
        definition.setPromptName(promptName);
        definition.setPromptLabel(displayedText, this._computationalLocale);
        definition.setHidden(isHidden);
        definition.setFixed(isReadOnly);
        if (desc != null && !desc.isEmpty()) {
            definition.setPromptDescription(desc, this._computationalLocale);
        }
        if (defaultToAll && allowAllValues) {
            Object[] objects = new Object[]{null};
            SpecialValues allValue = SpecialValues.ALL;
            objects[0] = allValue;
            this.setDefaultNumericPromptValues((PromptDefinition)definition, objects, allowMissingValues, maxValueCount, minValueCount, maxValue, minValue);
        } else if (defaultValues != null && defaultValues.length > 0) {
            this.setDefaultNumericPromptValues((PromptDefinition)definition, defaultValues, allowMissingValues, maxValueCount, minValueCount, maxValue, minValue);
        } else if (isReadOnly || isHidden) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.PromptNeedsDefaultValue.txt", new Object[0]);
            throw new MetadataException(message);
        }
        Prompt prompt = this._map.newPrompt();
        prompt.setLabel(promptName);
        if (imid == null) {
            retInfo[1] = imid = this._map.generateIntraModelID(promptName);
        }
        prompt.setIntraModelID(imid);
        prompt.setIsHidden(isHidden);
        prompt.setPromptDefinition((PromptDefinitionInterface)definition);
        this._map.addBusinessItem((BusinessItem)prompt);
        _infoLogger.info("On return from addNumericPrompt() method.");
        return retInfo;
    }

    public String[] addDatePrompt(String[] stringArray, int[] intArray, boolean[] booleanArray, String[][] objectArray) throws MetadataException {
        DateTypes dateType;
        this.checkStringArraySize(stringArray, 9);
        this.checkIntArraySize(intArray, 6);
        this.checkBooleanArraySize(booleanArray, 8);
        this.checkObjectArraySize((Object[])objectArray, 3);
        _infoLogger.info("In addDatePrompt() method.");
        Object dataItem = null;
        String displayedText = stringArray[0];
        String imid = stringArray[1];
        String desc = stringArray[2];
        String promptName = stringArray[3];
        String valueSource = stringArray[4];
        String formattedValueSource = stringArray[5];
        String format = stringArray[6];
        String tableUrl = stringArray[7];
        String tzname = stringArray[8];
        Object[] defaultValuesArray = objectArray[0];
        Object[] staticValuesArray = objectArray[1];
        String[] minMaxValuesArray = objectArray[2];
        int pageSize = intArray[0];
        int selectionType = intArray[1];
        int minValueCount = 1;
        int maxValueCount = 1;
        int valueProviderType = intArray[3];
        int dateTypeN = intArray[4];
        int tzoff = intArray[5] * 1000;
        boolean isHidden = booleanArray[0];
        boolean isReadOnly = booleanArray[1];
        boolean isValueDisplayed = booleanArray[2];
        boolean allowMissingValues = booleanArray[3];
        boolean isAllowUserValues = booleanArray[4];
        boolean isDistinct = booleanArray[5];
        Object defaultValue = null;
        String[] retInfo = new String[]{null, null};
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (imid != null) {
            this.validateImid(imid);
        }
        DatePeriod minValue = null;
        DatePeriod maxValue = null;
        tzname = "GMT";
        tzoff = 0;
        SimpleTimeZone timezone = new SimpleTimeZone(tzoff, tzname);
        DateTypes dateTypes = dateTypeN == 0 ? DateTypes.DATE : (dateTypeN == 3 ? DateTypes.WEEK : (dateTypeN == 5 ? DateTypes.MONTH : (dateType = dateTypeN == 6 ? DateTypes.QUARTER : DateTypes.YEAR)));
        if (minMaxValuesArray != null && minMaxValuesArray.length > 0) {
            String obj = minMaxValuesArray[0];
            if (obj != null) {
                minValue = (DatePeriod)this.getDateObject(obj, dateType, timezone);
            }
            if ((obj = minMaxValuesArray[1]) != null) {
                maxValue = (DatePeriod)this.getDateObject(obj, dateType, timezone);
            }
            if (minValue != null && maxValue != null && maxValue.before((Date)minValue)) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidMinMAxValues.fmt.txt", minValue, maxValue);
                throw new MetadataException(errorMsg);
            }
        }
        DateDefinition dateDefinition = new DateDefinition();
        dateDefinition.setMinimumValueCount(1);
        dateDefinition.setSelectionOrdered(selectionType == 3);
        if (allowMissingValues) {
            SupportedSpecialValues specialValues = new SupportedSpecialValues();
            if (allowMissingValues) {
                specialValues.setMissingValuesSupported(true);
            }
            specialValues.setOtherSupported(false);
            dateDefinition.setSupportedSpecialValues(specialValues);
        }
        if (pageSize != -1) {
            dateDefinition.setPageSize(pageSize);
        }
        if (maxValue != null) {
            dateDefinition.setMaximum((Date)maxValue);
        }
        if (minValue != null) {
            dateDefinition.setMinimum((Date)minValue);
        }
        dateDefinition.setSelectionOrdered(selectionType == 3);
        dateDefinition.setAllowUserValues(isAllowUserValues);
        RelationalDataItemValueProvider provider = null;
        switch (valueProviderType) {
            case 2: {
                DateType dataType;
                if (staticValuesArray == null || staticValuesArray.length == 0) break;
                provider = this.getStaticDateValueProvider((PromptDefinition)dateDefinition, staticValuesArray, maxValue, minValue, isValueDisplayed, allowMissingValues, dateType, timezone);
                switch (intArray[6]) {
                    case 0: {
                        dataType = new DateType();
                        break;
                    }
                    case 3: {
                        dataType = new WeekType();
                        break;
                    }
                    case 5: {
                        dataType = new MonthType();
                        break;
                    }
                    case 6: {
                        dataType = new QuarterType();
                        break;
                    }
                    case 7: {
                        dataType = new YearType();
                        break;
                    }
                    default: {
                        dataType = null;
                    }
                }
                ((StaticValueProvider)provider).setDataType((DataTypeInterface)dataType);
                break;
            }
            case 3: {
                provider = this.getDataItemValueProvider((PromptDefinition)dateDefinition, 4, valueSource, formattedValueSource, format, intArray[2], isValueDisplayed, isDistinct);
                break;
            }
            case 4: {
                provider = this.getColumnValueProvider((PromptDefinition)dateDefinition, 4, valueSource, formattedValueSource, tableUrl, format, intArray[2], isValueDisplayed, isDistinct);
                break;
            }
        }
        dateDefinition.setValueProvider(provider);
        if (promptName == null || promptName.trim().length() == 0) {
            if (imid != null) {
                promptName = imid;
            } else {
                List prompts = this._map.getObjects(false, Prompt.class);
                promptName = "Prompt" + (prompts.size() + 1);
            }
        }
        dateDefinition.setPromptName(promptName);
        dateDefinition.setPromptLabel(displayedText, this._computationalLocale);
        dateDefinition.setHidden(isHidden);
        dateDefinition.setFixed(isReadOnly);
        dateDefinition.setDateType(dateType);
        if (desc != null && !desc.isEmpty()) {
            dateDefinition.setPromptDescription(desc, this._computationalLocale);
        }
        if (defaultValuesArray != null && defaultValuesArray.length > 0) {
            this.setDefaultDatePromptValues(dateDefinition, defaultValuesArray, allowMissingValues, maxValueCount, minValueCount, dateType, timezone);
        } else if (isReadOnly || isHidden) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.PromptNeedsDefaultValue.txt", new Object[0]);
            throw new MetadataException(message);
        }
        Prompt prompt = this._map.newPrompt();
        prompt.setLabel(promptName);
        if (imid == null) {
            retInfo[1] = imid = this._map.generateIntraModelID(promptName);
        }
        prompt.setIntraModelID(imid);
        prompt.setIsHidden(isHidden);
        prompt.setPromptDefinition((PromptDefinitionInterface)dateDefinition);
        this._map.addBusinessItem((BusinessItem)prompt);
        _infoLogger.info("On return from addDatePrompt() method.");
        return retInfo;
    }

    public String[] addTimePrompt(String[] stringArray, int[] intArray, boolean[] booleanArray, String[][] objectArray) throws MetadataException {
        this.checkStringArraySize(stringArray, 5);
        this.checkIntArraySize(intArray, 3);
        this.checkBooleanArraySize(booleanArray, 5);
        this.checkObjectArraySize((Object[])objectArray, 2);
        _infoLogger.info("In addTimePrompt() method.");
        String displayedText = stringArray[0];
        String imid = stringArray[1];
        String desc = stringArray[2];
        String promptName = stringArray[3];
        String tzname = stringArray[4];
        Object[] defaultValuesArray = objectArray[0];
        String[] minMaxValuesArray = objectArray[1];
        int promptType = intArray[0];
        int tzoff = intArray[1] * 1000;
        boolean isHidden = booleanArray[0];
        boolean isReadOnly = booleanArray[1];
        boolean allowMissingValues = booleanArray[2];
        Object defaultValue = null;
        String[] retInfo = new String[]{null, null};
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (imid != null) {
            this.validateImid(imid);
        }
        DateTypes dateType = promptType == 2 ? DateTypes.TIME : DateTypes.TIMESTAMP;
        DatePeriod minValue = null;
        DatePeriod maxValue = null;
        tzname = "GMT";
        tzoff = 0;
        SimpleTimeZone timezone = new SimpleTimeZone(tzoff, tzname);
        if (minMaxValuesArray != null && minMaxValuesArray.length > 0) {
            String obj = minMaxValuesArray[0];
            if (obj != null) {
                minValue = (DatePeriod)this.getDateObject(obj, dateType, timezone);
            }
            if ((obj = minMaxValuesArray[1]) != null) {
                maxValue = (DatePeriod)this.getDateObject(obj, dateType, timezone);
            }
            if (minValue != null && maxValue != null && maxValue.before((Date)minValue)) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidMinMAxValues.fmt.txt", minValue, maxValue);
                throw new MetadataException(errorMsg);
            }
        }
        DateDefinition dateDefinition = new DateDefinition();
        if (allowMissingValues) {
            SupportedSpecialValues specialValues = new SupportedSpecialValues();
            if (allowMissingValues) {
                specialValues.setMissingValuesSupported(true);
            }
            specialValues.setOtherSupported(false);
            dateDefinition.setSupportedSpecialValues(specialValues);
        }
        dateDefinition.setMinimumValueCount(1);
        if (maxValue != null) {
            dateDefinition.setMaximum(maxValue);
        }
        if (minValue != null) {
            dateDefinition.setMinimum((Date)minValue);
        }
        if (promptName == null || promptName.trim().length() == 0) {
            if (imid != null) {
                promptName = imid;
            } else {
                List prompts = this._map.getObjects(false, Prompt.class);
                promptName = "Prompt" + (prompts.size() + 1);
            }
        }
        dateDefinition.setPromptName(promptName);
        dateDefinition.setPromptLabel(displayedText, this._computationalLocale);
        dateDefinition.setHidden(isHidden);
        dateDefinition.setFixed(isReadOnly);
        dateDefinition.setDateType(dateType);
        if (desc != null && !desc.isEmpty()) {
            dateDefinition.setPromptDescription(desc, this._computationalLocale);
        }
        if (defaultValuesArray != null && defaultValuesArray.length > 0) {
            this.setDefaultDatePromptValues(dateDefinition, defaultValuesArray, allowMissingValues, 1, 1, dateType, timezone);
        } else if (isReadOnly || isHidden) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.PromptNeedsDefaultValue.txt", new Object[0]);
            throw new MetadataException(message);
        }
        Prompt prompt = this._map.newPrompt();
        prompt.setLabel(promptName);
        if (imid == null) {
            retInfo[1] = imid = this._map.generateIntraModelID(promptName);
        }
        prompt.setIntraModelID(imid);
        prompt.setIsHidden(isHidden);
        prompt.setPromptDefinition((PromptDefinitionInterface)dateDefinition);
        this._map.addBusinessItem((BusinessItem)prompt);
        _infoLogger.info("On return from addTimePrompt() method.");
        return retInfo;
    }

    private Object getDateObject(Object dateObject, DateTypes dateType, TimeZone timezone) throws MetadataException {
        DatePeriod datePeriod = null;
        if (dateObject instanceof Double) {
            double dateValue = (Double)dateObject;
            Date date = new Date((long)dateValue);
            datePeriod = new DatePeriod(date, dateType, timezone, this._computationalLocale);
        } else if (dateObject instanceof String) {
            try {
                String relativeDT = (String)dateObject;
                DateTypes[] dateTypes = new DateTypes[]{dateType};
                datePeriod = DatePeriod.parseDatePeriod((String)relativeDT, (DateTypes[])dateTypes, (TimeZone)timezone, (Locale)this._computationalLocale);
            }
            catch (Exception e) {
                throw new MetadataException((Throwable)e);
            }
            DateTypes type = datePeriod.getPeriodType();
            if (type == DateTypes.DATE && type != dateType) {
                datePeriod.setPeriodType(dateType);
            }
        } else {
            return dateObject;
        }
        return datePeriod;
    }

    public String[] addOlapMemberPrompt(String[] stringArray, int[] intArray, boolean[] booleanArray, String[][] objectArray) throws MetadataException {
        BusinessItem bItem;
        this.checkStringArraySize(stringArray, 5);
        this.checkIntArraySize(intArray, 3);
        this.checkBooleanArraySize(booleanArray, 3);
        this.checkObjectArraySize((Object[])objectArray, 1);
        _infoLogger.info("In addOlapMemberPrompt() method.");
        String displayedText = stringArray[0];
        String imid = stringArray[1];
        String desc = stringArray[2];
        String promptName = stringArray[3];
        String dItemId = stringArray[4];
        Object[] defaultValues = objectArray[0];
        int selectionType = intArray[0];
        int minValueCount = intArray[1];
        int maxValueCount = intArray[2];
        boolean isHidden = booleanArray[0];
        boolean isReadOnly = booleanArray[1];
        boolean allowMissing = booleanArray[2];
        Object defaultValue = null;
        String[] retInfo = new String[]{null, null};
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (imid != null) {
            this.validateImid(imid);
        }
        if (this._map == null) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(_mapNotExistMsg, new Object[0]);
            throw new MetadataException(errorMsg);
        }
        if (imid != null) {
            this.validateImid(imid);
        }
        OLAPMemberNameDefinition definition = new OLAPMemberNameDefinition();
        if (selectionType == 0) {
            int n = selectionType = minValueCount > 1 || maxValueCount > 1 || defaultValues != null && defaultValues.length > 1 ? 2 : 1;
            maxValueCount = selectionType == 1 ? 1 : (maxValueCount > 1 ? maxValueCount : Integer.MAX_VALUE);
            minValueCount = minValueCount > 1 ? minValueCount : 1;
        }
        this.seMinMaxCount((PromptDefinition)definition, maxValueCount, minValueCount, selectionType, 4, defaultValues, false);
        maxValueCount = definition.getMaximumValueCount();
        minValueCount = definition.getMinimumValueCount();
        if (promptName == null || promptName.trim().length() == 0) {
            if (imid != null) {
                promptName = imid;
            } else {
                List prompts = this._map.getObjects(false, Prompt.class);
                promptName = "Prompt" + (prompts.size() + 1);
            }
        }
        definition.setPromptName(promptName);
        definition.setPromptLabel(displayedText, this._computationalLocale);
        definition.setHidden(isHidden);
        definition.setFixed(isReadOnly);
        definition.setSelectionOrdered(selectionType == 3);
        if (desc != null && !desc.isEmpty()) {
            definition.setPromptDescription(desc, this._computationalLocale);
        }
        if ((bItem = this._map.getBusinessItemByID(dItemId)) == null || !(bItem instanceof DataItem)) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidDataItemId.fmt.txt", dItemId);
            throw new MetadataException(message);
        }
        definition.setDataItem((Object)bItem);
        definition.setDefaultValue(null);
        if (defaultValues != null && defaultValues.length > 0) {
            this.setDefaultOlapMemberPromptValues(definition, defaultValues, allowMissing, maxValueCount, minValueCount);
        } else if (isReadOnly || isHidden) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.PromptNeedsDefaultValue.txt", new Object[0]);
            throw new MetadataException(message);
        }
        Prompt prompt = this._map.newPrompt();
        prompt.setLabel(promptName);
        if (imid == null) {
            retInfo[1] = imid = this._map.generateIntraModelID(promptName);
        }
        prompt.setIntraModelID(imid);
        prompt.setIsHidden(isHidden);
        prompt.setPromptDefinition((PromptDefinitionInterface)definition);
        this._map.addBusinessItem((BusinessItem)prompt);
        _infoLogger.info("On return from addOlapMemberPrompt() method.");
        return retInfo;
    }

    private Member getOlapServerMember(String uniqueName) throws MetadataException {
        List dsList = this._map.getObjects(0, DataSourceCube.class);
        DataSourceCube cube = (DataSourceCube)dsList.get(0);
        List dimensions = cube.getDimensions();
        for (Dimension dimension : dimensions) {
            List hierarchies = dimension.getHierarchies();
            for (Hierarchy hierarchy : hierarchies) {
                List levels = hierarchy.getLevels(true);
                for (Level level : levels) {
                    List members = level.getMembers();
                    for (Member member : members) {
                        String name = member.getMemberUniqueName();
                        if (!name.equalsIgnoreCase(uniqueName)) continue;
                        return member;
                    }
                }
            }
        }
        return null;
    }

    private StaticValueProvider getStaticTextValueProvider(PromptDefinition definition, String[] staticValuesArray, boolean isValueDisplayed, boolean allowMissing) throws MetadataException {
        Object provider = null;
        StaticValueProvider staticValues = new StaticValueProvider();
        staticValues.setValueDisplayed(isValueDisplayed);
        staticValues.setDataType((DataTypeInterface)StringType.DEFAULT_INSTANCE);
        int nPair = staticValuesArray.length / 2;
        ArrayList<ValueItem> valueItemList = new ArrayList<ValueItem>(nPair);
        Object warnings = null;
        int maxLength = ((TextDefinition)definition).getMaximumLength();
        int minLength = ((TextDefinition)definition).getMinimumLength();
        for (int i = 0; i < nPair; ++i) {
            String valueObject = staticValuesArray[i * 2];
            if (valueObject != null) {
                this.validateStringLength(valueObject, maxLength, minLength, false);
                if (valueObject.equalsIgnoreCase("_BLANK_") && allowMissing) continue;
            }
            String labelObject = staticValuesArray[i * 2 + 1];
            ValueItem valueItem = new ValueItem((Object)labelObject, (Object)valueObject);
            valueItemList.add(valueItem);
        }
        if (valueItemList.size() <= 0) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoValidValues.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        staticValues.setValues(valueItemList, this._computationalLocale);
        return staticValues;
    }

    private StaticValueProvider getStaticNumericValueProvider(PromptDefinition definition, Object[] staticValuesArray, int maxDecimal, double maxValue, double minValue, boolean isValueDisplayed, boolean integerOnly, boolean allowMissing) throws MetadataException {
        Object provider = null;
        StaticValueProvider staticValues = new StaticValueProvider();
        staticValues.setValueDisplayed(isValueDisplayed);
        if (integerOnly) {
            staticValues.setDataType((DataTypeInterface)IntegerType.DEFAULT_INSTANCE);
        } else {
            staticValues.setDataType((DataTypeInterface)DoubleType.DEFAULT_INSTANCE);
        }
        int nPair = staticValuesArray.length / 2;
        ArrayList<ValueItem> valueItemList = new ArrayList<ValueItem>(nPair);
        for (int i = 0; i < nPair; ++i) {
            Object unformatted = staticValuesArray[i * 2];
            if (unformatted instanceof MissingValues) {
                MissingValues missing = (MissingValues)unformatted;
                if (!allowMissing) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MissingNotSupported.fmt.txt", missing);
                    throw new MetadataException(errorMsg);
                }
                if (missing == MissingValues.Dot) {
                    continue;
                }
            } else {
                Double dblValue = (Double)unformatted;
                this.validateNumber(dblValue, maxDecimal, integerOnly);
                double dbl = dblValue;
                if (dbl > maxValue) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ValueTooBig.fmt.txt", unformatted, maxValue);
                    throw new MetadataException(errorMsg);
                }
                if (dbl < minValue) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ValueTooSmall.fmt.txt", unformatted, minValue);
                    throw new MetadataException(errorMsg);
                }
                if (integerOnly) {
                    unformatted = dblValue.intValue();
                }
            }
            ValueItem valueItem = new ValueItem(staticValuesArray[i * 2 + 1], unformatted);
            valueItemList.add(valueItem);
        }
        if (valueItemList.size() <= 0) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoValidValues.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        staticValues.setValues(valueItemList, this._computationalLocale);
        return staticValues;
    }

    private StaticValueProvider getStaticDateValueProvider(PromptDefinition definition, Object[] staticValuesArray, DatePeriod maxValue, DatePeriod minValue, boolean isValueDisplayed, boolean allowMissing, DateTypes dateType, TimeZone tzone) throws MetadataException {
        Object provider = null;
        StaticValueProvider staticValues = new StaticValueProvider();
        staticValues.setValueDisplayed(isValueDisplayed);
        int nPair = staticValuesArray.length / 2;
        ArrayList<ValueItem> valueItemList = new ArrayList<ValueItem>(nPair);
        for (int i = 0; i < nPair; ++i) {
            Object unformatted = staticValuesArray[i * 2];
            if (unformatted instanceof MissingValues) {
                MissingValues missing = (MissingValues)unformatted;
                if (!allowMissing) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MissingNotSupported.fmt.txt", missing);
                    throw new MetadataException(errorMsg);
                }
                if (missing == MissingValues.Dot) {
                    continue;
                }
            } else {
                DatePeriod datePeriod = (DatePeriod)this.getDateObject(unformatted, dateType, tzone);
                if (maxValue != null && datePeriod.after((Date)maxValue)) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ValueTooBig.fmt.txt", datePeriod.toString(), maxValue.toString());
                    throw new MetadataException(errorMsg);
                }
                if (minValue != null && datePeriod.before((Date)minValue)) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ValueTooSmall.fmt.txt", datePeriod.toString(), minValue.toString());
                    throw new MetadataException(errorMsg);
                }
                unformatted = datePeriod;
            }
            ValueItem valueItem = new ValueItem(staticValuesArray[i * 2 + 1], unformatted);
            valueItemList.add(valueItem);
        }
        if (valueItemList.size() <= 0) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoValidValues.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        staticValues.setValues(valueItemList, this._computationalLocale);
        return staticValues;
    }

    private RelationalDataItemValueProvider getDataItemValueProvider(PromptDefinition definition, int promptType, String dataItemId, String labelDataItemId, String format, int sortOptions, boolean isValueDisplayed, boolean isDistinct) throws MetadataException {
        BusinessItem bItem = this._map.getBusinessItemByID(dataItemId);
        if (bItem == null || !(bItem instanceof DataItem)) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ValueColumnNotFound.fmt.txt", dataItemId);
            throw new MetadataException(errorMsg);
        }
        RootDataItem dataItem = (RootDataItem)bItem;
        int type = dataItem.getExpressionType();
        if (type != promptType) {
            String msgId = promptType == 3 ? "ProcInfoMaps.ExpectingCharacterType.fmt.txt" : (promptType == 2 ? "ProcInfoMaps.ExpectingNumericType.fmt.txt" : (promptType == 4 ? "ProcInfoMaps.ExpectingDateType.fmt.txt" : "ProcInfoMaps.ExpectingOlapMemberType.fmt.txt"));
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(msgId, dataItemId);
            throw new MetadataException(errorMsg);
        }
        RelationalDataItemValueProvider rdProvider = new RelationalDataItemValueProvider();
        rdProvider.setDataItem((DataItem)dataItem);
        if (labelDataItemId != null && !labelDataItemId.isEmpty()) {
            bItem = this._map.getBusinessItemByID(labelDataItemId);
            if (bItem == null || !(bItem instanceof DataItem)) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.LabelColumnNotFound.fmt.txt", labelDataItemId);
                throw new MetadataException(errorMsg);
            }
            rdProvider.setLabelDataItem((DataItem)bItem);
            if (format != null && !format.isEmpty()) {
                rdProvider.setLabelFormatString(format);
            }
        }
        rdProvider.setLabelDataItemId(labelDataItemId);
        String sortFirst = sortOptions < 2 ? "Sort_First_None" : (sortOptions < 4 ? "Label_Value" : "Value_Label");
        rdProvider.setSortFirst(sortFirst);
        String sortOrder = sortOptions < 2 ? "None" : (sortOptions == 2 || sortOptions == 4 ? "Ascending" : "Descending");
        rdProvider.setSortOrder(sortOrder);
        rdProvider.setDistinct(isDistinct);
        rdProvider.setValueDisplayed(isValueDisplayed);
        rdProvider.setFormattedLabels(true);
        return rdProvider;
    }

    private PromptColumnValueProvider getColumnValueProvider(PromptDefinition definition, int promptType, String columnName, String labelColumnName, String tableUrl, String format, int sortOptions, boolean isValueDisplayed, boolean isDistinct) throws MetadataException {
        String sortOrder;
        List columns;
        String fileType = "(Table)";
        String objectPath = tableUrl = tableUrl.trim();
        if (!tableUrl.endsWith(fileType)) {
            objectPath = objectPath + fileType;
        }
        PathUrl pathUrl = null;
        try {
            pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._server, (String)objectPath);
        }
        catch (Exception e) {
            throw new MetadataException(e.getLocalizedMessage());
        }
        MetadataInterface mi = null;
        try {
            mi = this._service.getMetadataInterface(this._session, pathUrl);
        }
        catch (Exception e) {
            Object[] args = new String[]{tableUrl};
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.TableNotFound.fmt.txt", args);
            throw new MetadataException(errorMsg);
        }
        if (mi == null || !(mi instanceof OMRPhysicalTable)) {
            Object[] args = new String[]{tableUrl};
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.TableNotFound.fmt.txt", args);
            throw new MetadataException(errorMsg);
        }
        OMRPhysicalTable physicalTable = (OMRPhysicalTable)mi;
        try {
            columns = physicalTable.getColumns();
            boolean found = false;
            for (OMRColumn col : columns) {
                if (!col.getName().equalsIgnoreCase(columnName)) continue;
                com.sas.metadata.remote.Column column = (com.sas.metadata.remote.Column)col.getRepositoryEntity();
                String sasType = column.getSASColumnType();
                if (promptType == 3 && !sasType.equalsIgnoreCase("C")) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ExpectingCharacterType.fmt.txt", columnName);
                    throw new MetadataException(errorMsg);
                }
                if (promptType == 2 && !sasType.equalsIgnoreCase("N")) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ExpectingNumericType.fmt.txt", columnName);
                    throw new MetadataException(errorMsg);
                }
                if (promptType == 4 && !sasType.equalsIgnoreCase("N")) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ExpectingDateType.fmt.txt", columnName);
                    throw new MetadataException(errorMsg);
                }
                found = true;
                break;
            }
            if (!found) {
                Object[] args = new String[]{columnName};
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ValueColumnNotFound.fmt.txt", args);
                throw new MetadataException(errorMsg);
            }
        }
        catch (Exception e) {
            Object[] args = new String[]{columnName};
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ValueColumnNotFound.fmt.txt", args);
            throw new MetadataException(errorMsg);
        }
        PromptColumnValueProvider pcProvider = new PromptColumnValueProvider();
        pcProvider.setTableUrl(tableUrl);
        ColumnInfo valueColumn = new ColumnInfo(columnName);
        pcProvider.setValueColumn(valueColumn);
        pcProvider.setDistinct(isDistinct);
        String sortFirst = sortOptions < 2 ? "SortNone" : (sortOptions < 4 ? "SortLabel" : "SortValue");
        pcProvider.setValueDisplayed(isValueDisplayed);
        pcProvider.setSortFirst(sortFirst);
        String string = sortOptions < 2 ? "" : (sortOrder = sortOptions == 2 || sortOptions == 4 ? "ASCENDING" : "DESCENDING");
        if (sortFirst == "SortValue") {
            valueColumn.setSortOrder(sortOrder);
        }
        if (labelColumnName != null) {
            Object[] args = new String[]{labelColumnName, columnName};
            try {
                boolean found = false;
                for (OMRColumn col : columns) {
                    if (!col.getName().equalsIgnoreCase(labelColumnName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.LabelColumnNotFound.fmt.txt", args);
                    throw new MetadataException(errorMsg);
                }
            }
            catch (Exception e) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.LabelColumnNotFound.fmt.txt", args);
                throw new MetadataException(errorMsg);
            }
            if (format == null || format.isEmpty()) {
                format = ColumnInfo.DEFAULT_FORMAT;
            }
            if (sortFirst == "SortValue") {
                sortOrder = "";
            }
            ColumnInfo labelColumn = new ColumnInfo(labelColumnName, sortOrder, format);
            pcProvider.setLabelColumn(labelColumn);
        }
        return pcProvider;
    }

    private void setDefaultTextPromptValues(TextDefinition textPrompt, Object[] defaultValues, boolean allowMissingValues, int maxValueCount, int minValueCount) throws MetadataException {
        ArrayList<Object> newCollection = new ArrayList<Object>();
        boolean defaultToAll = false;
        int minLength = textPrompt.getMinimumLength();
        int maxLength = textPrompt.getMaximumLength();
        for (int i = 0; i < defaultValues.length; ++i) {
            Object valueObj = defaultValues[i];
            if (valueObj instanceof String) {
                String value = (String)valueObj;
                if (value.equalsIgnoreCase("_BLANK_")) {
                    if (allowMissingValues) {
                        valueObj = MissingValues.get((int)0);
                    }
                } else {
                    this.validateStringLength(value, maxLength, minLength, false);
                }
            }
            newCollection.add(valueObj);
            if (!(valueObj instanceof SpecialValues)) continue;
            defaultToAll = true;
            break;
        }
        if (newCollection.size() > 0) {
            int nValues = newCollection.size();
            if (!defaultToAll) {
                MessageFormatter errorMsg;
                if (nValues > maxValueCount && maxValueCount != -1) {
                    errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.TooManyDefaultValues.fmt.txt", maxValueCount);
                    throw new MetadataException(errorMsg);
                }
                if (nValues < minValueCount) {
                    errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NeedMoreDefaultValues.fmt.txt", minValueCount);
                    throw new MetadataException(errorMsg);
                }
            }
            textPrompt.setDefaultValue(newCollection);
        }
    }

    private void setDefaultNumericPromptValues(PromptDefinition definition, Object[] defaultValues, boolean allowMissingValues, int maxValueCount, int minValueCount, double maxValue, double minValue) throws MetadataException {
        ArrayList<Object> newCollection = new ArrayList<Object>(defaultValues.length);
        boolean defaultToAll = false;
        int minDecimal = -1;
        int maxDecimal = -1;
        boolean integerOnly = false;
        if (definition instanceof IntegerDefinition) {
            IntegerDefinition intDefinition = (IntegerDefinition)definition;
            integerOnly = true;
        } else if (definition instanceof DoubleDefinition) {
            DoubleDefinition dblDefinition = (DoubleDefinition)definition;
            minDecimal = dblDefinition.getMinimumDecimalPlaces();
            maxDecimal = dblDefinition.getMaximumDecimalPlaces();
        }
        for (int i = 0; i < defaultValues.length; ++i) {
            Object valueObj = defaultValues[i];
            if (valueObj instanceof MissingValues) {
                if (!allowMissingValues) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MissingNotSupported.fmt.txt", valueObj);
                    throw new MetadataException(errorMsg);
                }
            } else if (valueObj instanceof Double) {
                Double dblValue = (Double)valueObj;
                this.validateNumber(dblValue, maxDecimal, integerOnly);
                double dbl = dblValue;
                if (dbl > maxValue) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ValueTooBig.fmt.txt", dbl, maxValue);
                    throw new MetadataException(errorMsg);
                }
                if (dbl < minValue) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ValueTooSmall.fmt.txt", dbl, minValue);
                    throw new MetadataException(errorMsg);
                }
                if (integerOnly) {
                    valueObj = dblValue.intValue();
                }
            }
            newCollection.add(valueObj);
            if (!(valueObj instanceof SpecialValues)) continue;
            defaultToAll = true;
            break;
        }
        if (newCollection.size() > 0) {
            int nValues = newCollection.size();
            if (!defaultToAll) {
                MessageFormatter errorMsg;
                if (nValues > maxValueCount && maxValueCount != -1) {
                    errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.TooManyDefaultValues.fmt.txt", maxValueCount);
                    throw new MetadataException(errorMsg);
                }
                if (nValues < minValueCount) {
                    errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NeedMoreDefaultValues.fmt.txt", minValueCount);
                    throw new MetadataException(errorMsg);
                }
            }
            definition.setDefaultValue(newCollection);
        }
    }

    private void setDefaultDatePromptValues(DateDefinition dateDefinition, Object[] defaultValues, boolean allowMissingValues, int maxValueCount, int minValueCount, DateTypes dateType, TimeZone timezone) throws MetadataException {
        ArrayList<Object> newCollection = new ArrayList<Object>();
        Date minValue = dateDefinition.getMinimum();
        Date maxValue = dateDefinition.getMaximum();
        for (int i = 0; i < defaultValues.length; ++i) {
            Object valueObj = defaultValues[i];
            if ((valueObj = this.getDateObject(valueObj, dateType, timezone)) instanceof MissingValues) {
                if (!allowMissingValues) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MissingNotSupported.fmt.txt", valueObj);
                    throw new MetadataException(errorMsg);
                }
            } else if (valueObj instanceof DatePeriod) {
                DatePeriod dp = (DatePeriod)valueObj;
                if (dp.after(maxValue)) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ValueTooBig.fmt.txt", dp, maxValue);
                    throw new MetadataException(errorMsg);
                }
                if (dp.before(minValue)) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ValueTooSmall.fmt.txt", dp, minValue);
                    throw new MetadataException(errorMsg);
                }
            }
            newCollection.add(valueObj);
        }
        if (newCollection.size() > 0) {
            MessageFormatter errorMsg;
            int nValues = newCollection.size();
            if (nValues > maxValueCount && maxValueCount != -1) {
                errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.TooManyDefaultValues.fmt.txt", maxValueCount);
                throw new MetadataException(errorMsg);
            }
            if (nValues < minValueCount) {
                errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NeedMoreDefaultValues.fmt.txt", minValueCount);
                throw new MetadataException(errorMsg);
            }
            dateDefinition.setDefaultValue(newCollection);
        }
    }

    private void setDefaultOlapMemberPromptValues(OLAPMemberNameDefinition df, Object[] defaultValues, boolean allowMissingValues, int maxValueCount, int minValueCount) throws MetadataException {
        ArrayList<Object> newCollection = new ArrayList<Object>();
        for (int i = 0; i < defaultValues.length; ++i) {
            Object valueObj = defaultValues[i];
            if (!(valueObj instanceof String)) continue;
            String value = (String)valueObj;
            if (value.equalsIgnoreCase("_BLANK_")) {
                if (!allowMissingValues) continue;
                valueObj = MissingValues.get((int)0);
                newCollection.add(valueObj);
                continue;
            }
            Member member = this.getOlapServerMember(value);
            if (member == null) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidDefaultOlapMemberName.fmt.txt", value);
                throw new MetadataException(errorMsg);
            }
            OLAPMemberName memberName = new OLAPMemberName();
            memberName.setUniqueName(value);
            memberName.setLabel(member.getLabel(), this._computationalLocale);
            newCollection.add(memberName);
        }
        if (newCollection.size() > 0) {
            MessageFormatter errorMsg;
            int nValues = newCollection.size();
            if (nValues > maxValueCount && maxValueCount != -1) {
                errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.TooManyDefaultValues.fmt.txt", maxValueCount);
                throw new MetadataException(errorMsg);
            }
            if (nValues < minValueCount) {
                errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NeedMoreDefaultValues.fmt.txt", minValueCount);
                throw new MetadataException(errorMsg);
            }
            df.setDefaultValue(newCollection);
        }
    }

    private List getSASIdentityDrivenPrompts() throws Exception {
        if (_SASIdentityPromptDefs == null) {
            ServerInterface serverInt = null;
            List allServers = this._session.getUserContext().getServers();
            if (allServers.size() > 0) {
                serverInt = (ServerInterface)allServers.get(0);
            }
            ServicesLogFactory factory = new ServicesLogFactory();
            _SASIdentityPromptDefs = IQUeryUtil.getIdentityDrivenPrompts((MetadataServerInterface)((MetadataServerInterface)serverInt), (LoggerFactoryInterface)factory);
        }
        return _SASIdentityPromptDefs;
    }

    private String addIdentityPropertiesBasedOnKey(String key, String imid) throws Exception {
        String warning = null;
        HashMap<PromptDefinitionInterface, String> identityPromptsMap = null;
        List identityPromptList = this._map.getIdentityDrivenPropertyPrompts();
        if (identityPromptList.size() != 0) {
            identityPromptsMap = new HashMap<PromptDefinitionInterface, String>();
            for (Prompt prompt : identityPromptList) {
                PromptDefinitionInterface pd = prompt.getPromptDefinition();
                identityPromptsMap.put(pd, prompt.getIntraModelID());
            }
        }
        List promptDefinitions = this.getSASIdentityDrivenPrompts();
        for (PromptDefinitionInterface pd : promptDefinitions) {
            if (key != null && !pd.getPromptName().equalsIgnoreCase(key)) continue;
            if (identityPromptsMap == null || identityPromptsMap.size() == 0 || !identityPromptsMap.containsKey(pd)) {
                Prompt newPrompt = this._map.newPrompt();
                newPrompt.setPromptDefinition(pd);
                newPrompt.setLabel(pd.getPromptName());
                if (imid != null) {
                    if (key != null) {
                        this.validateImid(imid);
                        newPrompt.setIntraModelID(imid);
                        this._map.addBusinessItem((BusinessItem)newPrompt);
                        return warning;
                    }
                    String imid2 = this._map.generateIntraModelID(imid);
                    newPrompt.setIntraModelID(imid2);
                }
                MessageFormatter messageFormatter = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NewIdentityProperty.fmt.txt", pd.getPromptName(), newPrompt.getIntraModelID());
                String message = _MVA_NoteFormatCode + messageFormatter + _MVA_NewLineFormatCode;
                warning = warning == null ? message : warning + message;
                this._map.addBusinessItem((BusinessItem)newPrompt);
                continue;
            }
            MessageFormatter message2 = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DupIdentityProperty.fmt.txt", pd.getPromptName(), (String)identityPromptsMap.get(pd));
            String message = _MVA_WarningFormatCode + message2 + _MVA_NewLineFormatCode;
            warning = warning == null ? message : warning + message;
        }
        return warning;
    }

    private String deleteOneBItem(BusinessItem item, int objectType, boolean cascadeDelete) throws MetadataException {
        String message = null;
        List dependentItems = this._map.getObjectsBasedOn((BusinessModelObject)item, BusinessItem.class);
        if (!cascadeDelete && dependentItems.size() > 0) {
            MessageFormatter message2 = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.BMOinUse.fmt.txt", objectType, item.getIntraModelID());
            message = _MVA_WarningFormatCode + message2 + _MVA_NewLineFormatCode;
            return message;
        }
        MapFolder folder = this._map.getMapFolderContaining(item);
        if (folder != null) {
            folder.removeBusinessItem(item);
        }
        this._map.removeBusinessItem(item);
        return message;
    }

    private String deleteOneDataSource(DataSource ds, int objectType, boolean cascadeDelete) throws MetadataException {
        String message = null;
        ArrayList dependentObjects = new ArrayList();
        dependentObjects.addAll(this._map.getObjectsBasedOn((BusinessModelObject)ds, BusinessItem.class));
        dependentObjects.addAll(this._map.getObjectsBasedOn((BusinessModelObject)ds, BusinessRule.class));
        if (!cascadeDelete && dependentObjects.size() > 0) {
            MessageFormatter message2 = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.BMOinUse.fmt.txt", objectType, ds.getIntraModelID());
            message = _MVA_WarningFormatCode + message2 + _MVA_NewLineFormatCode;
            return message;
        }
        this._map.removeDataSource(ds);
        return message;
    }

    private List validateIdentifiers(String[] idList, Class itemClass) throws MetadataException {
        ArrayList<String> invalidIdList = null;
        for (int i = 0; i < idList.length; ++i) {
            String identifier = idList[i];
            BusinessItem bItem = this._map.getBusinessItemByID(identifier);
            if (bItem != null && itemClass.isInstance(bItem)) continue;
            if (invalidIdList == null) {
                invalidIdList = new ArrayList<String>();
            }
            invalidIdList.add(SQ + identifier + SQ);
        }
        return invalidIdList;
    }

    private List getSameNameItems(String name, Class itemClass, MapFolder mapFolder) {
        ArrayList<BusinessItem> result = null;
        List items = mapFolder.getItems(itemClass);
        for (BusinessItem item : items) {
            if (!name.equalsIgnoreCase(item.getLabel())) continue;
            if (result == null) {
                result = new ArrayList<BusinessItem>();
            }
            result.add(item);
        }
        return result;
    }

    private String checkDuplicateName(String imid, String name, Class itemClass, MapFolder mapFolder) {
        String warning = null;
        List items = this.getSameNameItems(name, itemClass, mapFolder);
        if (items.size() > 1) {
            String folderPath = mapFolder.getDisplayPath();
            String msgId = itemClass == FilterItem.class ? "ProcInfoMaps.DupFilterName.fmt.txt" : "ProcInfoMaps.DupDataItemName.fmt.txt";
            MessageFormatter messageFormatter = BaseIntegResourceBundle.getMessageFormatter(msgId, imid, name, folderPath);
            warning = _MVA_WarningFormatCode + messageFormatter + _MVA_NewLineFormatCode;
        }
        return warning;
    }

    private StringBuffer checkDupNamesInFolders(MapFolder folder, StringBuffer warnings) {
        List subFolderList = folder.getSubfolders();
        for (MapFolder subFolder : subFolderList) {
            warnings = this.checkDupNamesInFolders(subFolder, warnings);
        }
        warnings = this.getDupNamesInFolder(folder, warnings);
        return warnings;
    }

    private StringBuffer getDupNamesInFolder(MapFolder folder, StringBuffer warnings) {
        String message;
        MessageFormatter messageFormatter;
        String name;
        HashMap<String, String> itemMap = new HashMap<String, String>();
        List itemsList = folder.getItems(RootDataItem.class);
        String folderPath = folder.getDisplayPath();
        for (BusinessItem item : itemsList) {
            name = item.getLabel();
            if (itemMap.put(name.toUpperCase(), name) == null) continue;
            messageFormatter = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DupDataItemName.fmt.txt", item.getIntraModelID(), name, folderPath);
            message = _MVA_WarningFormatCode + messageFormatter + _MVA_NewLineFormatCode;
            if (warnings == null) {
                warnings = new StringBuffer(message);
                continue;
            }
            warnings.append(message);
        }
        itemMap.clear();
        itemsList = folder.getItems(FilterItem.class);
        for (BusinessItem item : itemsList) {
            name = item.getLabel();
            if (itemMap.put(name.toUpperCase(), name) == null) continue;
            messageFormatter = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DupFilterName.fmt.txt", item.getIntraModelID(), name, folderPath);
            message = _MVA_WarningFormatCode + messageFormatter + _MVA_NewLineFormatCode;
            if (warnings == null) {
                warnings = new StringBuffer(message);
                continue;
            }
            warnings.append(message);
        }
        itemMap.clear();
        List foldersList = folder.getSubfolders();
        if (foldersList == null || foldersList.size() == 1) {
            return warnings;
        }
        for (MapFolder subfolder : foldersList) {
            name = subfolder.getLabel();
            if (itemMap.put(name.toUpperCase(), name) == null) continue;
            MessageFormatter messageFormatter2 = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.DupFolderName.fmt.txt", name, folderPath);
            message = _MVA_WarningFormatCode + messageFormatter2 + _MVA_NewLineFormatCode;
            if (warnings == null) {
                warnings = new StringBuffer(message);
                continue;
            }
            warnings.append(message);
        }
        return warnings;
    }

    private void setAggFunctionsMap() {
        if (this._AggFunctionsMap != null) {
            return;
        }
        this._AggFunctionsMap = new HashMap<String, String>();
        this._AggFunctionsMap.put("Avg".toUpperCase(), "Avg");
        this._AggFunctionsMap.put("AvgDistinct".toUpperCase(), "AvgDistinct");
        this._AggFunctionsMap.put("Count".toUpperCase(), "Count");
        this._AggFunctionsMap.put("CountDistinct".toUpperCase(), "CountDistinct");
        this._AggFunctionsMap.put("CountPlusNMISS".toUpperCase(), "CountPlusNMISS");
        this._AggFunctionsMap.put("CountPlusNMISSDistinct".toUpperCase(), "CountPlusNMISSDistinct");
        this._AggFunctionsMap.put("CSS".toUpperCase(), "CSS");
        this._AggFunctionsMap.put("CSSDistinct".toUpperCase(), "CSSDistinct");
        this._AggFunctionsMap.put("CV".toUpperCase(), "CV");
        this._AggFunctionsMap.put("CVDistinct".toUpperCase(), "CVDistinct");
        this._AggFunctionsMap.put("Freq".toUpperCase(), "Freq");
        this._AggFunctionsMap.put("FreqDistinct".toUpperCase(), "FreqDistinct");
        this._AggFunctionsMap.put("InternalAggregation".toUpperCase(), "InternalAggregation");
        this._AggFunctionsMap.put("InternalAggregationAdditive".toUpperCase(), "InternalAggregationAdditive");
        this._AggFunctionsMap.put("Max".toUpperCase(), "Max");
        this._AggFunctionsMap.put("MaxDistinct".toUpperCase(), "MaxDistinct");
        this._AggFunctionsMap.put("Mean".toUpperCase(), "Mean");
        this._AggFunctionsMap.put("MeanDistinct".toUpperCase(), "MeanDistinct");
        this._AggFunctionsMap.put("Min".toUpperCase(), "Min");
        this._AggFunctionsMap.put("MinDistinct".toUpperCase(), "MinDistinct");
        this._AggFunctionsMap.put("N".toUpperCase(), "N");
        this._AggFunctionsMap.put("NDistinct".toUpperCase(), "NDistinct");
        this._AggFunctionsMap.put("NMISS".toUpperCase(), "NMISS");
        this._AggFunctionsMap.put("NMISSDistinct".toUpperCase(), "NMISSDistinct");
        this._AggFunctionsMap.put("PRT".toUpperCase(), "PRT");
        this._AggFunctionsMap.put("PRTDistinct".toUpperCase(), "PRTDistinct");
        this._AggFunctionsMap.put("Range".toUpperCase(), "Range");
        this._AggFunctionsMap.put("RangeDistinct".toUpperCase(), "RangeDistinct");
        this._AggFunctionsMap.put("STD".toUpperCase(), "STD");
        this._AggFunctionsMap.put("STDDistinct".toUpperCase(), "STDDistinct");
        this._AggFunctionsMap.put("STDERR".toUpperCase(), "STDERR");
        this._AggFunctionsMap.put("STDERRDistinct".toUpperCase(), "STDERRDistinct");
        this._AggFunctionsMap.put("Sum".toUpperCase(), "Sum");
        this._AggFunctionsMap.put("SumDistinct".toUpperCase(), "SumDistinct");
        this._AggFunctionsMap.put("T".toUpperCase(), "T");
        this._AggFunctionsMap.put("TDistinct".toUpperCase(), "TDistinct");
        this._AggFunctionsMap.put("USS".toUpperCase(), "USS");
        this._AggFunctionsMap.put("USSDistinct".toUpperCase(), "USSDistinct");
        this._AggFunctionsMap.put("VAR".toUpperCase(), "Var");
        this._AggFunctionsMap.put("VarDistinct".toUpperCase(), "VarDistinct");
    }

    private Object[] setMap(String mapName, String description, boolean[] booleanParms, int actionOnCustomProperties, String[] customProperties, String[] propertiesToDelete) throws Exception {
        Entity entity2;
        boolean emptyList;
        boolean initCap = booleanParms[0];
        boolean replaceUnderscores = booleanParms[1];
        boolean useLabels = booleanParms[2];
        boolean createTargetFolder = booleanParms[3];
        boolean noVerify = booleanParms[4];
        if (description != null) {
            this._map.setDescription(description);
        }
        MapFolder rootFolder = this._map.getRootMapFolder();
        rootFolder.setLabel(mapName);
        this.setAggFunctionsMap();
        this._options = new Properties();
        this.setBooleanOptions(initCap, replaceUnderscores, useLabels, createTargetFolder, noVerify, this._MLS_Id);
        Object[] retInfo = new Object[]{null, null, null};
        StringBuffer warnings = null;
        warnings = this.checkDupNamesInFolders(this._map.getRootMapFolder(), warnings);
        retInfo[0] = warnings == null ? null : warnings.toString();
        Entity entity = (Entity)this._map.getExtendedAttributes();
        boolean bl = emptyList = entity == null;
        if (!emptyList && (actionOnCustomProperties & 1) == 1) {
            this._map.setExtendedAttributes(null);
            emptyList = true;
        }
        if ((actionOnCustomProperties & 8) == 8) {
            if (!emptyList) {
                this.deleteCustomAttributes(entity, propertiesToDelete);
            } else {
                MessageFormatter messageFormatter = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoMapCustomAttributes.txt", new Object[0]);
                String message = _MVA_WarningFormatCode + messageFormatter + _MVA_NewLineFormatCode;
                Object object = retInfo[0] = retInfo[0] == null ? message : retInfo[0] + message;
            }
        }
        if ((actionOnCustomProperties & 2) == 2) {
            Entity entityAttr = this.newEntity(customProperties);
            this._map.setExtendedAttributes((EntityInterface)entityAttr);
        }
        if ((actionOnCustomProperties & 4) == 4 && (entity2 = this.addCustomAttributes(entity, customProperties)) != entity) {
            this._map.setExtendedAttributes((EntityInterface)entity2);
        }
        retInfo[1] = this._map;
        if (this._hasDataSource) {
            retInfo[2] = this._isRelational ? "TABLE" : "CUBE";
        }
        return retInfo;
    }

    private boolean isValidFormat(DataItem dataItem, String format, boolean isUserSpecifiedFormat) {
        SASFormatAttributes formatAttr;
        if (!dataItem.isValidFormat(format)) {
            return false;
        }
        try {
            formatAttr = SASFormatDescriptionUtil.getFormatAttributes((String)format);
        }
        catch (SASFormatException e) {
            return false;
        }
        SASFormatCategory formatCategory = formatAttr.getType();
        int exprType = dataItem.getExpressionType();
        if (formatCategory == SASFormatCategory.USER_DEFINED_CATEGORY) {
            return true;
        }
        switch (exprType) {
            case 4: 
            case 5: 
            case 6: {
                return !(isUserSpecifiedFormat ? formatCategory != SASFormatCategory.DATE_TIME_CATEGORY && formatCategory != SASFormatCategory.NUMERIC_CATEGORY && formatCategory != SASFormatCategory.CURRENCY_CONVERSION_CATEGORY : formatCategory != SASFormatCategory.DATE_TIME_CATEGORY);
            }
            case 2: {
                return !(isUserSpecifiedFormat ? formatCategory != SASFormatCategory.DATE_TIME_CATEGORY && formatCategory != SASFormatCategory.NUMERIC_CATEGORY && formatCategory != SASFormatCategory.CURRENCY_CONVERSION_CATEGORY : formatCategory != SASFormatCategory.NUMERIC_CATEGORY);
            }
            case 3: {
                return formatCategory == SASFormatCategory.CHARACTER_CATEGORY;
            }
        }
        return false;
    }

    private boolean copyAllExplicitPermissions(MetadataInterface fromObject, MetadataInterface toObject) throws Exception {
        _infoLogger.info("In copyAllExplicitPermissions() method.");
        if (fromObject.equals(toObject)) {
            return false;
        }
        if (fromObject.getReposId().equalsIgnoreCase(toObject.getReposId())) {
            return false;
        }
        boolean bChanged = this.clearExplicitPermissions(toObject);
        Random aceRand = new Random();
        Object fromJomaObj = fromObject.getRepositoryEntity();
        if (!(fromJomaObj instanceof Root)) {
            throw new IllegalArgumentException();
        }
        Root fromRoot = (Root)fromJomaObj;
        Object toJomaObj = toObject.getRepositoryEntity();
        if (!(toJomaObj instanceof Root)) {
            throw new IllegalArgumentException();
        }
        Root toRoot = (Root)toJomaObj;
        MdObjectStore jomaStore = (MdObjectStore)toRoot.getObjectStore();
        String repositoryID = toRoot.getRepositoryID();
        MdFactory factory = jomaStore.getFactory();
        List fromACList = AssociationListUtil.get((AssociationList)fromRoot.getAccessControls(true));
        int numFromAC = fromACList.size();
        if (numFromAC == 0) {
            return bChanged;
        }
        AssociationList toACList = toRoot.getAccessControls(true);
        int numToAC = toACList.size();
        if (numToAC != 0) {
            throw new IllegalArgumentException();
        }
        boolean bCopied = false;
        for (Object ac : fromACList) {
            if (ac instanceof AccessControlEntry) {
                AccessControlEntry ace = (AccessControlEntry)ac;
                List idList = AssociationListUtil.get((AssociationList)ace.getIdentities(true));
                List permList = AssociationListUtil.get((AssociationList)ace.getPermissions(true));
                PermissionCondition permCond = null;
                List permCondList = AssociationListUtil.get((AssociationList)ace.getAssociatedConditions(true));
                if (permCondList.size() > 0) {
                    permCond = (PermissionCondition)permCondList.get(0);
                }
                if (idList.size() == 0 || permList.size() == 0) continue;
                String suffix = Long.toHexString(aceRand.nextLong());
                AccessControlEntry dupACE = (AccessControlEntry)factory.createComplexMetadataObject(jomaStore, "ProcINFOMAPS-" + suffix, "AccessControlEntry", repositoryID);
                dupACE.setDesc("<-" + ace.getName() + "[" + ace.getDesc() + "]");
                for (Identity id : idList) {
                    dupACE.getIdentities().add((Object)id);
                }
                for (Permission perm : permList) {
                    dupACE.getPermissions().add((Object)perm);
                }
                if (permCond != null) {
                    PermissionCondition dupPermCond = (PermissionCondition)factory.createComplexMetadataObject(jomaStore, "ProcINFOMAPS-" + suffix, "PermissionCondition", repositoryID);
                    dupPermCond.setDesc("<-" + permCond.getName() + "[" + permCond.getDesc() + "]");
                    dupPermCond.setText(permCond.getText());
                    dupACE.setAssociatedCondition(dupPermCond);
                }
                toACList.add((Object)dupACE);
                bCopied = true;
                continue;
            }
            if (!(ac instanceof AccessControlTemplate)) continue;
            AccessControlTemplate act = (AccessControlTemplate)ac;
            toACList.add((Object)act);
            bCopied = true;
        }
        if (bCopied) {
            toRoot.updateMetadataAll();
            bChanged = true;
        }
        _infoLogger.info("on return from copyAllExplicitPermissions() method.");
        return bChanged;
    }

    private boolean clearExplicitPermissions(MetadataInterface targetObj) throws Exception {
        _infoLogger.info("In clearExplicitPermissions() method.");
        Object jomaObj = targetObj.getRepositoryEntity();
        if (!(jomaObj instanceof Root)) {
            throw new IllegalArgumentException();
        }
        Root root = (Root)jomaObj;
        AssociationList acList = root.getAccessControls(true);
        int numAC = acList.size();
        if (numAC == 0) {
            return false;
        }
        boolean bChanged = false;
        Iterator acIter = acList.iterator();
        while (acIter.hasNext()) {
            Object ac = acIter.next();
            if (ac instanceof AccessControlEntry) {
                AccessControlEntry ace = (AccessControlEntry)ac;
                acIter.remove();
                ace.delete();
                bChanged = true;
                continue;
            }
            if (!(ac instanceof AccessControlTemplate)) continue;
            acIter.remove();
            bChanged = true;
        }
        if (bChanged) {
            root.updateMetadataAll();
        }
        _infoLogger.info("On return from clearExplicitPermissions() method.");
        return bChanged;
    }

    private void setRequiredTables(List dsTableList, int actions) throws MetadataException {
        _infoLogger.info("In setRequiredTables() method.");
        List rdsList = this._map.getObjects(false, RequiredDataSources.class);
        List dataSources = null;
        RequiredDataSources requiredDS = null;
        if (rdsList != null && rdsList.size() > 0) {
            requiredDS = (RequiredDataSources)rdsList.get(rdsList.size() - 1);
            dataSources = requiredDS.getDataSources();
        }
        if ((dataSources = this.setRequiredTables(dataSources, dsTableList, actions)) != null) {
            if (dataSources.size() == 0) {
                if (requiredDS != null) {
                    this._map.removeBusinessRule((BusinessRule)requiredDS);
                }
            } else {
                if (requiredDS == null) {
                    requiredDS = this._map.newRequiredDataSources();
                }
                requiredDS.setDataSources(dataSources);
                this._map.addBusinessRule((BusinessRule)requiredDS);
            }
        }
        _infoLogger.info("On return from setRequiredTables() method.");
    }

    private List setRequiredTables(List dataSources, List dsTableList, int action) throws MetadataException {
        if (action == 8) {
            if (dataSources != null && dataSources.size() > 0) {
                dataSources.removeAll(dsTableList);
            }
        } else if (action == 4) {
            if (dataSources != null && dataSources.size() > 0) {
                if (dsTableList.size() > 0) {
                    for (Object obj : dsTableList) {
                        if (dataSources.contains(obj)) continue;
                        dataSources.add(obj);
                    }
                }
            } else {
                dataSources = dsTableList;
            }
        }
        return dataSources;
    }

    private void setDrillThrough(int drillThroughOpt) throws MetadataException {
        boolean allowDrillThrough;
        boolean bl = allowDrillThrough = drillThroughOpt != 2;
        if (allowDrillThrough != this._drillThrough) {
            List drillThroughRules = this._map.getResources(DrillThroughToDetail.class);
            if (drillThroughOpt == 2) {
                for (BusinessRule rule : drillThroughRules) {
                    this._map.removeBusinessRule(rule);
                }
            } else if (drillThroughRules == null || drillThroughRules.size() == 0) {
                if (this._cube.isDrillThroughEnabled()) {
                    DrillThroughToDetail rule = this._map.newDrillThroughToDetail();
                    this._map.addBusinessRule((BusinessRule)rule);
                }
            } else {
                DrillThroughToDetail drillThrough = (DrillThroughToDetail)drillThroughRules.get(0);
                drillThrough.setIsDrillThroughAllowed(true);
            }
            this._drillThrough = allowDrillThrough;
        }
    }

    private void setBooleanOptions(boolean initCap, boolean replaceUnderscores, boolean useLabels, boolean createTargetFolder, boolean noVerify, boolean MLS_Id) {
        String trueVal = "1";
        String falseVal = "0";
        if (initCap) {
            this._options.setProperty("INIT_CAP", trueVal);
        } else {
            this._options.setProperty("INIT_CAP", falseVal);
        }
        if (replaceUnderscores) {
            this._options.setProperty("REPLACE_UNDERSCORES", trueVal);
        } else {
            this._options.setProperty("REPLACE_UNDERSCORES", falseVal);
        }
        if (useLabels) {
            this._options.setProperty("USE_LABELS", trueVal);
        } else {
            this._options.setProperty("USE_LABELS", falseVal);
        }
        if (MLS_Id) {
            this._options.setProperty("MLS_ID", trueVal);
        } else {
            this._options.setProperty("MLS_ID", falseVal);
        }
        this._createTargetFolder = createTargetFolder;
        this._noVerify = noVerify;
    }

    private String getMapAbsolutePathName(BriefInformationMap briefMap) throws Exception {
        if (briefMap == null) {
            return null;
        }
        PathUrl url = briefMap.getPathUrl();
        String absoluteName = url.getAbsolutePath();
        return absoluteName;
    }

    private SectionedPropertyMap loadLocalizedProperties(Locale locale, File parentDir, String baseName) throws MetadataException {
        File propFile2;
        String propFilename;
        _infoLogger.info("In loadLocalizedProperties method.");
        ArrayList<File> propFiles = new ArrayList<File>();
        if (locale.getLanguage().length() > 0) {
            if (locale.getCountry().length() > 0) {
                propFilename = baseName + "_" + locale.getLanguage() + "_" + locale.getCountry() + LOCALIZABLE_FILE_EXTENSION;
                propFile2 = new File(parentDir, propFilename);
                propFiles.add(propFile2);
            }
            propFilename = baseName + "_" + locale.getLanguage() + LOCALIZABLE_FILE_EXTENSION;
            propFile2 = new File(parentDir, propFilename);
            propFiles.add(propFile2);
        } else {
            propFilename = baseName + LOCALIZABLE_FILE_EXTENSION;
            propFile2 = new File(parentDir, propFilename);
            propFiles.add(propFile2);
        }
        InputStreamReader rdr = null;
        SectionedPropertyMap localizedPropertyMap = null;
        for (File propFile2 : propFiles) {
            try {
                rdr = new InputStreamReader((InputStream)new FileInputStream(propFile2), Charset.forName("US-ASCII"));
                localizedPropertyMap = new SectionedPropertyMap();
                localizedPropertyMap.load((Reader)rdr);
                ((Reader)rdr).close();
                break;
            }
            catch (Exception exception) {
            }
        }
        if (localizedPropertyMap == null) {
            MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.NoImportFile.fmt.txt", propFilename, parentDir.getAbsolutePath());
            throw new MetadataException(message);
        }
        _infoLogger.info("On return from loadLocalizedProperties method.");
        return localizedPropertyMap;
    }

    private File getLocPropFile(String locPropFileName, boolean toExport) {
        String separator = System.getProperty("file.separator");
        StringBuilder sb = new StringBuilder();
        if (!locPropFileName.endsWith(separator)) {
            sb.append(separator);
        }
        sb.append(locPropFileName);
        if (!locPropFileName.endsWith(LOCALIZABLE_FILE_EXTENSION) && !locPropFileName.endsWith(LOCALIZABLE_FILE_EXTENSION.toUpperCase())) {
            sb.append(LOCALIZABLE_FILE_EXTENSION);
        }
        return new File(sb.toString());
    }

    private void checkStringArraySize(String[] array, int expectedSize) throws MetadataException {
        if (array.length < expectedSize) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.IncorrectArraySize.fmt.txt", "String", expectedSize, array.length);
            throw new MetadataException(errorMsg);
        }
    }

    private void checkIntArraySize(int[] array, int expectedSize) throws MetadataException {
        if (array.length < expectedSize) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.IncorrectArraySize.fmt.txt", "int", expectedSize, array.length);
            throw new MetadataException(errorMsg);
        }
    }

    private void checkObjectArraySize(Object[] array, int expectedSize) throws MetadataException {
        if (array.length < expectedSize) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.IncorrectArraySize.fmt.txt", "Object", expectedSize, array.length);
            throw new MetadataException(errorMsg);
        }
    }

    private void checkBooleanArraySize(boolean[] array, int expectedSize) throws MetadataException {
        if (array.length < expectedSize) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.IncorrectArraySize.fmt.txt", "boolean", expectedSize, array.length);
            throw new MetadataException(errorMsg);
        }
    }

    private void writeToLocPropFile(SectionedPropertyList sections, String locPropFileName) throws Exception {
        File locPropFile = this.getLocPropFile(locPropFileName, true);
        FileOutputStream os = new FileOutputStream(locPropFile);
        sections.save((OutputStream)os, Charset.forName("US-ASCII"));
        ((OutputStream)os).close();
    }

    private String percentSignHandling(String s) {
        char percentSign = '%';
        int index = s.indexOf(percentSign, 0);
        if (index == -1) {
            return s;
        }
        StringBuffer printableString = new StringBuffer();
        int beginIndex = 0;
        while (index > -1 && index < s.length()) {
            printableString.append(s.substring(beginIndex, ++index));
            printableString.append(percentSign);
            beginIndex = index;
            index = s.indexOf(percentSign, beginIndex);
        }
        printableString.append(s.substring(beginIndex));
        return printableString.toString();
    }

    private Locale setComputationalLocale(Locale newLocale) {
        Locale oldLocale = this.getComputationalLocale();
        if (newLocale == null) {
            newLocale = oldLocale;
        }
        this._computationalLocale = newLocale;
        if (this._map != null && oldLocale != newLocale) {
            this._map.setComputationalLocale(newLocale);
        }
        return oldLocale;
    }

    private Locale getComputationalLocale() {
        if (this._computationalLocale == null) {
            return LocaleUtilities.getDefaultComputationalLocale((SessionContextInterface)this._session);
        }
        return this._computationalLocale;
    }

    public Locale setViewerLocale(String sasLocale) throws MetadataException {
        Locale javaLocale = IOMServerUtils.ConvertSASLocaleToJavaLocale((String)sasLocale);
        Locale oldLocale = LocaleUtilities.SetDefaultViewerLocale((SessionContextInterface)this._session, (Locale)javaLocale);
        return oldLocale;
    }

    private void validateStringLength(String value, int maxLength, int minLength, boolean defaultValue) throws MetadataException {
        if (maxLength > 0 && value.length() > maxLength || minLength > 0 && value.length() < minLength) {
            String msgId = defaultValue ? "ProcInfoMaps.InvalidLengthOfDefaultValue.fmt.txt" : "ProcInfoMaps.InvalidLengthOfValue.fmt.txt";
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter(msgId, value);
            throw new MetadataException(errorMsg);
        }
    }

    private void seMinMaxCount(PromptDefinition definition, int maxValueCount, int minValueCount, int selectionType, int promptType, Object[] defaultValues, boolean defaultToAll) throws MetadataException {
        if (selectionType == 2 || selectionType == 3) {
            int n = minValueCount = minValueCount > 1 ? minValueCount : 1;
            int n2 = maxValueCount > 1 ? maxValueCount : (maxValueCount = maxValueCount == -1 ? Integer.MAX_VALUE : maxValueCount);
            if (maxValueCount < 2 || maxValueCount < minValueCount) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidMaxValueCount.fmt.txt", maxValueCount);
                throw new MetadataException(errorMsg);
            }
        } else {
            if (maxValueCount > 1 || minValueCount > 1) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.MinMaxValueNotApply.txt", new Object[0]);
                throw new MetadataException(errorMsg);
            }
            maxValueCount = 1;
            minValueCount = 1;
        }
        if (maxValueCount != -1 && maxValueCount < minValueCount) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidMinMaxValueCount.txt", new Object[0]);
            throw new MetadataException(errorMsg);
        }
        switch (promptType) {
            case 1: {
                TextDefinition textDefinition = (TextDefinition)definition;
                textDefinition.setMinimumValueCount(minValueCount);
                if (maxValueCount == -1) break;
                textDefinition.setMaximumValueCount(maxValueCount);
                break;
            }
            case 2: {
                IntegerDefinition integerDefinition = (IntegerDefinition)definition;
                integerDefinition.setMinimumValueCount(minValueCount);
                if (maxValueCount == -1) break;
                integerDefinition.setMaximumValueCount(maxValueCount);
                break;
            }
            case 3: {
                DoubleDefinition dblDefinition = (DoubleDefinition)definition;
                dblDefinition.setMinimumValueCount(minValueCount);
                if (maxValueCount == -1) break;
                dblDefinition.setMaximumValueCount(maxValueCount);
                break;
            }
            case 4: {
                OLAPMemberNameDefinition olapMemberNameDefinition = (OLAPMemberNameDefinition)definition;
                olapMemberNameDefinition.setMinimumValueCount(minValueCount);
                if (maxValueCount == -1) break;
                olapMemberNameDefinition.setMaximumValueCount(maxValueCount);
                break;
            }
        }
    }

    private void validateNumber(Double doubleObj, int maxDecimal, boolean integerOnly) throws MetadataException {
        double dblValue = doubleObj;
        if (integerOnly) {
            boolean isInteger;
            boolean bl = isInteger = Math.abs(dblValue - Math.floor(dblValue)) < 1.0E-10;
            if (!isInteger || Double.isInfinite(dblValue)) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.InvalidInteger.fmt.txt", doubleObj);
                throw new MetadataException(errorMsg);
            }
        } else {
            BigDecimal big = BigDecimal.valueOf(doubleObj);
            int scale = big.scale();
            if (scale > maxDecimal && maxDecimal != -1) {
                MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("ProcInfoMaps.ValueExceedsMaxDecimals.fmt.txt", dblValue, maxDecimal);
                throw new MetadataException(errorMsg);
            }
        }
    }

    private String getRelativePath(String mapPath) {
        int index;
        if ((mapPath = mapPath.trim()).toUpperCase().startsWith(SBIP)) {
            int relPathIndex = mapPath.indexOf(SLASH, SBIP.length());
            mapPath = mapPath.substring(relPathIndex);
        }
        if ((index = mapPath.lastIndexOf(SLASH)) != -1 && index == mapPath.length() - 1) {
            mapPath = mapPath.substring(0, index);
        }
        if (mapPath.length() == 0) {
            mapPath = SLASH;
        } else if (mapPath.charAt(0) != '/') {
            mapPath = SLASH + mapPath;
        }
        if (this._customRepos != null) {
            mapPath = this._customRepos.concat(mapPath);
        }
        return mapPath;
    }

    public SessionContextInterface getSessionContext() {
        return this._session;
    }

    private static enum SASIdentityProperty {
        _ALL_,
        EXTERNAL_IDENTITY,
        IDENTITY_GROUP_NAME,
        IDENTITY_GROUPS,
        IDENTITY_NAME,
        PERSON_NAME,
        USERID;


        private static SASIdentityProperty toEnum(String str) {
            return SASIdentityProperty.valueOf(str);
        }
    }
}

