/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.baseinteg;

import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.util.ChainedException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Locale;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;

public class JavaExceptionUtil {
    public static final int GET_REASONS = 1;
    public static final int GET_SASLOG = 2;
    public static final int GET_MESSAGES = 4;
    public static final int GET_TRACE = 8;
    public static final int GET_DEFAULT = 7;
    public static final int GET_ALL = 15;
    public static final int CHECK_FOR_FATAL_ERROR = 16;

    private JavaExceptionUtil() {
    }

    public static synchronized String getMessageFromException(Exception e) {
        if (e != null) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            PrintStream p = new PrintStream(b);
            e.printStackTrace(p);
            p.flush();
            return ((Object)b).toString();
        }
        return "";
    }

    public static synchronized String getMessageFromException(Exception e, int level, String SasLocale) {
        Locale locale;
        if (e == null) {
            return "";
        }
        Throwable thisException = e;
        boolean fatalError = false;
        if ((level & 0x10) == 16) {
            level &= 0xFFFFFFEF;
            while (thisException != null) {
                block12: {
                    if (thisException instanceof Error) {
                        fatalError = true;
                    } else if (thisException instanceof RuntimeException) {
                        if (thisException instanceof SystemException && ((SystemException)thisException).completed == CompletionStatus.COMPLETED_NO) {
                            fatalError = true;
                        }
                    } else {
                        try {
                            Class<?> cls = Class.forName("com.ibm.ws.process.exception.ProcessOpException");
                            if (cls == null) break block12;
                            fatalError = thisException.getClass().isInstance(cls);
                        }
                        catch (ClassNotFoundException e2) {
                            thisException = ChainedException.getTargetException((Throwable)thisException);
                            continue;
                        }
                    }
                }
                if (fatalError) break;
                thisException = ChainedException.getTargetException((Throwable)thisException);
            }
        }
        if ((locale = IOMServerUtils.ConvertSASLocaleToJavaLocale((String)SasLocale)) == null) {
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        String message = JavaExceptionUtil.getMessageFromException(e, level, locale);
        if (fatalError) {
            message = "***" + message;
        }
        return message;
    }

    private static String getMessageFromException(Exception exception, int level, Locale locale) {
        int levelToIQuerySerices = 3;
        String value = "";
        if (level == 8 || level == 15) {
            levelToIQuerySerices = 7;
        }
        value = exception instanceof IQueryServicesException ? ((IQueryServicesException)exception).getDetailMessage(locale, levelToIQuerySerices) : (exception instanceof IQueryServicesRuntimeException ? ((IQueryServicesRuntimeException)((Object)exception)).getDetailMessage(locale, levelToIQuerySerices) : IQueryServicesException.getDetailMessage((Locale)locale, (int)levelToIQuerySerices, (Throwable)exception));
        return value;
    }
}

