/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.baseinteg;

import com.sas.antlr.CommonAST;
import com.sas.antlr.RecognitionException;
import com.sas.antlr.TokenStreamException;
import com.sas.antlr.collections.AST;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.baseinteg.BaseIntegResourceBundle;
import com.sas.iquery.baseinteg.filterparser.ExprLexer;
import com.sas.iquery.baseinteg.filterparser.ExprParser;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.execution.util.StoredProcessUtils;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.AssociationRule;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.CascadeRule;
import com.sas.iquery.metadata.business.CascadeRuleItem;
import com.sas.iquery.metadata.business.CascadeRuleSet;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.FilterSetMember;
import com.sas.iquery.metadata.business.FilterSetRuleItems;
import com.sas.iquery.metadata.business.FilterSetRulesContainer;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.InformationMapFactory;
import com.sas.iquery.metadata.business.MapFolder;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RunStoredProcess;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.physical.OMAWrapper;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.util.DataSelectionUtilities;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class IMEMapInfo {
    public static final String STORED_PROCESS = "SP";
    public static final String DATAITEM = "DATAITEM";
    public static final String FILTER = "FILTER";
    public static final String BLANK = "";
    public static final String KEEP_ALL = "KA";
    public static final String DROP = "D";
    public static final String KEEP = "K";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String DESC = "desc";
    public static final String REPOSID = "reposid";
    public static final String CATEGORY = "CATEGORY";
    public static final String MEASURE = "MEASURE";
    public static final String LBRACKETS = "<<";
    public static final String RBRACKETS = ">>";
    public static final String beginMarker = "dyF(\" ";
    public static final String endMarker = "\")";
    public static final String SP_PROMPTGROUP_IDROOT = "PromptGrp_spPromptGroup";
    public static final String PREFILTER_PROMPTGROUP_NAME = "PreFilter Prompt Group";
    public static final String SP_PROMPTGROUP_NAME = "Stored Process Prompt Group";
    public static final String READ_PERMISSION = "Read";
    public static final String OMR_URI_PREFIX = "OMSOBJ:";
    public static final String MFT = "MFT_ENABLED";
    public static final String ENABLED = "ENABLED";
    public static final String DISABLED = "DISABLED";
    public static final int JAVA_AGGREGATEDATA = 1;
    public static final int JAVA_FOLDERORDER = 2;
    private BriefInformationMap _briefMap;
    private InformationMap _map;
    private boolean _aggregateData;
    private boolean _displayBusinessItemsInFolderOrder;
    private ResultSet _resultSet;
    private Map _unUsedDataItems;
    private Map _unUsedFilterItems;
    private Map _modifyDI;
    private int _columnCount;
    private int[] _columnType;
    private int _rowCount = -1;
    private int _bufferCount;
    private List _filterList;
    private int _size;
    private int _numContentsItems = 11;
    private boolean[] _authorizations = new boolean[2];
    private boolean _userAuthorizationsChecked = false;
    private int[] _datasetsInfoLength = new int[3];
    private int[] _maxLengthArray = new int[this._numContentsItems];
    private int _currentRowNumber = 0;
    private final char _NULL_CHAR = '\u0000';
    private int _rowInitialLength = 0;
    private int _nonDetailedDataItems = 0;
    private int _NumUnusableFilters = 0;
    private int _NumUnusableDataItems = 0;
    private String[][] _defaultAggregates;
    private int[] _maxFilterLengths = new int[4];
    private int _maxFilterBufferSize = 0;
    private String[] _filterName;
    private String[] _filterDesc;
    private String[] _filterID;
    private String[] _filterFolder;
    private String[] _filterExpression;
    private String[] _filterType;
    private String[] _promptedFilter;
    private ArrayList _allFilterDataItems;
    private String[][] _filterDataItems;
    private String _filterClause = null;
    private String[] _filterArray = null;
    private int _numSP = 0;
    private int _numSPGroups = 0;
    private int _numPreFilterPrompts = 0;
    private int _numFilterPrompts = 0;
    private PromptGroupInterface _spPromptGroup = null;
    private PromptValuesInterface _spPromptValues = null;
    private PromptValuesInterface _outPromptValues = null;
    private int _numPromptItems = 8;
    private ArrayList _MapPrompts;
    private ArrayList _mapFilters;
    private ArrayList _mapDataItems;
    private ArrayList _FilterPromptDefinitions;
    private ArrayList _PreFilterPromptDefinitions;
    private String[][] _mapPromptInfoArray;
    private String[][] _filterPromptInfoArray;
    private Map _PromptDefinitionForXML = new HashMap();
    private Map _FilterItemPrompts;
    private boolean[] _isFilterPrompted;
    private boolean[] _isPreFilter;
    private ArrayList _FilterPrompts;
    private Map _filterDependencies = new HashMap();
    private Map _PromptsLocation = new HashMap();
    private int _CHUNK_SIZE = 32676;
    private Map _clientPromptValues = new HashMap();
    private DataSelection _ds;
    private QueryConnector _queryConnector;
    private SessionContextInterface _session;
    private ResultSetInterface _resultsetInterface;
    private static long _usedMemory = 0L;
    private static long _freeMemory = 0L;
    private static long _totalMemory = 0L;
    private String _dsXML;

    public IMEMapInfo(BriefInformationMap briefInformationMap, int flags, Map reposMapping) throws RemoteException, ServiceException {
        this._briefMap = briefInformationMap;
        this._aggregateData = (flags & 1) != 0;
        this._displayBusinessItemsInFolderOrder = (flags & 2) != 0;
    }

    public boolean[] checkAuthorizations(IntelligentQueryMetadataServiceInterface iqMetadataService, SessionContextInterface session) throws RemoteException, ServiceException, MetadataException {
        if (this._userAuthorizationsChecked) {
            return this._authorizations;
        }
        this._authorizations[0] = true;
        this._authorizations[1] = true;
        OMIRepositoryInterface omrServer = (OMIRepositoryInterface)this._briefMap.getRepository();
        String reposID = this._briefMap.getReposId();
        this._authorizations[0] = omrServer.isAuthorized(BLANK, "OMSOBJ:Transformation/" + reposID, READ_PERMISSION);
        if (this._map == null) {
            this._map = InformationMapFactory.getInstance().newInformationMap(session, iqMetadataService, this._briefMap);
        }
        List dataSourceTables = this._map.getObjects(false, DataSourceTable.class);
        for (int i = 0; i < dataSourceTables.size(); ++i) {
            CMetadata ptable;
            DataSourceTable ds = (DataSourceTable)dataSourceTables.get(i);
            Table table = ds.getTable();
            if (!(table instanceof OMAWrapper) || (ptable = ((OMAWrapper)table).getOMAObject()) == null) continue;
            String tableID = ptable.getId();
            this._authorizations[1] = omrServer.isAuthorized(BLANK, "OMSOBJ:PhysicalTable/" + tableID, READ_PERMISSION);
            if (!this._authorizations[1]) break;
        }
        this._userAuthorizationsChecked = true;
        return this._authorizations;
    }

    public String getMapAttribute(String attribute) throws RemoteException {
        String value = null;
        value = attribute.compareTo(TYPE) == 0 ? "DATA" : (attribute.compareTo(NAME) == 0 ? this._briefMap.getName() : (attribute.compareTo(DESC) == 0 ? this._briefMap.getDescription() : (attribute.compareTo(REPOSID) == 0 ? this._briefMap.getReposId() : attribute + this.hashCode())));
        return value;
    }

    public String[] getDatasetsInfo() throws RemoteException, UnsupportedEncodingException {
        String[] datasetInfo = new String[3];
        String name = this.getMapAttribute(NAME);
        this._datasetsInfoLength[0] = name.getBytes("UTF-8").length;
        datasetInfo[0] = name;
        String type = this.getMapAttribute(TYPE);
        this._datasetsInfoLength[1] = type.getBytes("UTF-8").length;
        datasetInfo[1] = type;
        String reposid = this.getMapAttribute(REPOSID);
        this._datasetsInfoLength[2] = reposid.getBytes("UTF-8").length;
        datasetInfo[2] = reposid;
        return datasetInfo;
    }

    public int[] getDatasetsInfoLength() throws RemoteException {
        return this._datasetsInfoLength;
    }

    public String[][] getContentsInfo(IntelligentQueryMetadataServiceInterface iqMetadataService, SessionContextInterface session) throws MetadataException, UnsupportedEncodingException {
        String[][] contentsInfo = this.getContentsInfo(iqMetadataService, session, KEEP_ALL, null);
        return contentsInfo;
    }

    public String[][] getContentsInfo(IntelligentQueryMetadataServiceInterface iqMetadataService, SessionContextInterface session, String keep, String[] keepDropColumns) throws MetadataException, UnsupportedEncodingException {
        int i;
        this._rowInitialLength = 0;
        this._NumUnusableFilters = 0;
        this._filterList = new ArrayList();
        this._mapDataItems = new ArrayList();
        this._mapFilters = new ArrayList();
        if (this._map == null) {
            this._map = InformationMapFactory.getInstance().newInformationMap(session, iqMetadataService, this._briefMap);
        }
        if (this._displayBusinessItemsInFolderOrder) {
            MapFolder rootFolder = this._map.getRootMapFolder();
            this.getBusinessItemsFromFolder(rootFolder);
        }
        List dataItems = this.getNetDataItems(keep, keepDropColumns);
        String[][] contentsInfo = new String[dataItems.size()][this._numContentsItems];
        String dataItemID = null;
        int byteLen = 0;
        int arraySize = dataItems.size();
        if (arraySize == 0) {
            arraySize = 1;
        }
        this._defaultAggregates = new String[arraySize][2];
        this._defaultAggregates[0][0] = MFT;
        List aRules = this._map.getObjects(false, AssociationRule.class);
        this._defaultAggregates[0][1] = aRules.size() != 0 ? (this._aggregateData ? ENABLED : DISABLED) : ENABLED;
        for (i = 0; i < dataItems.size(); ++i) {
            DataItem di = (DataItem)dataItems.get(i);
            contentsInfo[i][0] = dataItemID = di.getIntraModelID();
            int type = di.getExpressionType();
            contentsInfo[i][1] = type == 3 ? "C" : "N";
            ExpressionInterface expr = di.getExpression();
            QualifiedColumn column = null;
            boolean modifyingDI = false;
            if (!this._aggregateData && this._modifyDI.size() != 0 && this._modifyDI.containsKey(dataItemID)) {
                modifyingDI = true;
                contentsInfo[i][1] = "C";
            }
            if (expr instanceof QualifiedColumn) {
                column = (QualifiedColumn)expr;
                contentsInfo[i][2] = Integer.toString(column.getDbmsLength());
                this._rowInitialLength += column.getDbmsLength();
                if (column.getDbmsLength() == 0) {
                    contentsInfo[i][2] = Integer.toString(column.getSasLength());
                    this._rowInitialLength += column.getSasLength();
                }
            } else {
                contentsInfo[i][2] = "*";
                this._rowInitialLength += 32;
            }
            contentsInfo[i][3] = modifyingDI ? (expr instanceof QualifiedColumn ? column.getSasFormat() : BLANK) : di.getFormat();
            if (contentsInfo[i][3] == null) {
                contentsInfo[i][3] = BLANK;
            }
            contentsInfo[i][4] = di.getLabel();
            if (contentsInfo[i][4] == null) {
                contentsInfo[i][4] = BLANK;
            }
            MapFolder mapFolder = this._map.getMapFolderContaining((BusinessItem)di);
            contentsInfo[i][5] = mapFolder.getDisplayPath();
            if (contentsInfo[i][5] == null) {
                contentsInfo[i][5] = BLANK;
            }
            contentsInfo[i][6] = di.getDescription();
            if (contentsInfo[i][6] == null) {
                contentsInfo[i][6] = BLANK;
            }
            contentsInfo[i][7] = di.getUsage() == DataItemActionType.USAGE_CATEGORY ? CATEGORY : MEASURE;
            if (this._aggregateData && di.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
                String aggregateFunction = di.getAggregationType().getLabel().toString();
                int index = aggregateFunction.indexOf(40);
                contentsInfo[i][8] = index != -1 ? aggregateFunction.substring(0, index) : aggregateFunction;
            }
            if (contentsInfo[i][8] == null) {
                contentsInfo[i][8] = BLANK;
            }
            contentsInfo[i][9] = di.isUsableInQuery() ? "YES" : "NO";
            contentsInfo[i][10] = di.isCalculatedItem() ? "YES" : "NO";
        }
        for (int di = 0; di < dataItems.size(); ++di) {
            for (int attr = 0; attr < this._numContentsItems; ++attr) {
                byteLen = contentsInfo[di][attr].getBytes("UTF-8").length;
                if (di == 0) {
                    this._maxLengthArray[attr] = byteLen;
                    continue;
                }
                if (byteLen <= this._maxLengthArray[attr]) continue;
                this._maxLengthArray[attr] = byteLen;
            }
        }
        String filterItemID = null;
        List mapFilters = !this._displayBusinessItemsInFolderOrder ? this._map.getObjects(0, FilterItem.class) : this._mapFilters;
        if (this._unUsedFilterItems == null) {
            this._unUsedFilterItems = new HashMap();
        } else {
            this._unUsedFilterItems.clear();
        }
        for (i = 0; i < mapFilters.size(); ++i) {
            FilterItem fi = (FilterItem)mapFilters.get(i);
            if (fi.isHidden()) continue;
            if (fi.isUsableInQuery()) {
                this._filterList.add(fi);
                continue;
            }
            if (!fi.getPrompts(65535).isEmpty()) continue;
            filterItemID = fi.getIntraModelID();
            this._unUsedFilterItems.put(filterItemID, fi);
            ++this._NumUnusableFilters;
        }
        return contentsInfo;
    }

    private List getNetDataItems(String keep, String[] keepDropColumns) throws MetadataException {
        DataItem di;
        int j;
        DataItem di2;
        int index;
        String dataItemID = null;
        this._NumUnusableDataItems = 0;
        this._nonDetailedDataItems = 0;
        if (this._unUsedDataItems == null) {
            this._unUsedDataItems = new HashMap();
        } else {
            this._unUsedDataItems.clear();
        }
        if (this._modifyDI == null) {
            this._modifyDI = new HashMap();
        } else {
            this._modifyDI.clear();
        }
        if (keep == null) {
            keep = KEEP_ALL;
        }
        List dataItems = !this._displayBusinessItemsInFolderOrder ? this._map.getObjects(false, DataItem.class) : this._mapDataItems;
        for (index = 0; index < dataItems.size(); ++index) {
            di2 = (DataItem)dataItems.get(index);
            if (di2.isUsableInQuery()) continue;
            dataItemID = di2.getIntraModelID();
            this._unUsedDataItems.put(dataItemID, di2);
            ++this._NumUnusableDataItems;
        }
        if (!this._unUsedDataItems.isEmpty()) {
            dataItems.removeAll(this._unUsedDataItems.values());
        }
        if (keep.equalsIgnoreCase(KEEP_ALL) && this._aggregateData) {
            return dataItems;
        }
        if (!this._aggregateData) {
            for (index = 0; index < dataItems.size(); ++index) {
                int expType;
                di2 = (DataItem)dataItems.get(index);
                dataItemID = di2.getIntraModelID();
                DataItemActionType diActionType = di2.getUsage();
                if (diActionType != DataItemActionType.USAGE_DETAIL && !di2.isActionSupported(DataItemActionType.USAGE_DETAIL)) {
                    this._unUsedDataItems.put(dataItemID, di2);
                    ++this._nonDetailedDataItems;
                    continue;
                }
                int diType = di2.getExpressionType();
                if (diType != 2 || (expType = di2.getExpression().getExpressionType()) != 3) continue;
                this._modifyDI.put(dataItemID, di2);
            }
            dataItems.removeAll(this._unUsedDataItems.values());
        }
        if (keep.equalsIgnoreCase(KEEP_ALL)) {
            return dataItems;
        }
        ArrayList<DataItem> subsetList = new ArrayList<DataItem>();
        block2: for (index = 0; index < keepDropColumns.length; ++index) {
            for (j = 0; j < dataItems.size(); ++j) {
                di = (DataItem)dataItems.get(j);
                dataItemID = di.getIntraModelID();
                if (!dataItemID.equalsIgnoreCase(keepDropColumns[index])) continue;
                if (keep.equalsIgnoreCase(KEEP)) {
                    subsetList.add(di);
                }
                if (keep.equalsIgnoreCase(DROP)) {
                    this._unUsedDataItems.put(dataItemID, di);
                    if (!this._aggregateData && this._modifyDI.size() != 0 && this._modifyDI.containsKey(dataItemID)) {
                        this._modifyDI.remove(dataItemID);
                    }
                }
                dataItems.remove(di);
                continue block2;
            }
        }
        if (keep.equalsIgnoreCase(KEEP)) {
            for (j = 0; j < dataItems.size(); ++j) {
                di = (DataItem)dataItems.get(j);
                dataItemID = di.getIntraModelID();
                this._unUsedDataItems.put(dataItemID, di);
                if (this._aggregateData || this._modifyDI.size() == 0 || !this._modifyDI.containsKey(dataItemID)) continue;
                this._modifyDI.remove(dataItemID);
            }
            return subsetList;
        }
        return dataItems;
    }

    private void getBusinessItemsFromFolder(MapFolder folder) {
        List folderList = folder.getSubfolders();
        for (MapFolder subFolder : folderList) {
            this.getBusinessItemsFromFolder(subFolder);
        }
        this._mapDataItems.addAll(folder.getItems(DataItem.class));
        this._mapFilters.addAll(folder.getItems(FilterItem.class));
    }

    public int[] getContentsMaxLength() {
        return this._maxLengthArray;
    }

    public String[][] getDefaultAggregates() {
        return this._defaultAggregates;
    }

    public int getFilterCount() {
        return this._size;
    }

    public String[] getFilterName() {
        return this._filterName;
    }

    public String[] getFilterDescription() {
        return this._filterDesc;
    }

    public String[] getFilterID() {
        return this._filterID;
    }

    public String[] getFilterFolder() {
        return this._filterFolder;
    }

    public String[] getFilterExpression() {
        return this._filterExpression;
    }

    public String[] getFilterType() {
        return this._filterType;
    }

    public String[] getFilterIsPrompted() {
        return this._promptedFilter;
    }

    public int getFilterBufferSize() {
        return this._maxFilterBufferSize;
    }

    public String[][] getFilterDataItems() {
        List di;
        int dataItemsCount = 0;
        int filterSize = this._allFilterDataItems.size();
        for (int index = 0; index < filterSize; ++index) {
            di = (List)this._allFilterDataItems.get(index);
            dataItemsCount += di.size();
        }
        this._filterDataItems = new String[filterSize][dataItemsCount];
        for (int i = 0; i < this._allFilterDataItems.size(); ++i) {
            di = (List)this._allFilterDataItems.get(i);
            for (int j = 0; j < di.size(); ++j) {
                this._filterDataItems[i][j] = di.get(j).toString();
            }
        }
        return this._filterDataItems;
    }

    public int getMaxStringLength(String[] iArray) throws UnsupportedEncodingException {
        int maxLength = 0;
        int byteLen = 0;
        for (int i = 0; i < iArray.length; ++i) {
            if (iArray[i] == null || maxLength >= (byteLen = iArray[i].getBytes("UTF-8").length)) continue;
            maxLength = byteLen;
        }
        return maxLength;
    }

    public void initializeFilterInfo() throws MetadataException, UnsupportedEncodingException {
        int filterSize = this._filterList.size();
        this._filterName = new String[filterSize];
        this._filterDesc = new String[filterSize];
        this._filterID = new String[filterSize];
        this._filterExpression = new String[filterSize];
        this._filterType = new String[filterSize];
        this._promptedFilter = new String[filterSize];
        this._filterFolder = new String[filterSize];
        this._size = 0;
        this._allFilterDataItems = new ArrayList();
        this._FilterItemPrompts = new HashMap();
        this._FilterPromptDefinitions = new ArrayList();
        this._PreFilterPromptDefinitions = new ArrayList();
        this._isFilterPrompted = new boolean[filterSize];
        this._isPreFilter = new boolean[filterSize];
        this._numPreFilterPrompts = 0;
        ArrayList pcValues = new ArrayList();
        FilterSetRulesContainer fsrc = (FilterSetRulesContainer)this._map;
        HashSet prefilters = new HashSet();
        List dataSources = this._map.getObjects(0, DataSourceTable.class);
        for (DataSourceTable dataSourceTable : dataSources) {
            if (!(dataSourceTable instanceof FilterSetMember)) continue;
            if (!this._userAuthorizationsChecked) {
                try {
                    this.checkAuthorizations(null, null);
                }
                catch (RemoteException re) {
                    MetadataException mde = new MetadataException(null, (Throwable)re);
                    mde.initCause((Throwable)re);
                    throw mde;
                }
                catch (ServiceException se) {
                    MetadataException mde = new MetadataException(null, (Throwable)se);
                    mde.initCause((Throwable)se);
                    throw mde;
                }
            }
            FilterSetRuleItems combinedFilterSet = this._authorizations[0] ? fsrc.getCombinedFilterSetRuleList((FilterSetMember)dataSourceTable) : fsrc.getCombinedFilterSetRuleList((FilterSetMember)dataSourceTable, pcValues);
            List c = combinedFilterSet.getResources(FilterItem.class, 65535);
            prefilters.addAll(c);
        }
        for (FilterItem thisFilter : this._filterList) {
            if (prefilters.contains(thisFilter)) {
                List prompts = thisFilter.getPrompts(65535);
                if (prompts.isEmpty()) continue;
                this._numPreFilterPrompts += prompts.size();
                for (Prompt thisPrompt : prompts) {
                    PromptDefinitionInterface pdi = thisPrompt.getPromptDefinition();
                    if (pdi == null || this._PreFilterPromptDefinitions.contains(pdi)) continue;
                    this._PreFilterPromptDefinitions.add(pdi);
                }
                continue;
            }
            if (thisFilter.getLabel().equalsIgnoreCase(BLANK)) continue;
            this._filterName[this._size] = thisFilter.getLabel();
            this._filterDesc[this._size] = thisFilter.getDescription();
            this._filterID[this._size] = thisFilter.getIntraModelID();
            MapFolder mapFolder = this._map.getMapFolderContaining((BusinessItem)thisFilter);
            this._filterFolder[this._size] = mapFolder != null ? mapFolder.getDisplayPath() : BLANK;
            this._filterExpression[this._size] = thisFilter.getExpression().toString();
            this._filterType[this._size] = thisFilter.getIdentityString().indexOf("Type =\"CompoundFilter\"") >= 0 ? "Compound" : "Simple";
            List prompts = thisFilter.getPrompts(65535);
            if (prompts.isEmpty()) {
                this._promptedFilter[this._size] = "No";
                this._isFilterPrompted[this._size] = false;
            } else {
                this._promptedFilter[this._size] = "Yes";
                this._isFilterPrompted[this._size] = true;
                ArrayList<String> pList = new ArrayList<String>();
                for (Prompt thisPrompt : prompts) {
                    PromptDefinitionInterface pdi = thisPrompt.getPromptDefinition();
                    if (pdi == null) continue;
                    if (!this._FilterPromptDefinitions.contains(pdi) && !this._isPreFilter[this._size]) {
                        this._FilterPromptDefinitions.add(pdi);
                    }
                    pList.add(thisPrompt.getPromptDefinition().getPromptID());
                }
                this._FilterItemPrompts.put(thisFilter.getIntraModelID(), pList);
            }
            List filterDataItem = thisFilter.getDataItems(0);
            this._allFilterDataItems.add(filterDataItem);
            ++this._size;
        }
        if (filterSize > 0) {
            this._maxFilterLengths[0] = this.getMaxStringLength(this._filterID);
            this._maxFilterLengths[1] = this.getMaxStringLength(this._filterName);
            this._maxFilterLengths[2] = this.getMaxStringLength(this._filterDesc);
            this._maxFilterLengths[3] = this.getMaxStringLength(this._filterFolder);
            for (int i = 0; i < this._maxFilterLengths.length; ++i) {
                this._maxFilterBufferSize += this._maxFilterLengths[i];
            }
        }
    }

    public void setFilterInfo(String filterClause, String[] filterArray, String[] dataItemArray) throws MetadataException {
        int i = 0;
        int j = 0;
        if (dataItemArray != null) {
            for (i = 0; i < dataItemArray.length; ++i) {
                DataItem dItem = (DataItem)this._map.getBusinessItemByID(dataItemArray[i]);
                if (dItem == null) {
                    Object[] args = new String[]{dataItemArray[i]};
                    MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("IMLE.DataItemByIDNotFound.fmt.txt", args);
                    throw new MetadataException(message);
                }
                String intraModelID = dItem.getIntraModelID();
                String placeHolder = LBRACKETS + i + RBRACKETS;
                boolean done = false;
                while (!done && j < filterArray.length) {
                    if (filterArray[j].contains(placeHolder)) {
                        String replacement = LBRACKETS + intraModelID + RBRACKETS;
                        filterArray[j] = filterArray[j].replaceFirst(placeHolder, replacement);
                        done = true;
                        continue;
                    }
                    ++j;
                }
                if (done || j < filterArray.length) continue;
                Object[] args = new String[]{intraModelID};
                MessageFormatter message = BaseIntegResourceBundle.getMessageFormatter("IMLE.DataItemNotReplacedInDyFilter.fmt.txt", args);
                throw new MetadataException(message);
            }
            j = 1;
            for (i = 0; i < filterArray.length; ++i) {
                if (!filterArray[i].startsWith(beginMarker)) continue;
                FilterItem filterItem = this._map.newFilterItem();
                filterItem.setLabel("DynamicFilter" + j);
                filterArray[i] = filterArray[i].substring(beginMarker.length(), filterArray[i].length() - endMarker.length());
                filterItem.setDescription(filterArray[i]);
                ExpressionInterface expression = StringExpressionUtil.getInstance().newExpression((BusinessModel)this._map, filterArray[i], 9, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
                filterItem.setExpression(expression);
                this._map.addBusinessItem((BusinessItem)filterItem);
                filterArray[i] = filterItem.getIntraModelID();
            }
        }
        this._filterClause = filterClause;
        this._filterArray = filterArray;
    }

    public int[] initializePromptInfo() throws MetadataException, RemoteException, ServiceException {
        Locale visualLocale = LocaleUtilities.getDefaultViewerLocale((BusinessModel)this._map);
        int[] AvailablePrompts = new int[3];
        DataSelection dataSelection = DataSelectionFactory.newDataSelection((BusinessModel)this._map);
        if (!this._filterList.isEmpty()) {
            dataSelection.setFilters(this._filterList);
        }
        AvailablePrompts[0] = this.isMapPrompted(dataSelection, visualLocale);
        AvailablePrompts[2] = this.isFiltersPrompted(dataSelection, visualLocale);
        this.buildPromptDependencies(dataSelection);
        return AvailablePrompts;
    }

    private int isMapPrompted(DataSelection ds, Locale visualLocale) throws MetadataException, RemoteException, ServiceException {
        this._numSPGroups = 0;
        this._MapPrompts = null;
        this._mapPromptInfoArray = null;
        List storedProcesses = this._map.getObjects(false, RunStoredProcess.class);
        this._numSP = storedProcesses.size();
        for (RunStoredProcess runStoredProcess : storedProcesses) {
            if (!runStoredProcess.isUsableInQuery()) continue;
            this._spPromptValues = StoredProcessUtils.retrieveStoredProcessPromptValues((RunStoredProcess)runStoredProcess, (PromptValuesInterface)ds.getPromptValues());
            if (this._spPromptValues == null) continue;
            this._spPromptGroup = this._spPromptValues.getPromptGroup();
            List PromptDefinitions = this._spPromptGroup.getPromptDefinitions(true);
            if (PromptDefinitions.isEmpty()) continue;
            this.setRequiredMapPrompts(this._spPromptGroup, null, null, visualLocale);
        }
        if (!this._PreFilterPromptDefinitions.isEmpty() && this._numPreFilterPrompts != 0) {
            DataSelection dataSelection = DataSelectionFactory.newDataSelection((BusinessModel)this._map);
            List dataItems = this._map.getObjects(false, DataItem.class);
            dataSelection.addResultItems(dataItems, Role.COLUMN);
            PromptValuesInterface queryPv = dataSelection.getPromptValues();
            for (PromptDefinitionInterface pdi : this._PreFilterPromptDefinitions) {
                PromptGroupInterface pfPromptGroup;
                PromptValuesInterface pfPromptValues = queryPv.findPromptValuesForPromptDefinition(pdi);
                if (pfPromptValues != null) {
                    pfPromptGroup = pfPromptValues.getPromptGroup();
                } else {
                    pfPromptGroup = new TransparentGroup();
                    pfPromptGroup.addPromptDefinition(pdi);
                }
                this.setRequiredMapPrompts(pfPromptGroup, pdi.getPromptID(), pdi.getPromptName(), visualLocale);
            }
        }
        return this._numSPGroups;
    }

    private void setRequiredMapPrompts(PromptGroupInterface PromptGroup, String promptID, String promptName, Locale visualLocale) {
        if (this._MapPrompts == null) {
            this._MapPrompts = new ArrayList();
        }
        if (this._mapPromptInfoArray == null) {
            this._mapPromptInfoArray = new String[this._numSP + this._numPreFilterPrompts][this._numPromptItems];
        }
        if (promptID == null) {
            String spIndex = new String(Integer.toString(this._numSPGroups));
            promptID = SP_PROMPTGROUP_IDROOT + spIndex;
        }
        if (promptName == null) {
            promptName = SP_PROMPTGROUP_NAME;
        }
        if (!this._MapPrompts.contains(promptID)) {
            this._mapPromptInfoArray[this._numSPGroups][0] = "MAP";
            this._mapPromptInfoArray[this._numSPGroups][1] = promptID;
            this._mapPromptInfoArray[this._numSPGroups][2] = promptName;
            this._mapPromptInfoArray[this._numSPGroups][3] = PromptGroup.getPromptGroupDescription(visualLocale);
            if (this._mapPromptInfoArray[this._numSPGroups][3] == null) {
                this._mapPromptInfoArray[this._numSPGroups][3] = BLANK;
            }
            this._mapPromptInfoArray[this._numSPGroups][4] = PromptGroup.getPromptGroupLabel(visualLocale);
            if (this._mapPromptInfoArray[this._numSPGroups][4] == null) {
                this._mapPromptInfoArray[this._numSPGroups][4] = BLANK;
            }
            this._mapPromptInfoArray[this._numSPGroups][5] = BLANK;
            this._mapPromptInfoArray[this._numSPGroups][6] = BLANK;
            this._mapPromptInfoArray[this._numSPGroups][7] = BLANK;
            this._MapPrompts.add(promptID);
            ++this._numSPGroups;
            this._PromptsLocation.put(promptID, "MAP");
            this._PromptDefinitionForXML.put(promptID, PromptGroup);
        }
    }

    private int isFiltersPrompted(DataSelection ds, Locale visualLocale) throws RemoteException, ServiceException {
        this._numFilterPrompts = 0;
        if (!this._FilterPromptDefinitions.isEmpty()) {
            this.setFilterPrompts(ds, visualLocale);
        }
        return this._numFilterPrompts;
    }

    private void setFilterPrompts(DataSelection ds, Locale visualLocale) throws RemoteException, ServiceException {
        this._FilterPrompts = new ArrayList();
        this._filterPromptInfoArray = new String[this._FilterPromptDefinitions.size()][this._numPromptItems];
        int i = 0;
        for (PromptDefinitionInterface pdi : this._FilterPromptDefinitions) {
            String promptID = pdi.getPromptID();
            this._filterPromptInfoArray[i][0] = FILTER;
            this._filterPromptInfoArray[i][1] = promptID;
            this._filterPromptInfoArray[i][2] = pdi.getPromptName();
            this._filterPromptInfoArray[i][3] = pdi.getPromptDescription(visualLocale);
            if (this._filterPromptInfoArray[i][3] == null) {
                this._filterPromptInfoArray[i][3] = BLANK;
            }
            this._filterPromptInfoArray[i][4] = pdi.getPromptLabel(visualLocale);
            if (this._filterPromptInfoArray[i][4] == null) {
                this._filterPromptInfoArray[i][4] = BLANK;
            }
            this._filterPromptInfoArray[i][5] = this.IdentifyExpressionType(pdi);
            this._filterPromptInfoArray[i][6] = BLANK;
            this._filterPromptInfoArray[i][7] = BLANK;
            this._FilterPrompts.add(promptID);
            ++this._numFilterPrompts;
            this._PromptsLocation.put(promptID, FILTER);
            this._PromptDefinitionForXML.put(promptID, pdi);
            ++i;
        }
    }

    public String[] getMapPrompts() {
        String[] SPPromptsArray = this._MapPrompts.toArray(new String[this._MapPrompts.size()]);
        return SPPromptsArray;
    }

    public int getMaxPromptLength() throws UnsupportedEncodingException {
        int maxSPPromptLength = 0;
        int maxFilterPromptLength = 0;
        if (this._MapPrompts != null && this._MapPrompts.size() != 0) {
            String[] mapPromptsArray = this._MapPrompts.toArray(new String[this._MapPrompts.size()]);
            maxSPPromptLength = this.getMaxStringLength(mapPromptsArray);
        }
        if (this._FilterPrompts != null && this._FilterPrompts.size() != 0) {
            String[] filterPromptsArray = this._FilterPrompts.toArray(new String[this._FilterPrompts.size()]);
            maxFilterPromptLength = this.getMaxStringLength(filterPromptsArray);
        }
        return Math.max(maxSPPromptLength, maxFilterPromptLength);
    }

    public String[] getFilterPrompts(String filterID) {
        String[] promptIDArray = new String[]{};
        if (this._FilterItemPrompts.containsKey(filterID)) {
            ArrayList promptList = (ArrayList)this._FilterItemPrompts.get(filterID);
            promptIDArray = promptList.toArray(new String[promptList.size()]);
        }
        return promptIDArray;
    }

    public String[][] getAllPromptsInfo() {
        int arrayIndex = 0;
        String[][] allPromptsInfoArray = new String[this._numSPGroups + this._numFilterPrompts][this._numPromptItems];
        if (this._mapPromptInfoArray != null && this._mapPromptInfoArray.length != 0) {
            System.arraycopy(this._mapPromptInfoArray, 0, allPromptsInfoArray, arrayIndex, this._mapPromptInfoArray.length);
            arrayIndex = this._mapPromptInfoArray.length;
        }
        if (this._filterPromptInfoArray != null && this._filterPromptInfoArray.length != 0) {
            System.arraycopy(this._filterPromptInfoArray, 0, allPromptsInfoArray, arrayIndex, this._filterPromptInfoArray.length);
        }
        return allPromptsInfoArray;
    }

    public void buildPromptDependencies(DataSelection ds) throws MetadataException {
        CascadeRuleSet crs = ds.getCascadeRuleSet();
        Collection cascadeRules = crs.getRules();
        for (CascadeRule rule : cascadeRules) {
            int index;
            CascadeRuleItem ruleItem = rule.getItem();
            Collection dependentRuleItems = rule.getDependentItems();
            if (dependentRuleItems.isEmpty()) continue;
            StringBuffer depPromptIDsString = new StringBuffer();
            String numRules = Integer.toString(dependentRuleItems.size());
            depPromptIDsString.append(numRules);
            depPromptIDsString.append('\u0000');
            for (CascadeRuleItem depRuleItem : dependentRuleItems) {
                String depPromptID = depRuleItem.getPrompt().getPromptID();
                depPromptIDsString.append(depPromptID);
                depPromptIDsString.append('\u0000');
            }
            String location = (String)this._PromptsLocation.get(ruleItem.getPrompt().getPromptID());
            if (location.equalsIgnoreCase("MAP")) {
                index = this._MapPrompts.indexOf(ruleItem.getPrompt().getPromptID());
                this._mapPromptInfoArray[index][7] = depPromptIDsString.toString();
                continue;
            }
            if (!location.equalsIgnoreCase(FILTER)) continue;
            index = this._FilterPrompts.indexOf(ruleItem.getPrompt().getPromptID());
            this._filterPromptInfoArray[index][7] = depPromptIDsString.toString();
        }
    }

    private String IdentifyExpressionType(PromptDefinitionInterface pd) {
        int returnType;
        String returnString = BLANK;
        int sqlType = pd.getPromptDataType().getExpressionUsage();
        try {
            returnType = ExpressionUtil.getExprType((int)sqlType);
        }
        catch (IQueryServicesRuntimeException IQ) {
            returnString = BLANK;
            return returnString;
        }
        switch (returnType) {
            case 1: {
                returnString = "BitString";
                break;
            }
            case 2: {
                returnString = "Num";
                break;
            }
            case 3: {
                returnString = "Char";
                break;
            }
            case 4: {
                returnString = "Date";
                break;
            }
            case 5: {
                returnString = "Time";
                break;
            }
            case 6: {
                returnString = "TimeStamp";
                break;
            }
            case 7: {
                returnString = "Interval_YM";
                break;
            }
            case 8: {
                returnString = "Interval_DT";
                break;
            }
            case 9: {
                returnString = "Boolean";
                break;
            }
            case 10: {
                returnString = "Enumeration";
                break;
            }
            case 11: {
                returnString = "Unquoted_Char";
                break;
            }
            default: {
                returnString = BLANK;
            }
        }
        return returnString;
    }

    public String getPromptXML(String PromptID) throws ParserConfigurationException, BackingStoreException {
        AbstractPersistence mappedObject = (AbstractPersistence)this._PromptDefinitionForXML.get(PromptID);
        String XMLString = this.getXMLForObject(mappedObject);
        int stringSize = XMLString.length();
        int numOfChunks = stringSize / this._CHUNK_SIZE;
        int Chunks = numOfChunks++;
        if (stringSize % this._CHUNK_SIZE > 0) {
            // empty if block
        }
        String numChunks = Integer.toString(numOfChunks);
        StringBuffer XMLBuff = new StringBuffer();
        XMLBuff.append(numChunks);
        XMLBuff.append('\u0000');
        int startIndex = 0;
        int endIndex = startIndex + this._CHUNK_SIZE;
        for (int i = 0; i < Chunks; ++i) {
            XMLBuff.append(XMLString.substring(startIndex, endIndex));
            XMLBuff.append('\u0000');
            startIndex = endIndex;
            endIndex = startIndex + this._CHUNK_SIZE;
        }
        if (numOfChunks > Chunks) {
            XMLBuff.append(XMLString.substring(startIndex));
            XMLBuff.append('\u0000');
        }
        int XMLSize = XMLBuff.length();
        return XMLBuff.substring(0, XMLSize);
    }

    public void setPromptValues(String[] iXML) throws SAXException, IOException, ParserConfigurationException, PromptValueNotFoundException {
        int i;
        int numChunks = iXML.length;
        StringBuffer pvXML = new StringBuffer();
        for (i = 0; i < numChunks; ++i) {
            pvXML.append(iXML[i].substring(0, iXML[i].length()));
        }
        int XMLSize = pvXML.length();
        this._outPromptValues = (PromptValuesInterface)this.getObjectForXML(pvXML.substring(0, XMLSize));
        PromptGroupInterface outPG = this._outPromptValues.getPromptGroup();
        List PromptDefinitions = outPG.getPromptDefinitions(true);
        i = 0;
        for (PromptDefinitionInterface pd : PromptDefinitions) {
            this._clientPromptValues.put(pd.getPromptID(), this._outPromptValues.getPromptValue(pd));
        }
    }

    private String getXMLForObject(AbstractPersistence obj) throws ParserConfigurationException, BackingStoreException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        PromptsWritingContext writingContext = PersistenceFactory.newWritingContext((PersistenceInterface)obj, null);
        Element element = obj.write((Node)doc, (IntegratedWritingContext)writingContext);
        PersistHelper.removeUnreferencedPersistenceIDs((Element)element, (PromptsWritingContext)writingContext);
        String outputXML = XmlUtil.documentToString((Node)element);
        return outputXML;
    }

    private Object getObjectForXML(String objXML) throws SAXException, IOException, ParserConfigurationException {
        Log4JFactory2 loggerFactory = new Log4JFactory2();
        PromptsReadingContext rc = PersistenceFactory.newReadingContext((LoggerFactoryInterface)loggerFactory);
        StringReader bis = new StringReader(objXML);
        PersistenceInterface obj = PromptUtil.newObjectFromXML((Reader)bis, null, (PromptsReadingContext)rc);
        return obj;
    }

    public void executeQuery(IntelligentQueryMetadataServiceInterface iqMetadataService, SessionContextInterface session, int fetchRows) throws MetadataException, IntelligentQueryException, InvalidPromptValueException, ExecutionException, SQLException {
        this.executeQuery(iqMetadataService, session, null, null, fetchRows);
    }

    public DataSelection getDataSelection() {
        return this._ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(IntelligentQueryMetadataServiceInterface iqMetadataService, SessionContextInterface session, String keep, String[] keepDropColumns, int fetchRows) throws MetadataException, IntelligentQueryException, InvalidPromptValueException, ExecutionException, SQLException {
        if (this._map == null) {
            this._map = InformationMapFactory.getInstance().newInformationMap(session, iqMetadataService, this._briefMap);
        }
        this._session = session;
        DataSelection dataSelection = null;
        dataSelection = this._filterClause != null && this._filterArray.length != 0 ? this.buildDataSelection(iqMetadataService, session, this._filterArray, this._filterClause, keep, keepDropColumns) : this.buildDataSelection(iqMetadataService, session, null, null, keep, keepDropColumns);
        List storedProcesses = this._map.getObjects(false, RunStoredProcess.class);
        Object lockObject = null;
        try {
            if (storedProcesses.size() != 0) {
                try {
                    lockObject = session.lock("IMEMapInfo");
                }
                catch (RemoteException re) {
                    MetadataException me = new MetadataException((Throwable)re);
                    me.initCause((Throwable)re);
                    throw me;
                }
            }
            this._queryConnector = new QueryConnector();
            ArrayList<DataSelection> selections = new ArrayList<DataSelection>();
            selections.add(dataSelection);
            RetrievalPolicy retrievalPolicy = new RetrievalPolicy();
            retrievalPolicy.getConnectionConfiguration().setConnectionLifetime(0);
            this._queryConnector.setRetrievalPolicy(retrievalPolicy);
            Map results = this._queryConnector.retrieveQueryResultMap(selections);
            this._resultsetInterface = (ResultSetInterface)results.get(dataSelection.getID());
            Object resultSetObject = this._resultsetInterface.getResultSet();
            if (resultSetObject instanceof ResultSet) {
                this._resultSet = (ResultSet)resultSetObject;
                this._resultSet.setFetchSize(fetchRows);
                ResultSetMetaData md = this._resultSet.getMetaData();
                this._columnCount = md.getColumnCount();
                this._columnType = new int[this._columnCount];
                for (int i = 1; i <= this._columnCount; ++i) {
                    this._columnType[i - 1] = md.getColumnType(i);
                }
            } else {
                this._resultSet = null;
            }
        }
        finally {
            try {
                if (lockObject != null) {
                    session.unlock(lockObject);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public String[] generateQuery(IntelligentQueryMetadataServiceInterface iqMetadataService, SessionContextInterface session, String keep, String[] keepDropColumns) throws MetadataException, IntelligentQueryException, InvalidPromptValueException, ExecutionException, SQLException, RemoteException {
        List storedProcesses;
        String[] returnArray = null;
        if (this._map == null) {
            this._map = InformationMapFactory.getInstance().newInformationMap(session, iqMetadataService, this._briefMap);
        }
        if ((storedProcesses = this._map.getObjects(false, RunStoredProcess.class)).size() == 0) {
            String XMLStr;
            returnArray = new String[3];
            DataSelection dataSelection = null;
            dataSelection = this._filterClause != null && this._filterArray.length != 0 ? this.buildDataSelection(iqMetadataService, session, this._filterArray, this._filterClause, keep, keepDropColumns) : this.buildDataSelection(iqMetadataService, session, null, null, keep, keepDropColumns);
            this._dsXML = XMLStr = dataSelection.toXML(4);
            Locale computationLocale = null;
            String inTableName = null;
            StpNames stpNames = null;
            Map mlsLookups = null;
            StringBuffer outSql = new StringBuffer();
            StringBuffer outLibName = new StringBuffer();
            StringBuffer outTableName = new StringBuffer();
            try {
                DataSelectionUtilities.getGeneratedCode((SessionContextInterface)session, (DataSelection)dataSelection, computationLocale, stpNames, mlsLookups, inTableName, (StringBuffer)outSql, (StringBuffer)outLibName, (StringBuffer)outTableName);
            }
            catch (GenerationException e) {
                throw new IntelligentQueryException((Throwable)e);
            }
            returnArray[0] = outSql.toString();
            returnArray[1] = outTableName.toString();
            returnArray[2] = outLibName.toString();
        }
        return returnArray;
    }

    public String getDataSelectionXML() {
        return this._dsXML;
    }

    public void closeResultSet() throws SQLException, DataRetrievalException, ExecutionException {
        if (this._resultsetInterface != null) {
            if (this._queryConnector != null) {
                this._queryConnector.closeResult(this._resultsetInterface);
            }
            this._resultsetInterface.close();
        }
        if (this._queryConnector != null) {
            this._queryConnector.close(this._session);
        }
    }

    public int[] getColumnType() {
        return this._columnType;
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public int getRowCount() throws SQLException {
        if (this._rowCount == -1 && this._resultSet != null) {
            int current = this._resultSet.getRow();
            this._resultSet.last();
            this._rowCount = this._resultSet.getRow();
            if (current <= 0) {
                this._resultSet.beforeFirst();
            } else if (current > this._rowCount) {
                this._resultSet.afterLast();
            } else {
                this._resultSet.absolute(current);
            }
        }
        return this._rowCount;
    }

    public int getBufferCount() {
        return this._bufferCount;
    }

    private void getRow(int rowNum, StringBuffer rowBuffer) throws SQLException {
        for (int columnIndex = 1; columnIndex <= this._columnCount; ++columnIndex) {
            Object rowValue = this._resultSet.getObject(columnIndex);
            if (rowValue == null) {
                rowBuffer.append(BLANK);
            } else {
                switch (this._columnType[columnIndex - 1]) {
                    case 12: {
                        String strValue = this._resultSet.getString(columnIndex);
                        rowBuffer.append(strValue);
                        break;
                    }
                    default: {
                        double defaultValue = this._resultSet.getDouble(columnIndex);
                        rowBuffer.append(defaultValue);
                    }
                }
            }
            rowBuffer.append('\u0000');
        }
    }

    public String getRows(int start, int count) throws SQLException {
        if (count < 0) {
            count = 0;
        }
        if (this._currentRowNumber != start) {
            this._currentRowNumber = start;
        }
        int rowTotalLength = this.ensureRowLength();
        StringBuffer rowBuffer = new StringBuffer(rowTotalLength * count);
        boolean hasNext = this.ensureRowPosition();
        if (hasNext) {
            boolean next = true;
            int i = 0;
            while (i < count && next && !this._resultSet.isAfterLast()) {
                this.getRow(start + i, rowBuffer);
                next = this._resultSet.next();
                ++i;
                ++this._currentRowNumber;
            }
        }
        this._bufferCount = Math.max(0, this._currentRowNumber - start);
        String returnValue = rowBuffer.toString();
        rowBuffer = null;
        return returnValue;
    }

    private int ensureRowLength() throws SQLException {
        if (this._resultSet == null) {
            return 0;
        }
        int rowLength = 0;
        ResultSetMetaData rsmeta = this._resultSet.getMetaData();
        if (rsmeta != null) {
            for (int i = 1; i <= rsmeta.getColumnCount(); ++i) {
                rowLength += rsmeta.getColumnDisplaySize(i);
            }
        }
        if (rowLength > this._rowInitialLength) {
            this._rowInitialLength = rowLength;
        }
        int rowTotalLength = this._rowInitialLength + this.getColumnCount();
        rowTotalLength += rowTotalLength * 5 / 100;
        return rowTotalLength;
    }

    private boolean ensureRowPosition() throws SQLException {
        boolean returnValue = true;
        int resultSetRowNumber = this._resultSet.getRow();
        if (resultSetRowNumber != this._currentRowNumber) {
            if (this._currentRowNumber > resultSetRowNumber) {
                while (this._currentRowNumber != resultSetRowNumber && returnValue && !this._resultSet.isAfterLast()) {
                    returnValue = this._resultSet.next();
                    resultSetRowNumber = this._resultSet.getRow();
                }
                if (!returnValue) {
                    returnValue = this._resultSet.absolute(this._currentRowNumber);
                }
            } else {
                returnValue = this._resultSet.absolute(this._currentRowNumber);
            }
        }
        return returnValue;
    }

    public String[] getUnusableDataItems() {
        if (this._unUsedDataItems == null) {
            return new String[0];
        }
        String[] returnValue = new String[this._unUsedDataItems.size()];
        int stringIndex = 0;
        Iterator iter = this._unUsedDataItems.keySet().iterator();
        while (iter.hasNext()) {
            DataItem di = (DataItem)this._unUsedDataItems.get(iter.next());
            returnValue[stringIndex] = di.getIntraModelID();
            ++stringIndex;
        }
        return returnValue;
    }

    public String[] getUnusableFilterItems() {
        if (this._unUsedFilterItems == null) {
            return new String[0];
        }
        String[] returnValue = new String[this._unUsedFilterItems.size()];
        int stringIndex = 0;
        Iterator iter = this._unUsedFilterItems.keySet().iterator();
        while (iter.hasNext()) {
            FilterItem fi = (FilterItem)this._unUsedFilterItems.get(iter.next());
            returnValue[stringIndex] = fi.getIntraModelID();
            ++stringIndex;
        }
        return returnValue;
    }

    public int[] getNumUnusableBusinessItems() {
        int[] numUnusable = new int[]{this._NumUnusableDataItems, this._NumUnusableFilters, this._nonDetailedDataItems};
        return numUnusable;
    }

    public int getNonDetailedDI() {
        return this._nonDetailedDataItems;
    }

    private DataSelection buildDataSelection(IntelligentQueryMetadataServiceInterface iqMetadataService, SessionContextInterface session, String[] filterList, String filterClause, String keep, String[] keepDropColumns) throws MetadataException, InvalidPromptValueException {
        this._mapDataItems = new ArrayList();
        this._mapFilters = new ArrayList();
        if (this._map == null) {
            this._map = InformationMapFactory.getInstance().newInformationMap(session, iqMetadataService, this._briefMap);
        }
        if (this._displayBusinessItemsInFolderOrder) {
            MapFolder rootFolder = this._map.getRootMapFolder();
            this.getBusinessItemsFromFolder(rootFolder);
        }
        DataSelection dataSelection = DataSelectionFactory.newDataSelection((BusinessModel)this._map);
        dataSelection.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, true);
        dataSelection.setQueryProperty(BusinessQueryProperty.TEMP_IS_VIEW, true);
        dataSelection.setQueryProperty(BusinessQueryProperty.LIBRARY_ACCESS_READONLY, true);
        this._ds = dataSelection;
        List dataItems = this.getNetDataItems(keep, keepDropColumns);
        for (DataItem di : this._modifyDI.values()) {
            di.setFormat(null);
        }
        for (int index = 0; index < dataItems.size(); ++index) {
            DataItem di;
            di = (DataItem)dataItems.get(index);
            if (!this._aggregateData) {
                di.setUsage(DataItemActionType.USAGE_DETAIL);
            }
            dataSelection.addResultItem(di, Role.COLUMN);
        }
        if (filterClause != null && filterClause.length() != 0 && filterList != null && filterList.length != 0) {
            Stack stack = this.stringToRPN_stack(filterClause);
            ArrayList<Object> fiList = new ArrayList<Object>();
            if (stack.size() == 1) {
                FilterItem fi = (FilterItem)this._map.getBusinessItemByID(filterList[0]);
                if (!(fi instanceof FilterItem)) {
                    throw new MetadataException(this.getErrorMessageForInvalidFilterID(filterList[0]));
                }
                fiList.add(fi);
            } else {
                CompoundFilter cf = this.processFilter(stack, filterList, (BusinessModel)this._map);
                fiList.add(cf);
            }
            dataSelection.setFilters(fiList);
        }
        if (this._outPromptValues != null) {
            this.transferPromptValues(dataSelection);
        }
        return dataSelection;
    }

    private void transferPromptValues(DataSelection ds) throws InvalidPromptValueException {
        String promptID;
        List promptDefList;
        PromptValuesInterface dsPV = ds.getPromptValues();
        List delegates = dsPV.getPromptValuesDelegates();
        if (delegates != null && !delegates.isEmpty()) {
            for (PromptValuesInterface delegatePV : delegates) {
                promptDefList = delegatePV.getPromptGroup().getPromptDefinitions(true);
                for (PromptDefinitionInterface pdi : promptDefList) {
                    promptID = pdi.getPromptID();
                    if (!this._clientPromptValues.containsKey(promptID)) continue;
                    delegatePV.setPromptValue(pdi, this._clientPromptValues.get(promptID));
                }
            }
        }
        if (!(promptDefList = dsPV.getPromptGroup().getPromptDefinitions(true)).isEmpty()) {
            for (PromptDefinitionInterface pdi : promptDefList) {
                promptID = pdi.getPromptID();
                if (!this._clientPromptValues.containsKey(promptID)) continue;
                dsPV.setPromptValue(pdi, this._clientPromptValues.get(promptID));
            }
        }
    }

    private Stack stringToRPN_stack(String input) throws MetadataException {
        Stack stack = new Stack();
        StringReader stringReader = new StringReader(input);
        ExprLexer lexer = new ExprLexer(stringReader);
        ExprParser parser = new ExprParser(lexer){

            public void reportError(RecognitionException ex) {
                throw new RuntimeException(ex.getMessage(), (Throwable)ex);
            }
        };
        try {
            parser.expr();
        }
        catch (RecognitionException e) {
            MessageFormatter formatter = BaseIntegResourceBundle.getMessageFormatter("IMLE.FilterParseRecognitionError.fmt.txt", new Object[]{e});
            throw new MetadataException(formatter, (Throwable)e);
        }
        catch (TokenStreamException e) {
            MessageFormatter formatter = BaseIntegResourceBundle.getMessageFormatter("IMLE.FilterParseInvalidTokenError.fmt.txt", new Object[]{e});
            throw new MetadataException(formatter, (Throwable)e);
        }
        AST t = parser.getAST();
        if (t == null) {
            MessageFormatter formatter = BaseIntegResourceBundle.getMessageFormatter("IMLE.NullParseTree.txt", new Object[0]);
            throw new MetadataException(formatter);
        }
        CommonAST parseTree = (CommonAST)parser.getAST();
        this.recurse((AST)parseTree, stack);
        return stack;
    }

    private void recurse(AST parseTree, Stack stack) {
        AST firstchild = parseTree.getFirstChild();
        AST secondChild = parseTree.getNextSibling();
        if (secondChild != null) {
            this.recurse(secondChild, stack);
        }
        if (firstchild != null) {
            this.recurse(firstchild, stack);
        }
        stack.push(parseTree.toString());
    }

    private CompoundFilter processFilter(Stack stack, String[] filterList, BusinessModel model) throws MetadataException {
        Stack<String> reverse_stack = new Stack<String>();
        while (!stack.empty()) {
            String element = (String)stack.pop();
            if (element.toUpperCase().equals("AND") || element.toUpperCase().equals("OR") || element.toUpperCase().equals("NOT")) {
                reverse_stack.push(element);
                continue;
            }
            int fnum = Integer.parseInt(element);
            reverse_stack.push(filterList[fnum]);
        }
        Stack<String> processingStack = new Stack<String>();
        while (!reverse_stack.empty()) {
            String str = (String)reverse_stack.pop();
            processingStack.push(str);
            if (str.toUpperCase().equals("AND")) {
                this.createCompoundFilter(model, processingStack, ConditionalRelationType.AND);
                continue;
            }
            if (str.toUpperCase().equals("OR")) {
                this.createCompoundFilter(model, processingStack, ConditionalRelationType.OR);
                continue;
            }
            if (!str.toUpperCase().equals("NOT")) continue;
            processingStack.pop();
            Object o = processingStack.peek();
            CompoundFilter not = model.newCompoundFilter();
            if (o instanceof CompoundFilter) {
                not = (CompoundFilter)processingStack.pop();
                model.addBusinessItem((BusinessItem)not);
            } else {
                String val = (String)processingStack.pop();
                BusinessItem item = model.getBusinessItemByID(val);
                if (!(item instanceof FilterItem)) {
                    throw new MetadataException(this.getErrorMessageForInvalidFilterID(val));
                }
                not.setLeftFilter((FilterItem)item);
                not.setIsHidden(true);
                model.addBusinessItem((BusinessItem)not);
            }
            not.setIsNegated(!not.isNegated());
            processingStack.push((String)not);
        }
        CompoundFilter cf = (CompoundFilter)processingStack.pop();
        return cf;
    }

    private void createCompoundFilter(BusinessModel model, Stack processingStack, ConditionalRelationType crType) throws MetadataException {
        processingStack.pop();
        Object o = processingStack.peek();
        if (o instanceof CompoundFilter) {
            CompoundFilter or = model.newCompoundFilter();
            or.setRightFilter((FilterItem)processingStack.pop());
            o = processingStack.peek();
            if (o instanceof String) {
                BusinessItem item = model.getBusinessItemByID((String)processingStack.pop());
                if (!(item instanceof FilterItem)) {
                    throw new MetadataException(this.getErrorMessageForInvalidFilterID((String)o));
                }
                or.setLeftFilter((FilterItem)item);
            } else if (o instanceof CompoundFilter) {
                or.setLeftFilter((FilterItem)processingStack.pop());
            }
            or.setRelationType(crType);
            or.setIsHidden(true);
            model.addBusinessItem((BusinessItem)or);
            processingStack.push(or);
        } else {
            String val = (String)processingStack.pop();
            BusinessItem item = model.getBusinessItemByID(val);
            if (!(item instanceof FilterItem)) {
                throw new MetadataException(this.getErrorMessageForInvalidFilterID(val));
            }
            CompoundFilter and = model.newCompoundFilter();
            and.setRightFilter((FilterItem)item);
            o = processingStack.peek();
            if (o instanceof String) {
                item = model.getBusinessItemByID((String)processingStack.pop());
                if (!(item instanceof FilterItem)) {
                    throw new MetadataException(this.getErrorMessageForInvalidFilterID((String)o));
                }
                and.setLeftFilter((FilterItem)item);
            } else if (o instanceof CompoundFilter) {
                and.setLeftFilter((FilterItem)processingStack.pop());
            }
            and.setRelationType(crType);
            and.setIsHidden(true);
            model.addBusinessItem((BusinessItem)and);
            processingStack.push(and);
        }
    }

    public static void runMemoryCheck() {
        IMEMapInfo.pollUsedMemory();
        System.out.println("JVM: Total Memory=" + Math.round(_totalMemory / 1024L) + " Kb, Used Memory=" + Math.round(_usedMemory / 1024L) + " Kb, Free Memory=" + Math.round(_freeMemory / 1024L) + " Kb");
    }

    public static void gc() {
        try {
            System.gc();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.sleep(100L);
            System.gc();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static long pollUsedMemory() {
        IMEMapInfo.gc();
        _totalMemory = Runtime.getRuntime().totalMemory();
        IMEMapInfo.gc();
        _freeMemory = Runtime.getRuntime().freeMemory();
        _usedMemory = _totalMemory - _freeMemory;
        return _usedMemory;
    }

    private MessageFormatter getErrorMessageForInvalidFilterID(String filterID) throws InvalidIDException {
        MessageFormatter msg = BaseIntegResourceBundle.getMessageFormatter("IMLE.InvalidFilterID.fmt.txt", filterID);
        return msg;
    }
}

