/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.services.ServiceException;
import com.sas.wadmin.visuals.properties.RootPropertiesModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class TransformationPropertiesModel
extends RootPropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(TransformationPropertiesModel.class);
    protected static final int TRANSFORMATION_PROPERTIES_COUNT = 12;
    protected static final int TRANSFORMATION_TYPE_OTHER = 0;
    protected static final int TRANSFORMATION_TYPE_WSMQ = 1;
    protected static final int TRANSFORMATION_TYPE_MSMQ = 2;
    protected int m_iType;
    protected int m_iQueueManager;
    int iTransformationType;
    String m_QueueManagerName;
    private static List s_lAttributes = null;

    public TransformationPropertiesModel(Transformation transformation) {
        super((Root)transformation);
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iCheckedOutBy = 3;
        this.m_iType = 4;
        this.m_iQueueManager = 5;
        this.m_iLastModifiedBy = 6;
        this.m_iDateUpdated = 7;
        this.m_iDateCreated = 8;
        this.m_iLogicalType = 9;
        this.m_iMetadataID = 10;
        this.m_iUsageVersion = 11;
    }

    @Override
    public int getNumberOfProperties() {
        return 12;
    }

    @Override
    protected List getPopulateAttributes() {
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList();
            s_lAttributes.addAll(super.getPopulateAttributes());
            s_lAttributes.add("DeployedComponents");
        }
        return s_lAttributes;
    }

    @Override
    protected void initializeProperties() {
        super.initializeProperties();
        this.setProperty(this.m_iType, bundle.getString("TransformationPropertiesModel.QueueType.txt"), null, TransformationPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iQueueManager, bundle.getString("TransformationPropertiesModel.QueueManagerName.txt"), null, TransformationPropertiesModel.getDefaultRenderer());
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        super.loadPropertyValues();
        this.setTransformationType();
        if (this.iTransformationType == 1) {
            this.m_aTempValues[this.m_iType] = bundle.getString("TransformationPropertiesModel.WebsphereQueue.txt");
            this.m_aTempValues[this.m_iQueueManager] = this.m_QueueManagerName;
        } else if (this.iTransformationType == 2) {
            this.m_aTempValues[this.m_iType] = bundle.getString("TransformationPropertiesModel.MicrosoftQueue.txt");
            this.m_aTempValues[this.m_iQueueManager] = this.m_QueueManagerName;
        }
    }

    private void setTransformationType() {
        Transformation transformation = (Transformation)this.m_mdoObject;
        AssociationList alDC = null;
        if (this.m_mdoObject == null) {
            return;
        }
        try {
            alDC = transformation.getDeployedComponents();
        }
        catch (MdException me) {
            MessageUtil.displayMessage((String)me.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        DeployedComponent deployedComponent = null;
        if (alDC != null && alDC.size() > 0) {
            deployedComponent = (DeployedComponent)alDC.get(0);
        }
        if (deployedComponent != null) {
            try {
                if (deployedComponent.getClassIdentifier().compareToIgnoreCase("MessageQueue.Websphere") == 0) {
                    this.iTransformationType = 1;
                    this.m_QueueManagerName = deployedComponent.getName();
                } else if (deployedComponent.getClassIdentifier().compareToIgnoreCase("MessageQueue.MSMQ") == 0) {
                    this.iTransformationType = 2;
                    this.m_QueueManagerName = deployedComponent.getName();
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }
}

