/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.services.ServiceException;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.wadmin.visuals.properties.RootPropertiesModel;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.ParametersInterface;
import com.sas.workspace.TransformUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.metadata.WsMetadataLibraryUtil;
import com.sas.workspace.metadata.WsMetadataPhysicalTableUtil;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class PhysicalTablePropertiesModel
extends RootPropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(PhysicalTablePropertiesModel.class);
    protected static final int PHYSICALTABLE_PROPERTIES_COUNT = 15;
    protected int m_iTableName;
    protected int m_iLibrary;
    protected int m_iDBMS;
    protected int m_iNumberOfRows;
    protected int m_iNumberOfColumns;
    protected static int m_iRowCountThreadsRunning = 0;
    protected static final int MAX_ROW_COUNT_THREADS = 5;
    private static String s_strTemplate = null;
    private static List s_lAttributes = null;
    private WsAppServer m_appServer;
    private IPhysicalTable m_modelTable;

    public PhysicalTablePropertiesModel(PhysicalTable mdoObject) {
        this(mdoObject, null);
    }

    public PhysicalTablePropertiesModel(PhysicalTable mdoObject, IPhysicalTable modelTable) {
        super((Root)mdoObject);
        this.m_modelTable = modelTable;
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iCheckedOutBy = 3;
        this.m_iTableName = 4;
        this.m_iLibrary = 5;
        this.m_iDBMS = 6;
        this.m_iNumberOfRows = 7;
        this.m_iNumberOfColumns = 8;
        this.m_iLastModifiedBy = 9;
        this.m_iDateUpdated = 10;
        this.m_iDateCreated = 11;
        this.m_iLogicalType = 12;
        this.m_iMetadataID = 13;
        this.m_iUsageVersion = 14;
    }

    @Override
    public int getNumberOfProperties() {
        return 15;
    }

    @Override
    protected List getPopulateAttributes() {
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList();
            s_lAttributes.addAll(super.getPopulateAttributes());
            s_lAttributes.add("Prompts");
        }
        return s_lAttributes;
    }

    @Override
    protected String getPopulateTemplate() {
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            template.append("<DataTable><Columns/><TablePackage/></DataTable>");
            template.append("<SASLibrary><DeployedComponents/><UsingPackages/></SASLibrary>");
            s_strTemplate = template.toString();
        }
        return super.getPopulateTemplate() + s_strTemplate;
    }

    @Override
    public void createUpdatePropertyThreads() {
        WorkspaceFile defaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
        boolean bRowCount = defaultsFile.getPropertyBoolean("QuickProperties.RowCount", false);
        if (bRowCount) {
            this.m_aUpdatePropertyThreads[this.m_iNumberOfRows] = this.createRowCountThread();
        }
        this.m_aUpdatePropertyThreads[this.m_iNumberOfColumns] = this.createColumnCountThread();
    }

    @Override
    protected void initializeProperties() {
        super.initializeProperties();
        this.setProperty(this.m_iTableName, bundle.getString("PhysicalTablePropertiesModel.TableName.txt"), null, PhysicalTablePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iLibrary, bundle.getString("PhysicalTablePropertiesModel.Library.txt"), null, PhysicalTablePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iDBMS, bundle.getString("PhysicalTablePropertiesModel.DBMS.txt"), null, PhysicalTablePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iNumberOfRows, bundle.getString("PhysicalTablePropertiesModel.NumberOfRows.txt"), null, PhysicalTablePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iNumberOfColumns, bundle.getString("PhysicalTablePropertiesModel.NumberOfColumns.txt"), null, PhysicalTablePropertiesModel.getDefaultRenderer());
    }

    protected long getRowCountLong(PhysicalTable table) throws MdException, RemoteException, WsAppServerFailException, WsAppServerLibraryException, SQLException, WsAppServerCodeException {
        if (this.m_modelTable != null) {
            return WsMetadataPhysicalTableUtil.getRowCountLong((PhysicalTable)table, (WsAppServer)this.m_appServer, (ParametersInterface)new ParametersModel(), (String)this.m_modelTable.getSASTableName());
        }
        return WsMetadataPhysicalTableUtil.getRowCountLong((PhysicalTable)table, (WsAppServer)this.m_appServer, (ParametersInterface)new ParametersModel());
    }

    public void setAppServer(WsAppServer server) {
        this.m_appServer = server;
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        String dbms;
        DatabaseSchema schema;
        StringBuffer libref;
        SASLibrary library;
        super.loadPropertyValues();
        PhysicalTable table = (PhysicalTable)this.m_mdoObject;
        String sType = this.m_mdoObject.getCMetadataType();
        if ("WorkTable".equals(sType)) {
            this.m_aTempValues[this.m_iCheckedOutBy] = bundle.getString("PhysicalTablePropertiesModel.CheckedOutBy.DoesntApplyForWorkTables.txt");
        }
        if (this.m_modelTable != null) {
            this.m_aTempValues[this.m_iTableName] = this.m_modelTable.getSASTableName();
            library = this.m_modelTable.getLibraryForUseInJob();
            libref = new StringBuffer();
            if (library != null) {
                libref.append(library.getLibref());
                schema = library.getDatabaseSchema();
                if (schema != null && schema.getSchemaName().length() > 0) {
                    libref.append('.').append(schema.getSchemaName());
                }
                this.m_aTempValues[this.m_iLibrary] = bundle.formatString("PhysicalTablePropertiesModel.Library.NameLibrefSchema.fmt", (Object)library.getName(), (Object)libref.toString());
            } else {
                this.m_aTempValues[this.m_iLibrary] = this.m_modelTable instanceof IWorkTable ? bundle.getString("PhysicalTablePropertiesModel.WorkTableNoLibrary.txt") : "";
            }
            dbms = "SAS";
            try {
                dbms = this.m_modelTable.getDBMSProductName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_aTempValues[this.m_iDBMS] = !this.m_modelTable.isView() ? bundle.formatString("PhysicalTablePropertiesModel.DBMSTable.fmt", (Object)dbms) : bundle.formatString("PhysicalTablePropertiesModel.DBMSView.fmt", (Object)dbms);
        } else {
            this.m_aTempValues[this.m_iTableName] = table.getSASTableName();
            library = LibraryUtil.findLibraryForTable((AssociationList)table.getTablePackages());
            libref = new StringBuffer();
            if (library != null) {
                libref.append(library.getLibref());
                schema = WsMetadataLibraryUtil.getSchemaForLibrary((SASLibrary)library);
                if (schema != null && schema.getSchemaName().length() > 0) {
                    libref.append('.');
                    libref.append(schema.getSchemaName());
                }
                this.m_aTempValues[this.m_iLibrary] = bundle.formatString("PhysicalTablePropertiesModel.Library.NameLibrefSchema.fmt", (Object)library.getName(), (Object)libref.toString());
            } else {
                this.m_aTempValues[this.m_iLibrary] = "WorkTable".equals(sType) ? bundle.getString("PhysicalTablePropertiesModel.WorkTableNoLibrary.txt") : "";
            }
            dbms = TransformUtil.getDBMSProductName((PhysicalTable)table);
            if (dbms == null && !"WorkTable".equals(sType)) {
                dbms = "SAS";
            }
            this.m_aTempValues[this.m_iDBMS] = dbms != null ? ("DATA".equalsIgnoreCase(table.getMemberType()) ? bundle.formatString("PhysicalTablePropertiesModel.DBMSTable.fmt", (Object)dbms) : bundle.formatString("PhysicalTablePropertiesModel.DBMSView.fmt", (Object)dbms)) : "";
        }
        WorkspaceFile defaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
        boolean bRowCount = defaultsFile.getPropertyBoolean("QuickProperties.RowCount", false);
        this.m_aTempValues[this.m_iNumberOfRows] = bRowCount ? null : bundle.getString("PhysicalTablePropertiesModel.RowCountDisabled.txt");
        if (this.m_modelTable != null) {
            NumberFormat nf = NumberFormat.getIntegerInstance();
            String columnCount = nf.format(this.m_modelTable.getColumnCount());
            this.m_aTempValues[this.m_iNumberOfColumns] = columnCount;
        } else {
            this.m_aTempValues[this.m_iNumberOfColumns] = null;
        }
    }

    protected Thread createColumnCountThread() {
        return new cGetColumnCountThread();
    }

    protected Thread createRowCountThread() {
        return new cGetRowCountThread();
    }

    protected class cGetRowCountThread
    extends Thread {
        public cGetRowCountThread() {
            super("basic properties row count for " + PhysicalTablePropertiesModel.this.m_mdoObject);
        }

        @Override
        public void run() {
            if (m_iRowCountThreadsRunning >= 5) {
                try {
                    Workspace.getDefaultLogger().info((Object)bundle.formatString("PhysicalTablePropertiesModel.RowCount.TooMany.fmt", (Object)PhysicalTablePropertiesModel.this.m_mdoObject.getName()));
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                PhysicalTablePropertiesModel.this.m_aTempValues[PhysicalTablePropertiesModel.this.m_iNumberOfRows] = bundle.getString("Common.Unknown.txt");
            } else {
                ++m_iRowCountThreadsRunning;
                PhysicalTable table = (PhysicalTable)PhysicalTablePropertiesModel.this.m_mdoObject;
                NumberFormat nf = NumberFormat.getIntegerInstance();
                long rowCount = -1L;
                try {
                    rowCount = PhysicalTablePropertiesModel.this.getRowCountLong(table);
                }
                catch (MdException me) {
                    if (PhysicalTablePropertiesModel.this.isDisplayErrors()) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                    } else {
                        Workspace.getDefaultLogger().error((Object)bundle.formatString("PhysicalTablePropertiesModel.RowCount.MdException.fmt", (Object)me.getLocalizedMessage()));
                    }
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                catch (Exception e) {
                    if (PhysicalTablePropertiesModel.this.isDisplayErrors()) {
                        MessageUtil.displayMessage((String)e.getMessage(), (int)0);
                    }
                    Workspace.getDefaultLogger().error((Object)bundle.formatString("PhysicalTablePropertiesModel.RowCount.Exception.fmt", (Object)e.getLocalizedMessage()));
                }
                if (rowCount == -1L) {
                    PhysicalTablePropertiesModel.this.m_aTempValues[PhysicalTablePropertiesModel.this.m_iNumberOfRows] = bundle.getString("Common.Unknown.txt");
                } else {
                    String rowCountString = nf.format(rowCount);
                    PhysicalTablePropertiesModel.this.m_aTempValues[PhysicalTablePropertiesModel.this.m_iNumberOfRows] = rowCountString;
                }
                --m_iRowCountThreadsRunning;
            }
            PhysicalTablePropertiesModel.this.setPropertyValue(PhysicalTablePropertiesModel.this.m_iNumberOfRows, PhysicalTablePropertiesModel.this.m_aTempValues[PhysicalTablePropertiesModel.this.m_iNumberOfRows]);
        }
    }

    protected class cGetColumnCountThread
    extends Thread {
        public cGetColumnCountThread() {
            super("basic properties column count for " + PhysicalTablePropertiesModel.this.m_mdoObject);
        }

        @Override
        public void run() {
            if (PhysicalTablePropertiesModel.this.m_modelTable != null) {
                return;
            }
            try {
                PhysicalTable table = (PhysicalTable)PhysicalTablePropertiesModel.this.m_mdoObject;
                NumberFormat nf = NumberFormat.getIntegerInstance();
                String columnCount = nf.format(table.getColumns().size());
                PhysicalTablePropertiesModel.this.m_aTempValues[PhysicalTablePropertiesModel.this.m_iNumberOfColumns] = columnCount;
            }
            catch (MdException me) {
                if (PhysicalTablePropertiesModel.this.isDisplayErrors()) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                } else {
                    Workspace.getDefaultLogger().error((Object)bundle.formatString("PhysicalTablePropertiesModel.ColumnCount.MdException.fmt", (Object)me.getLocalizedMessage()));
                }
                PhysicalTablePropertiesModel.this.m_aTempValues[PhysicalTablePropertiesModel.this.m_iNumberOfColumns] = bundle.getString("Common.Unknown.txt");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            PhysicalTablePropertiesModel.this.setPropertyValue(PhysicalTablePropertiesModel.this.m_iNumberOfColumns, PhysicalTablePropertiesModel.this.m_aTempValues[PhysicalTablePropertiesModel.this.m_iNumberOfColumns]);
        }
    }
}

