/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.services.ServiceException;
import com.sas.wadmin.visuals.properties.RootPropertiesModel;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.metadata.WsMetadataLibraryUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class LibraryPropertiesModel
extends RootPropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(LibraryPropertiesModel.class);
    private static final String BASE_SAS_LIBRARY = "BASE";
    protected static final int LIBRARY_PROPERTIES_COUNT = 14;
    protected int m_iLibref;
    protected int m_iPath;
    protected int m_iServer;
    protected int m_iLibname;
    private static String s_strTemplate = null;
    private static List s_lAttributes = null;

    public LibraryPropertiesModel(SASLibrary lib) {
        super((Root)lib);
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iCheckedOutBy = 3;
        this.m_iLibref = 4;
        this.m_iPath = 5;
        this.m_iServer = 6;
        this.m_iLibname = 7;
        this.m_iLastModifiedBy = 8;
        this.m_iDateUpdated = 9;
        this.m_iDateCreated = 10;
        this.m_iLogicalType = 11;
        this.m_iMetadataID = 12;
        this.m_iUsageVersion = 13;
    }

    @Override
    public int getNumberOfProperties() {
        return 14;
    }

    @Override
    protected String getPopulateTemplate() {
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            template.append("<DeployedDataPackage><DeployedComponents/></DeployedDataPackage>");
            s_strTemplate = template.toString();
        }
        return super.getPopulateTemplate() + s_strTemplate;
    }

    @Override
    protected List getPopulateAttributes() {
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList();
            s_lAttributes.addAll(super.getPopulateAttributes());
            s_lAttributes.add("DeployedComponents");
            s_lAttributes.add("Properties");
            s_lAttributes.add("UsingPackages");
        }
        return s_lAttributes;
    }

    @Override
    protected void initializeProperties() {
        super.initializeProperties();
        this.setProperty(this.m_iLibref, bundle.getString("LibraryPropertiesModel.Libref.txt"), null, LibraryPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iPath, bundle.getString("LibraryPropertiesModel.Path.txt"), null, LibraryPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iServer, bundle.getString("LibraryPropertiesModel.Server.txt"), null, LibraryPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iLibname, bundle.getString("LibraryPropertiesModel.Libname.txt"), null, LibraryPropertiesModel.getDefaultRenderer());
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        super.loadPropertyValues();
        SASLibrary library = (SASLibrary)this.m_mdoObject;
        StringBuffer sbLibref = new StringBuffer();
        ArrayList<String> paths = new ArrayList<String>();
        sbLibref.append(library.getLibref());
        DatabaseSchema schema = WsMetadataLibraryUtil.getSchemaForLibrary((SASLibrary)library);
        if (schema != null) {
            sbLibref.append(".");
            sbLibref.append(schema.getSchemaName());
        }
        if (library.getEngine().equals(BASE_SAS_LIBRARY)) {
            AssociationList alPaths = library.getUsingPackages();
            for (int i = 0; i < alPaths.size(); ++i) {
                paths.add(((Directory)alPaths.get(i)).getDirectoryName());
            }
        }
        this.m_aTempValues[this.m_iLibref] = sbLibref;
        this.m_aTempValues[this.m_iPath] = this.createCommaDelimitedString(paths);
        this.m_aTempValues[this.m_iServer] = this.createCommaDelimitedString((List)library.getDeployedComponents());
        this.m_aTempValues[this.m_iLibname] = LibraryUtil.getAccessPath((SASLibrary)library, null, (boolean)true, (boolean)false);
    }
}

