/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Key;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.UniqueKey;
import com.sas.services.ServiceException;
import com.sas.wadmin.visuals.properties.RootPropertiesModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsColumnMetadataUtil;
import java.rmi.RemoteException;
import java.text.NumberFormat;

public class ColumnPropertiesModel
extends RootPropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ColumnPropertiesModel.class);
    protected static final int COLUMN_PROPERTIES_COUNT = 18;
    protected int m_iSASColumnName;
    protected int m_iSASColumnLength;
    protected int m_iType;
    protected int m_iInformat;
    protected int m_iFormat;
    protected int m_iIsNullable;
    protected int m_iPrimaryKey;
    protected int m_iIndex;

    public ColumnPropertiesModel(Column col) {
        super((Root)col);
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iSASColumnName = 3;
        this.m_iSASColumnLength = 4;
        this.m_iType = 5;
        this.m_iInformat = 6;
        this.m_iFormat = 7;
        this.m_iIsNullable = 8;
        this.m_iPrimaryKey = 9;
        this.m_iIndex = 10;
        this.m_iCheckedOutBy = 11;
        this.m_iLastModifiedBy = 12;
        this.m_iDateUpdated = 13;
        this.m_iDateCreated = 14;
        this.m_iLogicalType = 15;
        this.m_iMetadataID = 16;
        this.m_iUsageVersion = 17;
    }

    @Override
    public int getNumberOfProperties() {
        return 18;
    }

    @Override
    protected void initializeProperties() {
        super.initializeProperties();
        this.setProperty(this.m_iSASColumnName, bundle.getString("ColumnPropertiesModel.SASColumnName.txt"), null, ColumnPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iSASColumnLength, bundle.getString("ColumnPropertiesModel.SASColumnLength.txt"), null, ColumnPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iType, bundle.getString("ColumnPropertiesModel.Type.txt"), null, ColumnPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iInformat, bundle.getString("ColumnPropertiesModel.Informat.txt"), null, ColumnPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iFormat, bundle.getString("ColumnPropertiesModel.Format.txt"), null, ColumnPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iIsNullable, bundle.getString("ColumnPropertiesModel.IsNullable.txt"), null, ColumnPropertiesModel.getDefaultBooleanRenderer());
        this.setProperty(this.m_iPrimaryKey, bundle.getString("ColumnPropertiesModel.PrimaryKey.txt"), null, ColumnPropertiesModel.getDefaultBooleanRenderer());
        this.setProperty(this.m_iIndex, bundle.getString("ColumnPropertiesModel.Index.txt"), null, ColumnPropertiesModel.getDefaultBooleanRenderer());
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        super.loadPropertyValues();
        Column col = (Column)this.m_mdoObject;
        NumberFormat nf = NumberFormat.getIntegerInstance();
        AssociationList lKeys = col.getKeys();
        boolean hasUniqueKey = false;
        for (int i = 0; i < lKeys.size(); ++i) {
            UniqueKey uniqueKey;
            Key key = (Key)lKeys.get(i);
            if (!(key instanceof UniqueKey) || (uniqueKey = (UniqueKey)key).getIsPrimary() != 1) continue;
            hasUniqueKey = true;
            break;
        }
        AssociationList lIndexes = col.getIndexes();
        this.m_aTempValues[this.m_iSASColumnName] = col.getSASColumnName();
        this.m_aTempValues[this.m_iSASColumnLength] = nf.format(col.getSASColumnLength());
        this.m_aTempValues[this.m_iType] = WsColumnMetadataUtil.getColumnViewTypeString((Column)col);
        this.m_aTempValues[this.m_iInformat] = col.getSASInformat();
        this.m_aTempValues[this.m_iFormat] = col.getSASFormat();
        this.m_aTempValues[this.m_iIsNullable] = col.getIsNullable() == 1;
        this.m_aTempValues[this.m_iPrimaryKey] = hasUniqueKey;
        this.m_aTempValues[this.m_iIndex] = lIndexes.size() > 0;
    }
}

