/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.metadata.remote.MdException;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.workspace.models.SimpleBrowseObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class BrowseObjectUtil
implements SimpleBrowseObject {
    SimpleBrowseObject m_browseObject = null;
    BrowseMetadataInterface m_browse;
    private static final String BASE_SAS_LIBRARY = "BASE";

    public BrowseObjectUtil(SimpleBrowseObject object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        this.m_browseObject = object;
        this.m_browse = this.m_browseObject.getBrowseObject();
    }

    public BrowseMetadataInterface getBrowseObject() {
        return this.m_browse;
    }

    public String getChangeState() {
        return this.m_browseObject.getChangeState();
    }

    public String getISEntityKey() {
        return this.m_browseObject.getISEntityKey();
    }

    public String getLockedBy() {
        return this.m_browseObject.getLockedBy();
    }

    public boolean isAFolder() {
        return this.m_browseObject.isAFolder();
    }

    public void setBrowseObject(BrowseMetadataInterface browseObject) {
        this.m_browseObject.setBrowseObject(browseObject);
        this.m_browse = browseObject;
    }

    public String getID() {
        return this.m_browseObject.getID();
    }

    public String getMetadataType() {
        return this.m_browseObject.getMetadataType();
    }

    public String getName() {
        return this.m_browseObject.getName();
    }

    public String getPublicType() {
        return this.m_browseObject.getPublicType();
    }

    public boolean isNew() {
        return this.m_browseObject.isNew();
    }

    public boolean isPublicObject() {
        return this.m_browseObject.isPublicObject();
    }

    public Object get(String key) {
        return this.m_browse.get(key);
    }

    public static String generateLibRef(BrowseMetadataInterface library) {
        StringBuffer libref = new StringBuffer();
        libref.append(library.get("Libref"));
        BrowseMetadataInterface schema = BrowseObjectUtil.getSchemaForLibrary(library);
        if (schema != null) {
            libref.append('.');
            libref.append(schema.get("SchemaName"));
        }
        String libRef = libref.toString();
        return libRef;
    }

    public static BrowseMetadataInterface getSchemaForLibrary(BrowseMetadataInterface library) {
        BrowseMetadataInterface schema;
        if (library == null) {
            return null;
        }
        List schemaList = (List)library.get("UsingPackages");
        if (schemaList != null && schemaList.size() > 0 && "DatabaseSchema".equals((schema = (BrowseMetadataInterface)schemaList.get(0)).getNativeType())) {
            return schema;
        }
        return null;
    }

    public static String getDBMSProductName(BrowseMetadataInterface table) throws MdException, RemoteException {
        List tablePackages = (List)table.get("TablePackage");
        BrowseMetadataInterface schema = null;
        if (tablePackages != null && tablePackages.size() > 0) {
            schema = (BrowseMetadataInterface)tablePackages.get(0);
        }
        if ("WorkTable".equals(table.getNativeType()) && schema == null) {
            return "SAS";
        }
        if (schema == null) {
            return null;
        }
        if ("SASLibrary".equals(schema.getNativeType())) {
            String libEng = (String)schema.get("Engine");
            if (libEng.startsWith("XML")) {
                return libEng;
            }
            if (libEng.equalsIgnoreCase("JSON")) {
                return libEng;
            }
            if (libEng.length() == 0 || !libEng.equalsIgnoreCase("SPDE")) {
                return "SAS";
            }
            return "SPDE";
        }
        List dcList = (List)schema.get("DeployedComponents");
        if (dcList == null || dcList.size() <= 0) {
            return "";
        }
        BrowseMetadataInterface dc = (BrowseMetadataInterface)dcList.get(0);
        if (dc == null) {
            return "";
        }
        String productName = (String)dc.get("ProductName");
        return productName;
    }

    public static BrowseMetadataInterface findLibraryForTable(List tablePackages) throws MdException, RemoteException {
        BrowseMetadataInterface lib = null;
        if (tablePackages != null) {
            for (int i = 0; i < tablePackages.size(); ++i) {
                List dbLibList;
                BrowseMetadataInterface tablePackage = (BrowseMetadataInterface)tablePackages.get(i);
                if ("SASLibrary".equals(tablePackage.getNativeType())) {
                    lib = tablePackage;
                    return lib;
                }
                if (!"DatabaseSchema".equals(tablePackage.getNativeType()) || (lib = BrowseObjectUtil.findLibraryForTable(dbLibList = (List)tablePackage.get("UsedByPackages"))) == null) continue;
                return lib;
            }
        }
        return lib;
    }

    public static List getLibraryPaths(BrowseMetadataInterface browseLibrary) throws RemoteException {
        ArrayList<String> paths = new ArrayList<String>();
        List alPaths = (List)browseLibrary.get("UsingPackages");
        if (alPaths != null) {
            for (int i = 0; i < alPaths.size(); ++i) {
                String dirName;
                BrowseMetadataInterface directory = (BrowseMetadataInterface)alPaths.get(i);
                if (directory == null || (dirName = (String)directory.get("DirectoryName")) == null) continue;
                paths.add(dirName);
            }
        }
        return paths;
    }
}

