/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.etl.models.job.impl.GeneratedTransformNames;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.wadmin.visuals.properties.BrowsePropertiesModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.models.SimpleBrowseObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BrowseGeneratedTransformPropertiesModel
extends BrowsePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(BrowseGeneratedTransformPropertiesModel.class);
    protected static final int PROTOTYPE_PROPERTIES_COUNT = 13;
    protected int m_iCategory;
    private static List s_lAttributes = null;

    public BrowseGeneratedTransformPropertiesModel(SimpleBrowseObject prototype) {
        super(prototype);
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iCheckedOutBy = 3;
        this.m_iCategory = 4;
        this.m_iLastModifiedBy = 5;
        this.m_iDateUpdated = 6;
        this.m_iDateCreated = 7;
        this.m_iDateArchived = 8;
        this.m_iArchiveName = 9;
        this.m_iLogicalType = 10;
        this.m_iMetadataID = 11;
        this.m_iUsageVersion = 12;
    }

    @Override
    public int getNumberOfProperties() {
        return 13;
    }

    @Override
    protected List getPopulateAttributes() {
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList();
            s_lAttributes.addAll(super.getPopulateAttributes());
            s_lAttributes.add("Extensions");
            s_lAttributes.add("Properties");
        }
        return s_lAttributes;
    }

    @Override
    protected void initializeProperties() {
        super.initializeProperties();
        this.setProperty(this.m_iCategory, bundle.getString("TransformPropertiesModel.Category.txt"), null, BrowseGeneratedTransformPropertiesModel.getDefaultRenderer());
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        super.loadPropertyValues();
        BrowseMetadataInterface browse = this.m_browseObject.getBrowseObject();
        String strGUID = BrowseGeneratedTransformPropertiesModel.getGuid(browse);
        GeneratedTransformNames gtNames = new GeneratedTransformNames(strGUID);
        String category = null;
        if (!gtNames.isNameStoredInBundle()) {
            List extensions = (List)browse.get("Extensions");
            if (extensions != null && extensions.size() > 0) {
                for (int i = 0; i < extensions.size(); ++i) {
                    BrowseMetadataInterface ext = (BrowseMetadataInterface)extensions.get(i);
                    if (!"UITREECATEGORY".equalsIgnoreCase(ext.getName())) continue;
                    category = (String)ext.get("Value");
                    break;
                }
            }
        } else {
            this.m_aTempValues[this.m_iName] = gtNames.getName();
            this.m_aTempValues[this.m_iDescription] = gtNames.getDescription();
            category = gtNames.getTreeLocation();
        }
        this.m_aTempValues[this.m_iCategory] = category != null ? category : null;
    }

    public static String getGuid(BrowseMetadataInterface proto) throws MdException, RemoteException {
        BrowseMetadataInterface prop = BrowseGeneratedTransformPropertiesModel.getGUIDProperty(proto);
        if (prop != null) {
            return (String)prop.get("DefaultValue");
        }
        String sGetXML = BrowseGeneratedTransformPropertiesModel.getGetXML(proto);
        if (sGetXML == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
        Matcher matcher = pattern.matcher(sGetXML);
        String strGUID = null;
        if (matcher.find()) {
            strGUID = matcher.group();
        }
        return strGUID;
    }

    public static BrowseMetadataInterface getGUIDProperty(BrowseMetadataInterface proto) throws MdException, RemoteException {
        List lstProps = (List)proto.get("Properties");
        if (lstProps != null) {
            int size = lstProps.size();
            for (int i = 0; i < size; ++i) {
                BrowseMetadataInterface p = (BrowseMetadataInterface)lstProps.get(i);
                String propName = (String)p.get("PropertyName");
                if (!"Class".equals(propName)) continue;
                return p;
            }
        }
        return null;
    }

    public static String getGetXML(BrowseMetadataInterface mdoTransform) throws MdException, RemoteException {
        BrowseMetadataInterface storedText;
        String text = null;
        if (mdoTransform != null && (storedText = BrowseGeneratedTransformPropertiesModel.getGetXMLTextStore(mdoTransform)) != null) {
            text = (String)storedText.get("StoredText");
        }
        return text;
    }

    public static BrowseMetadataInterface getGetXMLTextStore(BrowseMetadataInterface mdoTransform) throws MdException, RemoteException {
        List lProperties;
        BrowseMetadataInterface textStore = null;
        if (mdoTransform != null && (lProperties = (List)mdoTransform.get("Properties")) != null) {
            for (int iProperty = 0; iProperty < lProperties.size(); ++iProperty) {
                BrowseMetadataInterface storedText;
                String sGetXML;
                BrowseMetadataInterface property = (BrowseMetadataInterface)lProperties.get(iProperty);
                String propertyName = (String)property.get("PropertyName");
                if (!"GetXML".equals(propertyName) || (sGetXML = (String)(storedText = (BrowseMetadataInterface)property.get("StoredConfiguration")).get("StoredText")).indexOf("PropertyName=\"Class\"") <= -1) continue;
                textStore = storedText;
                break;
            }
        }
        return textStore;
    }
}

