/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.wadmin.visuals.properties.BrowsePropertiesModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.models.SimpleBrowseObject;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class BrowseExternalFilePropertiesModel
extends BrowsePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(BrowseExternalFilePropertiesModel.class);
    protected static final int EXTERNALTABLE_PROPERTIES_COUNT = 15;
    private static List s_lAttributes = null;
    private static String s_strTemplate = null;
    protected int m_iPath;
    protected int m_iServer;
    protected int m_iNumberOfColumns;

    public BrowseExternalFilePropertiesModel(SimpleBrowseObject et) {
        super(et);
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iCheckedOutBy = 3;
        this.m_iPath = 4;
        this.m_iServer = 5;
        this.m_iNumberOfColumns = 6;
        this.m_iLastModifiedBy = 7;
        this.m_iDateUpdated = 8;
        this.m_iDateCreated = 9;
        this.m_iDateArchived = 10;
        this.m_iArchiveName = 11;
        this.m_iLogicalType = 12;
        this.m_iMetadataID = 13;
        this.m_iUsageVersion = 14;
    }

    @Override
    public int getNumberOfProperties() {
        return 15;
    }

    @Override
    protected void initializeProperties() {
        super.initializeProperties();
        this.setProperty(this.m_iPath, bundle.getString("ExternalTablePropertiesModel.Path.txt"), null, BrowseExternalFilePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iServer, bundle.getString("ExternalTablePropertiesModel.Server.txt"), null, BrowseExternalFilePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iNumberOfColumns, bundle.getString("ExternalTablePropertiesModel.NumberOfColumns.txt"), null, BrowseExternalFilePropertiesModel.getDefaultRenderer());
    }

    @Override
    protected List getPopulateAttributes() {
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList();
            s_lAttributes.addAll(super.getPopulateAttributes());
            s_lAttributes.add("OwningFile");
            s_lAttributes.add("Columns");
            s_lAttributes.add("TablePackage");
            s_lAttributes.add("Prompts");
        }
        return s_lAttributes;
    }

    @Override
    protected String getPopulateTemplate() {
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            template.append("<File><FileRefs/></File>");
            template.append("<SASFileRef><DeployedComponents/></SASFileRef>");
            template.append("<SASLibrary><DeployedComponents/><UsingPackages/></SASLibrary>");
            s_strTemplate = template.toString();
        }
        return super.getPopulateTemplate() + s_strTemplate;
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        List columns;
        super.loadPropertyValues();
        BrowseMetadataInterface browse = this.m_browseObject.getBrowseObject();
        List files = (List)browse.get("OwningFile");
        if (files != null && files.size() > 0) {
            BrowseMetadataInterface fileref;
            List servers;
            BrowseMetadataInterface file = (BrowseMetadataInterface)files.get(0);
            String fileName = (String)file.get("FileName");
            this.m_aTempValues[this.m_iPath] = fileName;
            List filerefs = (List)file.get("FileRefs");
            if (filerefs != null && filerefs.size() > 0 && (servers = (List)(fileref = (BrowseMetadataInterface)filerefs.get(0)).get("DeployedComponents")) != null && servers.size() > 0) {
                BrowseMetadataInterface server = (BrowseMetadataInterface)servers.get(0);
                this.m_aTempValues[this.m_iServer] = server.get("Name");
            }
        }
        if ((columns = (List)browse.get("Columns")) != null) {
            NumberFormat nf = NumberFormat.getIntegerInstance();
            this.m_aTempValues[this.m_iNumberOfColumns] = nf.format(columns.size());
        } else {
            this.m_aTempValues[this.m_iNumberOfColumns] = bundle.getString("Common.Unknown.txt");
        }
    }
}

