/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.impl;

import com.sas.wadmin.visuals.common.enhancededitor.DecoratorProvider;
import com.sas.wadmin.visuals.common.enhancededitor.ParseData;
import com.sas.wadmin.visuals.common.enhancededitor.RenderProvider;
import com.sas.wadmin.visuals.common.enhancededitor.Token;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EditorUtils;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedDocument;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedEditorPane;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedRender;
import com.sas.wadmin.visuals.common.enhancededitor.impl.SectionsInfo;
import com.sas.wadmin.visuals.common.enhancededitor.impl.TokenMapInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public class EnhancedEditorView
extends PlainView {
    private Element longLine;
    private RenderProvider renderProvider;
    private DecoratorProvider decoratorProvider;
    private Font baseFont;
    private FontMetrics mMetrics;
    private int tabSize;
    private int tabBase;
    private int sel0;
    private int sel1;
    EnhancedRender DEFAULT_RENDER = new EnhancedRender(Color.BLACK, false, false);
    private static RenderingHints sysHints = null;

    public EnhancedEditorView(Element ele, RenderProvider renderProvider, DecoratorProvider decoratorProvider) {
        super(ele);
        this.renderProvider = renderProvider;
        this.decoratorProvider = decoratorProvider;
    }

    public static void setRenderingHits(Graphics2D g2d) {
        g2d.addRenderingHints(sysHints);
    }

    @Override
    public void changedUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    @Override
    public void insertUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        EnhancedDocument doc = (EnhancedDocument)this.getDocument();
        SectionsInfo sectionsInfo = doc.getSectionsInfo();
        Element root = this.getElement();
        int changeLine = root.getElementIndex(changes.getOffset());
        sectionsInfo.expand(changeLine);
        this.updateDamage(changes, a, f);
    }

    @Override
    public void removeUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        EnhancedDocument doc = (EnhancedDocument)this.getDocument();
        SectionsInfo sectionsInfo = doc.getSectionsInfo();
        Element root = this.getElement();
        int changeLine = root.getElementIndex(changes.getOffset());
        sectionsInfo.expand(changeLine);
        this.updateDamage(changes, a, f);
    }

    @Override
    protected void damageLineRange(int line0, int line1, Shape a, Component host) {
        if (a != null) {
            Rectangle area0 = this.lineToRect(a, line0);
            Rectangle area1 = this.lineToRect(a, line1);
            if (area0 != null && area1 != null) {
                Rectangle damage = area0.union(area1);
                host.repaint(damage.x, damage.y, damage.width, damage.height);
            } else {
                host.repaint();
            }
        }
    }

    @Override
    public int getNextVisualPositionFrom(int offset1, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        EnhancedDocument doc = (EnhancedDocument)this.getDocument();
        SectionsInfo sectionsInfo = doc.getSectionsInfo();
        int line1 = EditorUtils.getLineIndex(doc, offset1);
        switch (direction) {
            case 1: 
            case 5: {
                int offset2 = offset1;
                if (direction == 5 && sectionsInfo.getLastTopLevelLine() == line1) {
                    return offset1;
                }
                if (direction == 1 && sectionsInfo.getFirstTopLevelLine() == line1) {
                    return offset1;
                }
                while (sectionsInfo.isLineInCollpase(EditorUtils.getLineIndex(doc, offset2 = super.getNextVisualPositionFrom(offset2, b, a, direction, biasRet))) && offset2 >= 0) {
                }
                if (offset2 == -1) {
                    int lineLength;
                    int line2 = EditorUtils.getLineIndex(doc, offset1);
                    int gotoVisibleLine = direction == 1 ? sectionsInfo.getPreviousTopLevelLine(line2, 1) : sectionsInfo.getNextTopLevelLine(line2, 1);
                    int lineOffset = offset1 - EditorUtils.getCurrentLineStartOffset(doc, offset1);
                    if (lineOffset > (lineLength = EditorUtils.getLineLength(doc, gotoVisibleLine) - 1)) {
                        lineOffset = lineLength;
                    }
                    offset2 = EditorUtils.getStartOffsetForLine(doc, gotoVisibleLine) + lineOffset;
                }
                return offset2;
            }
            case 3: {
                int offset2 = offset1 + 1;
                int line2 = EditorUtils.getLineIndex(doc, offset2);
                if (line1 == line2 || !sectionsInfo.isLineInCollpase(line2)) break;
                int lastVisLine = sectionsInfo.getLastTopLevelLine();
                if (line1 == lastVisLine) {
                    return offset1;
                }
                line2 = sectionsInfo.getNextTopLevelLine(line1, 1);
                offset2 = EditorUtils.getStartOffsetForLine(doc, line2);
                return offset2;
            }
            case 7: {
                int offset2 = offset1 - 1;
                int line2 = EditorUtils.getLineIndex(doc, offset2);
                if (line1 == line2 || !sectionsInfo.isLineInCollpase(line2)) break;
                int firstVisLine = sectionsInfo.getFirstTopLevelLine();
                if (line1 == firstVisLine) {
                    return offset1;
                }
                line2 = sectionsInfo.getPreviousTopLevelLine(line1, 1);
                offset2 = EditorUtils.getStartOffsetForLine(doc, line2);
                return offset2 += EditorUtils.getLineLength(doc, line2) - 1;
            }
        }
        return super.getNextVisualPositionFrom(offset1, b, a, direction, biasRet);
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        EnhancedDocument doc = (EnhancedDocument)this.getDocument();
        SectionsInfo sectionsInfo = doc.getSectionsInfo();
        int lineIndex = doc.getDefaultRootElement().getElementIndex(pos);
        Rectangle lineArea = this.lineToRect(a, lineIndex);
        boolean isTopLevel = !sectionsInfo.isLineInCollpase(lineIndex);
        int tabBase = lineArea.x;
        Element line = this.getElement(lineIndex);
        int p0 = line.getStartOffset();
        doc.getText(p0, pos - p0, this.getLineBuffer());
        int xOffs = 0;
        TokenMapInfo tm = doc.getTokenMapInfo();
        if (tm != null) {
            xOffs = tm.getTabbedTextWidth(this.getLineBuffer(), this.mMetrics, tabBase, p0, this);
        }
        if (tm == null || xOffs < 1) {
            xOffs = Utilities.getTabbedTextWidth(this.getLineBuffer(), this.mMetrics, tabBase, (TabExpander)this, p0);
        }
        lineArea.x += xOffs;
        lineArea.width = 1;
        lineArea.height = isTopLevel ? this.mMetrics.getHeight() : 0;
        return lineArea;
    }

    @Override
    public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
        bias[0] = Position.Bias.Forward;
        Rectangle alloc = a.getBounds();
        EnhancedDocument doc = (EnhancedDocument)this.getDocument();
        SectionsInfo sectionsInfo = doc.getSectionsInfo();
        int x = (int)fx;
        int y = (int)fy;
        if (y < alloc.y) {
            int firstTopLevel = sectionsInfo.getFirstTopLevelLine();
            Element line = this.getElement(firstTopLevel);
            return line.getStartOffset();
        }
        if (y > alloc.y + alloc.height) {
            int lastTopLevel = sectionsInfo.getLastTopLevelLine();
            Element line = this.getElement(lastTopLevel);
            return line.getEndOffset() - 1;
        }
        return this.calculateModelOffset(alloc, doc, sectionsInfo, x, y);
    }

    private int calculateModelOffset(Rectangle alloc, EnhancedDocument doc, SectionsInfo sectionsInfo, int x, int y) {
        int topLevelLineCount;
        int offset = -1;
        int topLevelLineIndex = Math.abs((y - alloc.y) / this.mMetrics.getHeight());
        if (topLevelLineIndex >= (topLevelLineCount = sectionsInfo.getTopLevelLineCount())) {
            int lineIndex = sectionsInfo.getLastTopLevelLine();
            Element line = this.getElement(lineIndex);
            offset = line.getEndOffset() - 1;
        } else {
            int lineIndex = sectionsInfo.getNthTopLevelLine(topLevelLineIndex + 1);
            Element line = this.getElement(lineIndex);
            if (x < alloc.x) {
                offset = line.getStartOffset();
            } else if (x > alloc.x + alloc.width) {
                offset = line.getEndOffset() - 1;
            } else {
                try {
                    int p0 = line.getStartOffset();
                    int p1 = line.getEndOffset() - 1;
                    doc.getText(p0, p1 - p0, this.getLineBuffer());
                    int tabBase = alloc.x;
                    offset = p0 + Utilities.getTabbedTextOffset(this.getLineBuffer(), this.mMetrics, tabBase, x, this, p0);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return offset;
    }

    @Override
    protected int drawSelectedText(Graphics graphics, int x, int y, int p0, int p1) throws BadLocationException {
        return this.drawUnselectedText(graphics, x, y, p0, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int drawUnselectedText(Graphics graphics, int x, int y, int p0, int p1) {
        EnhancedEditorView.setRenderingHits((Graphics2D)graphics);
        Font saveFont = graphics.getFont();
        Color saveColor = graphics.getColor();
        EnhancedDocument doc = (EnhancedDocument)this.getDocument();
        Segment segment = this.getLineBuffer();
        Insets insets = this.getContainer().getInsets();
        if (x == 0) {
            x += insets.left;
        }
        try {
            Iterator<Token> i = doc.getTokens(p0, p1);
            int start = p0;
            while (i.hasNext()) {
                Token t = i.next();
                if (start < t.startIndex) {
                    doc.getText(start, t.startIndex - start, segment);
                    x = this.DEFAULT_RENDER.drawText(segment, x, y, graphics, this, start);
                }
                int l = t.length;
                int s = t.startIndex;
                if (s < p0) {
                    l -= p0 - s;
                    s = p0;
                }
                if (s + l > p1) {
                    l = p1 - s;
                }
                doc.getText(s, l, segment);
                int oldX = x;
                x = this.renderProvider.getRenderByToken(t).drawText(segment, x, y, graphics, this, t.startIndex);
                this.drawTokenDecorator(graphics, doc, t, oldX, y, x - oldX);
                start = t.end();
            }
            if (start < p1) {
                doc.getText(start, p1 - start, segment);
                x = this.DEFAULT_RENDER.drawText(segment, x, y, graphics, this, start);
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            graphics.setFont(saveFont);
            graphics.setColor(saveColor);
        }
        return x;
    }

    private void drawTokenDecorator(Graphics graphics, EnhancedDocument doc, Token t, int x, int y, int length) {
        int width = length;
        int height = this.getClientHeight();
        List<ParseData> items = doc.getParseData().getParseDataByToken(t);
        if (items != null && !items.isEmpty()) {
            for (ParseData pd : items) {
                this.decoratorProvider.getDecorator(pd.getType()).drawDecorator(graphics, t, x, y, width, height);
            }
        }
    }

    protected int drawElement(Element elem, Graphics g, int x, int y) throws BadLocationException {
        int p0 = elem.getStartOffset();
        int p1 = elem.getEndOffset();
        p1 = Math.min(this.getDocument().getLength(), p1);
        if (this.sel0 == this.sel1) {
            x = this.drawUnselectedText(g, x, y, p0, p1);
        } else if (p0 >= this.sel0 && p0 <= this.sel1 && p1 >= this.sel0 && p1 <= this.sel1) {
            x = this.drawSelectedText(g, x, y, p0, p1);
        } else if (this.sel0 >= p0 && this.sel0 <= p1) {
            if (this.sel1 >= p0 && this.sel1 <= p1) {
                x = this.drawUnselectedText(g, x, y, p0, this.sel0);
                x = this.drawSelectedText(g, x, y, this.sel0, this.sel1);
                x = this.drawUnselectedText(g, x, y, this.sel1, p1);
            } else {
                x = this.drawUnselectedText(g, x, y, p0, this.sel0);
                x = this.drawSelectedText(g, x, y, this.sel0, p1);
            }
        } else if (this.sel1 >= p0 && this.sel1 <= p1) {
            x = this.drawSelectedText(g, x, y, p0, this.sel1);
            x = this.drawUnselectedText(g, x, y, this.sel1, p1);
        } else {
            x = this.drawUnselectedText(g, x, y, p0, p1);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        Element line = this.getElement(lineIndex);
        int oldY = y;
        g.translate(0, y);
        y = 0;
        try {
            if (line.isLeaf()) {
                x = this.drawElement(line, g, x, y);
            } else {
                int count = line.getElementCount();
                for (int i = 0; i < count; ++i) {
                    Element elem = line.getElement(i);
                    x = this.drawElement(elem, g, x, y);
                }
            }
            this.drawSetionTag(lineIndex, g, x, y);
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            g.translate(0, -oldY);
        }
    }

    private void drawSetionTag(int lineIndex, Graphics g, int x, int y) {
        EnhancedDocument doc = (EnhancedDocument)this.getDocument();
        SectionsInfo sectionsInfo = doc.getSectionsInfo();
        if (sectionsInfo.isSectionStartLine(lineIndex) && sectionsInfo.isSectionCollapsed(lineIndex)) {
            int lineHeight = this.mMetrics.getHeight();
            g.setColor(Color.GRAY);
            String sectionTag = "...";
            g.drawString(sectionTag, x + 4, y);
            g.drawRect(x + 2, y - lineHeight + 4, this.mMetrics.stringWidth(sectionTag), lineHeight - 2);
        }
    }

    public void paint2(Graphics g, Shape a) {
        Shape originalA = a;
        JEditorPane host = (JEditorPane)this.getContainer();
        g.setFont(host.getFont());
        this.sel0 = host.getSelectionStart();
        this.sel1 = host.getSelectionEnd();
        this.updateMetrics();
        Rectangle clientRect = this.getClientRect();
        int lineHeight = this.mMetrics.getHeight();
        int firstVisibleLineIndex = this.getFirstVisibleLineNumber();
        int visibleLineCount = 1 + clientRect.height / lineHeight;
        SectionsInfo sectionsInfo = ((EnhancedDocument)this.getDocument()).getSectionsInfo();
        int[] topLevelLines = sectionsInfo.getTopLevelLines(firstVisibleLineIndex, visibleLineCount);
        System.out.println("Paint line from " + firstVisibleLineIndex + " as count " + visibleLineCount);
        System.out.println(Arrays.toString(topLevelLines));
        if (topLevelLines == null || topLevelLines.length == 0) {
            return;
        }
        int x = 0;
        int y = this.getYCoordForTopOfDeviceLine(firstVisibleLineIndex);
        System.out.println("X: " + x + " Y: " + (y += this.mMetrics.getAscent()) + " Ascent: " + this.mMetrics.getAscent() + "  clientRect.y: " + clientRect.y);
        this.paintImpl(g, originalA, lineHeight, topLevelLines, x, y);
    }

    @Override
    public void paint(Graphics g, Shape a) {
        Shape originalA = a;
        Rectangle alloc = (Rectangle)a;
        this.tabBase = alloc.x;
        JTextComponent host = (JTextComponent)this.getContainer();
        g.setFont(host.getFont());
        this.sel0 = host.getSelectionStart();
        this.sel1 = host.getSelectionEnd();
        this.updateMetrics();
        Rectangle clip = g.getClipBounds();
        int fontHeight = this.metrics.getHeight();
        int heightAbove = clip.y - alloc.y;
        int linesAbove = Math.max(0, heightAbove / fontHeight);
        Rectangle lineArea = this.lineToRect(a, linesAbove);
        int y = this.metrics.getAscent();
        int x = lineArea.x;
        SectionsInfo sectionsInfo = ((EnhancedDocument)this.getDocument()).getSectionsInfo();
        int[] topLevelLines = sectionsInfo.getTopLevelLines();
        this.paintImpl(g, originalA, fontHeight, topLevelLines, x, y);
    }

    private void paintImpl(Graphics g, Shape originalA, int lineHeight, int[] topLevelLines, int x, int y) {
        JEditorPane host = (JEditorPane)this.getContainer();
        Highlighter h = host.getHighlighter();
        LayeredHighlighter dh = h instanceof LayeredHighlighter ? (LayeredHighlighter)h : null;
        for (int index = 0; index < topLevelLines.length; ++index) {
            int currLine = topLevelLines[index];
            this.drawHighlighterLine(g, originalA, host, dh, currLine);
            this.drawLine(currLine, g, x, y);
            y += lineHeight;
        }
    }

    private void drawHighlighterLine(Graphics g, Shape originalA, JEditorPane host, LayeredHighlighter dh, int currLine) {
        Element lineElement = this.getElement(currLine);
        if (lineElement != null && dh != null) {
            if (currLine == EditorUtils.getLineCount(host) - 1) {
                dh.paintLayeredHighlights(g, lineElement.getStartOffset(), lineElement.getEndOffset(), originalA, host, this);
            } else {
                dh.paintLayeredHighlights(g, lineElement.getStartOffset(), lineElement.getEndOffset() - 1, originalA, host, this);
            }
        }
    }

    @Override
    protected Rectangle lineToRect(Shape a, int line) {
        EnhancedDocument doc = (EnhancedDocument)this.getDocument();
        SectionsInfo sectionsInfo = doc.getSectionsInfo();
        Rectangle r = null;
        this.updateMetrics();
        if (this.mMetrics != null) {
            int height;
            int lineTopLevel;
            boolean isCollapse = sectionsInfo.isLineInCollpase(line);
            if (isCollapse) {
                int prevTopLevel = sectionsInfo.getPreviousTopLevelLine(line, 1);
                lineTopLevel = sectionsInfo.getViewLineNumber(prevTopLevel);
                height = 0;
            } else {
                lineTopLevel = sectionsInfo.getViewLineNumber(line);
                height = this.mMetrics.getHeight();
            }
            Rectangle alloc = a.getBounds();
            alloc.y += lineTopLevel * height;
            alloc.height = height;
            r = alloc;
        }
        return r;
    }

    protected int getLineWidth(Element line) {
        if (this.mMetrics == null || line == null) {
            return 0;
        }
        int p0 = line.getStartOffset();
        int p1 = line.getEndOffset();
        int w = 0;
        try {
            EnhancedDocument doc = (EnhancedDocument)line.getDocument();
            doc.getText(p0, p1 - p0, this.getLineBuffer());
            TokenMapInfo tm = doc.getTokenMapInfo();
            if (tm != null) {
                w = tm.getTabbedTextWidth(this.getLineBuffer(), this.mMetrics, this.tabBase, p0, this);
            }
            if (tm == null || w == -1) {
                w = Utilities.getTabbedTextWidth(this.getLineBuffer(), this.mMetrics, this.tabBase, (TabExpander)this, p0);
            }
        }
        catch (BadLocationException ble) {
            w = 0;
        }
        return w;
    }

    protected void calculateLongestLine() {
        Element lines = this.getElement();
        int n = lines.getElementCount();
        int maxWidth = -1;
        for (int i = 0; i < n; ++i) {
            Element line = lines.getElement(i);
            int w = this.getLineWidth(line);
            if (w <= maxWidth) continue;
            maxWidth = w;
            this.longLine = line;
        }
    }

    public int getYCoordForTopOfDeviceLine(int screenLine) {
        if (this.getPartiallyVisibleLineCount() == 0) {
            return -1;
        }
        int ycoord = screenLine * this.getDeviceLineHeight();
        return ycoord;
    }

    public int getDeviceLineHeight() {
        return this.mMetrics.getHeight();
    }

    public int getPartiallyVisibleLineCount() {
        int clientHeight = this.getClientHeight();
        int partialAdd = clientHeight % this.mMetrics.getHeight() == 0 ? 0 : 1;
        return clientHeight / this.mMetrics.getHeight() + partialAdd;
    }

    public int getClientHeight() {
        JEditorPane host = (JEditorPane)this.getContainer();
        Container c = host.getParent();
        if (c instanceof JViewport) {
            JViewport vp = null;
            vp = (JViewport)c;
            return vp.getHeight();
        }
        return 0;
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        EnhancedDocument doc = (EnhancedDocument)this.getDocument();
        SectionsInfo sectionsInfo = doc.getSectionsInfo();
        switch (axis) {
            case 0: {
                return this.getLineWidth(this.longLine) + 5;
            }
            case 1: {
                int lineHeight = this.mMetrics.getHeight();
                int totalLines = sectionsInfo.getTopLevelLineCount();
                int span = totalLines * lineHeight;
                JViewport vp = null;
                EnhancedEditorPane host = (EnhancedEditorPane)this.getContainer();
                Container c = host.getParent();
                if (c instanceof JViewport) {
                    vp = (JViewport)c;
                    Rectangle rectangle = vp.getViewRect();
                }
                return span;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    public int getFirstVisibleLineNumber() {
        Rectangle clientRect = this.getVisibleEditorRect();
        Position.Bias[] biasRet = new Position.Bias[1];
        JEditorPane editorPane = (JEditorPane)this.getContainer();
        int x = -editorPane.getX();
        int y = -editorPane.getY();
        int charOffset = this.viewToModel(x, y, clientRect, biasRet);
        int line = EditorUtils.getLineNumber(editorPane, charOffset);
        return line;
    }

    public Rectangle getVisibleEditorRect() {
        JEditorPane editor = (JEditorPane)this.getContainer();
        Rectangle alloc = editor.getBounds();
        if (alloc.width > 0 && alloc.height > 0) {
            alloc.y = 0;
            alloc.x = 0;
            Insets insets = editor.getInsets();
            alloc.x += insets.left;
            alloc.y += insets.top;
            alloc.width -= insets.left + insets.right;
            alloc.height -= insets.top + insets.bottom;
            return alloc;
        }
        return null;
    }

    public int getClientYCoord() {
        JEditorPane host = (JEditorPane)this.getContainer();
        Container c = host.getParent();
        if (c instanceof JViewport) {
            JViewport vp = null;
            vp = (JViewport)c;
            Component v = vp.getView();
            if (v != null) {
                return v.getY();
            }
        }
        return 0;
    }

    @Override
    protected void updateMetrics() {
        super.updateMetrics();
        Container host = this.getContainer();
        Font f = host.getFont();
        if (this.baseFont != f) {
            this.baseFont = f;
            this.mMetrics = host.getFontMetrics(this.baseFont);
            this.calculateLongestLine();
        }
        this.tabSize = this.getTabSize() * this.mMetrics.charWidth('m');
    }

    @Override
    protected void updateDamage(DocumentEvent changes, Shape a, ViewFactory f) {
        Element[] removed;
        Container host = this.getContainer();
        this.updateMetrics();
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec = changes.getChange(elem);
        Element[] added = ec != null ? ec.getChildrenAdded() : null;
        Element[] elementArray = removed = ec != null ? ec.getChildrenRemoved() : null;
        if (added != null && added.length > 0 || removed != null && removed.length > 0) {
            if (added != null) {
                int currWide = this.getLineWidth(this.longLine);
                for (int i = 0; i < added.length; ++i) {
                    int w = this.getLineWidth(added[i]);
                    if (w <= currWide) continue;
                    currWide = w;
                    this.longLine = added[i];
                }
            }
            if (removed != null) {
                for (int i = 0; i < removed.length; ++i) {
                    if (removed[i] != this.longLine) continue;
                    this.calculateLongestLine();
                    break;
                }
            }
            this.preferenceChanged(null, true, true);
            host.repaint();
        } else {
            Element map = this.getElement();
            int startLine = map.getElementIndex(changes.getOffset());
            int endLine = map.getElementIndex(changes.getOffset() + changes.getLength());
            this.damageLineRange(startLine, endLine, a, host);
            if (changes.getType() == DocumentEvent.EventType.INSERT) {
                int w = this.getLineWidth(this.longLine);
                Element e = this.getElement(startLine);
                if (e == this.longLine) {
                    this.preferenceChanged(null, true, false);
                } else if (this.getLineWidth(e) > w) {
                    this.longLine = e;
                    this.preferenceChanged(null, true, false);
                }
            } else if (changes.getType() == DocumentEvent.EventType.REMOVE && this.getElement(startLine) == this.longLine) {
                this.calculateLongestLine();
                this.preferenceChanged(null, true, false);
            }
        }
    }

    public Rectangle getClientRect() {
        JEditorPane host = (JEditorPane)this.getContainer();
        Container c = host.getParent();
        if (c instanceof JViewport) {
            JViewport vp = null;
            vp = (JViewport)c;
            Rectangle r = vp.getViewRect();
            return r;
        }
        return null;
    }

    protected Element getElement(int index) {
        return this.getDocument().getDefaultRootElement().getElement(index);
    }

    static {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Map map = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
            sysHints = new RenderingHints(map);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

