/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.impl;

import com.sas.wadmin.visuals.common.enhancededitor.Decorator;
import com.sas.wadmin.visuals.common.enhancededitor.Token;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDecorator
implements Decorator {
    private static final int MINLENGTH = 2;

    @Override
    public void drawDecorator(Graphics graphics, Token t, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)graphics;
        graphics.setColor(this.getColor());
        List<Point> ps = this.generatePoints(x, y, width);
        int size = ps.size();
        if (size > 1) {
            Point lastPoint = ps.get(0);
            Point cPoint = null;
            for (int i = 1; i < size; ++i) {
                cPoint = ps.get(i);
                g2.draw(new Line2D.Float(lastPoint, cPoint));
                lastPoint = cPoint;
            }
        }
    }

    private List<Point> generatePoints(int x, int y, int width) {
        ArrayList<Point> result = new ArrayList<Point>();
        for (int i = 0; i < width; i += 2) {
            result.add(new Point(x + i, y + 2 + i / 2 % 2 * 2));
        }
        return result;
    }

    protected abstract Color getColor();
}

