/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.component;

import com.sas.wadmin.visuals.common.enhancededitor.component.RowHeaderComponent;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EditorUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class LineNumberPanel
extends RowHeaderComponent
implements CaretListener {
    private static final int HEIGHT = 2146483647;
    private int minimumDisplayDigits = 2;
    private int lastDigits;
    private int lastLine;
    private MouseListener mouseListener = null;
    private String numbersFormat = "%3d";
    private Color currentLineColor = Color.LIGHT_GRAY;

    public LineNumberPanel() {
        this.setBackground(Color.WHITE);
    }

    @Override
    public void install(JEditorPane editor) {
        super.install(editor);
        this.setFont(editor.getFont());
        this.setMinimumDisplayDigits(3);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        };
        this.addMouseListener(this.mouseListener);
    }

    @Override
    public void deinstall() {
        super.deinstall();
        this.removeMouseListener(this.mouseListener);
    }

    public int getMinimumDisplayDigits() {
        return this.minimumDisplayDigits;
    }

    public void setMinimumDisplayDigits(int minimumDisplayDigits) {
        this.minimumDisplayDigits = minimumDisplayDigits;
        this.setPreferredWidth();
    }

    @Override
    protected void setPreferredWidth() {
        int lines = EditorUtils.getLineCount(this.editor);
        int digits = Math.max(String.valueOf(lines).length(), this.minimumDisplayDigits);
        if (this.lastDigits != digits) {
            this.lastDigits = digits;
            this.numbersFormat = "%" + digits + "d";
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.charWidth('0') * digits;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width;
            Dimension d = this.getPreferredSize();
            d.setSize(preferredWidth, 2146483647);
            this.setPreferredSize(d);
            this.setSize(d);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.translate(0, -3);
        FontMetrics fontMetrics = this.editor.getFontMetrics(this.editor.getFont());
        Insets insets = this.getInsets();
        int currentLine = -1;
        currentLine = EditorUtils.getLineNumber(this.editor, this.editor.getCaretPosition());
        int lh = fontMetrics.getHeight();
        int maxLines = EditorUtils.getLineCount(this.editor);
        int number = 1;
        for (int line = 0; line < maxLines; ++line) {
            if (this.sectionsInfo.isLineInCollpase(line)) continue;
            String lineNumber = String.format(this.numbersFormat, line + 1);
            int y = number * lh;
            if (line == currentLine) {
                g.setColor(this.currentLineColor);
                g.fillRect(0, y - lh + fontMetrics.getDescent() - 1, this.getWidth(), lh);
                g.setColor(new Color(0xFF0000));
                g.drawString(lineNumber, insets.left, y);
            } else {
                g.setColor(new Color(0xFF0000));
                g.setFont(this.editor.getFont());
                g.drawString(lineNumber, insets.left, y);
            }
            ++number;
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int currentLine = EditorUtils.getLineIndex(this.doc, this.editor.getCaretPosition());
        if (this.lastLine != currentLine) {
            this.repaint();
            this.lastLine = currentLine;
        }
    }
}

