/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.component;

import com.sas.wadmin.visuals.common.enhancededitor.Section;
import com.sas.wadmin.visuals.common.enhancededitor.component.MarkerButton;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedDocument;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;

public class FoldingButton
extends MarkerButton {
    private Section section;
    private EnhancedDocument doc;
    private ImageIcon expandIcon;
    private ImageIcon collapseIcon;

    public FoldingButton(EnhancedDocument doc, Section section) {
        this.doc = doc;
        this.setAction(new FoldingAction());
        this.section = section;
        this.lineIndex = this.section.startLine;
        this.expandIcon = this.createImageIcon("res/Expand.gif", null);
        this.collapseIcon = this.createImageIcon("res/Collapse.gif", null);
        this.updateIcon();
        this.updateTooltip();
    }

    protected ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        return null;
    }

    private void updateTooltip() {
        if (this.section.isCollapse) {
            StringBuffer content = new StringBuffer();
            for (int i = this.section.startLine; i < this.section.endLine; ++i) {
                Segment segment = new Segment();
                Element elem = this.doc.getDefaultRootElement().getElement(i);
                int p0 = elem.getStartOffset();
                int p1 = elem.getEndOffset();
                try {
                    this.doc.getText(p0, p1, segment);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                content.append(segment.toString());
                content.append("\n");
            }
            this.setToolTipText(content.toString());
            this.setToolTipText(content.toString());
        } else {
            this.setToolTipText(null);
        }
    }

    private void updateIcon() {
        if (this.section.isCollapse) {
            this.setIcon(this.expandIcon);
        } else {
            this.setIcon(this.collapseIcon);
        }
    }

    class FoldingAction
    extends AbstractAction {
        FoldingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FoldingButton.this.doc.getSectionsInfo().changeSectionCollapse(((FoldingButton)FoldingButton.this).section.id);
            FoldingButton.this.updateIcon();
            FoldingButton.this.updateTooltip();
        }
    }
}

