/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.actions.gui;

import com.sas.wadmin.visuals.common.enhancededitor.actions.gui.EnhancedEditorDialog;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EditorUtils;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedDocument;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedEditorPane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class GotoLineDialog
extends EnhancedEditorDialog
implements DocumentListener,
PropertyChangeListener {
    private SpinnerNumberModel model;
    private JSpinner lineField;
    private JButton btnGo;
    private Action actGo;

    public GotoLineDialog() {
        this.setTitle("Goto Line");
        this.initWidget();
        this.layoutWidget();
    }

    private void initWidget() {
        this.model = new SpinnerNumberModel(1, 1, 1, 10);
        this.lineField = new JSpinner(this.model);
        this.actGo = new GoAction();
        this.btnGo = new JButton(this.actGo);
    }

    private void layoutWidget() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("Goto:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lineField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 1, 1));
        this.add((Component)this.btnGo, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void go() {
        int lineIndex = this.model.getNumber().intValue() - 1;
        this.pane.gotoLine(lineIndex);
    }

    @Override
    public void setEditorPane(EnhancedEditorPane pane) {
        super.setEditorPane(pane);
        this.pane.getDocument().addDocumentListener(this);
        this.pane.addPropertyChangeListener(this);
        this.updateMaxLine();
    }

    private void updateMaxLine() {
        if (this.pane != null) {
            int maxLine = EditorUtils.getLineCount(this.pane);
            this.model.setMaximum(Integer.valueOf(maxLine));
        } else {
            this.model.setMaximum(Integer.valueOf(1));
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateMaxLine();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateMaxLine();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateMaxLine();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("document")) {
            if (evt.getOldValue() instanceof Document) {
                ((Document)evt.getOldValue()).removeDocumentListener(this);
            }
            if (evt.getNewValue() instanceof EnhancedDocument) {
                ((Document)evt.getNewValue()).addDocumentListener(this);
            }
            this.updateMaxLine();
        }
    }

    private class GoAction
    extends AbstractAction {
        public GoAction() {
            super("Go");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GotoLineDialog.this.go();
        }
    }
}

