/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IFilter;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.wadmin.visuals.common.TableUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractPopulateOnDemandTableColumn;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsBooleanTableColumn;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsDialogTableCellEditor;
import com.sas.workspace.WsDialogTableCellEditorInterface;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsIconTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsLimitedPlainDocument;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.awt.Component;
import java.awt.Font;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Document;

public class TargetColumnsTableModel
extends WsAbstractTableModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(TargetColumnsTableModel.class);
    private static final int VISIBLE_COLUMNS = 12;
    private static final int INVISIBLE_COLUMNS = 3;
    public static final int MAPPINGTYPE_COLUMN = 0;
    public static final int EXCLUSIONS_COLUMN = 1;
    public static final int COLUMNNAME_COLUMN = 2;
    public static final int COLUMNDESCR_COLUMN = 3;
    public static final int EXPRESSION_COLUMN = 4;
    public static final int TABLENAME_COLUMN = 5;
    public static final int TABLEDESCR_COLUMN = 6;
    public static final int TYPE_COLUMN = 7;
    public static final int LENGTH_COLUMN = 8;
    public static final int INFORMAT_COLUMN = 9;
    public static final int FORMAT_COLUMN = 10;
    public static final int IS_NULLABLE_COLUMN = 11;
    private static final int COLUMN_COLUMN = 12;
    private static final int TABLE_COLUMN = 13;
    private static final int MAPPING_COLUMN = 14;
    private static final int MAPPINGTYPE_WIDTH = 18;
    private static final int EXCLUSIONS_WIDTH = 18;
    private static final int TABLENAME_WIDTH = 100;
    private static final int TABLEDESCR_WIDTH = 110;
    private static final int COLUMNNAME_WIDTH = 100;
    private static final int COLUMNDESCR_WIDTH = 110;
    private static final int EXPRESSION_WIDTH = 250;
    private static final int TYPE_WIDTH = 75;
    private static final int LENGTH_WIDTH = 50;
    private static final int INFORMAT_WIDTH = 75;
    private static final int FORMAT_WIDTH = 75;
    private static final int IS_NULLABLE_WIDTH = 100;
    private static final Icon UNMAPPED_ICON = bundle.getIcon("TargetColumnsTableModel.MappingType.Unmapped.image");
    private static final Icon ONE_TO_ONE_ICON = bundle.getIcon("TargetColumnsTableModel.MappingType.OneToOne.image");
    private static final Icon DERIVED_ICON = bundle.getIcon("TargetColumnsTableModel.MappingType.Derived.image");
    private static final Icon WARNING_ICON = bundle.getIcon("TargetColumnsTableModel.MappingType.Warning.image");
    private static final Icon NOT_EXCLUDED_ICON = bundle.getIcon("TargetColumnsTableModel.ExclusionType.None.image");
    private static final Icon EXCLUDED_FROM_MAPPING_ICON = bundle.getIcon("TargetColumnsTableModel.ExclusionType.Mapping.image");
    private static final Icon EXCLUDED_FROM_PROPAGATION_ICON = bundle.getIcon("TargetColumnsTableModel.ExclusionType.Propagation.image");
    private static final Icon EXCLUDED_FROM_PROPAGATION_AND_MAPPING_ICON = bundle.getIcon("TargetColumnsTableModel.ExclusionType.PropagationAndMapping.image");
    private IMappingsContainer m_container;
    private List m_lTables;
    private ITable m_tblSelected;
    private boolean m_bUseSQLSyntax;
    private IFilter m_filter;
    private IModelListener m_lsnrModel;

    public TargetColumnsTableModel(IMappingsContainer container) {
        this.m_container = container;
        this.m_lTables = new ArrayList();
        this.createListeners();
        this.createColumnDefinitions();
        this.setRowInstanceCount(1);
    }

    protected void createListeners() {
        this.m_lsnrModel = new ModelListener();
        this.m_container.getModel().addModelListener(this.m_lsnrModel);
    }

    public void dispose() {
        this.m_container.getModel().removeModelListener(this.m_lsnrModel);
    }

    private void createColumnDefinitions() {
        String[] saTypes = ColumnUIUtilities.getViewTypes();
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsIconTableColumn(0, " ", 18);
        this.m_aColumns[1] = new WsIconTableColumn(1, " ", 18);
        this.m_aColumns[2] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 2, bundle.getString("TargetColumnsTableModel.Column.txt"), 100, 32);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("TargetColumnsTableModel.ColumnDescr.txt"), 110, 200);
        this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("TargetColumnsTableModel.Expression.txt"), 250);
        this.m_aColumns[5] = new WsStringTableColumn(5, bundle.getString("TargetColumnsTableModel.Table.txt"), 100);
        this.m_aColumns[6] = new WsStringTableColumn(6, bundle.getString("TargetColumnsTableModel.TableDescr.txt"), 110);
        this.m_aColumns[7] = new WsEnumeratedTableColumn(7, bundle.getString("TargetColumnsTableModel.Type.txt"), 75, saTypes);
        this.m_aColumns[8] = new LengthTableColumn();
        this.m_aColumns[9] = new InformatTableColumn();
        this.m_aColumns[10] = new FormatTableColumn();
        this.m_aColumns[11] = new WsBooleanTableColumn(11, bundle.getString("TargetColumnsTableModel.IsNullable.txt"), 100);
        this.m_aColumns[12] = new WsObjectTableColumn();
        this.m_aColumns[13] = new WsObjectTableColumn();
        this.m_aColumns[14] = new WsObjectTableColumn();
        this.m_aColumns[2].setCellRenderer((TableCellRenderer)((Object)new ColumnNameCellRenderer()));
        this.m_aColumns[4].setCellEditor((TableCellEditor)((Object)new ExpressionEditor()));
        this.m_aColumns[4].setCellRenderer((TableCellRenderer)((Object)new ExpressionCellRenderer()));
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[5].setEditable(false);
        this.m_aColumns[6].setEditable(false);
    }

    public int getColumnCount() {
        return 12;
    }

    public int getHiddenColumnCount() {
        return 3;
    }

    public int getDefaultEditColumnIndex() {
        return 2;
    }

    public void setValueAt(Object obj, int iRow, int iColumn) {
        IColumn col = (IColumn)this.getValueAt(iRow, 12);
        if (iColumn == 2) {
            col.setName((String)obj);
        } else if (iColumn == 3) {
            col.setDescription((String)obj);
        } else if (iColumn == 7) {
            col.setType(ColumnUIUtilities.getModelType((String)obj));
        } else if (iColumn == 8) {
            col.setLength(((Integer)obj).intValue());
        } else if (iColumn == 9) {
            col.setInformat(ColumnUIUtilities.getModelInformat((String)obj));
        } else if (iColumn == 10) {
            col.setFormat(ColumnUIUtilities.getModelFormat((String)obj));
        } else if (iColumn == 11) {
            col.setNullable(((Boolean)obj).booleanValue());
        } else if (iColumn == 4) {
            this.updateExpression(col, this.getMapping(iRow), (String)obj);
        }
    }

    public String getToolTipAt(int iRow, int iColumn) {
        if (iColumn == 0) {
            if (iRow == -1) {
                return bundle.getString("TargetColumnsTableModel.MappingType.ColumnHeader.tip");
            }
            if (this.getValueAt(iRow, iColumn) == WARNING_ICON) {
                return this.getMapping(iRow).getWarning();
            }
        } else if (iColumn == 1) {
            if (iRow == -1) {
                return bundle.getString("TargetColumnsTableModel.ExclusionType.ColumnHeader.tip");
            }
            Icon icon = (Icon)this.getValueAt(iRow, iColumn);
            if (icon == EXCLUDED_FROM_MAPPING_ICON) {
                return bundle.getString("TargetColumnsTableModel.ExclusionType.Mapping.tip");
            }
            if (icon == EXCLUDED_FROM_PROPAGATION_ICON) {
                return bundle.getString("TargetColumnsTableModel.ExclusionType.Propagation.tip");
            }
            if (icon == EXCLUDED_FROM_PROPAGATION_AND_MAPPING_ICON) {
                return bundle.getString("TargetColumnsTableModel.ExclusionType.PropagationAndMapping.tip");
            }
        }
        return null;
    }

    public void moveDataToModel() {
        this.clear();
        this.m_lTables.clear();
        ITable[] aTables = this.m_container.getTargetTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            if (this.m_tblSelected != null && this.m_tblSelected != aTables[iTable]) continue;
            this.m_lTables.add(aTables[iTable]);
            IColumn[] aColumns = aTables[iTable].getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.m_lData.add(this.createRowValues(aColumns[iColumn]));
            }
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() {
    }

    public void populateStore() {
    }

    private List createRowValues(IColumn col) {
        IMapping mapping = this.findMappingForColumn(col);
        ArrayList<Object> lValues = new ArrayList<Object>(15);
        lValues.add(this.getMappingTypeIcon(mapping));
        lValues.add(this.getExclusionsIcon(col));
        lValues.add(col.getName());
        lValues.add(col.getDescription());
        lValues.add(this.getExpressionText(mapping));
        lValues.add(TableUIUtilities.getViewName(col.getTable()));
        lValues.add(col.getTable().getDescription());
        lValues.add(ColumnUIUtilities.getViewType(col.getType()));
        lValues.add(new Integer(col.getLength()));
        lValues.add(ColumnUIUtilities.getViewInformat(col.getInformat()));
        lValues.add(ColumnUIUtilities.getViewFormat(col.getFormat()));
        lValues.add(col.isNullable());
        lValues.add(col);
        lValues.add(col.getTable());
        lValues.add(mapping);
        return lValues;
    }

    private IMapping findMappingForColumn(IColumn col) {
        IMapping[] aMappings = this.m_container.getMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            IMapping mapping = aMappings[iMapping];
            if (!this.m_filter.pass((Object)mapping) || !mapping.containsInTargets(col)) continue;
            return mapping;
        }
        return null;
    }

    public IColumn getTargetColumn(int iRow) {
        return (IColumn)this.getValueAt(iRow, 12);
    }

    public int getRowIndex(IColumn col) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(12) != col) continue;
            return iRow;
        }
        return -1;
    }

    public int getRowIndex(IMapping mapping) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(14) != mapping) continue;
            return iRow;
        }
        return -1;
    }

    public int getRowIndex(IExpression expression) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            IMapping mapping = (IMapping)lValues.get(14);
            if (mapping == null || mapping.getExpression() != expression) continue;
            return iRow;
        }
        return -1;
    }

    public IMapping getMapping(int iRow) {
        return (IMapping)this.getValueAt(iRow, 14);
    }

    public void setExpressionText(int iRow, String sExpression) {
        this.setValueAt(sExpression, iRow, 4);
    }

    public String getExpressionText(int iRow) {
        return (String)this.getValueAt(iRow, 4);
    }

    public String createUniqueNameForNewColumn() {
        WsUniqueNameTableColumn colName = (WsUniqueNameTableColumn)this.m_aColumns[2];
        return (String)colName.createDefaultValue();
    }

    public void setExpressionCellEditor(TableCellEditor editor) {
        this.m_aColumns[4].setCellEditor(editor);
    }

    public void setExpressionEditorDialogAdapter(WsDialogTableCellEditorInterface dialogAdapter) {
        WsDialogTableCellEditor editor = (WsDialogTableCellEditor)this.m_aColumns[4].getCellEditor();
        editor.setDialog(dialogAdapter);
    }

    public WsDialogTableCellEditorInterface getExpressionEditorDialogAdapter() {
        WsDialogTableCellEditor editor = (WsDialogTableCellEditor)this.m_aColumns[4].getCellEditor();
        return editor.getDialog();
    }

    private Icon getMappingTypeIcon(IMapping mapping) {
        if (mapping == null) {
            return UNMAPPED_ICON;
        }
        if (mapping.getWarning() != null) {
            return WARNING_ICON;
        }
        String sType = mapping.getType();
        return "ONETOONE".equals(sType) ? ONE_TO_ONE_ICON : ("DERIVED".equals(sType) ? DERIVED_ICON : UNMAPPED_ICON);
    }

    private Icon getExclusionsIcon(IColumn column) {
        int iIcon = 0;
        if (this.m_container.getListOfColumnsExcludedFromPropagation().contains(column)) {
            iIcon += 2;
        }
        if (this.m_container.getListOfColumnsExcludedFromMapping().contains(column)) {
            ++iIcon;
        }
        if (iIcon == 0) {
            return NOT_EXCLUDED_ICON;
        }
        if (iIcon == 1) {
            return EXCLUDED_FROM_MAPPING_ICON;
        }
        if (iIcon == 2) {
            return EXCLUDED_FROM_PROPAGATION_ICON;
        }
        return EXCLUDED_FROM_PROPAGATION_AND_MAPPING_ICON;
    }

    private String getExpressionText(IMapping mapping) {
        if (mapping == null) {
            return "";
        }
        IExpression expression = mapping.getExpression();
        if (expression == null) {
            return "";
        }
        expression.setUseSQLSyntax(this.m_bUseSQLSyntax);
        String text = "";
        try {
            text = expression.getText(null, this.isQuotingNeeded());
        }
        catch (RemoteException e1) {
            Workspace.handleRemoteException((RemoteException)e1);
        }
        catch (CodegenException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (MdException e1) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
        }
        catch (BadServerDefinitionException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (BadLibraryDefinitionException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (ServerException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        return text;
    }

    private boolean isQuotingNeeded() {
        ArrayList<ITable> tables = new ArrayList<ITable>();
        tables.addAll(Arrays.asList(this.m_container.getSourceTables()));
        tables.addAll(Arrays.asList(this.m_container.getTargetTables()));
        for (int iTable = 0; iTable < tables.size(); ++iTable) {
            if (!((ITable)tables.get(iTable)).isQuoted()) continue;
            return true;
        }
        return false;
    }

    private boolean isSourceTable(ITable table) {
        ITable[] aTables = this.m_container.getSourceTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            if (aTables[iTable] != table) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExpression(IColumn column, IMapping mapping, String sExpression) {
        IModel mdl = this.m_container.getModel();
        mdl.startCompoundUndoable();
        try {
            if (sExpression.trim().length() != 0) {
                if (mapping == null) {
                    mapping = this.m_container.addMapping(new IColumn[0], new IColumn[]{column});
                }
                IExpression expression = mapping.getExpression();
                boolean verifySQLExpression = false;
                if (expression != null && expression.getExpressionType().equalsIgnoreCase("TextOperand") && ((ITextOperand)expression).getTextExpression() != null && ((ITextOperand)expression).getTextExpression().getExpressionType().equalsIgnoreCase("DERIVED")) {
                    verifySQLExpression = true;
                }
                if (!(expression != null && expression.getExpressionType().equalsIgnoreCase("DERIVED") || verifySQLExpression)) {
                    expression = mapping.createNewExpression();
                    mapping.setExpression(expression);
                }
                ITextExpression textExpression = (ITextExpression)expression;
                ITable[] aTables = this.m_container.getSourceTables();
                ArrayList<IColumn> lColumns = new ArrayList<IColumn>();
                for (int iTable = 0; iTable < aTables.length; ++iTable) {
                    IColumn[] aColumns = aTables[iTable].getColumns();
                    for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                        lColumns.add(aColumns[iColumn]);
                    }
                }
                IColumn[] aColumns = lColumns.toArray(new IColumn[lColumns.size()]);
                textExpression.setUseSQLSyntax(this.m_bUseSQLSyntax);
                textExpression.setText(sExpression, (IObject[])aColumns);
            } else if (mapping != null) {
                mapping.setExpression(null);
            }
        }
        finally {
            mdl.endCompoundUndoable();
        }
    }

    public void setSelectedTable(ITable tbl) {
        if (this.m_tblSelected == tbl) {
            return;
        }
        this.m_tblSelected = tbl;
        this.moveDataToModel();
    }

    public ITable getSelectedTable() {
        return this.m_tblSelected;
    }

    public void setUseSQLSyntax(boolean bUseSQLSyntax) {
        this.m_bUseSQLSyntax = bUseSQLSyntax;
    }

    public boolean isUsingSQLSyntax() {
        return this.m_bUseSQLSyntax;
    }

    public void setMappingsFilter(IFilter filter) {
        this.m_filter = filter;
    }

    public IFilter getMappingsFilter() {
        return this.m_filter;
    }

    private void addTable(ITable tbl) {
        if (this.m_tblSelected != null && this.m_tblSelected != tbl) {
            return;
        }
        if (!this.m_lTables.contains(tbl)) {
            this.m_lTables.add(tbl);
            IColumn[] aColumns = tbl.getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.insertRow(this.getRowCount() - 1, this.createRowValues(aColumns[iColumn]));
            }
        }
    }

    private void removeTable(ITable tbl) {
        if (this.m_tblSelected != null && this.m_tblSelected != tbl) {
            return;
        }
        if (this.m_lTables.contains(tbl)) {
            this.m_lTables.remove(tbl);
            IColumn[] aColumns = tbl.getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.deleteRow(this.getRowIndex(aColumns[iColumn]));
            }
        }
    }

    private void refreshTableName(ITable tbl) {
        String sName = TableUIUtilities.getViewName(tbl);
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            if (this.getValueAt(iRow, 13) != tbl) continue;
            super.setValueAt((Object)sName, iRow, 5);
        }
    }

    private void refreshTableDescription(ITable tbl) {
        String sDescription = tbl.getDescription();
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            if (this.getValueAt(iRow, 13) != tbl) continue;
            super.setValueAt((Object)sDescription, iRow, 6);
        }
    }

    private void addColumn(ITable tbl, IColumn col) {
        ITable table;
        int iRow = tbl.indexOfColumn(col);
        for (int iTable = 0; iTable < this.m_lTables.size() && (table = (ITable)this.m_lTables.get(iTable)) != tbl; ++iTable) {
            iRow += table.getColumnCount();
        }
        this.insertRow(iRow - 1, this.createRowValues(col));
    }

    private void removeColumn(IColumn col) {
        this.deleteRow(this.getRowIndex(col));
    }

    private void addMapping(IMapping mapping) {
        IColumn[] aColumns = mapping.getTargets();
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            int iRow = this.getRowIndex(aColumns[iColumn]);
            if (iRow == -1) continue;
            this.refreshMappingValues(iRow, mapping);
        }
    }

    private void removeMapping(IMapping mapping) {
        IColumn[] aColumns = mapping.getTargets();
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            int iRow = this.getRowIndex(aColumns[iColumn]);
            if (iRow == -1) continue;
            this.refreshMappingValues(iRow, null);
        }
    }

    private void addMappingSource(IMapping mapping, IColumn column) {
        int iRow = this.getRowIndex(mapping);
        if (iRow != -1) {
            this.refreshMappingValues(iRow, mapping);
        }
    }

    private void removeMappingSource(IMapping mapping, IColumn column) {
        int iRow = this.getRowIndex(mapping);
        if (iRow != -1) {
            this.refreshMappingValues(iRow, mapping);
        }
    }

    private void addMappingTarget(IMapping mapping, IColumn column) {
        int iRow = this.getRowIndex(column);
        if (iRow != -1) {
            this.refreshMappingValues(iRow, mapping);
        }
    }

    private void removeMappingTarget(IMapping mapping, IColumn column) {
        int iRow = this.getRowIndex(column);
        if (iRow != -1) {
            this.refreshMappingValues(iRow, null);
        }
    }

    private void refreshMappingValues(int iRow, IMapping mapping) {
        super.setValueAt((Object)mapping, iRow, 14);
        super.setValueAt((Object)this.getMappingTypeIcon(mapping), iRow, 0);
        super.setValueAt((Object)this.getExpressionText(mapping), iRow, 4);
    }

    private void refreshExpressions(IObject source) {
        block0: for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
            IExpression expression;
            IMapping mapping = this.getMapping(iRow);
            if (mapping == null || (expression = mapping.getExpression()) == null) continue;
            IObject[] aSources = expression.getSources();
            for (int iSource = 0; iSource < aSources.length; ++iSource) {
                if (aSources[iSource] != source) continue;
                super.setValueAt((Object)this.getExpressionText(mapping), iRow, 4);
                continue block0;
            }
        }
    }

    private void refreshExclusionsIcon(IColumn column) {
        int iRow = this.getRowIndex(column);
        if (iRow == -1) {
            return;
        }
        super.setValueAt((Object)this.getExclusionsIcon(column), iRow, 1);
    }

    private class ExpressionEditor
    extends WsDialogTableCellEditor {
        public ExpressionEditor() {
            this.setStopEditingOnDialogClose(true);
            Document doc = this.m_txt.getDocument();
            doc.putProperty("filterNewlines", Boolean.FALSE);
            if (doc instanceof WsLimitedPlainDocument) {
                ((WsLimitedPlainDocument)doc).setSingleLine(false);
            }
        }
    }

    private class ExpressionCellRenderer
    extends WsDefaultTableCellRenderer {
        private Font m_plainFont = this.getFont();
        private Font m_italicFont = new Font(this.m_plainFont.getName(), 2, this.m_plainFont.getSize());

        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
            IMapping mapping;
            super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
            if (tbl instanceof TableView) {
                iRow = ((TableView)tbl).convertRowIndexToModel(iRow);
            }
            if ((mapping = TargetColumnsTableModel.this.getMapping(iRow)) == null) {
                return this;
            }
            IExpression expression = mapping.getExpression();
            if (expression != null && (expression.getExpressionType().equalsIgnoreCase("CaseOperand") || expression.getExpressionType().equalsIgnoreCase("SubQueryOperand"))) {
                this.setFont(this.m_italicFont);
            } else {
                this.setFont(this.m_plainFont);
            }
            return this;
        }
    }

    private class ColumnNameCellRenderer
    extends WsDefaultTableCellRenderer {
        private ColumnNameCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
            super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
            if (tbl instanceof TableView) {
                iRow = ((TableView)tbl).convertRowIndexToModel(iRow);
            }
            IColumn col = TargetColumnsTableModel.this.getTargetColumn(iRow);
            WsCompoundIcon icon = new WsCompoundIcon();
            icon.addIcon(ColumnUIUtilities.getUsageIcon(col));
            icon.addIcon(ColumnUIUtilities.getTypeIcon(col));
            this.setIcon((Icon)icon);
            return this;
        }
    }

    private class FormatTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public FormatTableColumn() {
            super(10, bundle.getString("TargetColumnsTableModel.Format.txt"), 75, WsColumnMetadataUtil.NONE);
            this.setEditorEditable(true);
            this.setMaximumCharacters(32);
        }

        public void populate(JTable tbl, int row, int col) {
            String sType = (String)TargetColumnsTableModel.this.getValueAt(row = ((WsTable)tbl).convertRowIndexToModel(row), 7);
            if (WsColumnMetadataUtil.isColumnViewTypeCharacter((String)sType)) {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultCharacterFormats());
            } else {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultNumericFormats());
            }
        }
    }

    private class InformatTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public InformatTableColumn() {
            super(9, bundle.getString("TargetColumnsTableModel.Informat.txt"), 75, WsColumnMetadataUtil.NONE);
            this.setEditorEditable(true);
            this.setMaximumCharacters(32);
        }

        public void populate(JTable tbl, int row, int col) {
            String sType = (String)TargetColumnsTableModel.this.getValueAt(row = ((WsTable)tbl).convertRowIndexToModel(row), 7);
            if (WsColumnMetadataUtil.isColumnViewTypeCharacter((String)sType)) {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultCharacterInformats());
            } else {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultNumericInformats());
            }
        }
    }

    private class LengthTableColumn
    extends WsIntegerTableColumn {
        public LengthTableColumn() {
            super(8, bundle.getString("TargetColumnsTableModel.Length.txt"), 50);
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            if (oValue.equals(this.getMissingValue())) {
                return true;
            }
            int iValue = (Integer)oValue;
            int eType = TargetColumnsTableModel.this.getTargetColumn(iRow).getType();
            if (eType == 1) {
                if (iValue < 3 || iValue > 8) {
                    String sMessage = bundle.formatString("TargetColumnsTableModel.Error.NumericInvalidLength.fmt.txt", (Object)new Integer(3), (Object)new Integer(8));
                    MessageUtil.displayMessage((String)sMessage, (int)0);
                    return false;
                }
                return true;
            }
            if (eType == 0 && (iValue < 1 || iValue > Short.MAX_VALUE)) {
                String sMessage = bundle.formatString("TargetColumnsTableModel.Error.CharacterInvalidLength.fmt.txt", (Object)new Integer(1), (Object)new Integer(Short.MAX_VALUE));
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            return true;
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                TargetColumnsTableModel.this.moveDataToModel();
            } else if (obj == TargetColumnsTableModel.this.m_container) {
                if (sType == "DataTransform.DataTargetAdded") {
                    Object data = ev.getData();
                    if (data instanceof ITable) {
                        TargetColumnsTableModel.this.addTable((ITable)data);
                    }
                } else if (sType == "DataTransform.DataTargetRemoved") {
                    Object data = ev.getData();
                    if (data instanceof ITable) {
                        TargetColumnsTableModel.this.removeTable((ITable)data);
                    }
                } else if (sType == "MappingsContainer:MappingAdded") {
                    IMapping mapping = (IMapping)ev.getData();
                    if (TargetColumnsTableModel.this.m_filter.pass((Object)mapping)) {
                        TargetColumnsTableModel.this.addMapping(mapping);
                    }
                } else if (sType == "MappingsContainer:MappingRemoved") {
                    IMapping mapping = (IMapping)ev.getData();
                    if (TargetColumnsTableModel.this.m_filter.pass((Object)mapping)) {
                        TargetColumnsTableModel.this.removeMapping(mapping);
                    }
                } else if (sType == "MappingsContainer:ColumnExcludedFromMapping") {
                    TargetColumnsTableModel.this.refreshExclusionsIcon((IColumn)ev.getData());
                } else if (sType == "MappingsContainer:ColumnIncludedInMapping") {
                    TargetColumnsTableModel.this.refreshExclusionsIcon((IColumn)ev.getData());
                } else if (sType == "MappingsContainer:ColumnExcludedFromPropagation") {
                    TargetColumnsTableModel.this.refreshExclusionsIcon((IColumn)ev.getData());
                } else if (sType == "MappingsContainer:ColumnIncludedInPropagation") {
                    TargetColumnsTableModel.this.refreshExclusionsIcon((IColumn)ev.getData());
                }
            } else if (TargetColumnsTableModel.this.m_container instanceof ISelectResultsContainer && ((ISelectResultsContainer)TargetColumnsTableModel.this.m_container).getParentQuery().getTransformModel() == obj) {
                Object data;
                if (sType == "DataTransform.DataTargetAdded") {
                    Object data2 = ev.getData();
                    if (data2 instanceof ITable) {
                        TargetColumnsTableModel.this.addTable((ITable)data2);
                    }
                } else if (sType == "DataTransform.DataTargetRemoved" && (data = ev.getData()) instanceof ITable) {
                    TargetColumnsTableModel.this.removeTable((ITable)data);
                }
            } else if (obj instanceof ITable) {
                ITable tbl = (ITable)obj;
                if (TargetColumnsTableModel.this.m_lTables.contains(obj)) {
                    if (sType == "Object:NameChanged") {
                        TargetColumnsTableModel.this.refreshTableName(tbl);
                    } else if (sType == "PhysicalTable:SASTableNameChanged") {
                        TargetColumnsTableModel.this.refreshTableName(tbl);
                    } else if (sType == "Object:DescriptionChanged") {
                        TargetColumnsTableModel.this.refreshTableDescription(tbl);
                    } else if (sType == "Table:ColumnAdded") {
                        TargetColumnsTableModel.this.addColumn(tbl, (IColumn)ev.getData());
                    } else if (sType == "Table:ColumnMoved") {
                        TargetColumnsTableModel.this.removeColumn((IColumn)ev.getData());
                        TargetColumnsTableModel.this.addColumn(tbl, (IColumn)ev.getData());
                    } else if (sType == "Table:ColumnRemoved") {
                        TargetColumnsTableModel.this.removeColumn((IColumn)ev.getData());
                    }
                } else if (sType == "Object:NameChanged" && TargetColumnsTableModel.this.isSourceTable(tbl)) {
                    TargetColumnsTableModel.this.refreshExpressions((IObject)tbl);
                }
            } else if (obj instanceof IMapping) {
                IMapping mapping = (IMapping)obj;
                if (!TargetColumnsTableModel.this.m_filter.pass((Object)mapping) || !TargetColumnsTableModel.this.m_container.containsMapping(mapping)) {
                    return;
                }
                if (sType == "Mapping:TargetColumnAdded") {
                    TargetColumnsTableModel.this.addMappingTarget(mapping, (IColumn)ev.getData());
                } else if (sType == "Mapping:TargetColumnRemoved") {
                    TargetColumnsTableModel.this.removeMappingTarget(mapping, (IColumn)ev.getData());
                } else if (sType == "Mapping:SourceColumnAdded") {
                    TargetColumnsTableModel.this.addMappingSource(mapping, (IColumn)ev.getData());
                } else if (sType == "Mapping:SourceColumnRemoved") {
                    TargetColumnsTableModel.this.removeMappingSource(mapping, (IColumn)ev.getData());
                } else {
                    int iRow = TargetColumnsTableModel.this.getRowIndex(mapping);
                    if (iRow == -1) {
                        return;
                    }
                    if (sType == "Mapping:TypeChanged") {
                        TargetColumnsTableModel.super.setValueAt(TargetColumnsTableModel.this.getMappingTypeIcon(mapping), iRow, 0);
                    } else if (sType == "Mapping:ExpressionChanged" || sType == "Mapping:MappingChanged") {
                        TargetColumnsTableModel.this.refreshMappingValues(iRow, TargetColumnsTableModel.this.getMapping(iRow));
                    }
                }
            } else if (obj instanceof IExpression) {
                IExpression expression = (IExpression)obj;
                int iRow = TargetColumnsTableModel.this.getRowIndex(expression);
                if (iRow == -1) {
                    return;
                }
                if (sType == "TextExpression:TextChanged") {
                    TargetColumnsTableModel.this.refreshMappingValues(iRow, TargetColumnsTableModel.this.getMapping(iRow));
                }
            } else if (obj instanceof IColumn) {
                IColumn col = (IColumn)obj;
                int iRowIndex = TargetColumnsTableModel.this.getRowIndex(col);
                if (iRowIndex != -1) {
                    if (sType == "Object:NameChanged") {
                        TargetColumnsTableModel.super.setValueAt(col.getName(), iRowIndex, 2);
                    } else if (sType == "Object:DescriptionChanged") {
                        TargetColumnsTableModel.super.setValueAt(col.getDescription(), iRowIndex, 3);
                    } else if (sType == "Column:LengthChanged") {
                        TargetColumnsTableModel.super.setValueAt(new Integer(col.getLength()), iRowIndex, 8);
                    } else if (sType == "Column:TypeChanged") {
                        TargetColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewType(col.getType()), iRowIndex, 7);
                        TargetColumnsTableModel.this.fireTableCellUpdated(iRowIndex, 2);
                    } else if (sType == "Column:InformatChanged") {
                        TargetColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewInformat(col.getInformat()), iRowIndex, 9);
                    } else if (sType == "Column:FormatChanged") {
                        TargetColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewFormat(col.getFormat()), iRowIndex, 10);
                    } else if (sType == "Column:NullableChanged") {
                        TargetColumnsTableModel.super.setValueAt(col.isNullable(), iRowIndex, 11);
                    }
                } else if (sType == "Object:NameChanged" && TargetColumnsTableModel.this.isSourceTable(col.getTable())) {
                    TargetColumnsTableModel.this.refreshExpressions((IObject)col);
                }
            }
        }
    }
}

